/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.sample.CommonDBObjectArrayWritable;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class CommonDBSerDe
implements ConnectorSerDe {
    CommonDBObjectArrayWritable objectArrayWritable = null;
    String targetTableDescText = "";
    TeradataTableDesc targetTableDesc = null;
    String[] targetFieldNamesArray = null;
    int[] mappings = null;
    Object[] targetObjects = null;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        if (direction2 == ConnectorConfiguration.direction.output) {
            this.targetTableDescText = CommonDBConfiguration.getOutputTableDesc(configuration);
            this.targetTableDesc = CommonDBSchemaUtils.tableDescFromText(this.targetTableDescText);
            this.targetFieldNamesArray = CommonDBConfiguration.getOutputFieldNamesArray(configuration);
            int[] fieldTypes = new int[]{};
            int[] fieldScales = new int[]{};
            fieldTypes = CommonDBSchemaUtils.lookupTypesFromTableDescText(this.targetTableDescText, this.targetFieldNamesArray);
            fieldScales = CommonDBSchemaUtils.lookupFieldsSQLDataScales(this.targetTableDescText, this.targetFieldNamesArray);
            this.mappings = CommonDBSchemaUtils.lookupMappingFromTableDescText(this.targetTableDescText, this.targetFieldNamesArray);
            this.objectArrayWritable = new CommonDBObjectArrayWritable();
            this.objectArrayWritable.setNullJdbcTypes(fieldTypes);
            this.objectArrayWritable.setNullJdbcScales(fieldScales);
            int recordLength = this.targetTableDesc.getColumns().length;
            this.targetObjects = new Object[recordLength];
            for (int i = 0; i < recordLength; ++i) {
                this.targetObjects[i] = null;
            }
        }
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        return (ConnectorRecord)writable;
    }

    @Override
    public Writable serialize(ConnectorRecord connectorRecord) throws ConnectorException {
        int index = 0;
        for (int position : this.mappings) {
            this.targetObjects[position] = connectorRecord.get(index++);
        }
        this.objectArrayWritable.setObjects(this.targetObjects);
        return this.objectArrayWritable;
    }
}

