/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.processor;

import com.teradata.connector.common.ConnectorOutputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class CommonDBOutputProcessor
implements ConnectorOutputProcessor {
    public abstract String getTableName(Configuration var1) throws ConnectorException;

    public abstract Connection getConnection(Configuration var1) throws ConnectorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int outputPreProcessor(JobContext context) {
        Connection connection;
        block12: {
            connection = null;
            try {
                ConnectorRecordSchema userRecordSchema;
                Configuration configuration = context.getConfiguration();
                connection = this.getConnection(configuration);
                String tableName = this.getTableName(configuration);
                String[] fieldNames = CommonDBConfiguration.getOutputFieldNamesArray(configuration);
                TeradataColumnDesc[] columnDesc = CommonDBSchemaUtils.getColumnDesc(tableName, fieldNames, connection);
                TeradataTableDesc outputTableDesc = new TeradataTableDesc();
                outputTableDesc.setColumns(columnDesc);
                CommonDBConfiguration.setOutputTableDesc(configuration, CommonDBSchemaUtils.tableDescToJson(outputTableDesc));
                if (fieldNames.length == 0) {
                    CommonDBConfiguration.setOutputFieldNamesArray(configuration, outputTableDesc.getColumnNames());
                    fieldNames = outputTableDesc.getColumnNames();
                }
                if ((userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration))) != null && fieldNames.length != userRecordSchema.getLength()) {
                    throw new ConnectorException(14013);
                }
                TeradataTableDesc targetTableDesc = CommonDBSchemaUtils.tableDescFromText(CommonDBConfiguration.getOutputTableDesc(configuration));
                TeradataColumnDesc[] columnDescs = targetTableDesc.getColumns();
                ConnectorRecordSchema targetRecordSchema = new ConnectorRecordSchema(fieldNames.length);
                int index = 0;
                boolean findField = false;
                for (String fieldName : fieldNames) {
                    findField = false;
                    for (TeradataColumnDesc column : columnDescs) {
                        if (!fieldName.equalsIgnoreCase(column.getName())) continue;
                        targetRecordSchema.setFieldType(index++, CommonDBSchemaUtils.tranformTeradataDataType(column.getType()));
                        findField = true;
                        break;
                    }
                    if (findField) continue;
                    throw new ConnectorException(14005);
                }
                if (userRecordSchema != null) {
                    int columnCount = targetRecordSchema.getLength();
                    for (int i = 0; i < columnCount; ++i) {
                        if (userRecordSchema.getFieldType(i) == 1883 || userRecordSchema.getFieldType(i) == targetRecordSchema.getFieldType(i)) continue;
                        throw new ConnectorException(14015);
                    }
                }
                if (userRecordSchema != null) break block12;
                ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(targetRecordSchema)));
            }
            catch (ConnectorException e) {
                e.printStackTrace();
                CommonDBUtils.CloseConnection(connection);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CommonDBUtils.CloseConnection(connection);
                        throw throwable;
                    }
                }
                CommonDBUtils.CloseConnection(connection);
            }
        }
        CommonDBUtils.CloseConnection(connection);
        return 0;
    }

    @Override
    public int outputPostProcessor(JobContext context) {
        return 0;
    }
}

