/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.processor;

import com.teradata.connector.common.ConnectorInputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class CommonDBInputProcessor
implements ConnectorInputProcessor {
    public abstract String getTableName(Configuration var1) throws ConnectorException;

    public abstract Connection getConnection(Configuration var1) throws ConnectorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int inputPreProcessor(JobContext context) {
        Connection connection;
        block12: {
            connection = null;
            try {
                ConnectorRecordSchema userRecordSchema;
                Configuration configuration = context.getConfiguration();
                connection = this.getConnection(configuration);
                String tableName = this.getTableName(configuration);
                String[] fieldNames = CommonDBConfiguration.getInputFieldNamesArray(configuration);
                TeradataColumnDesc[] columnDesc = CommonDBSchemaUtils.getColumnDesc(tableName, fieldNames, connection);
                TeradataTableDesc inputTableDesc = new TeradataTableDesc();
                inputTableDesc.setColumns(columnDesc);
                CommonDBConfiguration.setInputTableDesc(configuration, CommonDBSchemaUtils.tableDescToJson(inputTableDesc));
                ConnectorConfiguration.setInputSplit(configuration, "com.teradata.connector.sample.CommonDBInputFormat$CommonDBInputSplit");
                if (fieldNames.length == 0) {
                    CommonDBConfiguration.setInputFieldNamesArray(configuration, inputTableDesc.getColumnNames());
                    fieldNames = inputTableDesc.getColumnNames();
                }
                if ((userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration))) != null && fieldNames.length != userRecordSchema.getLength()) {
                    throw new ConnectorException(14013);
                }
                TeradataTableDesc sourceTableDesc = CommonDBSchemaUtils.tableDescFromText(CommonDBConfiguration.getInputTableDesc(configuration));
                TeradataColumnDesc[] columnDescs = sourceTableDesc.getColumns();
                ConnectorRecordSchema sourceRecordSchema = new ConnectorRecordSchema(fieldNames.length);
                int index = 0;
                boolean findField = false;
                for (String fieldName : fieldNames) {
                    findField = false;
                    for (TeradataColumnDesc column : columnDescs) {
                        if (!fieldName.equalsIgnoreCase(column.getName())) continue;
                        sourceRecordSchema.setFieldType(index++, CommonDBSchemaUtils.tranformTeradataDataType(column.getType()));
                        findField = true;
                        break;
                    }
                    if (findField) continue;
                    throw new ConnectorException(14005);
                }
                if (userRecordSchema != null) {
                    int columnCount = sourceRecordSchema.getLength();
                    for (int i = 0; i < columnCount; ++i) {
                        if (userRecordSchema.getFieldType(i) == 1883 || userRecordSchema.getFieldType(i) == sourceRecordSchema.getFieldType(i)) continue;
                        throw new ConnectorException(14015);
                    }
                }
                if (userRecordSchema != null) break block12;
                ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(sourceRecordSchema)));
            }
            catch (ConnectorException e) {
                e.printStackTrace();
                CommonDBUtils.CloseConnection(connection);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CommonDBUtils.CloseConnection(connection);
                        throw throwable;
                    }
                }
                CommonDBUtils.CloseConnection(connection);
            }
        }
        CommonDBUtils.CloseConnection(connection);
        return 0;
    }

    @Override
    public int inputPostProcessor(JobContext context) {
        return 0;
    }
}

