/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.aster.utils;

import com.teradata.connector.common.utils.ConnectorSchemaParser;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class AsterDBConfiguration {
    public static final String ASTER_INPUT_JDBC_DRIVER_CLASS = "tdch.input.aster.jdbc.driver.class";
    public static final String ASTER_INPUT_JDBC_URL = "tdch.input.aster.jdbc.url";
    public static final String ASTER_INPUT_JDBC_USER_NAME = "tdch.input.aster.jdbc.user.name";
    public static final String ASTER_INPUT_JDBC_PASSWORD = "tdch.input.aster.jdbc.password";
    public static final String ASTER_INPUT_SPLIT_BY_COLUMN = "tdch.input.aster.split.by.column";
    public static final String ASTER_INPUT_DATABASE = "tdch.input.aster.database";
    public static final String ASTER_INPUT_SCHEMA = "tdch.input.aster.schema";
    public static final String ASTER_INPUT_TABLE = "tdch.input.aster.table";
    public static final String ASTER_OUTPUT_JDBC_DRIVER_CLASS = "tdch.output.aster.jdbc.driver.class";
    public static final String ASTER_OUTPUT_JDBC_URL = "tdch.output.aster.jdbc.url";
    public static final String ASTER_OUTPUT_JDBC_USER_NAME = "tdch.output.aster.jdbc.user.name";
    public static final String ASTER_OUTPUT_JDBC_PASSWORD = "tdch.output.aster.jdbc.password";
    public static final String ASTER_OUTPUT_TABLE = "tdch.output.aster.table";
    public static final String ASTER_OUTPUT_DATABASE = "tdch.output.aster.database";
    public static final String ASTER_OUTPUT_SCHEMA = "tdch.output.aster.schema";

    public static void setAsterInputTable(Configuration configuration, String inputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(inputTable, 3, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(ASTER_INPUT_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(ASTER_INPUT_SCHEMA, tokens.get(0));
                configuration.set(ASTER_INPUT_TABLE, tokens.get(1));
                break;
            }
            case 3: {
                configuration.set(ASTER_INPUT_DATABASE, tokens.get(0));
                configuration.set(ASTER_INPUT_SCHEMA, tokens.get(1));
                configuration.set(ASTER_INPUT_TABLE, tokens.get(2));
            }
        }
    }

    public static String getAsterInputTable(Configuration configuration) {
        return configuration.get(ASTER_INPUT_TABLE, null);
    }

    public static String getAsterInputSchema(Configuration configuration) {
        return configuration.get(ASTER_INPUT_SCHEMA, "public");
    }

    public static String getAsterInputDatabase(Configuration configuration) {
        return configuration.get(ASTER_INPUT_DATABASE, "");
    }

    public static void setAsterInputSchema(Configuration configuration, String schema) {
        configuration.set(ASTER_INPUT_SCHEMA, schema);
    }

    public static void setAsterInputDatabase(Configuration configuration, String value) {
        configuration.set(ASTER_INPUT_DATABASE, value);
    }

    public static String getAsterOutputDatabase(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_DATABASE, "");
    }

    public static void setAsterOutputDatabase(Configuration configuration, String value) {
        configuration.set(ASTER_OUTPUT_DATABASE, value);
    }

    public static String getAsterOutputSchema(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_SCHEMA, "public");
    }

    public static void setAsterOutputSchema(Configuration configuration, String value) {
        configuration.set(ASTER_OUTPUT_SCHEMA, value);
    }

    public static String getAsterOutputTable(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_TABLE, null);
    }

    public static void setAsterOutputTable(Configuration configuration, String outputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(outputTable, 3, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(ASTER_OUTPUT_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(ASTER_OUTPUT_SCHEMA, tokens.get(0));
                configuration.set(ASTER_OUTPUT_TABLE, tokens.get(1));
                break;
            }
            case 3: {
                configuration.set(ASTER_OUTPUT_DATABASE, tokens.get(0));
                configuration.set(ASTER_OUTPUT_SCHEMA, tokens.get(1));
                configuration.set(ASTER_OUTPUT_TABLE, tokens.get(2));
            }
        }
    }

    public static void setOutputJdbcDriverClass(Configuration configuration, String jdbcDriverClass) {
        configuration.set(ASTER_OUTPUT_JDBC_DRIVER_CLASS, jdbcDriverClass);
    }

    public static String getOutputJdbcDriverClass(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_JDBC_DRIVER_CLASS, null);
    }

    public static void setOutputJdbcUrl(Configuration configuration, String jdbcUrl) {
        configuration.set(ASTER_OUTPUT_JDBC_URL, jdbcUrl);
    }

    public static String getOutputJdbcUrl(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_JDBC_URL, "");
    }

    public static void setOutputJdbcUserName(Configuration configuration, String jdbcUserName) {
        configuration.set(ASTER_OUTPUT_JDBC_USER_NAME, jdbcUserName);
    }

    public static String getOutputJdbcUserName(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_JDBC_USER_NAME, "");
    }

    public static void setOutputJdbcPassword(Configuration configuration, String jdbcPassword) {
        configuration.set(ASTER_OUTPUT_JDBC_PASSWORD, jdbcPassword);
    }

    public static String getOutputJdbcPassword(Configuration configuration) {
        return configuration.get(ASTER_OUTPUT_JDBC_PASSWORD, "");
    }

    public static void setInputSplitByColumn(Configuration configuration, String splitByColumn) {
        configuration.set(ASTER_INPUT_SPLIT_BY_COLUMN, splitByColumn);
    }

    public static String getInputSplitByColumn(Configuration configuration) {
        return configuration.get(ASTER_INPUT_SPLIT_BY_COLUMN, "");
    }

    public static void setInputJdbcDriverClass(Configuration configuration, String jdbcDriverClass) {
        configuration.set(ASTER_INPUT_JDBC_DRIVER_CLASS, jdbcDriverClass);
    }

    public static String getInputJdbcDriverClass(Configuration configuration) {
        return configuration.get(ASTER_INPUT_JDBC_DRIVER_CLASS, null);
    }

    public static void setInputJdbcUrl(Configuration configuration, String jdbcUrl) {
        configuration.set(ASTER_INPUT_JDBC_URL, jdbcUrl);
    }

    public static String getInputJdbcUrl(Configuration configuration) {
        return configuration.get(ASTER_INPUT_JDBC_URL, "");
    }

    public static void setInputJdbcUserName(Configuration configuration, String jdbcUserName) {
        configuration.set(ASTER_INPUT_JDBC_USER_NAME, jdbcUserName);
    }

    public static String getInputJdbcUserName(Configuration configuration) {
        return configuration.get(ASTER_INPUT_JDBC_USER_NAME, "");
    }

    public static void setInputJdbcPassword(Configuration configuration, String jdbcPassword) {
        configuration.set(ASTER_INPUT_JDBC_PASSWORD, jdbcPassword);
    }

    public static String getInputJdbcPassword(Configuration configuration) {
        return configuration.get(ASTER_INPUT_JDBC_PASSWORD, "");
    }
}

