/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.aster;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.sample.CommonDBInputFormat;
import com.teradata.connector.sample.plugin.aster.utils.AsterDBConfiguration;
import com.teradata.connector.sample.plugin.aster.utils.AsterDBUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import java.sql.Connection;
import org.apache.hadoop.conf.Configuration;

public class AsterInputFormat
extends CommonDBInputFormat {
    protected static final String SQL_SELECT_COLUMN_SPLIT_RANGE = "SELECT %s FROM %s WHERE %s";
    protected static final String SQL_GET_COLUMN_VALUE_MIN_MAX = "SELECT MIN( %s ), MAX( %s ) FROM %s";

    @Override
    public String getSplitRangeSQL(Configuration configuration) {
        String[] inputFieldNamesArray = CommonDBConfiguration.getInputFieldNamesArray(configuration);
        String inputTableName = CommonDBUtils.getQuotedEscapedName(AsterDBConfiguration.getAsterInputDatabase(configuration), AsterDBConfiguration.getAsterInputSchema(configuration), AsterDBConfiguration.getAsterInputTable(configuration));
        return String.format(SQL_SELECT_COLUMN_SPLIT_RANGE, CommonDBSchemaUtils.concatFieldNamesArray(CommonDBSchemaUtils.quoteFieldNamesArray(inputFieldNamesArray)), inputTableName, "");
    }

    @Override
    public String getMinMaxSQL(Configuration configuration) {
        String splitColumnName = AsterDBConfiguration.getInputSplitByColumn(configuration);
        String inputTableName = CommonDBUtils.getQuotedEscapedName(AsterDBConfiguration.getAsterInputDatabase(configuration), AsterDBConfiguration.getAsterInputSchema(configuration), AsterDBConfiguration.getAsterInputTable(configuration));
        return String.format(SQL_GET_COLUMN_VALUE_MIN_MAX, splitColumnName, splitColumnName, inputTableName);
    }

    @Override
    public String getOneAmpSQL(Configuration configuration) {
        String[] inputFieldNamesArray = CommonDBConfiguration.getInputFieldNamesArray(configuration);
        String inputTableName = CommonDBUtils.getQuotedEscapedName(AsterDBConfiguration.getAsterInputDatabase(configuration), AsterDBConfiguration.getAsterInputSchema(configuration), AsterDBConfiguration.getAsterInputTable(configuration));
        return String.format(SQL_SELECT_COLUMN_SPLIT_RANGE, CommonDBSchemaUtils.concatFieldNamesArray(CommonDBSchemaUtils.quoteFieldNamesArray(inputFieldNamesArray)), inputTableName, "");
    }

    @Override
    public void validataConfiguration(Configuration configuration) throws ConnectorException {
        if (AsterDBConfiguration.getInputSplitByColumn(configuration).trim().equals("")) {
            throw new ConnectorException("Missing split column");
        }
    }

    @Override
    public Connection getConnection(Configuration conf) throws ConnectorException {
        return AsterDBUtils.openInputConnection(conf);
    }

    @Override
    public String getSplitColumn(Configuration configuration) {
        return AsterDBConfiguration.getInputSplitByColumn(configuration);
    }
}

