/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample;

import com.teradata.connector.common.ConnectorRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class CommonDBObjectArrayWritable
extends ConnectorRecord
implements DBWritable {
    protected int objectCount;
    protected int[] nullJdbcTypes = null;
    protected int[] nullJdbcScales = null;
    protected int nullJdbcTypeCount = 0;
    protected Object[] nullDefaultValues = null;
    protected int nullDefaultValueCount = 0;

    public CommonDBObjectArrayWritable() {
        this.record = new Object[0];
        this.objectCount = 0;
    }

    public CommonDBObjectArrayWritable(int objectCount) {
        if (objectCount > 0) {
            this.record = new Object[objectCount];
            this.objectCount = objectCount;
        }
    }

    public Object[] getObjects() {
        return this.record;
    }

    public void setObjects(Object[] objects) {
        this.record = objects;
        this.objectCount = objects.length;
    }

    @Override
    public Object get(int position) {
        return this.record[position];
    }

    @Override
    public void set(int position, Object object) {
        this.record[position] = object;
    }

    public int[] getNullJdbcTypes() {
        return this.nullJdbcTypes;
    }

    public void setNullJdbcTypes(int[] jdbcTypes) {
        if (jdbcTypes != null) {
            this.nullJdbcTypes = jdbcTypes;
            this.nullJdbcTypeCount = jdbcTypes.length;
        }
    }

    public int[] getNullJdbcScales() {
        return this.nullJdbcScales;
    }

    public void setNullJdbcScales(int[] jdbcScales) {
        if (jdbcScales != null) {
            this.nullJdbcScales = jdbcScales;
        }
    }

    public Object[] getNullDefaultValues() {
        return this.nullDefaultValues;
    }

    public void setNullDefaultValues(Object[] defaultValues) {
        if (defaultValues != null) {
            this.nullDefaultValues = defaultValues;
            this.nullDefaultValueCount = defaultValues.length;
        }
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        this.objectCount = metadata.getColumnCount();
        if (this.objectCount > 0) {
            this.record = new Object[this.objectCount];
        }
        for (int i = 0; i < this.objectCount; ++i) {
            this.record[i] = resultSet.getObject(i + 1);
        }
    }

    public void write(PreparedStatement statement) throws SQLException {
        for (int i = 0; i < this.objectCount; ++i) {
            if (this.record[i] == null) {
                if (this.nullDefaultValues != null && this.nullDefaultValueCount > i) {
                    statement.setObject(i + 1, this.nullDefaultValues[i]);
                    continue;
                }
                if (this.nullJdbcTypes != null && this.nullJdbcTypeCount > i) {
                    switch (this.nullJdbcTypes[i]) {
                        case 2: 
                        case 3: {
                            statement.setObject(i + 1, null, this.nullJdbcTypes[i], this.nullJdbcScales[i]);
                            break;
                        }
                        case 1111: 
                        case 2002: 
                        case 2003: {
                            statement.setObject(i + 1, null, 12);
                            break;
                        }
                        default: {
                            statement.setNull(i + 1, this.nullJdbcTypes[i]);
                            break;
                        }
                    }
                    continue;
                }
                statement.setObject(i + 1, "");
                continue;
            }
            statement.setObject(i + 1, this.record[i]);
        }
    }

    @Override
    public void readFields(DataInput arg0) throws IOException {
    }

    @Override
    public void write(DataOutput arg0) throws IOException {
    }
}

