/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream.processor;

import com.teradata.connector.common.ConnectorOutputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.idatastream.schema.IDataStreamColumnDesc;
import com.teradata.connector.idatastream.utils.IDataStreamPlugInConfiguration;
import com.teradata.connector.idatastream.utils.IDataStreamUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class IDataStreamOutputProcessor
implements ConnectorOutputProcessor {
    private static Log logger = LogFactory.getLog(IDataStreamOutputProcessor.class);

    @Override
    public int outputPreProcessor(JobContext context) throws ConnectorException {
        long startTime = System.currentTimeMillis();
        logger.info((Object)("output preprocessor " + this.getClass().getName() + " starts at:  " + startTime));
        Configuration configuration = context.getConfiguration();
        this.validateConfiguration(configuration);
        String tdchVersion = TeradataUtils.getTdchVersionNumber();
        logger.info((Object)("the teradata connector for hadoop version is: " + tdchVersion));
        IDataStreamOutputProcessor.configureTargetConnectorRecordSchema(configuration);
        logger.info((Object)("the number of mappers are " + ConnectorConfiguration.getNumMappers(configuration)));
        long endTime = System.currentTimeMillis();
        logger.info((Object)("output preprocessor " + this.getClass().getName() + " ends at:  " + endTime));
        logger.info((Object)("the total elapsed time of output preprocessor " + this.getClass().getName() + " is: " + (endTime - startTime) / 1000L + "s"));
        return 0;
    }

    @Override
    public int outputPostProcessor(JobContext context) throws ConnectorException {
        return 0;
    }

    public void validateConfiguration(Configuration configuration) throws ConnectorException {
        String outputSocketHost = IDataStreamPlugInConfiguration.getOutputSocketHost(configuration);
        String outputSocketPort = IDataStreamPlugInConfiguration.getOutputSocketPort(configuration);
        String[] outputFieldNamesArray = IDataStreamPlugInConfiguration.getOutputFieldNamesArray(configuration);
        int outputFieldNamesCount = outputFieldNamesArray.length;
        String[] outputFieldTypesArray = IDataStreamPlugInConfiguration.getOutputFieldTypesArray(configuration);
        int outputFieldTypesCount = outputFieldTypesArray.length;
        if (outputSocketHost.isEmpty()) {
            throw new ConnectorException(60001);
        }
        if (outputSocketPort.isEmpty()) {
            throw new ConnectorException(60002);
        }
        try {
            int i = Integer.parseInt(outputSocketPort);
            if (i <= 0) {
                throw new ConnectorException(60002);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(60002);
        }
        if (outputFieldNamesCount == 0) {
            String outputFieldNames = IDataStreamPlugInConfiguration.getOutputFieldNames(configuration);
            if (!outputFieldNames.isEmpty()) {
                IDataStreamPlugInConfiguration.setOutputFieldNames(configuration, outputFieldNames);
                outputFieldNamesArray = IDataStreamPlugInConfiguration.getOutputFieldNamesArray(configuration);
                outputFieldNamesCount = outputFieldNamesArray.length;
            } else {
                throw new ConnectorException(60003);
            }
        }
        if (outputFieldTypesCount == 0) {
            String outputFieldTypes = IDataStreamPlugInConfiguration.getOutputFieldTypes(configuration);
            if (!outputFieldTypes.isEmpty()) {
                IDataStreamPlugInConfiguration.setOutputFieldTypes(configuration, outputFieldTypes);
                outputFieldTypesArray = IDataStreamPlugInConfiguration.getOutputFieldTypesArray(configuration);
                outputFieldTypesCount = outputFieldTypesArray.length;
            } else {
                throw new ConnectorException(60004);
            }
        }
        if (outputFieldTypesCount != outputFieldNamesCount) {
            throw new ConnectorException(60004);
        }
    }

    public static void configureTargetConnectorRecordSchema(Configuration configuration) throws ConnectorException {
        String[] outputFieldTypes = IDataStreamPlugInConfiguration.getOutputFieldTypesArray(configuration);
        int outputFieldCount = outputFieldTypes.length;
        ConnectorRecordSchema targetRecordSchema = new ConnectorRecordSchema(outputFieldCount);
        for (int i = 0; i < outputFieldCount; ++i) {
            IDataStreamColumnDesc colDesc = IDataStreamUtils.getIDataStreamColumnDescFromString(outputFieldTypes[i]);
            targetRecordSchema.setFieldType(i, colDesc.getJDBCtype());
        }
        ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(targetRecordSchema)));
    }
}

