/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.converter.HiveDataType;
import com.teradata.connector.hive.converter.HiveDataTypeConverter;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveUtils;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDeBase;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.thrift.TException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class HiveSchemaUtils {
    protected static final String PATTERN_DECIMAL_TYPE = "\\s*DECIMAL\\s*\\(\\s*(\\d+)\\s*(,\\s*(\\d+)\\s*)?\\)";
    protected static final String PATTERN_VARCHAR_TYPE = "\\s*VARCHAR\\s*\\(\\s*(\\d+)\\s*\\)";
    protected static final String PATTERN_CHAR_TYPE = "\\s*CHAR\\s*\\(\\s*(\\d+)\\s*\\)";
    protected static final Pattern decimalPattern = Pattern.compile("\\s*DECIMAL\\s*\\(\\s*(\\d+)\\s*(,\\s*(\\d+)\\s*)?\\)");
    protected static final String PATTERN_MAP_TYPE = "\\s*(map\\s*[<].*[>])";
    protected static final String PATTERN_ARRAY_TYPE = "\\s*(array\\s*[<].*[>])";
    protected static final String PATTERN_STRUCT_TYPE = "\\s*(struct\\s*[<].*[>])";
    protected static final String PATTERN_UNION_TYPE = "\\s*(union\\s*[<].*[>])";
    public static final String LIST_COLUMNS = "columns";
    public static final String LIST_COLUMN_TYPES = "columns.types";

    public static HiveDataType lookupHiveDataTypeWritableImpl(int type) {
        switch (type) {
            case 4: {
                return HiveDataType.HiveDataTypeWritableImpl.INTEGER;
            }
            case -5: {
                return HiveDataType.HiveDataTypeWritableImpl.BIGINT;
            }
            case 5: {
                return HiveDataType.HiveDataTypeWritableImpl.SMALLINT;
            }
            case -6: {
                return HiveDataType.HiveDataTypeWritableImpl.TINYINT;
            }
            case 8: {
                return HiveDataType.HiveDataTypeWritableImpl.DOUBLE;
            }
            case 3: {
                return HiveDataType.HiveDataTypeWritableImpl.DECIMAL;
            }
            case 6: {
                return HiveDataType.HiveDataTypeWritableImpl.FLOAT;
            }
            case 16: {
                return HiveDataType.HiveDataTypeWritableImpl.BOOLEAN;
            }
            case 93: {
                return HiveDataType.HiveDataTypeWritableImpl.TIMESTAMP;
            }
            case -1001: {
                return HiveDataType.HiveDataTypeWritableImpl.ARRAY;
            }
            case -2: {
                return HiveDataType.HiveDataTypeWritableImpl.BINARY;
            }
            case 12: {
                return HiveDataType.HiveDataTypeWritableImpl.STRING;
            }
            case 91: {
                return HiveDataType.HiveDataTypeWritableImpl.DATE;
            }
            case -2001: {
                return HiveDataType.HiveDataTypeWritableImpl.VARCHAR;
            }
            case 1: {
                return HiveDataType.HiveDataTypeWritableImpl.CHAR;
            }
            case -1000: {
                return HiveDataType.HiveDataTypeWritableImpl.MAP;
            }
            case -1002: {
                return HiveDataType.HiveDataTypeWritableImpl.STRUCT;
            }
        }
        return null;
    }

    public static HiveDataType lookupHiveDataTypeLazyImpl(int type) {
        switch (type) {
            case 4: {
                return HiveDataType.HiveDataTypeLazyImpl.INTEGER;
            }
            case -5: {
                return HiveDataType.HiveDataTypeLazyImpl.BIGINT;
            }
            case 5: {
                return HiveDataType.HiveDataTypeLazyImpl.SMALLINT;
            }
            case -6: {
                return HiveDataType.HiveDataTypeLazyImpl.TINYINT;
            }
            case 8: {
                return HiveDataType.HiveDataTypeLazyImpl.DOUBLE;
            }
            case 3: {
                return HiveDataType.HiveDataTypeLazyImpl.DECIMAL;
            }
            case 6: {
                return HiveDataType.HiveDataTypeLazyImpl.FLOAT;
            }
            case 16: {
                return HiveDataType.HiveDataTypeLazyImpl.BOOLEAN;
            }
            case 93: {
                return HiveDataType.HiveDataTypeLazyImpl.TIMESTAMP;
            }
            case -1001: {
                return HiveDataType.HiveDataTypeLazyImpl.ARRAY;
            }
            case -2: {
                return HiveDataType.HiveDataTypeLazyImpl.BINARY;
            }
            case 12: {
                return HiveDataType.HiveDataTypeLazyImpl.STRING;
            }
            case 91: {
                return HiveDataType.HiveDataTypeLazyImpl.DATE;
            }
            case -2001: {
                return HiveDataType.HiveDataTypeLazyImpl.VARCHAR;
            }
            case 1: {
                return HiveDataType.HiveDataTypeLazyImpl.CHAR;
            }
            case -1000: {
                return HiveDataType.HiveDataTypeLazyImpl.MAP;
            }
            case -1002: {
                return HiveDataType.HiveDataTypeLazyImpl.STRUCT;
            }
        }
        return null;
    }

    public static StructObjectInspector createStructObjectInspector(String targetTableSchema) throws ConnectorException {
        ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        TeradataTableDesc tableDesc = HiveSchemaUtils.columnSchemaToTableDesc(targetTableSchema);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        for (int i = 0; i < columnDescs.length; ++i) {
            TypeInfo type = TypeInfoUtils.getTypeInfoFromTypeString((String)columnDescs[i].getTypeName().toLowerCase());
            fieldNames.add(columnDescs[i].getName());
            if (columnDescs[i].getType() == 3) {
                try {
                    Class<?> oi = Class.forName("org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector");
                    Class<?> ti = Class.forName("org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo");
                    Constructor<?> cnst1 = oi.getConstructor(ti);
                    Constructor<?> cnst2 = ti.getConstructor(Integer.TYPE, Integer.TYPE);
                    fieldInspectors.add((ObjectInspector)cnst1.newInstance(cnst2.newInstance(columnDescs[i].getPrecision(), columnDescs[i].getScale())));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    fieldInspectors.add(HiveSchemaUtils.getObjectInspector(type));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    fieldInspectors.add(HiveSchemaUtils.getObjectInspector(type));
                    continue;
                }
                catch (Exception e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
            }
            fieldInspectors.add(HiveSchemaUtils.getObjectInspector(type));
        }
        StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors);
        return structInspector;
    }

    public static ObjectInspector getObjectInspector(TypeInfo type) throws ConnectorException {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveType = (PrimitiveTypeInfo)type;
                return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)primitiveType.getPrimitiveCategory());
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                StandardMapObjectInspector mapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)HiveSchemaUtils.getObjectInspector(mapType.getMapKeyTypeInfo()), (ObjectInspector)HiveSchemaUtils.getObjectInspector(mapType.getMapValueTypeInfo()));
                return mapInspector;
            }
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)type;
                StandardListObjectInspector listInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)HiveSchemaUtils.getObjectInspector(listType.getListElementTypeInfo()));
                return listInspector;
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)type;
                ArrayList fieldTypes = structType.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
                for (TypeInfo fieldType : fieldTypes) {
                    fieldInspectors.add(HiveSchemaUtils.getObjectInspector(fieldType));
                }
                StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)structType.getAllStructFieldNames(), fieldInspectors);
                return structInspector;
            }
        }
        throw new ConnectorException(14006, type.getCategory());
    }

    public static ColumnarSerDeBase initializeColumnarSerDe(Configuration configuration, String schema, ConnectorConfiguration.direction direction2) throws ConnectorException {
        List<String> columns = ConnectorSchemaUtils.parseColumns(schema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        HiveSchemaUtils.updateNonScaleDecimalColumns(columnTypes);
        Properties props = new Properties();
        props.setProperty(LIST_COLUMNS, HiveUtils.listToString(columnNames));
        props.setProperty(LIST_COLUMN_TYPES, HiveUtils.listToString(columnTypes));
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            props.setProperty("line.delim", HivePlugInConfiguration.getInputLineSeparator(configuration));
        } else {
            props.setProperty("line.delim", HivePlugInConfiguration.getOutputLineSeparator(configuration));
        }
        String value = configuration.get("serialization.null.format");
        if (value == null || value.isEmpty()) {
            value = direction2.equals((Object)ConnectorConfiguration.direction.input) ? HivePlugInConfiguration.getInputNullString(configuration) : HivePlugInConfiguration.getOutputNullString(configuration);
        }
        if (value != null && !value.isEmpty()) {
            props.setProperty("serialization.null.format", value);
        }
        if ((value = configuration.get("serialization.format")) != null && !value.isEmpty()) {
            props.setProperty("serialization.format", value);
        }
        if ((value = configuration.get("colelction.delim")) != null && !value.isEmpty()) {
            props.setProperty("colelction.delim", value);
        }
        if ((value = configuration.get("mapkey.delim")) != null && !value.isEmpty()) {
            props.setProperty("mapkey.delim", value);
        }
        if ((value = configuration.get("serialization.last.column.takes.rest")) != null && !value.isEmpty()) {
            props.setProperty("serialization.last.column.takes.rest", value);
        }
        if ((value = configuration.get("escape.delim")) != null && !value.isEmpty()) {
            props.setProperty("escape.delim", value);
        }
        try {
            LazyBinaryColumnarSerDe serde = null;
            String defSerde = direction2.equals((Object)ConnectorConfiguration.direction.input) ? HivePlugInConfiguration.getInputRCFileSerde(configuration) : HivePlugInConfiguration.getOutputRCFileSerde(configuration);
            if (defSerde.isEmpty()) {
                serde = new LazyBinaryColumnarSerDe();
            } else if (defSerde.equals("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe")) {
                serde = new LazyBinaryColumnarSerDe();
            } else if (defSerde.equals("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")) {
                serde = new ColumnarSerDe();
            } else {
                throw new ConnectorException(32005);
            }
            serde.initialize(configuration, props);
            return serde;
        }
        catch (SerDeException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static LazySimpleSerDe initializeLazySimpleSerde(Configuration configuration, String schema, ConnectorConfiguration.direction direction2) throws ConnectorException {
        List<String> columns = ConnectorSchemaUtils.parseColumns(schema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        HiveSchemaUtils.updateNonScaleDecimalColumns(columnTypes);
        Properties props = new Properties();
        props.setProperty(LIST_COLUMNS, HiveUtils.listToString(columnNames));
        props.setProperty(LIST_COLUMN_TYPES, HiveUtils.listToString(columnTypes));
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            props.setProperty("field.delim", HivePlugInConfiguration.getInputSeparator(configuration));
            props.setProperty("line.delim", HivePlugInConfiguration.getInputLineSeparator(configuration));
        } else {
            props.setProperty("field.delim", HivePlugInConfiguration.getOutputSeparator(configuration));
            props.setProperty("line.delim", HivePlugInConfiguration.getOutputLineSeparator(configuration));
        }
        String value = configuration.get("serialization.null.format");
        if (value == null || value.isEmpty()) {
            value = direction2.equals((Object)ConnectorConfiguration.direction.input) ? HivePlugInConfiguration.getInputNullString(configuration) : HivePlugInConfiguration.getOutputNullString(configuration);
        }
        if (value != null && !value.isEmpty()) {
            props.setProperty("serialization.null.format", value);
        }
        if ((value = configuration.get("serialization.format")) != null && !value.isEmpty()) {
            props.setProperty("serialization.format", value);
        }
        if ((value = configuration.get("colelction.delim")) != null && !value.isEmpty()) {
            props.setProperty("colelction.delim", value);
        }
        if ((value = configuration.get("mapkey.delim")) != null && !value.isEmpty()) {
            props.setProperty("mapkey.delim", value);
        }
        if ((value = configuration.get("serialization.last.column.takes.rest")) != null && !value.isEmpty()) {
            props.setProperty("serialization.last.column.takes.rest", value);
        }
        if ((value = configuration.get("escape.delim")) != null && !value.isEmpty()) {
            props.setProperty("escape.delim", value);
        }
        try {
            LazySimpleSerDe serde = new LazySimpleSerDe();
            serde.initialize(configuration, props);
            return serde;
        }
        catch (SerDeException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static TeradataTableDesc columnSchemaToTableDesc(String tableColumnSchema) throws ConnectorException {
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        List<String> columns = ConnectorSchemaUtils.parseColumns(tableColumnSchema);
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        int[] precisions = HiveSchemaUtils.lookupHiveDataTypePrecisions(columnTypes.toArray(new String[columnTypes.size()]));
        int[] scales = HiveSchemaUtils.lookupHiveDataTypeScales(columnTypes.toArray(new String[columnTypes.size()]));
        for (int i = 0; i < columnNames.size(); ++i) {
            TeradataColumnDesc columnDesc = new TeradataColumnDesc();
            String columnName = ConnectorSchemaUtils.unquoteFieldName(columnNames.get(i).trim());
            columnDesc.setName(columnName);
            columnDesc.setType(HiveSchemaUtils.lookupHiveDataTypeByName(columnTypes.get(i).trim()));
            columnDesc.setTypeName(columnTypes.get(i).trim());
            columnDesc.setNullable(true);
            columnDesc.setPrecision(precisions[i]);
            columnDesc.setScale(scales[i]);
            tableDesc.addColumn(columnDesc);
        }
        return tableDesc;
    }

    public static int[] lookupHiveDataTypeByName(String[] typeName) throws ConnectorException {
        int[] types = new int[typeName.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = HiveSchemaUtils.lookupHiveDataTypeByName(typeName[i]);
        }
        return types;
    }

    public static int lookupHiveDataTypeByName(String typeName) throws ConnectorException {
        if ((typeName = typeName.toUpperCase()).equals("INT") || typeName.equals("INTEGER")) {
            return 4;
        }
        if (typeName.equals("BIGINT") || typeName.equals("LONG")) {
            return -5;
        }
        if (typeName.equals("SMALLINT")) {
            return 5;
        }
        if (typeName.equals("STRING")) {
            return 12;
        }
        if (Pattern.matches(PATTERN_VARCHAR_TYPE, typeName)) {
            return 12;
        }
        if (typeName.equals("DATE")) {
            return 91;
        }
        if (Pattern.matches(PATTERN_CHAR_TYPE, typeName)) {
            return 1;
        }
        if (typeName.equals("DOUBLE") || typeName.equals("DOUBLE PRECISION")) {
            return 8;
        }
        if (typeName.equals("BOOLEAN")) {
            return 16;
        }
        if (typeName.equals("TIMESTAMP")) {
            return 93;
        }
        if (typeName.equals("MAP") || Pattern.matches(PATTERN_MAP_TYPE, typeName.toLowerCase())) {
            return -1000;
        }
        if (typeName.equals("ARRAY") || Pattern.matches(PATTERN_ARRAY_TYPE, typeName.toLowerCase())) {
            return -1001;
        }
        if (typeName.equals("STRUCT") || Pattern.matches(PATTERN_STRUCT_TYPE, typeName.toLowerCase())) {
            return -1002;
        }
        if (typeName.equals("TINYINT")) {
            return -6;
        }
        if (typeName.equals("FLOAT")) {
            return 6;
        }
        if (typeName.equals("BINARY")) {
            return -2;
        }
        if (typeName.equals("DECIMAL") || Pattern.matches(PATTERN_DECIMAL_TYPE, typeName)) {
            return 3;
        }
        throw new ConnectorException(14006, typeName);
    }

    public static String typeNamesToJson(String[] typeNames) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        ArrayNode types = objectNode.putArray("types");
        for (int i = 0; i < typeNames.length; ++i) {
            ObjectNode type = types.addObject();
            type.put("type", typeNames[i]);
        }
        return objectNode.toString();
    }

    public static String[] typeNamesFromJson(String typeJson) {
        if (typeJson == null || typeJson.length() == 0) {
            return new String[0];
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map tableMap = (Map)objectMapper.readValue(typeJson, Map.class);
            ArrayList types = (ArrayList)tableMap.get("types");
            String[] typeName = new String[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                Map type = (Map)types.get(i);
                typeName[i] = (String)type.get("type");
            }
            return typeName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFieldNamesFromTableDescText(String tableDescText) throws ConnectorException {
        TeradataColumnDesc[] columns;
        TeradataTableDesc tableDesc = HiveSchemaUtils.tableDescFromText(tableDescText);
        StringBuilder sb = new StringBuilder();
        for (TeradataColumnDesc column : columns = tableDesc.getColumns()) {
            sb.append(ConnectorSchemaUtils.quoteFieldName(column.getName())).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static TeradataTableDesc tableDescFromText(String tableDescText) {
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map tableMap = (Map)objectMapper.readValue(tableDescText, Map.class);
            tableDesc.setDatabaseName((String)tableMap.get("database"));
            tableDesc.setName((String)tableMap.get("table"));
            ArrayList columnList = (ArrayList)tableMap.get(LIST_COLUMNS);
            for (int i = 0; i < columnList.size(); ++i) {
                TeradataColumnDesc columnDesc = new TeradataColumnDesc();
                Map columnMap = (Map)columnList.get(i);
                columnDesc.setName((String)columnMap.get("name"));
                columnDesc.setType((Integer)columnMap.get("type"));
                columnDesc.setTypeName((String)columnMap.get("typename"));
                columnDesc.setFormat((String)columnMap.get("format"));
                columnDesc.setNullable((Integer)columnMap.get("nullable") > 0);
                Object lenObject = columnMap.get("length");
                columnDesc.setCharType((Integer)columnMap.get("chartype"));
                columnDesc.setCaseSensitive((Integer)columnMap.get("casesensitive") > 0);
                if (lenObject instanceof Integer) {
                    columnDesc.setLength(((Integer)lenObject).intValue());
                } else if (lenObject instanceof Long) {
                    columnDesc.setLength((Long)lenObject);
                }
                columnDesc.setScale((Integer)columnMap.get("scale"));
                columnDesc.setPrecision((Integer)columnMap.get("precision"));
                tableDesc.addColumn(columnDesc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableDesc;
    }

    private static Map<String, Integer> arrayToHashMap(String[] arr) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < arr.length; ++i) {
            map.put(arr[i].toLowerCase().trim(), i);
        }
        return map;
    }

    public static int[] getColumnMapping(String[] ColNames, String[] mappingNames) {
        Map<String, Integer> map = HiveSchemaUtils.arrayToHashMap(ColNames);
        int[] mapping = new int[mappingNames.length];
        for (int i = 0; i < mappingNames.length; ++i) {
            mapping[i] = map.get(mappingNames[i].toLowerCase().trim());
        }
        return mapping;
    }

    public static HiveDataType[] lookupWritableHiveDataTypes(String[] typeNames) throws ConnectorException {
        HiveDataType[] fieldDataTypes = new HiveDataType[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            String typeName = typeNames[i].toUpperCase();
            fieldDataTypes[i] = Pattern.matches(PATTERN_VARCHAR_TYPE, typeName) ? HiveSchemaUtils.lookupHiveDataTypeWritableImpl(-2001) : HiveSchemaUtils.lookupHiveDataTypeWritableImpl(HiveSchemaUtils.lookupHiveDataTypeByName(typeNames[i]));
        }
        return fieldDataTypes;
    }

    public static HiveDataType[] lookupLazyHiveDataTypes(String[] typeNames) throws ConnectorException {
        HiveDataType[] fieldDataTypes = new HiveDataType[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            String typeName = typeNames[i].toUpperCase();
            fieldDataTypes[i] = Pattern.matches(PATTERN_VARCHAR_TYPE, typeName) ? HiveSchemaUtils.lookupHiveDataTypeLazyImpl(-2001) : HiveSchemaUtils.lookupHiveDataTypeLazyImpl(HiveSchemaUtils.lookupHiveDataTypeByName(typeNames[i]));
        }
        return fieldDataTypes;
    }

    public static int[] lookupHiveDataTypePrecisions(String[] typeNames) throws ConnectorException {
        int[] precisions = new int[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            HiveDataType dt = HiveSchemaUtils.lookupHiveDataTypeLazyImpl(HiveSchemaUtils.lookupHiveDataTypeByName(typeNames[i]));
            if (dt == HiveDataType.HiveDataTypeLazyImpl.DECIMAL) {
                Matcher m = decimalPattern.matcher(typeNames[i].toUpperCase());
                if (m.find()) {
                    precisions[i] = Integer.parseInt(m.group(1));
                    continue;
                }
                precisions[i] = 10;
                continue;
            }
            precisions[i] = 5;
        }
        return precisions;
    }

    public static int[] lookupHiveDataTypeScales(String[] typeNames) throws ConnectorException {
        int[] scales = new int[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            HiveDataType dt = HiveSchemaUtils.lookupHiveDataTypeLazyImpl(HiveSchemaUtils.lookupHiveDataTypeByName(typeNames[i]));
            if (dt == HiveDataType.HiveDataTypeLazyImpl.DECIMAL) {
                Matcher m = decimalPattern.matcher(typeNames[i].toUpperCase());
                if (m.find() && m.group(3) != null) {
                    scales[i] = Integer.parseInt(m.group(3));
                    continue;
                }
                scales[i] = 0;
                continue;
            }
            scales[i] = 6;
        }
        return scales;
    }

    public static void updateNonScaleDecimalColumns(List<String> columnTypes) {
        for (int i = 0; i < columnTypes.size(); ++i) {
            if (columnTypes.get(i).toUpperCase().equals("DECIMAL")) {
                columnTypes.set(i, "decimal(10,0)");
                continue;
            }
            Matcher m = decimalPattern.matcher(columnTypes.get(i).toUpperCase());
            if (!m.find() || m.group(2) != null) continue;
            String cType = columnTypes.get(i);
            cType = cType.replace(")", ",0)");
            columnTypes.set(i, cType);
        }
    }

    public static String lookupTypeNameByDataType(int datatype) throws ConnectorException {
        switch (datatype) {
            case 16: {
                return "boolean";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "bigint";
            }
            case 5: {
                return "smallint";
            }
            case -6: {
                return "tinyint";
            }
            case 6: {
                return "float";
            }
            case -2: {
                return "BINARY";
            }
            case 93: {
                return "timestamp";
            }
            case 12: {
                return "string";
            }
            case 8: {
                return "double";
            }
            case -1000: {
                return "map";
            }
            case -1001: {
                return "array";
            }
            case -1002: {
                return "struct";
            }
        }
        throw new ConnectorException(14006, datatype);
    }

    public static void logHiveTableExtInfo(Log logger, String databaseName, String tableName, HiveConf hiveConf) throws ConnectorException, UnknownDBException, TException, HiveException {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Hive hive = Hive.get((HiveConf)hiveConf);
        Table tbl = hive.getTable(databaseName, tableName);
        String tblInfo = MetaDataFormatUtils.getTableInformation((Table)tbl);
        String colInfo = HiveSchemaUtils.printHiveTableSchema(tbl.getCols(), tbl.isPartitioned() ? tbl.getPartCols() : null);
        logger.debug((Object)("\n# Hive Table Info For " + databaseName + "." + tableName + ":\n" + colInfo + "\n" + tblInfo));
    }

    public static void logHivePartitionValues(Log logger, String databaseName, String tableName, HiveConf hiveConf) throws UnknownDBException, TException {
        if (!logger.isDebugEnabled()) {
            return;
        }
        HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf, null);
        List partitions = client.listPartitions(databaseName, tableName, (short)20000);
        if (partitions.size() > 0) {
            for (Partition partition : partitions) {
                logger.debug((Object)("#Partition Location: " + partition.getSd().getLocation()));
            }
        }
    }

    public static void checkSchemaMatch(ConnectorRecordSchema r1, ConnectorRecordSchema r2) throws ConnectorException {
        if (r1.getLength() != r2.getLength()) {
            throw new ConnectorException(14013);
        }
        for (int i = 0; i < r1.getLength(); ++i) {
            if (r1.getFieldType(i) == 1883 || r2.getFieldType(i) == 1883 || HiveSchemaUtils.isHiveComplexType(r1.getFieldType(i)) && r2.getFieldType(i) == 12 || HiveSchemaUtils.isHiveComplexType(r2.getFieldType(i)) && r1.getFieldType(i) == 12 || r1.getFieldType(i) == r2.getFieldType(i)) continue;
            throw new ConnectorException(14015);
        }
    }

    public static boolean isHiveComplexType(int type) {
        return -1001 == type || -1000 == type || -1002 == type;
    }

    public static ConnectorDataTypeConverter[] initializeHiveTypeDecoder(String targetTableSchema) throws ConnectorException {
        List<String> columns = ConnectorSchemaUtils.parseColumns(targetTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        ConnectorDataTypeConverter[] hiveDecoder = new ConnectorDataTypeConverter[columns.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            HiveDataTypeConverter converter = null;
            String targetName = columnNames.get(i);
            String targetTypeNames = columnTypes.get(i);
            int type = HiveSchemaUtils.lookupHiveDataTypeByName(targetTypeNames);
            if (Pattern.matches(PATTERN_VARCHAR_TYPE, targetTypeNames.toUpperCase())) {
                type = -2001;
            }
            if (!HiveSchemaUtils.isHiveComplexType(type) && type != 3 && type != -2001 && type != 1) continue;
            switch (type) {
                case -1000: {
                    converter = new HiveDataTypeConverter.JsonStringToMap(targetName, targetTypeNames);
                    converter.setDefaultValue(-1000);
                    break;
                }
                case -1001: {
                    converter = new HiveDataTypeConverter.JsonStringToArray(targetName, targetTypeNames);
                    break;
                }
                case -1002: {
                    converter = new HiveDataTypeConverter.JsonStringToStruct(targetName, targetTypeNames);
                    break;
                }
                case 3: {
                    if (HiveDecimal.class.getConstructors().length != 0) {
                        converter = new HiveDataTypeConverter.BigDecimalToHiveDecimalWithConstructor(targetName, targetTypeNames);
                        break;
                    }
                    converter = new HiveDataTypeConverter.BigDecimalToHiveDecimalWithCreateMethod(targetName, targetTypeNames);
                    break;
                }
                case -2001: {
                    converter = new HiveDataTypeConverter.StringToHiveVarchar(targetName, targetTypeNames);
                    break;
                }
                case 1: {
                    converter = new HiveDataTypeConverter.StringToHiveChar(targetName, targetTypeNames);
                }
            }
            hiveDecoder[i] = converter;
        }
        return hiveDecoder;
    }

    public static ConnectorDataTypeConverter[] initializeHiveTypeEncoder(String sourceTableSchema) throws ConnectorException {
        List<String> columns = ConnectorSchemaUtils.parseColumns(sourceTableSchema.toLowerCase());
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        ConnectorDataTypeConverter[] jsonEncoder = new ConnectorDataTypeConverter[columns.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            ConnectorDataTypeConverter.ObjectToJsonString converter = new ConnectorDataTypeConverter.ObjectToJsonString();
            int type = HiveSchemaUtils.lookupHiveDataTypeByName(columnTypes.get(i));
            if (!HiveSchemaUtils.isHiveComplexType(type)) continue;
            switch (type) {
                case -1002: 
                case -1001: 
                case -1000: {
                    converter = new ConnectorDataTypeConverter.ObjectToJsonString();
                    converter.setDefaultValue("");
                }
            }
            jsonEncoder[i] = converter;
        }
        return jsonEncoder;
    }

    private static String printHiveTableSchema(List<FieldSchema> cols, List<FieldSchema> partCols) {
        StringBuffer sb = new StringBuffer();
        sb.append("# col_name              data_type               comment\n");
        HiveSchemaUtils.printHiveTableColumn(cols, sb);
        if (partCols != null && !partCols.isEmpty()) {
            sb.append("# Partition Information\n");
            sb.append("# col_name              data_type               comment\n");
            HiveSchemaUtils.printHiveTableColumn(partCols, sb);
        }
        return sb.toString();
    }

    private static void printHiveTableColumn(List<FieldSchema> cols, StringBuffer sb) {
        for (FieldSchema col : cols) {
            String colName = col.getName();
            String colType = col.getType();
            String colComment = col.getComment() == null ? "" : col.getComment();
            sb.append("   " + colName + "                 " + colType + "           " + colComment);
            sb.append("\n");
        }
    }
}

