/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorUnicodeCharacterConverter;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class HivePlugInConfiguration
extends ConnectorConfiguration {
    private static final String TDCH_INPUT_HIVE_NULL_STRING = "tdch.input.hive.null.string";
    private static final String TDCH_INPUT_HIVE_FIELDS_SEPARATOR = "tdch.input.hive.fields.separator";
    private static final String TDCH_INPUT_HIVE_TABLE_SCHEMA = "tdch.input.hive.table.schema";
    private static final String TDCH_INPUT_HIVE_PARTITION_SCHEMA = "tdch.input.hive.partition.schema";
    private static final String TDCH_INPUT_HIVE_CONF_FILE = "tdch.input.hive.conf.file";
    private static final String TDCH_INPUT_HIVE_LINE_SEPARATOR = "tdch.input.hive.line.separator";
    private static final String TDCH_INPUT_HIVE_PATHS = "tdch.input.hive.paths";
    private static final String TDCH_INPUT_PARQUET_READ_SUPPORT_CLASS = "parquet.read.support.class";
    private static final String TDCH_INPUT_READ_SUPPORT_CLASS_VALUE = "com.teradata.connector.hive.HiveParquetReadSupportExt";
    private static final String TDCH_INPUT_HIVE_DATABASE = "tdch.input.hive.database";
    private static final String TDCH_INPUT_HIVE_TABLE = "tdch.input.hive.table";
    private static final String TDCH_INPUT_HIVE_TYPE_NAME = "tdch.input.hive.type.name";
    private static final String TDCH_INPUT_HIVE_SCHEMA_FIELD_NAMES = "tdch.input.hive.schema.field.names";
    private static final String TDCH_INPUT_HIVE_FIELD_NAMES = "tdch.input.hive.field.names";
    private static final String TDCH_INPUT_HIVE_PARTITION_FILTERS = "tdch.input.hive.partition.filter";
    private static final String TDCH_INPUT_HIVE_RCFILE_SERDE = "tdch.input.hive.rcfile.serde";
    private static final String TDCH_OUTPUT_HIVE_NULL_STRING = "tdch.output.hive.null.string";
    private static final String TDCH_OUTPUT_HIVE_FIELDS_SEPARATOR = "tdch.output.hive.fields_separator";
    private static final String TDCH_OUTPUT_HIVE_TABLE_SCHEMA = "tdch.output.hive.table.schema";
    private static final String TDCH_OUTPUT_HIVE_PARTITION_SCHEMA = "tdch.output.hive.partition.schema";
    private static final String TDCH_OUTPUT_HIVE_CONF_FILE = "tdch.output.hive.conf.file";
    private static final String TDCH_OUTPUT_HIVE_LINE_SEPARATOR = "tdch.output.hive.line.separator";
    private static final String TDCH_OUTPUT_HIVE_PATHS = "tdch.output.hive.paths";
    private static final String TDCH_OUTPUT_HIVE_DATABASE = "tdch.output.hive.database";
    private static final String TDCH_OUTPUT_HIVE_TABLE = "tdch.output.hive.table";
    private static final String TDCH_OUTPUT_HIVE_TYPE_NAME = "tdch.output.hive.type.name";
    private static final String TDCH_OUTPUT_HIVE_SCHEMA_FIELD_NAMES = "tdch.output.hive.schema.field.names";
    private static final String TDCH_OUTPUT_HIVE_FIELD_NAMES = "tdch.output.hive.field.names";
    private static final String TDCH_OUTPUT_HIVE_RCFILE_SERDE = "tdch.output.hive.rcfile.serde";
    private static final String TDCH_OUTPUT_HIVE_OVERWRITE = "tdch.output.hive.overwrite";
    public static final String VALUE_FIELDS_SEPARATOR = "\\u0001";
    public static final String VALUE_LINE_SEPARATOR = "\n";

    public static String getInputNullString(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_NULL_STRING);
    }

    public static void setInputNullString(Configuration configuration, String nullString) {
        configuration.set(TDCH_INPUT_HIVE_NULL_STRING, nullString.trim());
    }

    public static String getReadSupportClass(Configuration configuration) {
        return configuration.get(TDCH_INPUT_PARQUET_READ_SUPPORT_CLASS);
    }

    public static void setReadSupportClass(Configuration configuration) {
        configuration.set(TDCH_INPUT_PARQUET_READ_SUPPORT_CLASS, TDCH_INPUT_READ_SUPPORT_CLASS_VALUE);
    }

    public static void setInputSeparator(Configuration configuration, String separator) throws ConnectorException {
        configuration.set(TDCH_INPUT_HIVE_FIELDS_SEPARATOR, separator);
        if (separator != null && separator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
        }
    }

    public static String getInputSeparator(Configuration configuration) throws ConnectorException {
        String separator = configuration.get(TDCH_INPUT_HIVE_FIELDS_SEPARATOR, VALUE_FIELDS_SEPARATOR);
        if (separator != null && separator.length() > 0) {
            separator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
            separator = separator.substring(0, 1);
        }
        return separator;
    }

    public static void setInputTableSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_INPUT_HIVE_TABLE_SCHEMA, schema);
    }

    public static String getInputTableSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_TABLE_SCHEMA, "");
    }

    public static void setInputPartitionSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_INPUT_HIVE_PARTITION_SCHEMA, schema);
    }

    public static String getInputPartitionSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_PARTITION_SCHEMA, "");
    }

    public static void setInputConfigureFile(Configuration configuration, String filePath) {
        if (filePath != null && filePath.trim().length() != 0) {
            configuration.set(TDCH_INPUT_HIVE_CONF_FILE, filePath.trim());
        }
    }

    public static String getInputConfigureFile(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_CONF_FILE, "");
    }

    public static void setInputLineSeparator(Configuration configuration, String lineSeparator) throws ConnectorException {
        configuration.set(TDCH_INPUT_HIVE_LINE_SEPARATOR, lineSeparator);
        if (lineSeparator != null && lineSeparator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(lineSeparator);
        }
    }

    public static String getInputLineSeparator(Configuration configuration) throws ConnectorException {
        String lineSeparator = configuration.get(TDCH_INPUT_HIVE_LINE_SEPARATOR, VALUE_LINE_SEPARATOR);
        if (lineSeparator != null && lineSeparator.length() > 0) {
            lineSeparator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(lineSeparator);
            lineSeparator = lineSeparator.substring(0, 1);
        }
        return lineSeparator;
    }

    public static void setInputPaths(Configuration configuration, String paths) {
        configuration.set(TDCH_INPUT_HIVE_PATHS, paths);
        configuration.set("mapred.input.dir", paths);
    }

    public static String getInputPaths(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_PATHS, "");
    }

    public static void setInputDatabase(Configuration configuration, String inputDatabase) {
        configuration.set(TDCH_INPUT_HIVE_DATABASE, inputDatabase);
    }

    public static String getInputDatabase(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_DATABASE, "");
    }

    public static void setInputTable(Configuration configuration, String inputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(inputTable, 2, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(TDCH_INPUT_HIVE_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(TDCH_INPUT_HIVE_DATABASE, tokens.get(0));
                configuration.set(TDCH_INPUT_HIVE_TABLE, tokens.get(1));
            }
        }
    }

    public static String getInputTable(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_TABLE, "");
    }

    public static void setInputTableFieldTypes(Configuration configuration, String[] typeNames) {
        configuration.set(TDCH_INPUT_HIVE_TYPE_NAME, HiveSchemaUtils.typeNamesToJson(typeNames));
    }

    public static String[] getInputTableFieldTypes(Configuration configuration) {
        return HiveSchemaUtils.typeNamesFromJson(configuration.get(TDCH_INPUT_HIVE_TYPE_NAME, ""));
    }

    public static void setInputTableFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_INPUT_HIVE_SCHEMA_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getInputTableFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_INPUT_HIVE_SCHEMA_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setInputFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_INPUT_HIVE_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getInputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_INPUT_HIVE_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setInputPartitionFilters(Configuration configuration, String[] filters) {
        configuration.setStrings(TDCH_INPUT_HIVE_PARTITION_FILTERS, filters);
    }

    public static String[] getInputPartitionFilters(Configuration configuration) {
        return configuration.getStrings(TDCH_INPUT_HIVE_PARTITION_FILTERS, new String[0]);
    }

    public static void setInputRCFileSerde(Configuration configuration, String serde) {
        configuration.set(TDCH_INPUT_HIVE_RCFILE_SERDE, serde);
    }

    public static String getInputRCFileSerde(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HIVE_RCFILE_SERDE, "");
    }

    public static String getOutputNullString(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_NULL_STRING);
    }

    public static void setOutputNullString(Configuration configuration, String nullString) {
        configuration.set(TDCH_OUTPUT_HIVE_NULL_STRING, nullString.trim());
    }

    public static void setOutputSeparator(Configuration configuration, String separator) throws ConnectorException {
        configuration.set(TDCH_OUTPUT_HIVE_FIELDS_SEPARATOR, separator);
        if (separator != null && separator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
        }
    }

    public static String getOutputSeparator(Configuration configuration) throws ConnectorException {
        String separator = configuration.get(TDCH_OUTPUT_HIVE_FIELDS_SEPARATOR, VALUE_FIELDS_SEPARATOR);
        if (separator != null && separator.length() > 0) {
            separator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
            separator = separator.substring(0, 1);
        }
        return separator;
    }

    public static void setOutputLineSeparator(Configuration configuration, String separator) throws ConnectorException {
        configuration.set(TDCH_OUTPUT_HIVE_LINE_SEPARATOR, separator);
        if (separator != null && separator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
        }
    }

    public static String getOutputLineSeparator(Configuration configuration) throws ConnectorException {
        String lineSeparator = configuration.get(TDCH_OUTPUT_HIVE_LINE_SEPARATOR, VALUE_LINE_SEPARATOR);
        if (lineSeparator != null && lineSeparator.length() > 0) {
            lineSeparator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(lineSeparator);
            lineSeparator = lineSeparator.substring(0, 1);
        }
        return lineSeparator;
    }

    public static void setOutputTableSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_OUTPUT_HIVE_TABLE_SCHEMA, schema);
    }

    public static String getOutputTableSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_TABLE_SCHEMA, "");
    }

    public static void setOutputPaths(Configuration configuration, String paths) {
        configuration.set(TDCH_OUTPUT_HIVE_PATHS, paths);
        configuration.set("mapred.output.dir", paths);
    }

    public static String getOutputPaths(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_PATHS, "");
    }

    public static void setOutputConfigureFile(Configuration configuration, String filePath) {
        if (filePath != null && filePath.trim().length() != 0) {
            configuration.set(TDCH_OUTPUT_HIVE_CONF_FILE, filePath.trim());
        }
    }

    public static String getOutputConfigureFile(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_CONF_FILE, "");
    }

    public static void setOutputDatabase(Configuration configuration, String inputDatabase) {
        configuration.set(TDCH_OUTPUT_HIVE_DATABASE, inputDatabase);
    }

    public static String getOutputDatabase(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_DATABASE, "");
    }

    public static void setOutputTable(Configuration configuration, String inputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(inputTable, 2, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(TDCH_OUTPUT_HIVE_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(TDCH_OUTPUT_HIVE_DATABASE, tokens.get(0));
                configuration.set(TDCH_OUTPUT_HIVE_TABLE, tokens.get(1));
            }
        }
    }

    public static String getOutputTable(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_TABLE, "");
    }

    public static void setOutputTableFieldTypes(Configuration configuration, String[] typeNames) {
        typeNames = ConnectorSchemaUtils.unquoteFieldNamesArray(typeNames);
        String typeNamesJson = ConnectorSchemaUtils.fieldNamesToJson(typeNames);
        configuration.set(TDCH_OUTPUT_HIVE_TYPE_NAME, typeNamesJson);
    }

    public static String[] getOutputTableFieldTypes(Configuration configuration) {
        String targetFieldNamesArrayJson = configuration.get(TDCH_OUTPUT_HIVE_TYPE_NAME, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(targetFieldNamesArrayJson);
    }

    public static void setOutputTableFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_OUTPUT_HIVE_SCHEMA_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getOutputTableFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_OUTPUT_HIVE_SCHEMA_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setOutputPartitionSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_OUTPUT_HIVE_PARTITION_SCHEMA, schema);
    }

    public static String getOutputPartitionSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_PARTITION_SCHEMA, "");
    }

    public static void setOutputFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_OUTPUT_HIVE_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getOutputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_OUTPUT_HIVE_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setOutputRCFileSerde(Configuration configuration, String serde) {
        configuration.set(TDCH_OUTPUT_HIVE_RCFILE_SERDE, serde);
    }

    public static String getOutputRCFileSerde(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HIVE_RCFILE_SERDE, "");
    }

    public static void setOutputOverwrite(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_OUTPUT_HIVE_OVERWRITE, value);
    }

    public static boolean getOutputOverwrite(Configuration configuration) {
        return configuration.getBoolean(TDCH_OUTPUT_HIVE_OVERWRITE, false);
    }
}

