/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.hive.serde.HiveConnectorSerDe;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class HiveTextFileSerDe
extends HiveConnectorSerDe {
    private LazySimpleSerDe serde = null;
    private StructObjectInspector objectInspector = null;
    protected static LazyStruct cachedLazyStruct = null;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        super.initialize(context, direction2);
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(this.configuration);
            this.serde = HiveSchemaUtils.initializeLazySimpleSerde(this.configuration, sourceTableSchema, direction2);
            this.inputSchemaDataTypes = HiveSchemaUtils.lookupLazyHiveDataTypes(HivePlugInConfiguration.getInputTableFieldTypes(this.configuration));
        } else {
            String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(this.configuration);
            this.serde = HiveSchemaUtils.initializeLazySimpleSerde(this.configuration, targetTableSchema, direction2);
            this.objectInspector = HiveSchemaUtils.createStructObjectInspector(targetTableSchema);
        }
    }

    @Override
    protected Writable doSerialize(ConnectorRecord r) throws SerDeException {
        return this.serde.serialize(Arrays.asList(r.getAllObject()), (ObjectInspector)this.objectInspector);
    }

    @Override
    protected ConnectorRecord doDeserialize(Writable w) throws SerDeException {
        cachedLazyStruct = (LazyStruct)this.serde.deserialize(w);
        for (int i = 0; i < this.nonPartSize; ++i) {
            try {
                this.deserRecord.set(i, this.inputSchemaDataTypes[i].transform(cachedLazyStruct.getField(i)));
                continue;
            }
            catch (ConnectorException e) {
                e.printStackTrace();
            }
        }
        return this.deserRecord;
    }
}

