/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.converter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveChar;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveVarchar;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public interface HiveDataType {
    public int getType();

    public Object transform(Object var1);

    public static enum HiveDataTypeWritableImpl implements HiveDataType
    {
        BOOLEAN(1){

            @Override
            public int getType() {
                return 16;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Boolean.valueOf(((BooleanWritable)object).get());
            }
        }
        ,
        INTEGER(2){

            @Override
            public final int getType() {
                return 4;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Integer.valueOf(((IntWritable)object).get());
            }
        }
        ,
        BIGINT(3){

            @Override
            public final int getType() {
                return -5;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Long.valueOf(((LongWritable)object).get());
            }
        }
        ,
        SMALLINT(4){

            @Override
            public final int getType() {
                return 5;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Short.valueOf(((ShortWritable)object).get());
            }
        }
        ,
        TINYINT(5){

            @Override
            public final int getType() {
                return -6;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Byte.valueOf(((ByteWritable)object).get());
            }
        }
        ,
        DECIMAL(6){

            @Override
            public final int getType() {
                return 3;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((HiveDecimalWritable)object).getHiveDecimal().bigDecimalValue();
            }
        }
        ,
        FLOAT(7){

            @Override
            public final int getType() {
                return 6;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Float.valueOf(((FloatWritable)object).get());
            }
        }
        ,
        BINARY(8){

            @Override
            public final int getType() {
                return -2;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((BytesWritable)object).get();
            }
        }
        ,
        TIMESTAMP(9){

            @Override
            public final int getType() {
                return 93;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((TimestampWritable)object).getTimestamp();
            }
        }
        ,
        STRING(10){

            @Override
            public final int getType() {
                return 12;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((Text)object).toString();
            }
        }
        ,
        DOUBLE(11){

            @Override
            public final int getType() {
                return 8;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Double.valueOf(((DoubleWritable)object).get());
            }
        }
        ,
        MAP(12){

            @Override
            public int getType() {
                return -1000;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                Map lazyObjectsMap = ((LazyBinaryMap)object).getMap();
                HashMap<Object, Object> javaObjectsMap = new HashMap<Object, Object>();
                for (Map.Entry entry : lazyObjectsMap.entrySet()) {
                    javaObjectsMap.put(this.parseWritableObject(entry.getKey()), this.parseWritableObject(entry.getValue()));
                }
                return javaObjectsMap;
            }
        }
        ,
        ARRAY(13){

            @Override
            public final int getType() {
                return -1001;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                List lazyObjectsList = ((LazyBinaryArray)object).getList();
                ArrayList<Object> javaObjectsList = new ArrayList<Object>();
                for (Object item : lazyObjectsList) {
                    javaObjectsList.add(this.parseWritableObject(item));
                }
                return javaObjectsList;
            }
        }
        ,
        STRUCT(14){

            @Override
            public int getType() {
                return -1002;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                ArrayList lazyObjectsList = ((LazyBinaryStruct)object).getFieldsAsList();
                ArrayList<Object> javaObjectsList = new ArrayList<Object>();
                for (Object item : lazyObjectsList) {
                    javaObjectsList.add(this.parseWritableObject(item));
                }
                return javaObjectsList;
            }
        }
        ,
        CHAR(15){

            @Override
            public final int getType() {
                return 1;
            }

            @Override
            public Object transform(Object object) {
                if (object instanceof HiveCharWritable) {
                    HiveCharWritable hvw = new HiveCharWritable();
                    hvw = (HiveCharWritable)object;
                    String strChar = hvw.getHiveChar().getValue();
                    return object == null ? null : strChar;
                }
                return object == null ? null : (HiveCharWritable)((LazyHiveChar)object).getWritableObject();
            }
        }
        ,
        DATE(16){

            @Override
            public final int getType() {
                return 91;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((DateWritable)object).get();
            }
        }
        ,
        VARCHAR(17){

            @Override
            public final int getType() {
                return -2001;
            }

            @Override
            public Object transform(Object object) {
                if (object instanceof HiveVarcharWritable) {
                    HiveVarcharWritable hvw = new HiveVarcharWritable();
                    hvw = (HiveVarcharWritable)object;
                    String strVarchar = hvw.getHiveVarchar().getValue();
                    return object == null ? null : strVarchar;
                }
                return object == null ? null : (HiveVarcharWritable)((LazyHiveVarchar)object).getWritableObject();
            }
        }
        ,
        OTHER(99){

            @Override
            public final int getType() {
                return 1882;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : object.toString();
            }
        };

        private static boolean hiveDecimalWritableAvailable;
        private int index = 0;

        private HiveDataTypeWritableImpl(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        protected Object parseWritableObject(Object object) {
            if (object instanceof IntWritable) {
                return INTEGER.transform(object);
            }
            if (object instanceof LongWritable) {
                return BIGINT.transform(object);
            }
            if (object instanceof ShortWritable) {
                return SMALLINT.transform(object);
            }
            if (object instanceof ByteWritable) {
                return TINYINT.transform(object);
            }
            if (object instanceof BytesWritable) {
                return BINARY.transform(object);
            }
            if (object instanceof BooleanWritable) {
                return BOOLEAN.transform(object);
            }
            if (hiveDecimalWritableAvailable && object instanceof HiveDecimalWritable) {
                return DECIMAL.transform(object);
            }
            if (object instanceof FloatWritable) {
                return FLOAT.transform(object);
            }
            if (object instanceof DateWritable) {
                return DATE.transform(object);
            }
            if (object instanceof LazyHiveChar) {
                return CHAR.transform(object);
            }
            if (object instanceof LazyHiveVarchar) {
                return VARCHAR.transform(object);
            }
            if (object instanceof DoubleWritable) {
                return DOUBLE.transform(object);
            }
            if (object instanceof Text) {
                return STRING.transform(object);
            }
            if (object instanceof TimestampWritable) {
                return TIMESTAMP.transform(object);
            }
            if (object instanceof LazyBinaryMap) {
                return MAP.transform(object);
            }
            if (object instanceof LazyBinaryArray) {
                return ARRAY.transform(object);
            }
            if (object instanceof LazyBinaryStruct) {
                return STRUCT.transform(object);
            }
            return null;
        }

        static {
            hiveDecimalWritableAvailable = false;
            try {
                Class.forName("org.apache.hadoop.hive.serde2.io.HiveDecimalWritable");
                hiveDecimalWritableAvailable = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static enum HiveDataTypeLazyImpl implements HiveDataType
    {
        BOOLEAN(1){

            @Override
            public int getType() {
                return 16;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Boolean.valueOf(((BooleanWritable)((LazyBoolean)object).getWritableObject()).get());
            }
        }
        ,
        INTEGER(2){

            @Override
            public final int getType() {
                return 4;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Integer.valueOf(((IntWritable)((LazyInteger)object).getWritableObject()).get());
            }
        }
        ,
        BIGINT(3){

            @Override
            public final int getType() {
                return -5;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Long.valueOf(((LongWritable)((LazyLong)object).getWritableObject()).get());
            }
        }
        ,
        SMALLINT(4){

            @Override
            public final int getType() {
                return 5;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Short.valueOf(((ShortWritable)((LazyShort)object).getWritableObject()).get());
            }
        }
        ,
        TINYINT(5){

            @Override
            public final int getType() {
                return -6;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Byte.valueOf(((ByteWritable)((LazyByte)object).getWritableObject()).get());
            }
        }
        ,
        DECIMAL(6){

            @Override
            public final int getType() {
                return 3;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((LazyHiveDecimal)object).getWritableObject().getHiveDecimal().bigDecimalValue();
            }
        }
        ,
        FLOAT(7){

            @Override
            public final int getType() {
                return 6;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Float.valueOf(((FloatWritable)((LazyFloat)object).getWritableObject()).get());
            }
        }
        ,
        BINARY(8){

            @Override
            public final int getType() {
                return -2;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? new byte[]{} : ((BytesWritable)((LazyBinary)object).getWritableObject()).getBytes();
            }
        }
        ,
        TIMESTAMP(9){

            @Override
            public final int getType() {
                return 93;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((LazyTimestamp)object).getWritableObject().getTimestamp();
            }
        }
        ,
        STRING(10){

            @Override
            public final int getType() {
                return 12;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((Text)((LazyString)object).getWritableObject()).toString();
            }
        }
        ,
        DOUBLE(11){

            @Override
            public final int getType() {
                return 8;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : Double.valueOf(((DoubleWritable)((LazyDouble)object).getWritableObject()).get());
            }
        }
        ,
        MAP(12){

            @Override
            public int getType() {
                return -1000;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                Map lazyObjectsMap = ((LazyMap)object).getMap();
                HashMap<Object, Object> javaObjectsMap = new HashMap<Object, Object>();
                for (Map.Entry entry : lazyObjectsMap.entrySet()) {
                    javaObjectsMap.put(this.parseLazyObject(entry.getKey()), this.parseLazyObject(entry.getValue()));
                }
                return javaObjectsMap;
            }
        }
        ,
        ARRAY(13){

            @Override
            public final int getType() {
                return -1001;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                List lazyObjectsList = ((LazyArray)object).getList();
                ArrayList<Object> javaObjectsList = new ArrayList<Object>();
                for (Object item : lazyObjectsList) {
                    javaObjectsList.add(this.parseLazyObject(item));
                }
                return javaObjectsList;
            }
        }
        ,
        STRUCT(14){
            private boolean lazyStructReflectionInitd = false;
            private Method LazyStructGetFieldsAsListMethod = null;

            @Override
            public int getType() {
                return -1002;
            }

            @Override
            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                if (!this.lazyStructReflectionInitd) {
                    this.initializeLazyStructReflection();
                }
                List lazyObjectsList = null;
                try {
                    lazyObjectsList = (List)this.LazyStructGetFieldsAsListMethod.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
                ArrayList<Object> javaObjectsList = new ArrayList<Object>();
                for (Object item : lazyObjectsList) {
                    javaObjectsList.add(this.parseLazyObject(item));
                }
                return javaObjectsList;
            }

            private void initializeLazyStructReflection() {
                try {
                    Class<?> LazyStructClass = Class.forName("org.apache.hadoop.hive.serde2.lazy.LazyStruct");
                    this.LazyStructGetFieldsAsListMethod = LazyStructClass.getMethod("getFieldsAsList", new Class[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        ,
        CHAR(15){

            @Override
            public final int getType() {
                return 1;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((HiveCharWritable)((LazyHiveChar)object).getWritableObject()).toString();
            }
        }
        ,
        DATE(16){

            @Override
            public final int getType() {
                return 91;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((DateWritable)((LazyDate)object).getWritableObject()).get();
            }
        }
        ,
        VARCHAR(17){

            @Override
            public final int getType() {
                return -2001;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : ((HiveVarcharWritable)((LazyHiveVarchar)object).getWritableObject()).toString();
            }
        }
        ,
        OTHER(99){

            @Override
            public final int getType() {
                return 1882;
            }

            @Override
            public Object transform(Object object) {
                return object == null ? null : object.toString();
            }
        };

        private static boolean lazyHiveDecimalAvailable;
        private int index = 0;

        private HiveDataTypeLazyImpl(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        protected Object parseLazyObject(Object object) {
            if (object instanceof LazyInteger) {
                return INTEGER.transform(object);
            }
            if (object instanceof LazyLong) {
                return BIGINT.transform(object);
            }
            if (object instanceof LazyShort) {
                return SMALLINT.transform(object);
            }
            if (object instanceof LazyByte) {
                return TINYINT.transform(object);
            }
            if (object instanceof LazyBinary) {
                return BINARY.transform(object);
            }
            if (object instanceof LazyHiveChar) {
                return CHAR.transform(object);
            }
            if (object instanceof LazyBoolean) {
                return BOOLEAN.transform(object);
            }
            if (lazyHiveDecimalAvailable && object instanceof LazyHiveDecimal) {
                return DECIMAL.transform(object);
            }
            if (object instanceof LazyFloat) {
                return FLOAT.transform(object);
            }
            if (object instanceof LazyDouble) {
                return DOUBLE.transform(object);
            }
            if (object instanceof LazyString) {
                return STRING.transform(object);
            }
            if (object instanceof LazyHiveVarchar) {
                return VARCHAR.transform(object);
            }
            if (object instanceof LazyDate) {
                return DATE.transform(object);
            }
            if (object instanceof LazyTimestamp) {
                return TIMESTAMP.transform(object);
            }
            if (object instanceof LazyMap) {
                return MAP.transform(object);
            }
            if (object instanceof LazyArray) {
                return ARRAY.transform(object);
            }
            if (object instanceof LazyStruct) {
                return STRUCT.transform(object);
            }
            return null;
        }

        static {
            lazyHiveDecimalAvailable = false;
            try {
                Class.forName("org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal");
                lazyHiveDecimalAvailable = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

