/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.hive.DataWritableWriterExt;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageTypeParser;
import parquet.schema.MessageType;

public class ParquetWriteSupportExt
extends WriteSupport<ParquetHiveRecord> {
    public static final String PARQUET_HIVE_SCHEMA = "parquet.hive.schema";
    private DataWritableWriterExt writer;
    private org.apache.parquet.schema.MessageType schema;

    public static void setSchema(MessageType messageType, Configuration configuration) {
        configuration.set(PARQUET_HIVE_SCHEMA, messageType.toString());
    }

    public static org.apache.parquet.schema.MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)configuration.get(PARQUET_HIVE_SCHEMA));
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = ParquetWriteSupportExt.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new DataWritableWriterExt(recordConsumer, (GroupType)this.schema);
    }

    public void write(ArrayWritable record) {
        this.writer.write(record);
    }

    public void write(ParquetHiveRecord arg0) {
    }
}

