/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.hive.BasicDataTypes;
import com.teradata.connector.hive.ParquetExt;
import com.teradata.connector.hive.ParquetFactoryExt;
import com.teradata.connector.hive.ParquetInt96Value;
import com.teradata.connector.hive.ParquetNanoTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class HiveParquetReadSupportExt
extends ReadSupport<ParquetExt> {
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = HiveParquetReadSupportExt.getSchemaForRead((MessageType)fileSchema, (String)partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    public RecordMaterializer<ParquetExt> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new RecordMaterializerExt(readContext.getRequestedSchema());
    }

    class ParquetLongValue
    extends BasicDataTypes {
        private final long value;

        public ParquetLongValue(long value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addLong(this.value);
        }
    }

    class ParquetIntegerValue
    extends BasicDataTypes {
        private final int value;

        public ParquetIntegerValue(int value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public int getInteger() {
            return this.value;
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addInteger(this.value);
        }
    }

    class ParquetFloatValue
    extends BasicDataTypes {
        private final float value;

        public ParquetFloatValue(float value) {
            this.value = value;
        }

        @Override
        public float getFloat() {
            return this.value;
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addFloat(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    class ParquetDoubleValue
    extends BasicDataTypes {
        private final double value;

        public ParquetDoubleValue(double value) {
            this.value = value;
        }

        @Override
        public double getDouble() {
            return this.value;
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addDouble(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    class ParquetBooleanValue
    extends BasicDataTypes {
        private final boolean bool;

        public ParquetBooleanValue(boolean bool) {
            this.bool = bool;
        }

        public String toString() {
            return String.valueOf(this.bool);
        }

        @Override
        public boolean getBoolean() {
            return this.bool;
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addBoolean(this.bool);
        }
    }

    class ParquetBinaryValue
    extends BasicDataTypes {
        private final Binary binary;

        public ParquetBinaryValue(Binary binary) {
            this.binary = binary;
        }

        @Override
        public Binary getBinary() {
            return this.binary;
        }

        @Override
        public String getString() {
            return this.binary.toStringUsingUTF8();
        }

        @Override
        public void writeValue(RecordConsumer recordConsumer) {
            recordConsumer.addBinary(this.binary);
        }

        public String toString() {
            return this.getString();
        }
    }

    public class PlainParquetExt
    extends ParquetExt {
        private final GroupType schema;
        private final List<Object>[] data;

        public PlainParquetExt(GroupType schema) {
            this.schema = schema;
            this.data = new List[schema.getFields().size()];
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                this.data[i] = new ArrayList<Object>();
            }
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String indent) {
            String result = "";
            int i = 0;
            for (Type field : this.schema.getFields()) {
                String name = field.getName();
                List<Object> values = this.data[i];
                ++i;
                if (values == null || values.size() <= 0) continue;
                for (Object value : values) {
                    result = result + indent + name;
                    if (value == null) {
                        result = result + ": NULL\n";
                        continue;
                    }
                    if (value instanceof ParquetExt) {
                        result = result + "\n" + ((PlainParquetExt)((Object)value)).toString(indent + "  ");
                        continue;
                    }
                    result = result + ": " + value.toString() + "\n";
                }
            }
            return result;
        }

        @Override
        public ParquetExt addGroup(int fieldIndex) {
            PlainParquetExt g = new PlainParquetExt(this.schema.getType(fieldIndex).asGroupType());
            this.add(fieldIndex, (ParquetExt)g);
            return g;
        }

        @Override
        public ParquetExt getGroup(int fieldIndex, int index) {
            return (ParquetExt)((Object)this.getValue(fieldIndex, index));
        }

        private Object getValue(int fieldIndex, int index) {
            List<Object> list;
            try {
                list = this.data[fieldIndex];
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") in group:\n" + (Object)((Object)this));
            }
            try {
                return list.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") element number " + index + " in group:\n" + (Object)((Object)this));
            }
        }

        private void add(int fieldIndex, BasicDataTypes value) {
            Type type = this.schema.getType(fieldIndex);
            List<Object> list = this.data[fieldIndex];
            if (!type.isRepetition(Type.Repetition.REPEATED) && !list.isEmpty()) {
                throw new IllegalStateException("field " + fieldIndex + " (" + type.getName() + ") can not have more than one value: " + list);
            }
            list.add(value);
        }

        @Override
        public int getFieldRepetitionCount(int fieldIndex) {
            List<Object> list = this.data[fieldIndex];
            return list == null ? 0 : list.size();
        }

        @Override
        public String getValueToString(int fieldIndex, int index) {
            return String.valueOf(this.getValue(fieldIndex, index));
        }

        @Override
        public String getString(int fieldIndex, int index) {
            return ((ParquetBinaryValue)this.getValue(fieldIndex, index)).getString();
        }

        @Override
        public int getInteger(int fieldIndex, int index) {
            return ((ParquetIntegerValue)this.getValue(fieldIndex, index)).getInteger();
        }

        @Override
        public long getLong(int fieldIndex, int index) {
            return ((ParquetLongValue)this.getValue(fieldIndex, index)).getLong();
        }

        @Override
        public double getDouble(int fieldIndex, int index) {
            return ((ParquetDoubleValue)this.getValue(fieldIndex, index)).getDouble();
        }

        @Override
        public float getFloat(int fieldIndex, int index) {
            return ((ParquetFloatValue)this.getValue(fieldIndex, index)).getFloat();
        }

        @Override
        public boolean getBoolean(int fieldIndex, int index) {
            return ((ParquetBooleanValue)this.getValue(fieldIndex, index)).getBoolean();
        }

        @Override
        public Binary getBinary(int fieldIndex, int index) {
            return ((ParquetBinaryValue)this.getValue(fieldIndex, index)).getBinary();
        }

        public ParquetNanoTime getTimeNanos(int fieldIndex, int index) {
            return ParquetNanoTime.fromInt96((ParquetInt96Value)this.getValue(fieldIndex, index));
        }

        @Override
        public Binary getInt96(int fieldIndex, int index) {
            return ((ParquetInt96Value)this.getValue(fieldIndex, index)).getInt96();
        }

        @Override
        public void add(int fieldIndex, int value) {
            this.add(fieldIndex, new ParquetIntegerValue(value));
        }

        @Override
        public void add(int fieldIndex, long value) {
            this.add(fieldIndex, new ParquetLongValue(value));
        }

        @Override
        public void add(int fieldIndex, String value) {
            this.add(fieldIndex, new ParquetBinaryValue(Binary.fromString((String)value)));
        }

        @Override
        public void add(int fieldIndex, ParquetNanoTime value) {
            this.add(fieldIndex, value.toInt96());
        }

        @Override
        public void add(int fieldIndex, boolean value) {
            this.add(fieldIndex, new ParquetBooleanValue(value));
        }

        @Override
        public void add(int fieldIndex, Binary value) {
            switch (this.getType().getType(fieldIndex).asPrimitiveType().getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    this.add(fieldIndex, new ParquetBinaryValue(value));
                    break;
                }
                case INT96: {
                    this.add(fieldIndex, new ParquetInt96Value(value));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.getType().asPrimitiveType().getName() + " not supported for Binary");
                }
            }
        }

        @Override
        public void add(int fieldIndex, float value) {
            this.add(fieldIndex, new ParquetFloatValue(value));
        }

        @Override
        public void add(int fieldIndex, double value) {
            this.add(fieldIndex, new ParquetDoubleValue(value));
        }

        @Override
        public void add(int fieldIndex, ParquetExt value) {
            this.data[fieldIndex].add((Object)value);
        }

        @Override
        public GroupType getType() {
            return this.schema;
        }

        @Override
        public void writeValue(int field, int index, RecordConsumer recordConsumer) {
            ((BasicDataTypes)this.getValue(field, index)).writeValue(recordConsumer);
        }
    }

    class PlainParquetFactoryExt
    extends ParquetFactoryExt {
        private final MessageType schema;

        public PlainParquetFactoryExt(MessageType schema) {
            this.schema = schema;
        }

        @Override
        public ParquetExt newGroup() {
            return new PlainParquetExt((GroupType)this.schema);
        }
    }

    class PrimitiveConverterExt
    extends PrimitiveConverter {
        private final ParquetConverterExt parent;
        private final int index;

        PrimitiveConverterExt(ParquetConverterExt parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void addBinary(Binary value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }

        public void addBoolean(boolean value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }

        public void addDouble(double value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }

        public void addFloat(float value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }

        public void addInt(int value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }

        public void addLong(long value) {
            this.parent.getCurrentRecord().add(this.index, value);
        }
    }

    class ParquetConverterExt
    extends GroupConverter {
        private final ParquetConverterExt parent;
        private final int index;
        protected ParquetExt current;
        private Converter[] converters;

        ParquetConverterExt(ParquetConverterExt parent, int index, GroupType schema) {
            this.parent = parent;
            this.index = index;
            this.converters = new Converter[schema.getFieldCount()];
            for (int i = 0; i < this.converters.length; ++i) {
                Type type = schema.getType(i);
                this.converters[i] = type.isPrimitive() ? new PrimitiveConverterExt(this, i) : new ParquetConverterExt(this, i, type.asGroupType());
            }
        }

        public void start() {
            this.current = this.parent.getCurrentRecord().addGroup(this.index);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void end() {
        }

        public ParquetExt getCurrentRecord() {
            return this.current;
        }
    }

    class RecordMaterializerExt
    extends RecordMaterializer<ParquetExt> {
        private final PlainParquetFactoryExt plainParquetFactory;
        private ParquetConverterExt root;

        public RecordMaterializerExt(MessageType schema) {
            this.plainParquetFactory = new PlainParquetFactoryExt(schema);
            this.root = new ParquetConverterExt(null, 0, (GroupType)schema){

                @Override
                public void start() {
                    this.current = RecordMaterializerExt.this.plainParquetFactory.newGroup();
                }

                @Override
                public void end() {
                }
            };
        }

        public ParquetExt getCurrentRecord() {
            return this.root.getCurrentRecord();
        }

        public GroupConverter getRootConverter() {
            return this.root;
        }
    }
}

