/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hive.ParquetOutputFormatExt;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.api.WriteSupport;
import parquet.schema.MessageType;

public class HiveParquetFileOutputFormat
extends FileOutputFormat<Void, Writable> {
    boolean useApacheVerflag = true;

    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String outputPath = null;
        String outputdir = context.getConfiguration().get("mapred.output.dir");
        String partition = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)HadoopConfigurationUtils.getOutputBaseName((JobContext)context), (String)"");
        outputPath = outputdir != null ? outputdir + "/" + partition : partition;
        String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(context.getConfiguration());
        List<String> columns = ConnectorSchemaUtils.parseColumns(targetTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        Properties props = new Properties();
        props.setProperty("columns", HiveUtils.listToString(columnNames));
        props.setProperty("columns.types", HiveUtils.listToString(columnTypes));
        ArrayList columnTypeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)HiveUtils.listToString(columnTypes));
        ParquetOutputFormatExt pOutExt = new ParquetOutputFormatExt();
        parquet.hadoop.ParquetOutputFormat output = pOutExt.getParquetOutputFormat((WriteSupport)this.returnWriteSupport((WriteSupport)new DataWritableWriteSupport()));
        DataWritableWriteSupport.setSchema((MessageType)HiveSchemaConverter.convert(columnNames, (List)columnTypeInfos), (Configuration)conf);
        this.initializeSerProperties(conf, props);
        final RecordWriter writer = !this.useApacheVerflag ? ((ParquetOutputFormat)output).getRecordWriter(context, new Path(outputPath)) : output.getRecordWriter(context, new Path(outputPath));
        return new RecordWriter<NullWritable, Writable>(){

            public void write(NullWritable key, Writable value) throws IOException, InterruptedException {
                writer.write(null, (Object)value);
            }

            public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
                writer.close(arg0);
            }
        };
    }

    public DataWritableWriteSupport returnWriteSupport(WriteSupport ws) {
        this.useApacheVerflag = true;
        return new DataWritableWriteSupport();
    }

    public DataWritableWriteSupport returnWriteSupport(org.apache.parquet.hadoop.api.WriteSupport ws) {
        this.useApacheVerflag = false;
        return new DataWritableWriteSupport();
    }

    private void initializeSerProperties(Configuration conf, Properties tableProperties) {
        String compressionName;
        String enableDictionaryPage;
        String blockSize = tableProperties.getProperty("parquet.block.size");
        if (blockSize != null && !blockSize.isEmpty()) {
            conf.setInt("parquet.block.size", Integer.valueOf(blockSize).intValue());
        }
        if ((enableDictionaryPage = tableProperties.getProperty("parquet.enable.dictionary")) != null && !enableDictionaryPage.isEmpty()) {
            conf.setBoolean("parquet.enable.dictionary", Boolean.valueOf(enableDictionaryPage).booleanValue());
        }
        if ((compressionName = tableProperties.getProperty("parquet.compression")) != null && !compressionName.isEmpty()) {
            conf.set("parquet.compression", compressionName.toUpperCase());
        }
    }
}

