/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class HiveORCFileOutputFormat<K, V>
extends FileOutputFormat<NullWritable, Writable> {
    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException {
        OrcOutputFormat output = new OrcOutputFormat();
        JobConf conf = new JobConf(context.getConfiguration());
        String outputPath = null;
        String outputdir = context.getConfiguration().get("mapred.output.dir");
        String partition = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)HadoopConfigurationUtils.getOutputBaseName((JobContext)context), (String)"");
        if (outputdir != null) {
            outputPath = outputdir + "/" + partition;
        }
        FileSystem fs = new Path(outputPath).getFileSystem(context.getConfiguration());
        org.apache.hadoop.mapred.RecordWriter recordWriter = output.getRecordWriter(fs, conf, outputPath, null);
        return new TeradataOrcRecordWriter(recordWriter);
    }

    private static class TeradataOrcRecordWriter
    extends RecordWriter<Writable, Writable> {
        org.apache.hadoop.mapred.RecordWriter writer = null;

        TeradataOrcRecordWriter(org.apache.hadoop.mapred.RecordWriter recordWriter) {
            this.writer = recordWriter;
        }

        public void write(Writable nullWritable, Writable row) throws IOException {
            this.writer.write((Object)NullWritable.get(), (Object)row);
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.writer.close(null);
        }
    }
}

