/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.hive.BigDecimalWritable;
import com.teradata.connector.hive.BinaryWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class DataWritableWriterExt {
    private final RecordConsumer recordConsumer;
    private final GroupType schema;

    public DataWritableWriterExt(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(ArrayWritable arr) {
        if (arr == null) {
            return;
        }
        this.recordConsumer.startMessage();
        this.writeData(arr, this.schema);
        this.recordConsumer.endMessage();
    }

    private void writeData(ArrayWritable arr, GroupType type) {
        if (arr == null) {
            return;
        }
        int fieldCount = type.getFieldCount();
        Writable[] values = arr.get();
        for (int field = 0; field < fieldCount; ++field) {
            Type fieldType = type.getType(field);
            String fieldName = fieldType.getName();
            Writable value = values[field];
            if (value == null) continue;
            this.recordConsumer.startField(fieldName, field);
            if (fieldType.isPrimitive()) {
                this.writePrimitive(value);
            } else {
                this.recordConsumer.startGroup();
                if (value instanceof ArrayWritable) {
                    if (fieldType.asGroupType().getRepetition().equals((Object)Type.Repetition.REPEATED)) {
                        this.writeArray((ArrayWritable)value, fieldType.asGroupType());
                    } else {
                        this.writeData((ArrayWritable)value, fieldType.asGroupType());
                    }
                } else if (value != null) {
                    throw new ParquetEncodingException("This should be an ArrayWritable or MapWritable: " + value);
                }
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(fieldName, field);
        }
    }

    private void writeArray(ArrayWritable array, GroupType type) {
        if (array == null) {
            return;
        }
        Writable[] subValues = array.get();
        int fieldCount = type.getFieldCount();
        for (int field = 0; field < fieldCount; ++field) {
            Type subType = type.getType(field);
            this.recordConsumer.startField(subType.getName(), field);
            for (int i = 0; i < subValues.length; ++i) {
                Writable subValue = subValues[i];
                if (subValue == null) continue;
                if (subType.isPrimitive()) {
                    if (subValue instanceof ArrayWritable) {
                        this.writePrimitive(((ArrayWritable)subValue).get()[field]);
                        continue;
                    }
                    this.writePrimitive(subValue);
                    continue;
                }
                if (!(subValue instanceof ArrayWritable)) {
                    throw new RuntimeException("This should be a ArrayWritable: " + subValue);
                }
                this.recordConsumer.startGroup();
                this.writeData((ArrayWritable)subValue, subType.asGroupType());
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(subType.getName(), field);
        }
    }

    private void writePrimitive(Writable value) {
        if (value == null) {
            return;
        }
        if (value instanceof DoubleWritable) {
            this.recordConsumer.addDouble(((DoubleWritable)value).get());
        } else if (value instanceof BooleanWritable) {
            this.recordConsumer.addBoolean(((BooleanWritable)value).get());
        } else if (value instanceof FloatWritable) {
            this.recordConsumer.addFloat(((FloatWritable)value).get());
        } else if (value instanceof IntWritable) {
            this.recordConsumer.addInteger(((IntWritable)value).get());
        } else if (value instanceof LongWritable) {
            this.recordConsumer.addLong(((LongWritable)value).get());
        } else if (value instanceof ShortWritable) {
            this.recordConsumer.addInteger((int)((ShortWritable)value).get());
        } else if (value instanceof ByteWritable) {
            this.recordConsumer.addInteger((int)((ByteWritable)value).get());
        } else {
            if (value instanceof BigDecimalWritable) {
                throw new UnsupportedOperationException("BigDecimal writing not implemented");
            }
            if (value instanceof BinaryWritable) {
                this.recordConsumer.addBinary(((BinaryWritable)value).getBinary());
            } else {
                throw new IllegalArgumentException("Unknown value type: " + value + " " + value.getClass());
            }
        }
    }
}

