/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class BigDecimalWritable
implements WritableComparable<BigDecimalWritable> {
    private byte[] internalStorage = new byte[0];
    private int scale;
    private final LazyBinaryUtils.VInt vInt = new LazyBinaryUtils.VInt();

    public BigDecimalWritable() {
    }

    public BigDecimalWritable(byte[] bytes, int scale) {
        this.set(bytes, scale);
    }

    public BigDecimalWritable(BigDecimalWritable writable) {
        this.set(writable.getBigDecimal());
    }

    public BigDecimalWritable(BigDecimal value) {
        this.set(value);
    }

    public void set(BigDecimal value) {
        if ((value = value.stripTrailingZeros()).compareTo(BigDecimal.ZERO) == 0) {
            value = BigDecimal.ZERO;
        }
        this.set(value.unscaledValue().toByteArray(), value.scale());
    }

    public void set(BigDecimalWritable writable) {
        this.set(writable.getBigDecimal());
    }

    public void set(byte[] bytes, int scale) {
        this.internalStorage = bytes;
        this.scale = scale;
    }

    public void setFromBytes(byte[] bytes, int offset, int length) {
        LazyBinaryUtils.readVInt((byte[])bytes, (int)offset, (LazyBinaryUtils.VInt)this.vInt);
        this.scale = this.vInt.value;
        LazyBinaryUtils.readVInt((byte[])bytes, (int)(offset += this.vInt.length), (LazyBinaryUtils.VInt)this.vInt);
        offset += this.vInt.length;
        if (this.internalStorage.length != this.vInt.value) {
            this.internalStorage = new byte[this.vInt.value];
        }
        System.arraycopy(bytes, offset, this.internalStorage, 0, this.vInt.value);
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal(new BigInteger(this.internalStorage), this.scale);
    }

    public void readFields(DataInput in) throws IOException {
        this.scale = WritableUtils.readVInt((DataInput)in);
        int byteArrayLen = WritableUtils.readVInt((DataInput)in);
        if (this.internalStorage.length != byteArrayLen) {
            this.internalStorage = new byte[byteArrayLen];
        }
        in.readFully(this.internalStorage);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.scale);
        WritableUtils.writeVInt((DataOutput)out, (int)this.internalStorage.length);
        out.write(this.internalStorage);
    }

    public int compareTo(BigDecimalWritable that) {
        return this.getBigDecimal().compareTo(that.getBigDecimal());
    }

    public void writeToByteStream(ByteStream.Output byteStream) {
        LazyBinaryUtils.writeVInt((ByteStream.RandomAccessOutput)byteStream, (int)this.scale);
        LazyBinaryUtils.writeVInt((ByteStream.RandomAccessOutput)byteStream, (int)this.internalStorage.length);
        byteStream.write(this.internalStorage, 0, this.internalStorage.length);
    }

    public String toString() {
        return this.getBigDecimal().toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BigDecimalWritable)) {
            return false;
        }
        BigDecimalWritable bdw = (BigDecimalWritable)other;
        return this.getBigDecimal().compareTo(bdw.getBigDecimal()) == 0;
    }

    public int hashCode() {
        return this.getBigDecimal().hashCode();
    }
}

