/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorUnicodeCharacterConverter;
import org.apache.hadoop.conf.Configuration;

public class HdfsPlugInConfiguration {
    public static final String TDCH_INPUT_HDFS_SEPARATOR = "tdch.input.hdfs.separator";
    public static final String TDCH_INPUT_HDFS_PATHS = "tdch.input.hdfs.paths";
    public static final String TDCH_INPUT_HDFS_AVRO_SCHEMA = "tdch.input.hdfs.avro.schema";
    public static final String TDCH_INPUT_HDFS_SCHEMA = "tdch.input.hdfs.schema";
    public static final String TDCH_INPUT_HDFS_NULL_STRING = "tdch.input.hdfs.null.string";
    public static final String TDCH_INPUT_HDFS_NULL_NON_STRING = "tdch.input.hdfs.null.non.string";
    public static final String TDCH_INPUT_HDFS_ENCLOSED_BY = "tdch.input.hdfs.enclosed.by";
    public static final String TDCH_INPUT_HDFS_ESCAPED_BY = "tdch.input.hdfs.escaped.by";
    public static final String TDCH_INPUT_HDFS_AVRO_SCHEMA_FILE = "tdch.input.hdfs.avro.schema.file";
    public static final String TDCH_INPUT_HDFS_FIELD_NAMES_ARRAY = "tdch.input.hdfs.field.names";
    public static final String TDCH_OUTPUT_HDFS_SEPARATOR = "tdch.output.hdfs.separator";
    public static final String TDCH_OUTPUT_HDFS_PATHS = "tdch.output.hdfs.paths";
    public static final String TDCH_OUTPUT_HDFS_AVRO_SCHEMA = "tdch.output.hdfs.avro.schema";
    public static final String TDCH_OUTPUT_HDFS_SCHEMA = "tdch.output.hdfs.schema";
    public static final String TDCH_OUTPUT_HDFS_NULL_STRING = "tdch.output.hdfs.null.string";
    public static final String TDCH_OUTPUT_HDFS_NULL_NON_STRING = "tdch.output.hdfs.null.non.string";
    public static final String TDCH_OUTPUT_HDFS_ENCLOSE_BY = "tdch.output.hdfs.enclosed.by";
    public static final String TDCH_OUTPUT_HDFS_ESCAPED_BY = "tdch.output.hdfs.escaped.by";
    public static final String TDCH_OUTPUT_HDFS_AVRO_SCHEMA_FILE = "tdch.output.hdfs.avro.schema.file";
    public static final String TDCH_OUTPUT_HDFS_FIELD_NAMES_ARRAY = "tdch.output.hdfs.field.names";
    public static final String VALUE_HDFS_AVRO_SCHEMA_INPUT_KEY = "avro.schema.input.key";
    public static final String VALUE_HDFS_AVRO_SCHEMA_OUTPUT_KEY = "avro.schema.output.key";
    public static final String VALUE_FIELDS_SEPARATOR = "\t";
    public static final boolean VALUE_HDFS_CUSTOM_PARSE_OFF = false;

    public static String getInputPaths(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_PATHS, "");
    }

    public static void setInputPaths(Configuration configuration, String inputPath) {
        configuration.set(TDCH_INPUT_HDFS_PATHS, inputPath);
        configuration.set("mapred.input.dir", inputPath);
    }

    public static String[] getInputFieldNamesArray(Configuration configuration) {
        return configuration.getStrings(TDCH_INPUT_HDFS_FIELD_NAMES_ARRAY, new String[0]);
    }

    public static void setInputFieldNamesArray(Configuration configuration, String[] inputFieldNamesArray) {
        configuration.setStrings(TDCH_INPUT_HDFS_FIELD_NAMES_ARRAY, inputFieldNamesArray);
    }

    public static String getInputSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_SCHEMA, "");
    }

    public static void setInputSchema(Configuration configuration, String inputSchema) {
        configuration.set(TDCH_INPUT_HDFS_SCHEMA, inputSchema);
    }

    public static String getInputAvroSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_AVRO_SCHEMA, "");
    }

    public static void setInputAvroSchema(Configuration configuration, String inputAvroSchema) {
        configuration.set(TDCH_INPUT_HDFS_AVRO_SCHEMA, inputAvroSchema);
    }

    public static String getInputAvroSchemaFile(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_AVRO_SCHEMA_FILE, "");
    }

    public static void setInputAvroSchemaFile(Configuration configuration, String inputAvroSchemaFile) {
        configuration.set(TDCH_INPUT_HDFS_AVRO_SCHEMA_FILE, inputAvroSchemaFile);
    }

    public static String getInputEscapedBy(Configuration configuration) throws ConnectorException {
        String escapedByString = configuration.get(TDCH_INPUT_HDFS_ESCAPED_BY);
        return (escapedByString = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(escapedByString)) == null ? "" : escapedByString.substring(0, 1);
    }

    public static void setInputEscapedBy(Configuration configuration, String inputEscapedBy) throws ConnectorException {
        configuration.set(TDCH_INPUT_HDFS_ESCAPED_BY, inputEscapedBy);
        if (inputEscapedBy != null && inputEscapedBy.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(inputEscapedBy);
        }
    }

    public static String getInputEnclosedBy(Configuration configuration) throws ConnectorException {
        String enclosedBy = configuration.get(TDCH_INPUT_HDFS_ENCLOSED_BY);
        return (enclosedBy = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(enclosedBy)) == null ? "" : enclosedBy.substring(0, 1);
    }

    public static void setInputEnclosedBy(Configuration configuration, String inputEnclosedBy) throws ConnectorException {
        configuration.set(TDCH_INPUT_HDFS_ENCLOSED_BY, inputEnclosedBy);
        if (inputEnclosedBy != null && inputEnclosedBy.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(inputEnclosedBy);
        }
    }

    public static String getInputNullNonString(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_NULL_NON_STRING, "");
    }

    public static void setInputNullNonString(Configuration configuration, String inputNullNonString) {
        configuration.set(TDCH_INPUT_HDFS_NULL_NON_STRING, inputNullNonString);
    }

    public static String getInputNullString(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HDFS_NULL_STRING, "");
    }

    public static void setInputNullString(Configuration configuration, String inputNullString) {
        configuration.set(TDCH_INPUT_HDFS_NULL_STRING, inputNullString);
    }

    public static String getInputSeparator(Configuration configuration) throws ConnectorException {
        String separator = configuration.get(TDCH_INPUT_HDFS_SEPARATOR, VALUE_FIELDS_SEPARATOR);
        if (separator != null && separator.length() > 0) {
            separator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
            separator = separator.substring(0, 1);
        }
        return separator;
    }

    public static void setInputSeparator(Configuration configuration, String inputSeparator) throws ConnectorException {
        configuration.set(TDCH_INPUT_HDFS_SEPARATOR, inputSeparator);
        if (inputSeparator != null && inputSeparator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(inputSeparator);
        }
    }

    public static String getOutputPaths(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_PATHS, "");
    }

    public static void setOutputPaths(Configuration configuration, String outPath) {
        configuration.set(TDCH_OUTPUT_HDFS_PATHS, outPath);
        configuration.set("mapred.output.dir", outPath);
    }

    public static String[] getOutputFieldNamesArray(Configuration configuration) {
        return configuration.getStrings(TDCH_OUTPUT_HDFS_FIELD_NAMES_ARRAY, new String[0]);
    }

    public static void setOutputFieldNamesArray(Configuration configuration, String[] outputFieldNamesArray) {
        configuration.setStrings(TDCH_OUTPUT_HDFS_FIELD_NAMES_ARRAY, outputFieldNamesArray);
    }

    public static String getOutputSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_SCHEMA, "");
    }

    public static void setOutputSchema(Configuration configuration, String outputSchema) {
        configuration.set(TDCH_OUTPUT_HDFS_SCHEMA, outputSchema);
    }

    public static String getOutputAvroSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_AVRO_SCHEMA, "");
    }

    public static void setOutputAvroSchema(Configuration configuration, String outputAvroSchema) {
        configuration.set(TDCH_OUTPUT_HDFS_AVRO_SCHEMA, outputAvroSchema);
    }

    public static String getOutputAvroSchemaFile(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_AVRO_SCHEMA_FILE, "");
    }

    public static void setOutputAvroSchemaFile(Configuration configuration, String outputAvroSchemaFile) {
        configuration.set(TDCH_OUTPUT_HDFS_AVRO_SCHEMA_FILE, outputAvroSchemaFile);
    }

    public static String getOutputEscapedBy(Configuration configuration) throws ConnectorException {
        String escapedByString = configuration.get(TDCH_OUTPUT_HDFS_ESCAPED_BY);
        return (escapedByString = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(escapedByString)) == null ? "" : escapedByString.substring(0, 1);
    }

    public static void setOutputEscapedBy(Configuration configuration, String outputEscapedBy) throws ConnectorException {
        configuration.set(TDCH_OUTPUT_HDFS_ESCAPED_BY, outputEscapedBy);
        if (outputEscapedBy != null && outputEscapedBy.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(outputEscapedBy);
        }
    }

    public static String getOutputEnclosedBy(Configuration configuration) throws ConnectorException {
        String enclosedBy = configuration.get(TDCH_OUTPUT_HDFS_ENCLOSE_BY);
        return (enclosedBy = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(enclosedBy)) == null ? "" : enclosedBy.substring(0, 1);
    }

    public static void setOutputEnclosedBy(Configuration configuration, String outputEnclosedBy) throws ConnectorException {
        configuration.set(TDCH_OUTPUT_HDFS_ENCLOSE_BY, outputEnclosedBy);
        if (outputEnclosedBy != null && outputEnclosedBy.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(outputEnclosedBy);
        }
    }

    public static String getOutputNullNonString(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_NULL_NON_STRING, "");
    }

    public static void setOutputNullNonString(Configuration configuration, String outputNullNonString) {
        configuration.set(TDCH_OUTPUT_HDFS_NULL_NON_STRING, outputNullNonString);
    }

    public static String getOutputNullString(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HDFS_NULL_STRING, "");
    }

    public static void setOutputNullString(Configuration configuration, String outputNullString) {
        configuration.set(TDCH_OUTPUT_HDFS_NULL_STRING, outputNullString);
    }

    public static String getOutputSeparator(Configuration configuration) throws ConnectorException {
        String separator = configuration.get(TDCH_OUTPUT_HDFS_SEPARATOR, VALUE_FIELDS_SEPARATOR);
        if (separator != null && separator.length() > 0) {
            separator = ConnectorUnicodeCharacterConverter.fromEncodedUnicode(separator);
            separator = separator.substring(0, 1);
        }
        return separator;
    }

    public static void setOutputSeparator(Configuration configuration, String outputSeparator) throws ConnectorException {
        configuration.set(TDCH_OUTPUT_HDFS_SEPARATOR, outputSeparator);
        if (outputSeparator != null && outputSeparator.length() > 0) {
            ConnectorUnicodeCharacterConverter.fromEncodedUnicode(outputSeparator);
        }
    }
}

