/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.processor;

import com.teradata.connector.common.ConnectorOutputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsTextFileOutputProcessor
implements ConnectorOutputProcessor {
    @Override
    public int outputPreProcessor(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        String outputPaths = HdfsPlugInConfiguration.getOutputPaths(configuration);
        if (outputPaths.isEmpty()) {
            String dir = configuration.get("mapred.output.dir", "");
            if (dir.isEmpty()) {
                throw new ConnectorException(12003);
            }
            HdfsPlugInConfiguration.setOutputPaths(configuration, dir);
        }
        String targetSchema = HdfsPlugInConfiguration.getOutputSchema(configuration);
        String[] targetFieldNames = HdfsPlugInConfiguration.getOutputFieldNamesArray(configuration);
        if (targetFieldNames.length > 0 && targetSchema.isEmpty()) {
            throw new ConnectorException(50009);
        }
        if (!targetSchema.isEmpty()) {
            ConnectorRecordSchema targetRecordSchema;
            List<String> tableFields = ConnectorSchemaUtils.parseColumns(targetSchema.toLowerCase());
            List<String> tableFieldNames = ConnectorSchemaUtils.parseColumnNames(tableFields);
            List<String> tableFieldDataTypes = ConnectorSchemaUtils.parseColumnTypes(tableFields);
            ConnectorRecordSchema userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration));
            if (targetFieldNames.length > 0) {
                int[] mapping = HdfsSchemaUtils.getColumnMapping(tableFieldNames, targetFieldNames);
                targetRecordSchema = new ConnectorRecordSchema(targetFieldNames.length);
                for (int index = 0; index < targetFieldNames.length; ++index) {
                    targetRecordSchema.setFieldType(index, HdfsSchemaUtils.lookupHdfsAvroDatatype(tableFieldDataTypes.get(mapping[index])));
                }
            } else {
                targetRecordSchema = new ConnectorRecordSchema(tableFieldNames.size());
                for (int index = 0; index < tableFieldNames.size(); ++index) {
                    targetRecordSchema.setFieldType(index, HdfsSchemaUtils.lookupHdfsAvroDatatype(tableFieldDataTypes.get(index)));
                }
            }
            if (userRecordSchema != null) {
                if (userRecordSchema.getLength() != targetRecordSchema.getLength()) {
                    throw new ConnectorException(14014);
                }
                int columnCount = targetRecordSchema.getLength();
                for (int i = 0; i < columnCount; ++i) {
                    if (userRecordSchema.getFieldType(i) == targetRecordSchema.getFieldType(i)) continue;
                    throw new ConnectorException(14016);
                }
            } else {
                ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(targetRecordSchema)));
            }
        }
        return 0;
    }

    @Override
    public int outputPostProcessor(JobContext context) throws ConnectorException {
        return 0;
    }
}

