/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs;

import java.io.IOException;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class HdfsAvroInputFormat<WritableComparable, Writable>
extends FileInputFormat<WritableComparable, Writable> {
    public RecordReader<WritableComparable, Writable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new HdfsAvroRecordReader(split, context);
    }

    public class HdfsAvroRecordReader
    extends RecordReader<WritableComparable, Writable> {
        private RecordReader reader = null;
        protected Configuration configuration;
        private ObjectWritable returnvalue = new ObjectWritable();

        public HdfsAvroRecordReader(InputSplit split, TaskAttemptContext context) {
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public WritableComparable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public Writable getCurrentValue() throws IOException, InterruptedException {
            this.returnvalue.set(this.reader.getCurrentKey());
            return this.returnvalue;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            AvroKeyInputFormat avroinputformat = new AvroKeyInputFormat();
            this.reader = avroinputformat.createRecordReader(split, context);
            this.reader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.nextKeyValue();
        }
    }
}

