/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hcat.utils;

import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

@Deprecated
public class HCatPlugInConfiguration {
    public static final String TDCH_INPUT_HCAT_DATABASE = "tdch.input.hcat.database";
    public static final String TDCH_INPUT_HCAT_TABLE = "tdch.input.hcat.table";
    public static final String TDCH_INPUT_HCAT_TABLE_SCHEMA = "tdch.input.hcat.table.schema";
    public static final String TDCH_INPUT_HCAT_PARTITION_SCHEMA = "tdch.input.hcat.partition.schema";
    public static final String TDCH_INPUT_HCAT_FIELD_NAMES = "tdch.input.hcat.field.names";
    public static final String TDCH_INPUT_HCAT_SCHEMA_FIELD_NAMES = "tdch.input.hcat.schema.field.names";
    public static final String TDCH_INPUT_HCAT_TYPE_NAME = "tdch.input.hcat.schema.type.names";
    public static final String TDCH_OUTPUT_HCAT_DATABASE = "tdch.output.hcat.database";
    public static final String TDCH_OUTPUT_HCAT_TABLE = "tdch.output.hcat.table";
    public static final String TDCH_OUTPUT_HCAT_TABLE_SCHEMA = "tdch.output.hcat.table.schema";
    public static final String TDCH_OUTPUT_HCAT_FIELD_NAMES = "tdch.output.hcat.field.names";
    public static final String TDCH_OUTPUT_HCAT_FIELD_TYPE_NAMES = "tdch.output.hcat.field.type.names";
    public static final String TDCH_OUTPUT_HCAT_SCHEMA_FIELD_NAMES = "tdch.output.hcat.schema.field.names";
    public static final String TDCH_OUTPUT_HCAT_TYPE_NAME = "tdch.output.hcat.schema.type.names";

    public static String getInputDatabase(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HCAT_DATABASE, "");
    }

    public static void setInputDatabase(Configuration configuration, String inputDatabase) {
        configuration.set(TDCH_INPUT_HCAT_DATABASE, inputDatabase);
    }

    public static String getInputTable(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HCAT_TABLE, "");
    }

    public static void setInputTable(Configuration configuration, String inputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(inputTable, 2, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(TDCH_INPUT_HCAT_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(TDCH_INPUT_HCAT_DATABASE, tokens.get(0));
                configuration.set(TDCH_INPUT_HCAT_TABLE, tokens.get(1));
            }
        }
    }

    public static void setInputTableSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_INPUT_HCAT_TABLE_SCHEMA, schema);
    }

    public static String getInputTableSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_HCAT_TABLE_SCHEMA, "");
    }

    public static void setInputPartitionSchema(Configuration configuration, String partitionSchema) {
        configuration.set(TDCH_INPUT_HCAT_PARTITION_SCHEMA, partitionSchema);
    }

    public static String getOutputDatabase(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HCAT_DATABASE, "");
    }

    public static void setOutputDatabase(Configuration configuration, String outputDatabase) {
        configuration.set(TDCH_OUTPUT_HCAT_DATABASE, outputDatabase);
    }

    public static String getOutputTable(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HCAT_TABLE);
    }

    public static void setOutputTable(Configuration configuration, String outputTable) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(outputTable, 2, false);
        switch (tokens.size()) {
            case 1: {
                configuration.set(TDCH_OUTPUT_HCAT_TABLE, tokens.get(0));
                break;
            }
            case 2: {
                configuration.set(TDCH_OUTPUT_HCAT_DATABASE, tokens.get(0));
                configuration.set(TDCH_OUTPUT_HCAT_TABLE, tokens.get(1));
            }
        }
    }

    public static void setOutputTableSchema(Configuration configuration, String schema) {
        configuration.set(TDCH_OUTPUT_HCAT_TABLE_SCHEMA, schema);
    }

    public static String getOutputTableSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_HCAT_TABLE_SCHEMA, "");
    }

    public static void setOutputFieldNamesArray(Configuration configuration, String[] targetFieldNamesArray) {
        configuration.setStrings(TDCH_OUTPUT_HCAT_FIELD_NAMES, targetFieldNamesArray);
    }

    public static String[] getOutputFieldNamesArray(Configuration configuration) {
        return configuration.getStrings(TDCH_OUTPUT_HCAT_FIELD_NAMES, new String[0]);
    }

    public static void setOutputFieldTypeNamesArray(Configuration configuration, String[] targetFieldNamesArray) {
        targetFieldNamesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(targetFieldNamesArray);
        String targetFieldNamesArrayJson = ConnectorSchemaUtils.fieldNamesToJson(targetFieldNamesArray);
        configuration.set(TDCH_OUTPUT_HCAT_FIELD_TYPE_NAMES, targetFieldNamesArrayJson);
    }

    public static String[] getOutputFieldTypeNamesArray(Configuration configuration) {
        String targetFieldNamesArrayJson = configuration.get(TDCH_OUTPUT_HCAT_FIELD_TYPE_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(targetFieldNamesArrayJson);
    }

    public static void setInputFieldNamesArray(Configuration configuration, String[] sourceFieldNamesArray) {
        configuration.setStrings(TDCH_INPUT_HCAT_FIELD_NAMES, sourceFieldNamesArray);
    }

    public static String[] getInputFieldNamesArray(Configuration configuration) {
        return configuration.getStrings(TDCH_INPUT_HCAT_FIELD_NAMES, new String[0]);
    }

    public static void setTargetSchemaFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_OUTPUT_HCAT_SCHEMA_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getTargetSchemaFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_OUTPUT_HCAT_SCHEMA_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setSourceSchemaFieldNamesArray(Configuration configuration, String[] fieldNames) {
        fieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNames);
        configuration.set(TDCH_INPUT_HCAT_SCHEMA_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getSourceSchemaFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_INPUT_HCAT_SCHEMA_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setInputTableFieldTypes(Configuration configuration, String[] typeNames) {
        configuration.set(TDCH_INPUT_HCAT_TYPE_NAME, HiveSchemaUtils.typeNamesToJson(typeNames));
    }

    public static String[] getInputTableFieldTypes(Configuration configuration) {
        return HiveSchemaUtils.typeNamesFromJson(configuration.get(TDCH_INPUT_HCAT_TYPE_NAME, ""));
    }

    public static void setOutputTableFieldTypes(Configuration configuration, String[] typeNames) {
        typeNames = ConnectorSchemaUtils.unquoteFieldNamesArray(typeNames);
        String typeNamesJson = ConnectorSchemaUtils.fieldNamesToJson(typeNames);
        configuration.set(TDCH_OUTPUT_HCAT_TYPE_NAME, typeNamesJson);
    }

    public static String[] getOutputTableFieldTypes(Configuration configuration) {
        String targetFieldNamesArrayJson = configuration.get(TDCH_OUTPUT_HCAT_TYPE_NAME, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(targetFieldNamesArrayJson);
    }
}

