/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hcat;

import com.teradata.connector.common.exception.ConnectorException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

@Deprecated
class ConnectorCombineFileHCatSplit
extends InputSplit
implements Writable {
    private InputSplit[] splits;
    private String[] locations;
    private long totalLength;
    Constructor<?> HCatSplitConstructor = null;
    Method HCatSplitWriteMethod = null;
    Method HCatSplitReadFieldsMethod = null;

    public ConnectorCombineFileHCatSplit() throws IOException {
        Class<?> HCatSplitClass = null;
        try {
            HCatSplitClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatSplit");
        }
        catch (ClassNotFoundException e) {
            try {
                HCatSplitClass = Class.forName("org.apache.hcatalog.mapreduce.HCatSplit");
            }
            catch (ClassNotFoundException e2) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        try {
            this.HCatSplitConstructor = HCatSplitClass.getConstructor(new Class[0]);
            this.HCatSplitWriteMethod = HCatSplitClass.getMethod("write", DataOutput.class);
            this.HCatSplitReadFieldsMethod = HCatSplitClass.getMethod("readFields", DataInput.class);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public ConnectorCombineFileHCatSplit(InputSplit[] splits) throws IOException {
        this.splits = splits;
        HashSet<String> locations = new HashSet<String>();
        for (InputSplit split : splits) {
            try {
                this.totalLength += split.getLength();
                locations.addAll(Arrays.asList(split.getLocations()));
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage());
            }
        }
        this.locations = locations.toArray(new String[0]);
        Class<?> HCatSplitClass = null;
        try {
            HCatSplitClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatSplit");
        }
        catch (ClassNotFoundException e) {
            try {
                HCatSplitClass = Class.forName("org.apache.hcatalog.mapreduce.HCatSplit");
            }
            catch (ClassNotFoundException e2) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        try {
            this.HCatSplitConstructor = HCatSplitClass.getConstructor(new Class[0]);
            this.HCatSplitWriteMethod = HCatSplitClass.getMethod("write", DataOutput.class);
            this.HCatSplitReadFieldsMethod = HCatSplitClass.getMethod("readFields", DataInput.class);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public int length() {
        return this.splits.length;
    }

    public InputSplit get(int index) {
        return this.splits[index];
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.totalLength == 0L) {
            for (InputSplit split : this.splits) {
                this.totalLength += split.getLength();
            }
        }
        return this.totalLength;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.locations == null) {
            HashSet<String> locations = new HashSet<String>();
            for (InputSplit split : this.splits) {
                locations.addAll(Arrays.asList(split.getLocations()));
            }
            this.locations = locations.toArray(new String[0]);
        }
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.totalLength);
        out.writeInt(this.splits.length);
        for (InputSplit split : this.splits) {
            try {
                this.HCatSplitWriteMethod.invoke((Object)split, out);
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage());
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.totalLength = in.readLong();
        int arrLength = in.readInt();
        this.splits = new InputSplit[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            try {
                this.splits[i] = (InputSplit)this.HCatSplitConstructor.newInstance(new Object[0]);
                this.HCatSplitReadFieldsMethod.invoke((Object)this.splits[i], in);
                continue;
            }
            catch (Exception e) {
                throw new ConnectorException(e.toString());
            }
        }
    }
}

