/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorConverter;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.converter.ConnectorDataWritable;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.jdbc.ResultStruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class ConnectorSchemaUtils {
    public static final String PATTERN_MAP_TYPE = "\\s*(map\\s*[<].*[>])";
    public static final String PATTERN_ARRAY_TYPE = "\\s*(array\\s*[<].*[>])";
    public static final String PATTERN_STRUCT_TYPE = "\\s*(struct\\s*[<].*[>])";
    public static final String PATTERN_UNION_TYPE = "\\s*(union\\s*[<].*[>])";
    private static final String PATTERN_CALENDAR_TIME_TYPE = "\\s*time\\s*with\\s*time\\s*zone\\s*";
    private static final String PATTERN_CALENDAR_TIMESTAMP_TYPE = "\\s*timestamp\\s*with\\s*time\\s*zone\\s*";
    public static final String LIST_COLUMNS = "columns";
    public static final String LIST_COLUMN_TYPES = "columns.types";
    private static final char ESCAPE_CHAR = '\\';
    private static final char SPACE_CHAR = ' ';
    private static final char DOT_CHAR = '.';
    private static final char COMMA_CHAR = ',';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String REPLACE_DOUBLE_QUOTE = "\\\"";
    private static final String REPLACE_SINGLE_QUOTE = "\\'";

    public static List<String> parseColumns(String schema) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setEscapeChar('\\');
        return parser.tokenizeKeepEscape(schema);
    }

    public static List<String> parseFields(String fields) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setEscapeChar('\\');
        return parser.tokenize(fields);
    }

    public static List<String> parseColumnNames(List<String> fields) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar(' ');
        parser.setEscapeChar('\\');
        parser.setIgnoreContinousDelim(true);
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            List<String> tokens = parser.tokenize(field.trim(), 2, false);
            if (tokens.size() >= 1) {
                result.add(tokens.get(0).trim().replaceAll("\"", ""));
                continue;
            }
            result.add("");
        }
        return result;
    }

    public static List<String> parseColumnTypes(List<String> fields) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar(' ');
        parser.setEscapeChar('\\');
        parser.setIgnoreContinousDelim(true);
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            List<String> tokens = parser.tokenize(field.trim(), 2, false);
            if (tokens.size() == 2) {
                result.add(tokens.get(1).trim());
                continue;
            }
            result.add("");
        }
        return result;
    }

    public static String[] convertFieldNamesToArray(String fieldNames) {
        List<String> fields = ConnectorSchemaUtils.parseFields(fieldNames);
        return fields.toArray(new String[0]);
    }

    public static String concatFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null || fieldNamesArray.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String fieldName : fieldNamesArray) {
            builder.append(fieldName).append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String quoteFieldName(String fieldName) {
        return ConnectorSchemaUtils.quoteFieldName(fieldName, REPLACE_DOUBLE_QUOTE);
    }

    public static String quoteFieldName(String fieldName, String replaceQuoteString) {
        if (fieldName == null || fieldName.isEmpty()) {
            return String.format("%c%c", Character.valueOf('\"'), Character.valueOf('\"'));
        }
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        parser.setEscapeChar('\\');
        List<String> tokens = parser.tokenize(fieldName);
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            if (token.length() > 1) {
                char begin = token.charAt(0);
                char end = token.charAt(token.length() - 1);
                if ((begin == '\'' || begin == '\"') && begin == end) {
                    token = token.substring(1, token.length() - 1);
                }
            }
            builder.append('\"').append(token.replace(String.valueOf('\"'), replaceQuoteString)).append('\"').append('.');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String quoteFieldNames(String fieldNames) {
        if (fieldNames == null || fieldNames.isEmpty()) {
            return "";
        }
        String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldNames);
        String[] quotedFieldNamesArray = ConnectorSchemaUtils.quoteFieldNamesArray(fieldNamesArray);
        StringBuilder builder = new StringBuilder();
        for (String fieldName : quotedFieldNamesArray) {
            builder.append(fieldName).append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] quoteFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null) {
            return new String[0];
        }
        String[] newFieldNamesArray = new String[fieldNamesArray.length];
        for (int i = 0; i < newFieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i].trim();
            newFieldNamesArray[i] = ConnectorSchemaUtils.quoteFieldName(fieldName);
        }
        return newFieldNamesArray;
    }

    public static String quoteFieldValue(String fieldValue) {
        return ConnectorSchemaUtils.quoteFieldValue(fieldValue, REPLACE_SINGLE_QUOTE);
    }

    public static String quoteFieldValue(String fieldValue, String replaceQuoteString) {
        if (fieldValue == null || fieldValue.isEmpty()) {
            return String.format("%c%c", Character.valueOf('\''), Character.valueOf('\''));
        }
        if (fieldValue.length() > 1) {
            char begin = fieldValue.charAt(0);
            char end = fieldValue.charAt(fieldValue.length() - 1);
            if ((begin == '\'' || begin == '\"') && begin == end) {
                fieldValue = fieldValue.substring(1, fieldValue.length() - 1);
            }
        }
        return '\'' + fieldValue.replace(String.valueOf('\''), replaceQuoteString) + '\'';
    }

    public static String unquoteFieldValue(String fieldValue) {
        return ConnectorSchemaUtils.unquoteFieldValue(fieldValue, REPLACE_SINGLE_QUOTE);
    }

    public static String unquoteFieldValue(String fieldValue, String replaceQuoteString) {
        if (fieldValue == null || fieldValue.isEmpty()) {
            return "";
        }
        if (fieldValue.length() > 1) {
            char begin = fieldValue.charAt(0);
            char end = fieldValue.charAt(fieldValue.length() - 1);
            if ((begin == '\'' || begin == '\"') && begin == end) {
                fieldValue = fieldValue.substring(1, fieldValue.length() - 1);
            }
        }
        return fieldValue.replace(replaceQuoteString, String.valueOf('\''));
    }

    public static String unquoteFieldName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return "";
        }
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        parser.setEscapeChar('\\');
        List<String> tokens = parser.tokenize(fieldName);
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            if (token.length() > 1) {
                char begin = token.charAt(0);
                char end = token.charAt(token.length() - 1);
                if ((begin == '\'' || begin == '\"') && begin == end) {
                    token = token.substring(1, token.length() - 1);
                }
            }
            token = token.replace(REPLACE_DOUBLE_QUOTE, String.valueOf('\"'));
            builder.append(token).append('.');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] unquoteFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null) {
            return new String[0];
        }
        String[] newFieldNamesArray = new String[fieldNamesArray.length];
        for (int i = 0; i < newFieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i].trim();
            newFieldNamesArray[i] = ConnectorSchemaUtils.unquoteFieldName(fieldName);
        }
        return newFieldNamesArray;
    }

    public static ConnectorRecordSchema recordSchemaFromString(String recordSchema) throws ConnectorException {
        ByteArrayInputStream input;
        if (recordSchema == null || recordSchema.isEmpty()) {
            return null;
        }
        try {
            input = new ByteArrayInputStream(Base64.decodeBase64((String)recordSchema));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new ConnectorException(e1.getMessage(), e1);
        }
        DataInputStream in = new DataInputStream(input);
        ConnectorRecordSchema result = new ConnectorRecordSchema();
        try {
            result.readFields(in);
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return result;
    }

    public static String recordSchemaToString(ConnectorRecordSchema recordSchema) throws ConnectorException {
        if (recordSchema == null || recordSchema.getLength() == 0) {
            return "";
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        try {
            recordSchema.write(out);
            return Base64.encodeBase64String((byte[])output.toByteArray());
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static String getHivePathString(Object object) {
        if (object instanceof Timestamp) {
            return new TimestampWritable((Timestamp)object).toString();
        }
        if (object instanceof Double) {
            return new DoubleWritable(((Double)object).doubleValue()).toString();
        }
        if (object instanceof Float) {
            return new FloatWritable(((Float)object).floatValue()).toString();
        }
        if (object instanceof Integer) {
            return new IntWritable(((Integer)object).intValue()).toString();
        }
        if (object instanceof Boolean) {
            return new BooleanWritable(((Boolean)object).booleanValue()).toString();
        }
        if (object instanceof Short) {
            return new ShortWritable(((Short)object).shortValue()).toString();
        }
        if (object instanceof Byte) {
            return new ByteWritable(((Byte)object).byteValue()).toString();
        }
        if (object instanceof Long) {
            return new LongWritable(((Long)object).longValue()).toString();
        }
        return object.toString();
    }

    public static int[] getHivePartitionMapping(String[] schemaFieldNames, String sourcePartitionSchema) throws ConnectorException {
        List<String> fields = ConnectorSchemaUtils.parseColumns(sourcePartitionSchema);
        List<String> fieldNames = ConnectorSchemaUtils.parseColumnNames(fields);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (int i = 0; i < schemaFieldNames.length; ++i) {
            columnMap.put(schemaFieldNames[i].toLowerCase(), i);
        }
        int[] mapping = new int[fieldNames.size()];
        for (int i = 0; i < fieldNames.size(); ++i) {
            Integer position = (Integer)columnMap.get(fieldNames.get(i).trim().toLowerCase());
            if (position == null) {
                throw new ConnectorException(14005);
            }
            mapping[i] = position;
        }
        return mapping;
    }

    public static ConnectorDataTypeConverter lookupUDF(ConnectorRecordSchema sourceRecordSchema, int i) throws ConnectorException {
        try {
            Constructor<?>[] constructors;
            Class<?> converterClass;
            Class<ConnectorDataTypeConverter> baseClass = ConnectorDataTypeConverter.class;
            String converterClassString = sourceRecordSchema.getDataTypeConverter(i);
            if (!converterClassString.contains(".")) {
                converterClassString = baseClass.getName() + "$" + sourceRecordSchema.getDataTypeConverter(i);
            }
            try {
                converterClass = Class.forName(converterClassString);
            }
            catch (ClassNotFoundException e) {
                converterClass = Class.forName(sourceRecordSchema.getDataTypeConverter(i));
            }
            for (Constructor<?> constructor : constructors = converterClass.getConstructors()) {
                int j;
                int parameterLength;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != (parameterLength = sourceRecordSchema.getParameters(i).length)) continue;
                for (j = 0; j < parameterLength && parameterTypes[j].isAssignableFrom(String.class); ++j) {
                }
                if (j != parameterLength || !baseClass.isAssignableFrom(converterClass)) continue;
                return (ConnectorDataTypeConverter)constructor.newInstance(sourceRecordSchema.getParameters(i));
            }
            return null;
        }
        catch (SecurityException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ConnectorException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static int lookupDataTypeAndValidate(String typeName) throws ConnectorException {
        if ((typeName = typeName.toUpperCase()).equals("INT") || typeName.equals("INTEGER")) {
            return 4;
        }
        if (typeName.equals("BIGINT") || typeName.equals("LONG")) {
            return -5;
        }
        if (typeName.equals("SMALLINT")) {
            return 5;
        }
        if (typeName.equals("STRING") || typeName.equals("VARCHAR")) {
            return 12;
        }
        if (typeName.equals("FLOAT")) {
            return 6;
        }
        if (typeName.equals("DOUBLE") || typeName.equals("DOUBLE PRECISION")) {
            return 8;
        }
        if (typeName.equals("DECIMAL")) {
            return 3;
        }
        if (typeName.equals("BOOLEAN")) {
            return 16;
        }
        if (typeName.equals("DATE")) {
            return 91;
        }
        if (typeName.equals("TIME")) {
            return 92;
        }
        if (typeName.equals("TIMESTAMP")) {
            return 93;
        }
        if (Pattern.matches(PATTERN_CALENDAR_TIME_TYPE, typeName.toLowerCase())) {
            return 1885;
        }
        if (Pattern.matches(PATTERN_CALENDAR_TIMESTAMP_TYPE, typeName.toLowerCase())) {
            return 1886;
        }
        if (typeName.startsWith("PERIOD")) {
            return 2002;
        }
        if (typeName.startsWith("INTERVAL")) {
            return 1111;
        }
        if (typeName.equals("CHAR")) {
            return 1;
        }
        if (typeName.equals("MAP") || Pattern.matches(PATTERN_MAP_TYPE, typeName.toLowerCase())) {
            return 12;
        }
        if (typeName.equals("ARRAY") || Pattern.matches(PATTERN_ARRAY_TYPE, typeName.toLowerCase())) {
            return 12;
        }
        if (typeName.equals("STRUCT") || typeName.equals("RECORD") || Pattern.matches(PATTERN_STRUCT_TYPE, typeName.toLowerCase())) {
            return 12;
        }
        if (typeName.equals("TINYINT")) {
            return -6;
        }
        if (typeName.equals("LONGVARCHAR")) {
            return -1;
        }
        if (typeName.equals("CLOB")) {
            return 2005;
        }
        if (typeName.equals("BLOB")) {
            return 2004;
        }
        if (typeName.equals("BINARY") || typeName.equals("VARBINARY") || typeName.equals("BYTES")) {
            return -2;
        }
        if (typeName.equals("REAL")) {
            return 8;
        }
        if (typeName.equals("ENUM")) {
            return 12;
        }
        if (typeName.equals("NULL")) {
            return 12;
        }
        if (typeName.equals("UNION")) {
            return 1882;
        }
        if (typeName.equals("FIXED")) {
            return 12;
        }
        if (typeName.equals("NUMERIC")) {
            return 3;
        }
        if (typeName.equals("OTHER")) {
            return 1882;
        }
        return 1883;
    }

    public static String[] getUdfParameters(String udf) {
        int start = udf.indexOf("(");
        int end = udf.indexOf(")");
        if (start == -1 || end == -1) {
            return new String[]{""};
        }
        if (end - start == 1) {
            return new String[0];
        }
        String parameters = udf.substring(start + 1, end);
        return parameters.split(",");
    }

    public static String[] fieldNamesFromJson(String fieldNamesJson) {
        if (fieldNamesJson == null || fieldNamesJson.trim().length() == 0) {
            return new String[0];
        }
        String[] fieldNames = new String[]{};
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map tableMap = (Map)objectMapper.readValue(fieldNamesJson, Map.class);
            String database = (String)tableMap.get("database");
            String table = (String)tableMap.get("table");
            ArrayList columnList = (ArrayList)tableMap.get(LIST_COLUMNS);
            fieldNames = new String[columnList.size()];
            for (int i = 0; i < columnList.size(); ++i) {
                Map columnMap = (Map)columnList.get(i);
                fieldNames[i] = (String)columnMap.get("name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldNames;
    }

    public static String fieldNamesToJson(String[] fieldNames) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode table = objectMapper.createObjectNode();
        table.put("database", "");
        table.put("table", "");
        ArrayNode columns = table.putArray(LIST_COLUMNS);
        for (int i = 0; i < fieldNames.length; ++i) {
            ObjectNode column = columns.addObject();
            column.put("name", fieldNames[i]);
        }
        return table.toString();
    }

    public static boolean isConnectorDefinitionDataType(int type) {
        return type == 4 || type == -5 || type == 5 || type == -6 || type == 6 || type == 7 || type == 8 || type == 16 || type == 2 || type == 3 || type == 2005 || type == 2004 || type == 1 || type == 12 || type == -1 || type == -2 || type == -3 || type == 91 || type == 92 || type == 93 || type == 2003 || type == 2002 || type == 1111 || type == 1882 || type == 1885 || type == 1886 || type == 1883;
    }

    public static ConnectorRecordSchema formalizeConnectorRecordSchema(ConnectorRecordSchema r) throws ConnectorException {
        for (int i = 0; i < r.getLength(); ++i) {
            if (ConnectorSchemaUtils.isConnectorDefinitionDataType(r.getFieldType(i))) continue;
            r.setFieldType(i, 12);
        }
        return r;
    }

    public static int getWritableObjectType(Object object) throws ConnectorException {
        if (object instanceof IntWritable) {
            return 4;
        }
        if (object instanceof LongWritable) {
            return -5;
        }
        if (object instanceof ShortWritable) {
            return 5;
        }
        if (object instanceof ByteWritable) {
            return -6;
        }
        if (object instanceof FloatWritable) {
            return 6;
        }
        if (object instanceof DoubleWritable) {
            return 7;
        }
        if (object instanceof BooleanWritable) {
            return 16;
        }
        if (object instanceof ConnectorDataWritable.BigDecimalWritable) {
            return 2;
        }
        if (object instanceof ConnectorDataWritable.ClobWritable) {
            return 2005;
        }
        if (object instanceof ConnectorDataWritable.BlobWritable) {
            return 2004;
        }
        if (object instanceof Text) {
            return 12;
        }
        if (object instanceof BytesWritable) {
            return -2;
        }
        if (object instanceof ConnectorDataWritable.DateWritable) {
            return 91;
        }
        if (object instanceof ConnectorDataWritable.TimeWritable) {
            return 92;
        }
        if (object instanceof TimestampWritable) {
            return 93;
        }
        if (object instanceof ConnectorDataWritable.PeriodWritable) {
            return 2002;
        }
        if (object instanceof ConnectorDataWritable.CalendarWritable) {
            return 1886;
        }
        throw new ConnectorException(15028, object.getClass());
    }

    public static int getGenericObjectType(Object object) {
        if (object == null) {
            return 1884;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 7;
        }
        if (object instanceof Boolean) {
            return 16;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Clob) {
            return 2005;
        }
        if (object instanceof Blob) {
            return 2004;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof byte[]) {
            return -2;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof Calendar) {
            return 1886;
        }
        if (object instanceof ResultStruct) {
            ResultStruct rs = (ResultStruct)object;
            try {
                if (rs.getSQLTypeName().startsWith("PERIOD")) {
                    return 2002;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return 12;
    }

    public static Map<Long, ConnectorDataTypeConverter> constructConvertMap(ConnectorConverter connectorConverter, Configuration configuration, int targetScale, int targetPrecision, int targetLength) throws ConnectorException {
        int[] connectorType = new int[]{4, -5, 5, -6, 6, 7, 8, 16, 2, 3, 2005, 2004, 1, 12, -1, -2, -3, 91, 92, 93, 2003, 2002, 1111, 1885, 1886};
        Map<Integer, Object> defaultVal = connectorConverter.initializeDefaultValue();
        Map<Integer, Object> falseDefVal = connectorConverter.initializeFalseDefaultValue();
        Map<Integer, Object> trueDefVal = connectorConverter.initializeTrueDefaultValue();
        HashMap<Long, ConnectorDataTypeConverter> map = new HashMap<Long, ConnectorDataTypeConverter>();
        for (int i = 0; i < connectorType.length; ++i) {
            int sourceType = connectorType[i];
            for (int j = 0; j < connectorType.length; ++j) {
                int targetType = connectorType[j];
                long mapKey = ConnectorSchemaUtils.genConnectorMapKey(sourceType, targetType);
                if (map.get(mapKey) != null) {
                    throw new ConnectorException(15027);
                }
                try {
                    ConnectorDataTypeConverter c = connectorConverter.lookupDataTypeConverter(sourceType, targetType, targetScale, targetPrecision, targetLength, defaultVal, falseDefVal, trueDefVal, configuration);
                    map.put(mapKey, c);
                    continue;
                }
                catch (ConnectorException e) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    public static long genConnectorMapKey(int sourceType, int targetType) {
        if (sourceType < 0) {
            sourceType = -1 * sourceType * 100000;
        }
        if (targetType < 0) {
            targetType = -1 * targetType * 10000;
        }
        return sourceType * 1000000000 + targetType;
    }

    public static boolean isTimeWithTimeZoneType(String typeName) {
        return Pattern.matches(PATTERN_CALENDAR_TIME_TYPE, typeName.toLowerCase());
    }

    public static boolean isTimestampWithTimeZoneType(String typeName) {
        return Pattern.matches(PATTERN_CALENDAR_TIMESTAMP_TYPE, typeName.toLowerCase());
    }
}

