/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class ConnectorCsvPrinter {
    private char fieldSeparator = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private CSVWriter csvWriter;
    private CharArrayWriter out;

    public ConnectorCsvPrinter() {
        this.initialize();
    }

    public ConnectorCsvPrinter(String fieldSeparator, String quoteChar, String escapeChar) {
        if (!fieldSeparator.isEmpty()) {
            this.fieldSeparator = fieldSeparator.charAt(0);
        }
        if (!quoteChar.isEmpty()) {
            this.quoteChar = quoteChar.charAt(0);
        }
        if (!escapeChar.isEmpty()) {
            this.escapeChar = escapeChar.charAt(0);
        }
        this.initialize();
    }

    public ConnectorCsvPrinter(char fieldSeparator, char quoteChar, char escapeChar) {
        this.fieldSeparator = fieldSeparator;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.initialize();
    }

    private void initialize() {
        this.out = new CharArrayWriter();
        this.csvWriter = new CSVWriter((Writer)this.out, this.fieldSeparator, this.quoteChar, this.escapeChar, "");
    }

    public String print(String[] objects) throws IOException {
        this.out.reset();
        this.csvWriter.writeNext(objects);
        return this.out.toString();
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }
}

