/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorJobRunner;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.StandardCharsets;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.test.group.SlowTests;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTests.class})
public class ConnectorJobRunnerTest {
    public static final String VALUE_TERADATA_INPUT_SPLIT_BY_AMP_PROCESSOR = "com.teradata.connector.teradata.processor.TeradataSplitByAmpProcessor";
    public static final String VALUE_TERADATA_SPLIT_BY_AMP_INPUT_FORMAT = "com.teradata.connector.teradata.TeradataSplitByAmpInputFormat";
    public static final String VALUE_TERADATA_SERDE = "com.teradata.connector.teradata.serde.TeradataSerDe";
    public static final String VALUE_TERADATA_OUTPUT_BATCH_INSERT_PROCESSOR = "com.teradata.connector.teradata.processor.TeradataBatchInsertProcessor";
    public static final String VALUE_TERADATA_BATCH_INSERT_OUTPUT_FORMAT = "com.teradata.connector.teradata.TeradataBatchInsertOutputFormat";
    public static final String VALUE_TERADATA_CONVERTER = "com.teradata.connector.teradata.converter.TeradataConverter";
    final String dbs = System.getProperty("dbs");
    final String databasename = System.getProperty("databasename");
    final String user = System.getProperty("user");
    final String password = System.getProperty("password");

    @Test
    public void testRunJob() {
        Job job;
        try {
            job = new Job();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Configuration configuration = job.getConfiguration();
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, "com.teradata.jdbc.TeraDriver");
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, "jdbc:teradata://" + this.dbs + "/database=" + this.databasename);
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)job, this.user.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)job, this.password.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setOutputJdbcDriverClass(configuration, "com.teradata.jdbc.TeraDriver");
        TeradataPlugInConfiguration.setOutputJdbcUrl(configuration, "jdbc:teradata://" + this.dbs + "/database=" + this.databasename);
        TeradataPlugInConfiguration.setOutputTeradataUserName((JobContext)job, this.user.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setOutputTeradataPassword((JobContext)job, this.password.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTable(configuration, "import_case");
        TeradataPlugInConfiguration.setInputDatabase(configuration, "tdch_tests");
        TeradataPlugInConfiguration.setOutputTable(configuration, "export_case");
        TeradataPlugInConfiguration.setOutputDatabase(configuration, "tdch_tests");
        ConnectorConfiguration.setUseCombinedInputFormat(configuration, false);
        configuration.set("tdch.plugin.input.processor", VALUE_TERADATA_INPUT_SPLIT_BY_AMP_PROCESSOR);
        configuration.set("tdch.plugin.input.format", VALUE_TERADATA_SPLIT_BY_AMP_INPUT_FORMAT);
        ConnectorConfiguration.setInputSerDe(configuration, VALUE_TERADATA_SERDE);
        configuration.set("tdch.plugin.output.processor", VALUE_TERADATA_OUTPUT_BATCH_INSERT_PROCESSOR);
        configuration.set("tdch.plugin.output.format", VALUE_TERADATA_BATCH_INSERT_OUTPUT_FORMAT);
        ConnectorConfiguration.setOutputSerDe(configuration, VALUE_TERADATA_SERDE);
        ConnectorConfiguration.setDataConverter(configuration, VALUE_TERADATA_CONVERTER);
        try {
            int result = ConnectorJobRunner.runJob(job);
            Assert.assertEquals((int)result, (int)0);
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
    }
}

