/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorImportTool;
import com.teradata.connector.test.group.SlowTests;
import java.util.Date;
import junit.framework.Assert;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ConnectorImportToolTest {
    String dbs = System.getProperty("dbs");
    String databasename = System.getProperty("databasename");
    String user = System.getProperty("user");
    String password = System.getProperty("password");

    @Test
    public void testRun() throws Exception {
        String[] args;
        try {
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])new String[0]);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Import tool parameters is not provided"));
        }
        try {
            args = new String[]{"-jobtype", "spark"};
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Import job type is invalid"));
        }
        try {
            args = new String[]{"-fileformat", "newsequence"};
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Import file format is invalid"));
        }
        try {
            args = new String[]{"-method", "split.by.nothing"};
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Import method was invalid, should be one of 'split.by.hash','split.by.value','split.by.partition','split.by.amp'"));
        }
        try {
            args = new String[]{"-nummappers", "-1"};
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("invalid provided value for parameter -nummappers,  greater than zero  value is required for this parameter"));
        }
        try {
            args = new String[]{"-numreducers", "i"};
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("NumberFormatException: For input string: \"i\""));
        }
    }

    @Category(value={SlowTests.class})
    @Test
    public void testRunJob() throws Exception {
        String[] args = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hive", "-sourcetable", this.databasename + ".TD_ALL_DATATYPE_small", "-nummappers", "2", "-targetdatabase", "hivetest", "-method", "split.by.partition", "-usexviews", "false"};
        try {
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Neither target path nor target Hive table name is provided"));
        }
        String[] argsUnknown = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hive", "-sourcetable", this.databasename + ".TD_ALL_DATATYPE_small", "-nummappers", "2", "-targetdatabase", "hivetest", "-method", "split.by.partition", "-usexviews", "false", "-hiveversion", "0.13"};
        try {
            ToolRunner.run((Tool)new ConnectorImportTool(), (String[])argsUnknown);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("unrecognized input parameters"));
        }
        String[] newArgs = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hdfs", "-sourcetable", this.databasename + ".TD_ALL_DATATYPE_small", "-nummappers", "2", "-targetpaths", "/tmp/" + new Date(), "-method", "split.by.partition", "-usexviews", "false", "-lineseparator", "\n", "-debugoption", "1", "-sourcedateformat", "dd-mm-yy", "-sourcetimeformat", "HH//mm:ss", "-sourcetimestampformat", "dd/MM/yyyy HH//mm:ss.SSSSSS"};
        int res = ToolRunner.run((Tool)new ConnectorImportTool(), (String[])newArgs);
        Assert.assertEquals((int)res, (int)0);
    }
}

