/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConfigurationMappingUtils;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.hadoop.db.TeradataConfiguration;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.Test;

public class ConfigurationMappingUtilsTest {
    String user = "tduser";
    String password = "tdpass";

    @Test
    public void testImportConfigurationMapping() throws Exception {
        Configuration conf = new Configuration();
        TeradataConfiguration.setInputJobType(conf, "hdfs");
        TeradataConfiguration.setInputFileFormat(conf, "rcfile");
        TeradataConfiguration.setInputTargetPaths(conf, "/user/TDimport");
        TeradataConfiguration.setInputSourceTable(conf, "TDtable");
        TeradataConfiguration.setInputSourceDatabase(conf, "TDdatabase");
        TeradataConfiguration.setJDBCDriverClass(conf, "com.teradata.jdbc.TeraDriver");
        TeradataConfiguration.setJDBCURL(conf, "jdbc:teradata://dbs/database=databasename");
        TeradataConfiguration.setJDBCUsername(conf, this.user);
        TeradataConfiguration.setJDBCPassword(conf, this.password);
        try {
            ConfigurationMappingUtils.importConfigurationMapping(conf);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("plugin \"hdfs-rcfile\" not found"));
        }
        TeradataConfiguration.setInputJobType(conf, "hive");
        ConfigurationMappingUtils.importConfigurationMapping(conf);
        Assert.assertEquals((int)conf.getInt("tdch.num.mappers", 0), (int)2);
        Assert.assertEquals((String)conf.get("teradata.db.input.source.table"), (String)"TDtable");
        Assert.assertNull((Object)conf.get("tdch.output.hive.table"));
        Assert.assertEquals((String)conf.get("tdch.output.hive.paths"), (String)"/user/TDimport");
        Assert.assertEquals((String)conf.get("mapred.output.dir"), (String)"/user/TDimport");
    }

    @Test
    public void exportConfigurationMappingTest() throws Exception {
        Configuration conf = new Configuration();
        TeradataConfiguration.setOutputJobType(conf, "hdfs");
        TeradataConfiguration.setOutputFileFormat(conf, "textfile");
        TeradataConfiguration.setOutputSourcePaths(conf, "/user/TDexport");
        TeradataConfiguration.setOutputTargetTable(conf, "TDtable");
        TeradataConfiguration.setOutputTargetDatabase(conf, "TDdatabase");
        TeradataConfiguration.setJDBCDriverClass(conf, "com.teradata.jdbc.TeraDriver");
        TeradataConfiguration.setJDBCURL(conf, "jdbc:teradata://dbs/database=databasename");
        TeradataConfiguration.setJDBCUsername(conf, this.user);
        TeradataConfiguration.setJDBCPassword(conf, this.password);
        TeradataConfiguration.setOutputMethod(conf, "batch.insert");
        TeradataConfiguration.setOutputSeparator(conf, ",");
        ConfigurationMappingUtils.exportConfigurationMapping(conf);
        Assert.assertEquals((String)conf.get("teradata.db.output.target.table"), (String)"TDtable");
        Assert.assertEquals((int)conf.getInt("tdch.num.mappers", 0), (int)2);
        Assert.assertNull((Object)conf.get("teradata.db.output.source.database"));
        Assert.assertEquals((String)conf.get("teradata.db.output.source.paths"), (String)"/user/TDexport");
        Assert.assertEquals((String)conf.get("teradata.db.output.fields.separator"), (String)",");
    }

    @Test
    public void hideCredentialsTest() throws Exception {
        Configuration conf = new Configuration();
        TeradataConfiguration.setJDBCUsername(conf, this.user);
        TeradataConfiguration.setJDBCPassword(conf, this.password);
        TeradataPlugInConfiguration.setInputJdbcUserName(conf, this.user);
        TeradataPlugInConfiguration.setInputJdbcPassword(conf, this.password);
        TeradataPlugInConfiguration.setOutputJdbcUserName(conf, this.user);
        TeradataPlugInConfiguration.setOutputJdbcPassword(conf, this.password);
        Job context = new Job(conf);
        conf = context.getConfiguration();
        Assert.assertEquals((String)conf.get("mapreduce.jdbc.username"), (String)this.user);
        Assert.assertEquals((String)conf.get("mapreduce.jdbc.password"), (String)this.password);
        ConfigurationMappingUtils.hideCredentials((JobContext)context);
        Assert.assertTrue((boolean)conf.get("mapreduce.jdbc.username").isEmpty());
        Assert.assertTrue((boolean)conf.get("mapreduce.jdbc.password").isEmpty());
        Assert.assertTrue((boolean)conf.get("tdch.input.teradata.jdbc.user.name").isEmpty());
        Assert.assertTrue((boolean)conf.get("tdch.input.teradata.jdbc.password").isEmpty());
        Assert.assertTrue((boolean)conf.get("tdch.output.teradata.jdbc.user.name").isEmpty());
        Assert.assertTrue((boolean)conf.get("tdch.output.teradata.jdbc.password").isEmpty());
    }
}

