/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.converter;

import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class ConnectorDataTypeConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected boolean nullable = false;
    protected Object defaultValue = null;
    private static final String DefaultTimestampFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DefaultTimestampFormatTZ = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final String DefaultDateFormat = "yyyy-MM-dd";
    private static final String DefaultTimeFormat = "HH:mm:ss";

    public abstract Object convert(Object var1);

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected static Date parseStringWithFormatArray(List<DateFormat> list, String s) {
        if (list == null || list.size() == 0) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            DateFormat df = list.get(i);
            try {
                return df.parse(s);
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }

    protected static DateFormat createDateFormat(TimeZone tz, String dateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static long convertMillisecFromSourceToDefaultTZ(long millisec, TimeZone sourceTZ) {
        int offSet = TimeZone.getDefault().getOffset(millisec) - sourceTZ.getOffset(millisec);
        return millisec + (long)offSet;
    }

    public static long convertMillisecFromDefaultToTargetTZ(long millisec, TimeZone targetTZ) {
        int offSet = targetTZ.getOffset(millisec) - TimeZone.getDefault().getOffset(millisec);
        return millisec + (long)offSet;
    }

    @Deprecated
    public static final class DateToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    @Deprecated
    public static final class DateTZToStringFMT
    extends ConnectorDataTypeConverter {
        DateFormat df;
        private int offset;
        private Calendar targetCalendar;

        public DateTZToStringFMT(String sourceTimezoneId, String dateFormat) {
            this.df = dateFormat == null || dateFormat.isEmpty() ? null : new SimpleDateFormat(dateFormat);
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getDefault();
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((java.sql.Date)object).getTime());
            this.targetCalendar.add(14, this.offset);
            Date d = new Date(this.targetCalendar.getTimeInMillis());
            if (this.df != null) {
                return this.df.format(d);
            }
            return d.toString();
        }
    }

    @Deprecated
    public static final class DateTZToDateTZ
    extends ConnectorDataTypeConverter {
        private int offset;
        private Calendar targetCalendar;

        public DateTZToDateTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((java.sql.Date)object).getTime());
            this.targetCalendar.add(14, this.offset);
            return new java.sql.Date(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class DateToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (int)(((java.sql.Date)object).getTime() / 1000L);
        }
    }

    @Deprecated
    public static final class StringToTimestampWithFormat
    extends ConnectorDataTypeConverter {
        protected String dateFormat;

        public StringToTimestampWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
                return new Timestamp(df.parse((String)object).getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    public static final class StringToTimestampTZ_d
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public StringToTimestampTZ_d(String targetTimeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(targetTimeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(Timestamp.valueOf((String)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class StringToTimestamp
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Timestamp.valueOf((String)object);
        }
    }

    @Deprecated
    public static final class StringToTimeWithFormat
    extends ConnectorDataTypeConverter {
        String dateFormat;

        public StringToTimeWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
                return new Time(df.parse((String)object).getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    public static final class StringToTime
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Time.valueOf((String)object);
        }
    }

    @Deprecated
    public static final class StringToDateWithFormat
    extends ConnectorDataTypeConverter {
        private String dateFormat;

        public StringToDateWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
                return new java.sql.Date(df.parse((String)object).getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    public static final class StringToDate
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return java.sql.Date.valueOf((String)object);
        }
    }

    @Deprecated
    public static final class TimeToStringWithFormat
    extends ConnectorDataTypeConverter {
        String dateFormat;

        public TimeToStringWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            return df.format((Time)object);
        }
    }

    @Deprecated
    public static final class TimeToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    @Deprecated
    public static final class TimeToTimeWithTimeZone
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimeToTimeWithTimeZone(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Time)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Time(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimeToTime
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    @Deprecated
    public static final class TimestampTZToTimestampTZ_d
    extends ConnectorDataTypeConverter {
        TimeZone sourceTimeZone;
        TimeZone targetTimeZone;
        Calendar sourceCalendar;
        Calendar targetCalendar;

        public TimestampTZToTimestampTZ_d(String sourceTimeZoneId, String targetTimeZoneId) {
            this.sourceTimeZone = TimeZone.getTimeZone(sourceTimeZoneId);
            this.sourceCalendar = Calendar.getInstance(this.targetTimeZone);
            this.targetTimeZone = TimeZone.getTimeZone(targetTimeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = this.sourceTimeZone.getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimestampToTimestampTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampToTimestampTZ(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimestampToTimestamp
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    @Deprecated
    public static final class TimestampTZToTimestamp
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampTZToTimestamp(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimestampTZToTime
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampTZToTime(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Time(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimestampToTime
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return new Time(((Timestamp)object).getTime());
        }
    }

    @Deprecated
    public static final class TimestampTZToDate
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampTZToDate(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new java.sql.Date(this.targetCalendar.getTimeInMillis());
        }
    }

    @Deprecated
    public static final class TimestampToDate
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return new java.sql.Date(((Timestamp)object).getTime());
        }
    }

    @Deprecated
    public static final class TimestampToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Timestamp)object).getTime();
        }
    }

    @Deprecated
    public static final class LongToTimestamp
    extends ConnectorDataTypeConverter {
        Timestamp ts = new Timestamp(System.currentTimeMillis());

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.ts.setTime((Long)object);
            return this.ts;
        }
    }

    @Deprecated
    public static final class TimestampTZToString
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampTZToString(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis()).toString();
        }
    }

    public static final class Others
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            return object == null ? null : object;
        }
    }

    public static final class ObjectToJsonString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            StringWriter writer = new StringWriter();
            try {
                this.objectMapper.writeValue((Writer)writer, object);
                return writer.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static final class ObjectToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class BytesToString
    extends ConnectorDataTypeConverter {
        public static String bytesToString(byte[] bytes) {
            char[] buffer = new char[bytes.length >> 1];
            for (int i = 0; i < buffer.length; ++i) {
                char ch;
                int bpos = i << 1;
                buffer[i] = ch = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
            }
            return new String(buffer);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            byte[] bytesData = (byte[])object;
            return BytesToString.bytesToString(bytesData);
        }
    }

    public static final class BinaryToString
    extends ConnectorDataTypeConverter {
        private StringBuilder builder = new StringBuilder();

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            this.builder.setLength(0);
            for (byte b : (byte[])object) {
                int h = b & 0xFF;
                String hex = Integer.toHexString(h);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                this.builder.append(hex);
            }
            return this.builder.toString();
        }
    }

    public static final class BinaryToBinary
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            return object == null ? this.defaultValue : object;
        }
    }

    public static final class TimestampToTimestampWithTimeZone
    extends ConnectorDataTypeConverter {
        TimeZone targetTimeZone;
        Calendar targetCalendar;

        public TimestampToTimestampWithTimeZone(String timeZoneId) {
            this.targetTimeZone = TimeZone.getTimeZone(timeZoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimeZone);
        }

        @Override
        public final Object convert(Object object) {
            long currentTime = System.currentTimeMillis();
            int sourceOffset = TimeZone.getDefault().getOffset(currentTime);
            int targetOffset = this.targetTimeZone.getOffset(currentTime);
            int hourDifference = (sourceOffset - targetOffset) / 3600000;
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Timestamp)object).getTime());
            this.targetCalendar.add(10, hourDifference);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    public static final class TimestampToStringWithFormat
    extends ConnectorDataTypeConverter {
        String dateFormat;

        public TimestampToStringWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            return df.format((Timestamp)object);
        }
    }

    public static final class TimestampToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class TimestampTZToStringFMTTZ
    extends ConnectorDataTypeConverter {
        private int offset;
        private Timestamp timestamp;
        private DateFormat df;

        public TimestampTZToStringFMTTZ(String sourceTimezoneId, String targetTimezoneId, String targetFormat) {
            if (targetFormat == null || targetFormat.isEmpty()) {
                targetFormat = ConnectorDataTypeConverter.DefaultTimestampFormat;
            }
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            int defTZ = TimeZone.getDefault().getOffset(System.currentTimeMillis());
            this.offset = defTZ - sourceTimezone.getOffset(System.currentTimeMillis());
            this.timestamp = new Timestamp(0L);
            this.df = TimestampTZToStringFMTTZ.createDateFormat(targetTimezone, targetFormat);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long millisec = ((Timestamp)object).getTime() + (long)this.offset;
            this.timestamp.setTime(millisec);
            return this.df.format(this.timestamp);
        }
    }

    public static final class TimestampTZToTimestampTZ
    extends ConnectorDataTypeConverter {
        private int offset;

        public TimestampTZToTimestampTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Timestamp ts = new Timestamp(((Timestamp)object).getTime() + (long)this.offset);
            ts.setNanos(((Timestamp)object).getNanos());
            return ts;
        }
    }

    public static final class TimestampTZToTimeTZ
    extends ConnectorDataTypeConverter {
        private int offset;

        public TimestampTZToTimeTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long milliSec = ((Timestamp)object).getTime() + (long)this.offset;
            return new Time(milliSec);
        }
    }

    public static final class TimestampTZToDateTZ
    extends ConnectorDataTypeConverter {
        private int offset;

        public TimestampTZToDateTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Timestamp ts = (Timestamp)object;
            long milliSec = ts.getTime() + (long)this.offset;
            return new java.sql.Date(milliSec);
        }
    }

    public static final class TimestampTZToLong
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;

        public TimestampTZToLong(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Timestamp ts = (Timestamp)object;
            long milliSec = ts.getTime();
            milliSec = TimestampTZToLong.convertMillisecFromSourceToDefaultTZ(milliSec, this.sourceTimezone);
            return milliSec;
        }
    }

    public static final class TimestampTZToInteger
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;

        public TimestampTZToInteger(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Timestamp ts = (Timestamp)object;
            long milliSec = ts.getTime();
            milliSec = TimestampTZToInteger.convertMillisecFromSourceToDefaultTZ(milliSec, this.sourceTimezone);
            return (int)(milliSec / 1000L);
        }
    }

    public static final class CalendarToStringFMTTZ
    extends ConnectorDataTypeConverter {
        private TimeZone targetTimezone;
        private DateFormat df;

        public CalendarToStringFMTTZ(String targetTimezoneId, String targetFormat) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.df = targetFormat == null || targetFormat.isEmpty() ? CalendarToStringFMTTZ.createDateFormat(this.targetTimezone, ConnectorDataTypeConverter.DefaultTimestampFormatTZ) : CalendarToStringFMTTZ.createDateFormat(this.targetTimezone, targetFormat);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            return this.df.format(cal.getTimeInMillis());
        }
    }

    public static final class CalendarToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            return (int)(cal.getTimeInMillis() / 1000L);
        }
    }

    public static final class CalendarToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            return cal.getTimeInMillis();
        }
    }

    public static final class CalendarToDateTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public CalendarToDateTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            long milliSec = CalendarToDateTZ.convertMillisecFromDefaultToTargetTZ(cal.getTimeInMillis(), this.targetTimezone);
            return new java.sql.Date(milliSec);
        }
    }

    public static final class CalendarToTimestampTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public CalendarToTimestampTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            long milliSec = CalendarToTimestampTZ.convertMillisecFromDefaultToTargetTZ(cal.getTimeInMillis(), this.targetTimezone);
            return new Timestamp(milliSec);
        }
    }

    public static final class CalendarToTimeTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public CalendarToTimeTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            long milliSec = CalendarToTimeTZ.convertMillisecFromDefaultToTargetTZ(cal.getTimeInMillis(), this.targetTimezone);
            return new Time(milliSec);
        }
    }

    public static final class CalendarToCalendar
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;

        public CalendarToCalendar(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Calendar cal = (Calendar)object;
            this.targetCalendar.setTimeInMillis(cal.getTimeInMillis());
            return this.targetCalendar;
        }
    }

    public static final class StringFMTTZToCalendarTime
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;
        private DateFormat df;
        private List<DateFormat> backupDateFormat;
        private TimeZone targetTimezone;
        private TimeZone sourceTimezone;

        public ConnectorDataTypeConverter setupBackupDateFormat(Configuration conf, String confName) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, confName);
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                DateFormat df = StringFMTTZToCalendarTime.createDateFormat(this.sourceTimezone, values.get(i));
                this.backupDateFormat.add(df);
            }
            return this;
        }

        public StringFMTTZToCalendarTime(String sourceFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimezone);
            this.df = sourceFormat == null || sourceFormat.isEmpty() ? StringFMTTZToCalendarTime.createDateFormat(this.sourceTimezone, ConnectorDataTypeConverter.DefaultTimeFormat) : StringFMTTZToCalendarTime.createDateFormat(this.sourceTimezone, sourceFormat);
        }

        @Override
        public final Object convert(Object object) {
            Date d;
            block3: {
                if (object == null || ((String)object).isEmpty()) {
                    return this.nullable ? null : this.defaultValue;
                }
                try {
                    d = this.df.parse((String)object);
                }
                catch (ParseException e) {
                    d = StringFMTTZToCalendarTime.parseStringWithFormatArray(this.backupDateFormat, (String)object);
                    if (d != null) break block3;
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            long millTime = d.getTime();
            this.targetCalendar.setTimeInMillis(millTime);
            return this.targetCalendar;
        }
    }

    public static final class StringFMTTZToCalendarTimestamp
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;
        private DateFormat df;
        private List<DateFormat> backupDateFormat;
        private TimeZone targetTimezone;
        private TimeZone sourceTimezone;

        public ConnectorDataTypeConverter setupBackupDateFormat(Configuration conf, String confName) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, confName);
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                DateFormat df = StringFMTTZToCalendarTimestamp.createDateFormat(this.sourceTimezone, values.get(i));
                this.backupDateFormat.add(df);
            }
            return this;
        }

        public StringFMTTZToCalendarTimestamp(String sourceFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(this.targetTimezone);
            this.df = sourceFormat == null || sourceFormat.isEmpty() ? null : StringFMTTZToCalendarTimestamp.createDateFormat(this.sourceTimezone, sourceFormat);
        }

        @Override
        public final Object convert(Object object) {
            long millTime;
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            if (this.df == null) {
                try {
                    Timestamp ts = Timestamp.valueOf((String)object);
                    millTime = ts.getTime();
                }
                catch (IllegalArgumentException e) {
                    try {
                        java.sql.Date d = java.sql.Date.valueOf((String)object);
                        millTime = d.getTime();
                    }
                    catch (IllegalArgumentException e1) {
                        Time t = Time.valueOf((String)object);
                        millTime = t.getTime();
                    }
                }
                millTime = StringFMTTZToCalendarTimestamp.convertMillisecFromSourceToDefaultTZ(millTime, this.sourceTimezone);
            } else {
                Date d;
                block11: {
                    try {
                        d = this.df.parse((String)object);
                    }
                    catch (ParseException e) {
                        d = StringFMTTZToCalendarTimestamp.parseStringWithFormatArray(this.backupDateFormat, (String)object);
                        if (d != null) break block11;
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                millTime = d.getTime();
            }
            this.targetCalendar.setTimeInMillis(millTime);
            return this.targetCalendar;
        }
    }

    public static final class LongToCalendar
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;

        public LongToCalendar(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis((Long)object);
            return this.targetCalendar;
        }
    }

    public static final class DateToCalendar
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;

        public DateToCalendar(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((java.sql.Date)object).getTime());
            return this.targetCalendar;
        }
    }

    public static final class TimestampTZToCalendar
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;
        private TimeZone sourceTimezone;

        public TimestampTZToCalendar(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Timestamp ts = (Timestamp)object;
            long millisec = TimestampTZToCalendar.convertMillisecFromSourceToDefaultTZ(ts.getTime(), this.sourceTimezone);
            this.targetCalendar.setTimeInMillis(millisec);
            return this.targetCalendar;
        }
    }

    public static final class TimeTZToCalendar
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;
        private Calendar targetCalendar;

        public TimeTZToCalendar(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time t = (Time)object;
            long millisec = TimeTZToCalendar.convertMillisecFromSourceToDefaultTZ(t.getTime(), this.sourceTimezone);
            this.targetCalendar.setTimeInMillis(millisec);
            return this.targetCalendar;
        }
    }

    public static final class TimeTZToStringFMTTZ
    extends ConnectorDataTypeConverter {
        private int offset;
        private DateFormat df;
        private Time time;

        public TimeTZToStringFMTTZ(String targetFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetFormat == null || targetFormat.isEmpty()) {
                targetFormat = ConnectorDataTypeConverter.DefaultTimeFormat;
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            int defTZ = TimeZone.getDefault().getOffset(System.currentTimeMillis());
            this.offset = defTZ - sourceTimezone.getOffset(System.currentTimeMillis());
            this.df = TimeTZToStringFMTTZ.createDateFormat(targetTimezone, targetFormat);
            this.time = new Time(0L);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time t = (Time)object;
            long milliSec = t.getTime() + (long)this.offset;
            this.time.setTime(milliSec);
            return this.df.format(this.time);
        }
    }

    public static final class TimeTZToTimeTZ
    extends ConnectorDataTypeConverter {
        private int offset;

        public TimeTZToTimeTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time t = (Time)object;
            long milliSec = t.getTime() + (long)this.offset;
            return new Time(milliSec);
        }
    }

    public static final class TimeToTimestamp
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time t = (Time)object;
            Date currentDate = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(currentDate);
            SimpleDateFormat f = new SimpleDateFormat(ConnectorDataTypeConverter.DefaultDateFormat);
            Timestamp ts = Timestamp.valueOf(f.format(cal.getTime()) + " " + t.toString());
            return ts;
        }
    }

    public static final class TimeTZToLong
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;

        public TimeTZToLong(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time ts = (Time)object;
            long milliSec = ts.getTime();
            milliSec = TimeTZToLong.convertMillisecFromSourceToDefaultTZ(milliSec, this.sourceTimezone);
            return milliSec;
        }
    }

    public static final class TimeTZToInteger
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;

        public TimeTZToInteger(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            Time ts = (Time)object;
            long milliSec = ts.getTime();
            milliSec = TimeTZToInteger.convertMillisecFromSourceToDefaultTZ(milliSec, this.sourceTimezone);
            return (int)(milliSec / 1000L);
        }
    }

    public static final class DateToStringWithFormat
    extends ConnectorDataTypeConverter {
        String dateFormat;

        public DateToStringWithFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            return df.format((java.sql.Date)object);
        }
    }

    public static final class DateTZToTimestampTZ
    extends ConnectorDataTypeConverter {
        private int offset;
        private Calendar targetCalendar;

        public DateTZToTimestampTZ(String sourceTimezoneId, String targetTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.offset = targetTimezone.getOffset(System.currentTimeMillis()) - sourceTimezone.getOffset(System.currentTimeMillis());
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((java.sql.Date)object).getTime());
            this.targetCalendar.add(14, this.offset);
            return new Timestamp(this.targetCalendar.getTimeInMillis());
        }
    }

    public static final class DateTZToLong
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;
        private boolean timezoneIsDST;
        private int offset;

        public DateTZToLong(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            if (!this.sourceTimezone.useDaylightTime()) {
                this.timezoneIsDST = false;
                this.offset = this.sourceTimezone.getOffset(System.currentTimeMillis());
            } else {
                this.timezoneIsDST = true;
                this.offset = 0;
            }
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long timestamp = ((java.sql.Date)object).getTime();
            if (this.timezoneIsDST) {
                this.offset = this.sourceTimezone.getOffset(timestamp);
            }
            return timestamp - (long)this.offset;
        }
    }

    public static final class DateTZToInteger
    extends ConnectorDataTypeConverter {
        private TimeZone sourceTimezone;
        private boolean timezoneIsDST;
        private int offset;

        public DateTZToInteger(String sourceTimezoneId) {
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            if (!this.sourceTimezone.useDaylightTime()) {
                this.timezoneIsDST = false;
                this.offset = this.sourceTimezone.getOffset(System.currentTimeMillis());
            } else {
                this.timezoneIsDST = true;
                this.offset = 0;
            }
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long timestamp = ((java.sql.Date)object).getTime();
            if (this.timezoneIsDST) {
                this.offset = this.sourceTimezone.getOffset(timestamp);
            }
            return (int)((timestamp - (long)this.offset) / 1000L);
        }
    }

    public static final class DateToStringFMT
    extends ConnectorDataTypeConverter {
        DateFormat df;

        public DateToStringFMT(String dateFormat) {
            this.df = dateFormat == null || dateFormat.isEmpty() ? null : new SimpleDateFormat(dateFormat);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            if (this.df != null) {
                return this.df.format(object);
            }
            return object.toString();
        }
    }

    public static final class DateToTimestamp
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return new Timestamp(((java.sql.Date)object).getTime());
        }
    }

    public static final class DateToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((java.sql.Date)object).getTime();
        }
    }

    public static final class DateToDate
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class BlobToString
    extends ConnectorDataTypeConverter {
        private StringBuilder builder = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object convert(Object object) {
            if (object == null) {
                return "";
            }
            int bufsize = 10000;
            int size = 100000;
            int offset = 0;
            int nbytes = 0;
            Blob blobObj = (Blob)object;
            byte[] buf = new byte[bufsize];
            byte[] data = new byte[size];
            InputStream stream = null;
            this.builder.setLength(0);
            try {
                stream = blobObj.getBinaryStream();
                while ((nbytes = stream.read(buf, 0, bufsize)) > 0) {
                    if (offset + nbytes > size) {
                        byte[] newdata = new byte[size *= 2];
                        System.arraycopy(data, 0, newdata, 0, offset);
                        data = newdata;
                    }
                    System.arraycopy(buf, 0, data, offset, nbytes);
                    offset += nbytes;
                }
            }
            catch (IOException newdata) {
            }
            catch (SQLException newdata) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException newdata) {}
            }
            if (offset == 0) {
                return "";
            }
            byte[] bytesData = new byte[offset];
            System.arraycopy(data, 0, bytesData, 0, offset);
            this.builder.setLength(0);
            for (byte b : bytesData) {
                int h = b & 0xFF;
                String hex = Integer.toHexString(h);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                this.builder.append(hex);
            }
            return this.builder.toString();
        }
    }

    public static final class BlobToBinary
    extends ConnectorDataTypeConverter {
        private static final byte[] NULLBYTES = new byte[0];
        private StringBuilder builder = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return NULLBYTES;
            }
            int bufsize = 10000;
            int size = 100000;
            int offset = 0;
            int nbytes = 0;
            Blob blobObj = (Blob)object;
            byte[] buf = new byte[bufsize];
            byte[] data = new byte[size];
            InputStream stream = null;
            this.builder.setLength(0);
            try {
                stream = blobObj.getBinaryStream();
                while ((nbytes = stream.read(buf, 0, bufsize)) > 0) {
                    if (offset + nbytes > size) {
                        byte[] newdata = new byte[size *= 2];
                        System.arraycopy(data, 0, newdata, 0, offset);
                        data = newdata;
                    }
                    System.arraycopy(buf, 0, data, offset, nbytes);
                    offset += nbytes;
                }
            }
            catch (IOException newdata) {
            }
            catch (SQLException newdata) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException newdata) {}
            }
            if (offset == 0) {
                return NULLBYTES;
            }
            byte[] lob = new byte[offset];
            System.arraycopy(data, 0, lob, 0, offset);
            return lob;
        }
    }

    public static final class ClobToString
    extends ConnectorDataTypeConverter {
        private StringBuilder builder = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            int bufsize = 10000;
            Clob clobObj = (Clob)object;
            byte[] bytesData = new byte[bufsize];
            InputStream stream = null;
            this.builder.setLength(0);
            try {
                int nbytes;
                stream = clobObj.getAsciiStream();
                while ((nbytes = stream.read(bytesData, 0, bufsize)) > 0) {
                    for (int i = 0; i < nbytes; ++i) {
                        byte b = bytesData[i];
                        int c = b & 0xFF;
                        this.builder.append((char)c);
                    }
                }
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            catch (SQLException e) {
                String string = "";
                return string;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return this.builder.toString();
        }
    }

    public static final class IntervalToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class PeriodToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            String result = object.toString();
            int bracketPos = result.indexOf(91);
            if (bracketPos > 0 && (bracketPos = (result = result.substring(bracketPos + 1)).lastIndexOf(93)) > 0) {
                result = "(" + result.substring(0, bracketPos) + ")";
            }
            return result;
        }
    }

    public static final class StringToInterval
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class StringToPeriod
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class StringToBytes
    extends ConnectorDataTypeConverter {
        public byte[] toBytes(String str) {
            char[] buffer = str.toCharArray();
            byte[] b = new byte[buffer.length << 1];
            for (int i = 0; i < buffer.length; ++i) {
                int bpos = i << 1;
                b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
                b[bpos + 1] = (byte)(buffer[i] & 0xFF);
            }
            return b;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            String value = object.toString();
            int len = value.length();
            switch (len) {
                case 0: {
                    return this.defaultValue;
                }
            }
            return this.toBytes(value);
        }
    }

    public static final class StringToBinary
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            String value = object.toString();
            int len = value.length();
            switch (len) {
                case 0: {
                    return this.defaultValue;
                }
                case 1: {
                    byte[] bytesData = new byte[]{(byte)Character.digit(value.charAt(0), 16)};
                    return bytesData;
                }
            }
            byte[] bytesData = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                bytesData[i / 2] = (byte)((Character.digit(value.charAt(i), 16) << 4) + Character.digit(value.charAt(i + 1), 16));
            }
            return bytesData;
        }
    }

    public static final class StringFMTTZToTimestampTZ
    extends ConnectorDataTypeConverter {
        private List<TimestampParser> tsParsers = null;
        private TimeZone sourceTimezone = null;
        private TimeZone targetTimezone = null;

        public StringFMTTZToTimestampTZ(String inputFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (inputFormat == null || inputFormat.isEmpty()) {
                inputFormat = ConnectorDataTypeConverter.DefaultTimestampFormat;
            }
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.tsParsers = new ArrayList<TimestampParser>();
            this.tsParsers.add(TimestampParsers.createTimestampParser(inputFormat));
        }

        public ConnectorDataTypeConverter setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.timestamp.format");
            for (int i = 0; i < values.size(); ++i) {
                this.tsParsers.add(TimestampParsers.createTimestampParser(values.get(i)));
            }
            return this;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            String source = (String)object;
            Timestamp ts = null;
            Throwable parseException = null;
            for (TimestampParser parser : this.tsParsers) {
                try {
                    ts = parser.parse(source, this.sourceTimezone, this.targetTimezone);
                    break;
                }
                catch (ParseException e) {
                    parseException = e;
                }
                catch (IllegalArgumentException e) {
                    parseException = e;
                }
                catch (Exception e) {
                    parseException = e;
                }
            }
            if (ts == null) {
                throw new RuntimeException(parseException.getMessage(), parseException);
            }
            return ts;
        }

        public static class TimestampParsers {
            private TimestampParsers() {
            }

            public static TimestampParser createTimestampParser(String sourceFMT) {
                if (sourceFMT.matches(".*S{4,}.*")) {
                    return new JodaTimestampParser(sourceFMT);
                }
                return new DateFormatTimestampParser(sourceFMT);
            }

            private static class DateFormatTimestampParser
            implements TimestampParser {
                private int numfracseconds = 0;
                private DateFormat sourceDateFormat = null;

                private DateFormatTimestampParser(String sourceFMT) {
                    this.numfracseconds = sourceFMT.indexOf(83) == -1 ? 0 : sourceFMT.lastIndexOf(83) - sourceFMT.indexOf(83) + 1;
                    this.numfracseconds = this.numfracseconds == 3 ? 0 : this.numfracseconds;
                    this.sourceDateFormat = new SimpleDateFormat(sourceFMT);
                }

                @Override
                public Timestamp parse(String source, TimeZone inputTZ, TimeZone outputTZ) throws ParseException {
                    String nanos;
                    int nanLength;
                    this.sourceDateFormat.setTimeZone(inputTZ);
                    Date d = this.sourceDateFormat.parse(source);
                    long milliSec = ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(d.getTime(), outputTZ);
                    Timestamp ts = new Timestamp(milliSec);
                    if (this.numfracseconds != 0) {
                        int nanos2 = (int)((double)Math.abs(milliSec % 1000L) * Math.pow(10.0, 9 - this.numfracseconds));
                        ts.setNanos(nanos2);
                    }
                    if ((nanLength = (nanos = ts.getNanos() + "").length()) == 8) {
                        nanos = nanos + "0";
                    } else if (nanLength == 7) {
                        nanos = nanos + "00";
                    }
                    ts.setNanos(Integer.parseInt(nanos));
                    return ts;
                }
            }

            private static class JodaTimestampParser
            implements TimestampParser {
                private boolean containsZone = false;
                private int numfracseconds = 0;
                private DateTimeFormatter dtf = null;

                private JodaTimestampParser(String sourceFMT) {
                    this.containsZone = sourceFMT.contains("Z");
                    this.numfracseconds = sourceFMT.lastIndexOf(83) - sourceFMT.indexOf("SSSS") + 1;
                    this.dtf = DateTimeFormat.forPattern((String)sourceFMT);
                }

                @Override
                public Timestamp parse(String sourceTS, TimeZone sourceTZ, TimeZone targetTZ) {
                    DateTime dt = null;
                    dt = !this.containsZone ? this.dtf.parseLocalDateTime(sourceTS).toDateTime(DateTimeZone.forTimeZone((TimeZone)sourceTZ)) : this.dtf.parseDateTime(sourceTS);
                    long time = dt.getMillis();
                    String millis = "" + time % 1000L;
                    String fracseconds = sourceTS.substring(sourceTS.indexOf(millis), sourceTS.indexOf(millis) + this.numfracseconds);
                    Timestamp ts = new Timestamp(ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(time, targetTZ));
                    ts.setNanos(Integer.parseInt(fracseconds) * (int)Math.pow(10.0, 9 - this.numfracseconds));
                    return ts;
                }
            }
        }

        private static interface TimestampParser {
            public Timestamp parse(String var1, TimeZone var2, TimeZone var3) throws ParseException;
        }
    }

    public static final class StringFMTTZToTimeTZ
    extends ConnectorDataTypeConverter {
        private DateFormat sourceDateFormat;
        private List<DateFormat> backupDateFormat;
        private TimeZone sourceTimezone;
        private TimeZone targetTimezone;

        public StringFMTTZToTimeTZ(String inputFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (inputFormat == null || inputFormat.isEmpty()) {
                inputFormat = ConnectorDataTypeConverter.DefaultTimeFormat;
            }
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.sourceDateFormat = StringFMTTZToTimeTZ.createDateFormat(this.sourceTimezone, inputFormat);
        }

        public ConnectorDataTypeConverter setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.time.format");
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                this.backupDateFormat.add(StringFMTTZToTimeTZ.createDateFormat(this.sourceTimezone, values.get(i)));
            }
            return this;
        }

        @Override
        public final Object convert(Object object) {
            Date d;
            block3: {
                if (object == null || ((String)object).isEmpty()) {
                    return this.nullable ? null : this.defaultValue;
                }
                String source = (String)object;
                try {
                    d = this.sourceDateFormat.parse(source);
                }
                catch (ParseException e) {
                    d = StringFMTTZToTimeTZ.parseStringWithFormatArray(this.backupDateFormat, (String)object);
                    if (d != null) break block3;
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            long milliSec = StringFMTTZToTimeTZ.convertMillisecFromDefaultToTargetTZ(d.getTime(), this.targetTimezone);
            return new Time(milliSec);
        }
    }

    public static final class StringFMTTZToDateTZ
    extends ConnectorDataTypeConverter {
        private DateFormat sourceDateFormat;
        private List<DateFormat> backupDateFormat = null;
        private TimeZone sourceTimezone;
        private TimeZone targetTimezone;

        public StringFMTTZToDateTZ(String inputFormat, String sourceTimezoneId, String targetTimezoneId) {
            if (inputFormat == null || inputFormat.isEmpty()) {
                inputFormat = ConnectorDataTypeConverter.DefaultDateFormat;
            }
            if (sourceTimezoneId == null || sourceTimezoneId.isEmpty()) {
                sourceTimezoneId = TimeZone.getDefault().getID();
            }
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.sourceTimezone = TimeZone.getTimeZone(sourceTimezoneId);
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.sourceDateFormat = StringFMTTZToDateTZ.createDateFormat(this.sourceTimezone, inputFormat);
        }

        public ConnectorDataTypeConverter setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.date.format");
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                this.backupDateFormat.add(StringFMTTZToDateTZ.createDateFormat(this.sourceTimezone, values.get(i)));
            }
            return this;
        }

        @Override
        public final Object convert(Object object) {
            Date d;
            block3: {
                if (object == null || ((String)object).isEmpty()) {
                    return this.nullable ? null : this.defaultValue;
                }
                String source = (String)object;
                try {
                    d = this.sourceDateFormat.parse(source);
                }
                catch (ParseException e) {
                    d = StringFMTTZToDateTZ.parseStringWithFormatArray(this.backupDateFormat, (String)object);
                    if (d != null) break block3;
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            long milliSec = StringFMTTZToDateTZ.convertMillisecFromDefaultToTargetTZ(d.getTime(), this.targetTimezone);
            return new java.sql.Date(milliSec);
        }
    }

    public static final class StringToString
    extends ConnectorDataTypeConverter {
        int length;
        boolean truncate;

        public StringToString() {
            this.setTruncate(true);
            this.setLength(Integer.MAX_VALUE);
        }

        public StringToString(boolean truncate, int length) {
            this.setTruncate(truncate);
            this.setLength(length);
        }

        public void setTruncate(boolean truncate) {
            this.truncate = truncate;
        }

        public void setLength(int length) {
            this.length = length < 1 ? Integer.MAX_VALUE : length;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            if (this.truncate) {
                String objstr = (String)object;
                if (objstr.length() > this.length) {
                    return objstr.substring(0, this.length);
                }
                return objstr;
            }
            String objstr = (String)object;
            if (objstr.length() > this.length) {
                throw new RuntimeException("String would be truncated");
            }
            return object;
        }
    }

    public static final class StringToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Boolean.valueOf((String)object);
        }
    }

    public static final class StringToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal((String)object);
        }
    }

    public static final class StringToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return new BigDecimal((String)object).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class StringToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Double.valueOf((String)object);
        }
    }

    public static final class StringToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf((String)object);
        }
    }

    public static final class StringToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Byte.valueOf((String)object);
        }
    }

    public static final class StringToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Short.valueOf((String)object);
        }
    }

    public static final class StringToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Long.valueOf((String)object);
        }
    }

    public static final class StringToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null || ((String)object).isEmpty()) {
                return this.nullable ? null : this.defaultValue;
            }
            return Integer.valueOf((String)object);
        }
    }

    public static final class BooleanToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class BooleanToBoolean
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class BooleanToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;
        int scale;
        int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            if (((Boolean)object).booleanValue()) {
                return ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return ((BigDecimal)this.falseDefaultValue).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class BooleanToBigDecimal
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;
        int scale;
        int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            if (((Boolean)object).booleanValue()) {
                return (BigDecimal)this.defaultValue;
            }
            return (BigDecimal)this.falseDefaultValue;
        }
    }

    public static final class BooleanToDouble
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BooleanToFloat
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BooleanToTinyInt
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BooleanToShort
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BooleanToLong
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BooleanToInteger
    extends ConnectorDataTypeConverter {
        Object falseDefaultValue;

        public void setFalseDefaultValue(Object falseDefaultValue) {
            this.falseDefaultValue = falseDefaultValue;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Boolean)object == true ? this.defaultValue : this.falseDefaultValue;
        }
    }

    public static final class BigDecimalToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class BigDecimalToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).unscaledValue().longValue() != 0L;
        }
    }

    public static final class BigDecimalToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return ((BigDecimal)object).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class BigDecimalToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return (BigDecimal)object;
        }
    }

    public static final class BigDecimalToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).doubleValue();
        }
    }

    public static final class BigDecimalToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((BigDecimal)object).floatValue());
        }
    }

    public static final class BigDecimalToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).byteValue();
        }
    }

    public static final class BigDecimalToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).shortValue();
        }
    }

    public static final class BigDecimalToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).longValue();
        }
    }

    public static final class BigDecimalToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((BigDecimal)object).intValue();
        }
    }

    public static final class DoubleToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class DoubleToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Double)object != 0.0;
        }
    }

    public static final class DoubleToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;
        protected int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            MathContext mc = new MathContext(this.precision, RoundingMode.HALF_UP);
            return new BigDecimal((Double)object, mc).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class DoubleToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;
        protected int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal((Double)object);
        }
    }

    public static final class DoubleToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class DoubleToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((Double)object).floatValue());
        }
    }

    public static final class DoubleToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Double)object).byteValue();
        }
    }

    public static final class DoubleToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Double)object).shortValue();
        }
    }

    public static final class DoubleToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Double)object).longValue();
        }
    }

    public static final class DoubleToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Double)object).intValue();
        }
    }

    public static final class FloatToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class FloatToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (double)((Float)object).floatValue() != 0.0;
        }
    }

    public static final class FloatToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;
        protected int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            MathContext mc = new MathContext(this.precision, RoundingMode.HALF_UP);
            return new BigDecimal(((Float)object).floatValue(), mc).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class FloatToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;
        protected int precision;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal(((Float)object).floatValue());
        }
    }

    public static final class FloatToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Float)object).doubleValue();
        }
    }

    public static final class FloatToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class FloatToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Float)object).byteValue();
        }
    }

    public static final class FloatToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Float)object).shortValue();
        }
    }

    public static final class FloatToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Float)object).longValue();
        }
    }

    public static final class FloatToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Float)object).intValue();
        }
    }

    public static final class TinyIntToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class TinyIntToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Byte)object != 0;
        }
    }

    public static final class TinyIntToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return new BigDecimal(((Byte)object).byteValue()).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class TinyIntToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal(((Byte)object).byteValue());
        }
    }

    public static final class TinyIntToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Byte)object).doubleValue();
        }
    }

    public static final class TinyIntToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((Byte)object).floatValue());
        }
    }

    public static final class TinyIntToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class TinyIntToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Byte)object).shortValue();
        }
    }

    public static final class TinyIntToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Byte)object).longValue();
        }
    }

    public static final class TinyIntToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Byte)object).intValue();
        }
    }

    public static final class ShortToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class ShortToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Short)object != 0;
        }
    }

    public static final class ShortToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return new BigDecimal(((Short)object).shortValue()).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class ShortToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal(((Short)object).shortValue());
        }
    }

    public static final class ShortToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Short)object).doubleValue();
        }
    }

    public static final class ShortToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((Short)object).floatValue());
        }
    }

    public static final class ShortToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Short)object).byteValue();
        }
    }

    public static final class ShortToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Short)object;
        }
    }

    public static final class ShortToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Short)object).longValue();
        }
    }

    public static final class ShortToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Short)object).intValue();
        }
    }

    public static final class LongToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class LongToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Long)object != 0L;
        }
    }

    public static final class LongToDateTZ
    extends ConnectorDataTypeConverter {
        private TimeZone targetTimezone;
        private boolean timezoneIsDST;
        private int offset;

        public LongToDateTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            if (!this.targetTimezone.useDaylightTime()) {
                this.timezoneIsDST = false;
                this.offset = this.targetTimezone.getOffset(System.currentTimeMillis());
            } else {
                this.timezoneIsDST = true;
                this.offset = 0;
            }
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long timestamp = (Long)object;
            if (this.timezoneIsDST) {
                this.offset = this.targetTimezone.getOffset(timestamp);
            }
            return new java.sql.Date(timestamp + (long)this.offset);
        }
    }

    public static final class LongToTimeTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public LongToTimeTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long milliSec = (Long)object;
            milliSec = LongToTimeTZ.convertMillisecFromDefaultToTargetTZ(milliSec, this.targetTimezone);
            return new Time(milliSec);
        }
    }

    public static final class LongToTimestampTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public LongToTimestampTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long milliSec = (Long)object;
            milliSec = LongToTimestampTZ.convertMillisecFromDefaultToTargetTZ(milliSec, this.targetTimezone);
            return new Timestamp(milliSec);
        }
    }

    public static final class LongToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return new BigDecimal((Long)object).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class LongToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal((Long)object);
        }
    }

    public static final class LongToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Long)object).doubleValue();
        }
    }

    public static final class LongToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((Long)object).floatValue());
        }
    }

    public static final class LongToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Long)object).byteValue();
        }
    }

    public static final class LongToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Long)object).shortValue();
        }
    }

    public static final class LongToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static final class LongToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Long)object).intValue();
        }
    }

    public static final class IntegerToString
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object.toString();
        }
    }

    public static final class IntegerToBoolean
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return (Integer)object != 0;
        }
    }

    public static final class IntegerToCalendar
    extends ConnectorDataTypeConverter {
        private Calendar targetCalendar;

        public IntegerToCalendar(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            TimeZone targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            this.targetCalendar = Calendar.getInstance(targetTimezone);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            this.targetCalendar.setTimeInMillis(((Integer)object).longValue() * 1000L);
            return this.targetCalendar;
        }
    }

    public static final class IntegerToDateTZ
    extends ConnectorDataTypeConverter {
        private TimeZone targetTimezone;
        private boolean timezoneIsDST;
        private int offset;

        public IntegerToDateTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
            if (!this.targetTimezone.useDaylightTime()) {
                this.timezoneIsDST = false;
                this.offset = this.targetTimezone.getOffset(System.currentTimeMillis());
            } else {
                this.timezoneIsDST = true;
                this.offset = 0;
            }
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long timestamp = ((Integer)object).longValue() * 1000L;
            if (this.timezoneIsDST) {
                this.offset = this.targetTimezone.getOffset(timestamp);
            }
            return new java.sql.Date(timestamp + (long)this.offset);
        }
    }

    public static final class IntegerToTimeTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public IntegerToTimeTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long milliSec = ((Integer)object).longValue() * 1000L;
            milliSec = IntegerToTimeTZ.convertMillisecFromDefaultToTargetTZ(milliSec, this.targetTimezone);
            return new Time(milliSec);
        }
    }

    public static final class IntegerToTimestampTZ
    extends ConnectorDataTypeConverter {
        TimeZone targetTimezone;

        public IntegerToTimestampTZ(String targetTimezoneId) {
            if (targetTimezoneId == null || targetTimezoneId.isEmpty()) {
                targetTimezoneId = TimeZone.getDefault().getID();
            }
            this.targetTimezone = TimeZone.getTimeZone(targetTimezoneId);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            long milliSec = ((Integer)object).longValue() * 1000L;
            milliSec = IntegerToTimestampTZ.convertMillisecFromDefaultToTargetTZ(milliSec, this.targetTimezone);
            return new Timestamp(milliSec);
        }
    }

    public static final class IntegerToBigDecimalWithScale
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : ((BigDecimal)this.defaultValue).setScale(this.scale, RoundingMode.HALF_UP);
            }
            return new BigDecimal((Integer)object).setScale(this.scale, RoundingMode.HALF_UP);
        }
    }

    public static final class IntegerToBigDecimal
    extends ConnectorDataTypeConverter {
        protected int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : (BigDecimal)this.defaultValue;
            }
            return new BigDecimal((Integer)object);
        }
    }

    public static final class IntegerToDouble
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Integer)object).doubleValue();
        }
    }

    public static final class IntegerToFloat
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return Float.valueOf(((Integer)object).floatValue());
        }
    }

    public static final class IntegerToTinyInt
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Integer)object).byteValue();
        }
    }

    public static final class IntegerToShort
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Integer)object).shortValue();
        }
    }

    public static final class IntegerToLong
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return ((Integer)object).longValue();
        }
    }

    public static final class IntegerToInteger
    extends ConnectorDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            return object;
        }
    }

    public static class ObjectToAnyType
    extends ConnectorDataTypeConverter {
        Map<Long, ConnectorDataTypeConverter> map;
        int targetType;

        @Override
        public Object convert(Object object) {
            int sourceType = ConnectorSchemaUtils.getGenericObjectType(object);
            if (sourceType == 1884) {
                sourceType = 12;
            }
            long mapKey = ConnectorSchemaUtils.genConnectorMapKey(sourceType, this.targetType);
            ConnectorDataTypeConverter c = this.map.get(mapKey);
            return c.convert(object);
        }

        public ObjectToAnyType(Map<Long, ConnectorDataTypeConverter> map, int targetType) {
            this.map = map;
            this.targetType = targetType;
        }

        @Override
        public void setNullable(boolean nullable) {
            super.setNullable(nullable);
            for (Map.Entry<Long, ConnectorDataTypeConverter> entry : this.map.entrySet()) {
                entry.getValue().setNullable(nullable);
            }
        }
    }
}

