/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.converter;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class ConnectorConverter {
    public abstract void initialize(JobContext var1) throws ConnectorException;

    public abstract Map<Integer, Boolean> initializeNullable() throws ConnectorException;

    public abstract Map<Integer, Object> initializeDefaultValue() throws ConnectorException;

    public abstract Map<Integer, Object> initializeFalseDefaultValue() throws ConnectorException;

    public abstract Map<Integer, Object> initializeTrueDefaultValue() throws ConnectorException;

    public abstract ConnectorRecord convert(ConnectorRecord var1) throws ConnectorException;

    public int[] initializeScale() throws ConnectorException {
        return null;
    }

    public int[] initializePrecision() throws ConnectorException {
        return null;
    }

    public int[] initializeLength() throws ConnectorException {
        return null;
    }

    public ConnectorDataTypeConverter[] lookupConverter(Configuration configuration, ConnectorRecordSchema sourceRecordSchema) throws ConnectorException {
        int[] scales = this.initializeScale();
        int[] precisions = this.initializePrecision();
        int[] lengths = this.initializeLength();
        Map<Integer, Object> defaultVal = this.initializeDefaultValue();
        Map<Integer, Boolean> nullable = this.initializeNullable();
        Map<Integer, Object> falseDefVal = this.initializeFalseDefaultValue();
        Map<Integer, Object> trueDefVal = this.initializeTrueDefaultValue();
        ConnectorRecordSchema targetRecordSchema = null;
        targetRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration));
        int columnCount = targetRecordSchema.getLength();
        ConnectorDataTypeConverter[] dataTypeConverters = new ConnectorDataTypeConverter[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            try {
                int sourceType = sourceRecordSchema == null ? 12 : sourceRecordSchema.getFieldType(i);
                int targetType = targetRecordSchema.getFieldType(i);
                if (sourceType == 1883) {
                    dataTypeConverters[i] = ConnectorSchemaUtils.lookupUDF(sourceRecordSchema, i);
                    if (dataTypeConverters[i] != null) continue;
                    throw new ConnectorException(11001);
                }
                dataTypeConverters[i] = this.lookupDataTypeConverter(sourceType, targetType, scales == null ? 6 : scales[i], precisions == null ? 6 : precisions[i], lengths == null ? Integer.MAX_VALUE : lengths[i], defaultVal, falseDefVal, trueDefVal, configuration);
                boolean nul = nullable.get(i);
                dataTypeConverters[i].setNullable(nul);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        return dataTypeConverters;
    }

    public ConnectorDataTypeConverter lookupDataTypeConverter(int sourceType, int targetType, int targetScale, int targetPrecision, int targetLength, Map<Integer, Object> defaultVal, Map<Integer, Object> falseDefVal, Map<Integer, Object> trueDefVal, Configuration configuration) throws ConnectorException {
        if (targetType == 1882) {
            ConnectorDataTypeConverter.Others converter = new ConnectorDataTypeConverter.Others();
            return converter;
        }
        ConnectorDataTypeConverter converter = new ConnectorDataTypeConverter.ObjectToString();
        String inputDateFormat = ConnectorConfiguration.getInputDateFormat(configuration);
        String outputDateFormat = ConnectorConfiguration.getOutputDateFormat(configuration);
        String inputTimezoneId = ConnectorConfiguration.getInputTimezoneId(configuration);
        String outputTimezoneId = ConnectorConfiguration.getOutputTimezoneId(configuration);
        String inputTimeFormat = ConnectorConfiguration.getInputTimeFormat(configuration);
        String outputTimeFormat = ConnectorConfiguration.getOutputTimeFormat(configuration);
        String inputTimestampFormat = ConnectorConfiguration.getInputTimestampFormat(configuration);
        String outputTimestampFormat = ConnectorConfiguration.getOutputTimestampFormat(configuration);
        block0 : switch (sourceType) {
            case 4: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.IntegerToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.IntegerToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.IntegerToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.IntegerToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.IntegerToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.IntegerToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.IntegerToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.IntegerToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.IntegerToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.IntegerToTimestampTZ(outputTimezoneId);
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.IntegerToTimeTZ(outputTimezoneId);
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.IntegerToDateTZ(outputTimezoneId);
                        break block0;
                    }
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.IntegerToCalendar(outputTimezoneId);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.IntegerToBoolean();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.IntegerToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case -5: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.LongToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.LongToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.LongToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.LongToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.LongToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.LongToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.LongToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.LongToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.LongToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.LongToBoolean();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.LongToString();
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.LongToTimestampTZ(outputTimezoneId);
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.LongToTimeTZ(outputTimezoneId);
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.LongToDateTZ(outputTimezoneId);
                        break block0;
                    }
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.LongToCalendar(outputTimezoneId);
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 5: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.ShortToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.ShortToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.ShortToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.ShortToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.ShortToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.ShortToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.ShortToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.ShortToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.ShortToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.ShortToBoolean();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.ShortToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case -6: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.TinyIntToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.TinyIntToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.TinyIntToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.TinyIntToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.TinyIntToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.TinyIntToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBoolean();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TinyIntToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 16: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.BooleanToInteger();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToInteger)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.BooleanToLong();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToLong)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.BooleanToShort();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToShort)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.BooleanToTinyInt();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToTinyInt)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.BooleanToFloat();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToFloat)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.BooleanToDouble();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToDouble)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.BooleanToBigDecimal();
                        if (falseDefVal == null) break block0;
                        ((ConnectorDataTypeConverter.BooleanToBigDecimal)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.BooleanToBigDecimalWithScale();
                        if (falseDefVal != null) {
                            ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setFalseDefaultValue(falseDefVal.get(targetType));
                        }
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setScale(targetScale);
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setPrecision(targetPrecision);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BooleanToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 6: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.FloatToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.FloatToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.FloatToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.FloatToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.FloatToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.FloatToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.FloatToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.FloatToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.FloatToBigDecimalWithScale)converter).setScale(targetScale);
                        ((ConnectorDataTypeConverter.FloatToBigDecimalWithScale)converter).setPrecision(targetPrecision);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.FloatToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 7: 
            case 8: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.DoubleToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.DoubleToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.DoubleToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.DoubleToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.DoubleToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.DoubleToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.DoubleToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.DoubleToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.DoubleToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.DoubleToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 2: 
            case 3: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToBoolean();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case -1: 
            case 1: 
            case 12: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.StringToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.StringToLong();
                        break block0;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.StringToShort();
                        break block0;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.StringToTinyInt();
                        break block0;
                    }
                    case 6: {
                        converter = new ConnectorDataTypeConverter.StringToFloat();
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.StringToDouble();
                        break block0;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.StringToBigDecimal();
                        break block0;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.StringToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.StringToBigDecimalWithScale)converter).setScale(targetScale);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.StringToString(ConnectorConfiguration.getStringTruncate(configuration), targetLength);
                        break block0;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.StringToBoolean();
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.StringFMTTZToDateTZ(inputDateFormat, inputTimezoneId, outputTimezoneId).setupBackupDateFormat(configuration);
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.StringFMTTZToTimeTZ(inputTimeFormat, inputTimezoneId, outputTimezoneId).setupBackupDateFormat(configuration);
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.StringFMTTZToTimestampTZ(inputTimestampFormat, inputTimezoneId, outputTimezoneId).setupBackupDateFormat(configuration);
                        break block0;
                    }
                    case 2002: {
                        converter = new ConnectorDataTypeConverter.StringToPeriod();
                        break block0;
                    }
                    case 1111: {
                        converter = new ConnectorDataTypeConverter.StringToInterval();
                        break block0;
                    }
                    case -3: 
                    case -2: {
                        converter = new ConnectorDataTypeConverter.StringToBytes();
                        break block0;
                    }
                    case 2004: {
                        converter = new ConnectorDataTypeConverter.StringToBinary();
                        break block0;
                    }
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.StringFMTTZToCalendarTimestamp(inputTimestampFormat, inputTimezoneId, outputTimezoneId).setupBackupDateFormat(configuration, "tdch.input.timestamp.format");
                        break block0;
                    }
                    case 1885: {
                        converter = new ConnectorDataTypeConverter.StringFMTTZToCalendarTime(inputTimeFormat, inputTimezoneId, outputTimezoneId).setupBackupDateFormat(configuration, "tdch.input.time.format");
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 91: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.DateTZToInteger(inputTimezoneId);
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.DateTZToLong(inputTimezoneId);
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.DateToDate();
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.DateTZToTimestampTZ(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.DateToStringFMT(outputDateFormat);
                        break block0;
                    }
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.DateToCalendar(outputTimezoneId);
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 92: {
                switch (targetType) {
                    case 93: {
                        converter = new ConnectorDataTypeConverter.TimeToTimestamp();
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.TimeTZToTimeTZ(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case 4: {
                        converter = new ConnectorDataTypeConverter.TimeTZToInteger(inputTimezoneId);
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.TimeTZToLong(inputTimezoneId);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TimeTZToStringFMTTZ(outputTimeFormat, inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.TimeTZToCalendar(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 93: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToInteger(inputTimezoneId);
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToLong(inputTimezoneId);
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToDateTZ(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToTimeTZ(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToTimestampTZ(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToStringFMTTZ(inputTimezoneId, outputTimezoneId, outputTimestampFormat);
                        break block0;
                    }
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.TimestampTZToCalendar(inputTimezoneId, outputTimezoneId);
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 2005: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.ClobToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 2004: {
                switch (targetType) {
                    case -2: {
                        converter = new ConnectorDataTypeConverter.BlobToBinary();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2004: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BlobToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case -3: 
            case -2: {
                switch (targetType) {
                    case -3: 
                    case -2: 
                    case 2004: {
                        converter = new ConnectorDataTypeConverter.BinaryToBinary();
                        break block0;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BytesToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 2002: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2002: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.PeriodToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 1111: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 1111: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.IntervalToString();
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 1885: 
            case 1886: {
                switch (targetType) {
                    case 1885: 
                    case 1886: {
                        converter = new ConnectorDataTypeConverter.CalendarToCalendar(outputTimezoneId);
                        break block0;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.CalendarToTimeTZ(outputTimezoneId);
                        break block0;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.CalendarToTimestampTZ(outputTimezoneId);
                        break block0;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.CalendarToDateTZ(outputTimezoneId);
                        break block0;
                    }
                    case 4: {
                        converter = new ConnectorDataTypeConverter.CalendarToInteger();
                        break block0;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.CalendarToLong();
                        break block0;
                    }
                    case 1: 
                    case 12: 
                    case 2005: {
                        if (sourceType == 1886) {
                            converter = new ConnectorDataTypeConverter.CalendarToStringFMTTZ(outputTimezoneId, outputTimestampFormat);
                            break block0;
                        }
                        converter = new ConnectorDataTypeConverter.CalendarToStringFMTTZ(outputTimezoneId, outputTimeFormat);
                        break block0;
                    }
                }
                throw new ConnectorException(14007, sourceType + " to " + targetType);
            }
            case 1882: {
                Map<Long, ConnectorDataTypeConverter> map = ConnectorSchemaUtils.constructConvertMap(this, configuration, targetScale, targetPrecision, targetLength);
                converter = new ConnectorDataTypeConverter.ObjectToAnyType(map, targetType);
                break;
            }
        }
        if (sourceType != 16) {
            if (defaultVal != null) {
                converter.setDefaultValue(defaultVal.get(targetType));
            }
        } else if (trueDefVal != null) {
            converter.setDefaultValue(trueDefVal.get(targetType));
        }
        return converter;
    }

    public abstract void lookupConverter(ConnectorRecordSchema var1) throws ConnectorException;
}

