/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorPlugin;
import com.teradata.connector.common.exception.ConnectorException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class ConnectorPluginTest {
    @Test
    public void testLoadConnectorPluginFromConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set("tdch.job.plugin.configuration.file", "file.conf");
        try {
            ConnectorPlugin.loadConnectorPluginFromConf(conf);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("file does not exist :file.conf"));
        }
    }

    @Test
    public void testGetConnectorSourcePlugin() throws Exception {
        try {
            ConnectorPlugin.getConnectorSourcePlugin("unknown");
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("plugin \"unknown\" not found"));
        }
        Assert.assertTrue((boolean)(ConnectorPlugin.getConnectorSourcePlugin("teradata-split.by.amp") instanceof ConnectorPlugin));
    }

    @Test
    public void testGetConnectorTargetPlugin() throws Exception {
        try {
            ConnectorPlugin.getConnectorTargetPlugin("unknown");
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("plugin \"unknown\" not found"));
        }
        Assert.assertTrue((boolean)(ConnectorPlugin.getConnectorTargetPlugin("hive-orcfile") instanceof ConnectorPlugin));
    }

    @Test
    public void testValidate() throws Exception {
        ConnectorPlugin.ConnectorSourcePlugin csp = new ConnectorPlugin.ConnectorSourcePlugin();
        csp.setInputFormatClass(null);
        csp.setConfigurationClass(null);
        csp.setSerDeClass(null);
        csp.setInputProcessor(null);
        try {
            csp.validate();
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("bad configuration"));
        }
        ConnectorPlugin.ConnectorTargetPlugin ctp = new ConnectorPlugin.ConnectorTargetPlugin();
        ctp.setOutputFormatClass(null);
        ctp.setConfigurationClass(null);
        ctp.setOutputProcessor(null);
        try {
            ctp.validate();
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("bad configuration"));
        }
    }

    @Test
    public void testToString() throws Exception {
        ConnectorPlugin.ConnectorSourcePlugin csp = new ConnectorPlugin.ConnectorSourcePlugin();
        ConnectorPlugin.ConnectorTargetPlugin ctp = new ConnectorPlugin.ConnectorTargetPlugin();
        csp.setInputFormatClass("Input");
        ctp.setOutputFormatClass("Output");
        Assert.assertTrue((boolean)csp.toString().contains("inputFormatClass: Input"));
        Assert.assertTrue((boolean)ctp.toString().contains("outputFormatClass: Output"));
    }
}

