/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ConnectorCombineInputFormat<K, V>
extends InputFormat<K, V> {
    InputFormat<K, Writable> plugedInInputFormat = null;

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        try {
            if (!FileInputFormat.class.isAssignableFrom(Class.forName(ConnectorConfiguration.getPlugInInputFormat(job.getConfiguration())))) {
                return this.getNoneFileSplit(job);
            }
        }
        catch (Exception e1) {
            throw new ConnectorException(e1.getMessage(), e1);
        }
        return new ConnectorCombineFileInputFormat().getSplits(job);
    }

    private List<InputSplit> getNoneFileSplit(JobContext job) throws IOException, InterruptedException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Configuration configuration = job.getConfiguration();
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        if (this.plugedInInputFormat == null) {
            this.configurePlugedInInuputFormat(job);
        }
        List inputSplits = this.plugedInInputFormat.getSplits(job);
        ArrayList<InputSplit> combinedSplits = new ArrayList<InputSplit>();
        String inputSplitClass = ConnectorConfiguration.getInputSplit(configuration);
        if (numMappers >= inputSplits.size()) {
            for (InputSplit split : inputSplits) {
                InputSplit[] splits = new InputSplit[]{split};
                combinedSplits.add(new ConnectorCombineSplit(splits, inputSplitClass));
            }
        } else {
            int i;
            ArrayList packageSplits = new ArrayList();
            for (int i2 = 0; i2 < numMappers; ++i2) {
                packageSplits.add(new ArrayList());
            }
            boolean odd = true;
            int lastRound = 0;
            for (i = 0; i < inputSplits.size(); ++i) {
                int lane = i % numMappers;
                int round = i / numMappers;
                if (round != lastRound) {
                    boolean bl = odd = !odd;
                }
                if (odd) {
                    ((List)packageSplits.get(lane)).add((InputSplit)inputSplits.get(i));
                } else {
                    ((List)packageSplits.get(numMappers - 1 - lane)).add((InputSplit)inputSplits.get(i));
                }
                lastRound = round;
            }
            for (i = 0; i < numMappers; ++i) {
                ConnectorCombineSplit combineSplit = new ConnectorCombineSplit(((List)packageSplits.get(i)).toArray(new InputSplit[0]), inputSplitClass);
                combinedSplits.add(combineSplit);
            }
        }
        return combinedSplits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (split instanceof CombineFileSplit) {
            return new ConnectorCombineFileRecordReader((CombineFileSplit)split, context);
        }
        return new ConnectorCombinePlugedinInputRecordReader((ConnectorCombineSplit)split, context);
    }

    protected void configurePlugedInInuputFormat(JobContext context) {
        Configuration configuration = context.getConfiguration();
        try {
            this.plugedInInputFormat = (InputFormat)Class.forName(ConnectorConfiguration.getPlugInInputFormat(configuration)).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private class ConnectorCombinePlugedinInputRecordReader
    extends RecordReader<K, V> {
        private Log logger = LogFactory.getLog(ConnectorCombinePlugedinInputRecordReader.class);
        protected ConnectorCombineSplit split;
        protected TaskAttemptContext context;
        protected int index;
        protected long progress;
        protected RecordReader<K, V> currentPlugedInRecordReader;
        protected ConnectorSerDe sourceSerDe;
        private long end_timestamp = 0L;
        private long start_timestamp = System.currentTimeMillis();

        public ConnectorCombinePlugedinInputRecordReader(ConnectorCombineSplit split, TaskAttemptContext context) throws IOException {
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
            this.split = split;
            this.context = context;
            this.index = 0;
            this.currentPlugedInRecordReader = null;
            this.progress = 0L;
            try {
                this.initNextRecordReader();
            }
            catch (InterruptedException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            InputSplit inputSplit = ((ConnectorCombineSplit)split).getInputSplits()[this.index];
            this.currentPlugedInRecordReader.initialize(inputSplit, context);
            ++this.index;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            while (this.currentPlugedInRecordReader == null || !this.currentPlugedInRecordReader.nextKeyValue()) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentPlugedInRecordReader.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.sourceSerDe.deserialize((Writable)this.currentPlugedInRecordReader.getCurrentValue());
        }

        public void close() throws IOException {
            if (this.currentPlugedInRecordReader != null) {
                this.currentPlugedInRecordReader.close();
                this.currentPlugedInRecordReader = null;
            }
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
            this.logger.info((Object)("the total elapsed time of recordreader " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
        }

        public float getProgress() throws IOException, InterruptedException {
            long currentProgress = 0L;
            if (this.currentPlugedInRecordReader != null) {
                long currentLen = this.split.getInputSplits()[this.index - 1].getLength();
                currentProgress = (long)(this.currentPlugedInRecordReader.getProgress() * (float)currentLen);
            }
            long length = this.split.getLength();
            return Math.min(1.0f, (float)(this.progress + currentProgress) / (float)length);
        }

        protected boolean initNextRecordReader() throws IOException, InterruptedException {
            if (this.currentPlugedInRecordReader != null) {
                this.currentPlugedInRecordReader.close();
                this.currentPlugedInRecordReader = null;
                if (this.index > 0 && this.index < this.split.getInputSplits().length) {
                    this.progress += this.split.getInputSplits()[this.index].getLength();
                }
            }
            if (this.split.getInputSplits().length == this.index) {
                return false;
            }
            try {
                Configuration configuration = this.context.getConfiguration();
                if (ConnectorCombineInputFormat.this.plugedInInputFormat == null) {
                    ConnectorCombineInputFormat.this.configurePlugedInInuputFormat((JobContext)this.context);
                }
                this.sourceSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getInputSerDe(configuration)).newInstance();
                this.sourceSerDe.initialize((JobContext)this.context, ConnectorConfiguration.direction.input);
                InputSplit connectorSplit = this.split.getInputSplits()[this.index];
                this.currentPlugedInRecordReader = ConnectorCombineInputFormat.this.plugedInInputFormat.createRecordReader(connectorSplit, this.context);
                if (this.index > 0) {
                    this.currentPlugedInRecordReader.initialize(connectorSplit, this.context);
                    ++this.index;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    private class ConnectorCombineFileRecordReader
    extends RecordReader<K, V> {
        private Log logger = LogFactory.getLog(ConnectorCombineFileRecordReader.class);
        protected CombineFileSplit split;
        protected TaskAttemptContext context;
        protected int index;
        protected long progress;
        protected RecordReader<K, V> currentPlugedInRecordReader;
        protected ConnectorSerDe sourceSerDe;
        private long end_timestamp = 0L;
        private long start_timestamp = System.currentTimeMillis();

        public ConnectorCombineFileRecordReader(CombineFileSplit split, TaskAttemptContext context) throws IOException {
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
            this.split = split;
            this.context = context;
            this.index = 0;
            this.currentPlugedInRecordReader = null;
            this.progress = 0L;
            this.initNextRecordReader();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            FileSplit fileSplit = new FileSplit(((CombineFileSplit)split).getPath(this.index), ((CombineFileSplit)split).getOffset(this.index), ((CombineFileSplit)split).getLength(this.index), split.getLocations());
            this.currentPlugedInRecordReader.initialize((InputSplit)fileSplit, context);
            ++this.index;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            while (this.currentPlugedInRecordReader == null || !this.currentPlugedInRecordReader.nextKeyValue()) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentPlugedInRecordReader.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.sourceSerDe.deserialize((Writable)this.currentPlugedInRecordReader.getCurrentValue());
        }

        public void close() throws IOException {
            if (this.currentPlugedInRecordReader != null) {
                this.currentPlugedInRecordReader.close();
                this.currentPlugedInRecordReader = null;
            }
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
            this.logger.info((Object)("the total elapsed time of recordreader " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
        }

        public float getProgress() throws IOException, InterruptedException {
            long currentProgress = 0L;
            if (this.currentPlugedInRecordReader != null) {
                currentProgress = (long)(this.currentPlugedInRecordReader.getProgress() * (float)this.split.getLength(this.index - 1));
            }
            long length = this.split.getLength();
            return Math.min(1.0f, (float)(this.progress + currentProgress) / (float)length);
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.currentPlugedInRecordReader != null) {
                this.currentPlugedInRecordReader.close();
                this.currentPlugedInRecordReader = null;
                if (this.index > 0 && this.index < this.split.getNumPaths()) {
                    this.progress += this.split.getLength(this.index);
                }
            }
            if (this.split.getNumPaths() == this.index) {
                return false;
            }
            try {
                Configuration configuration = this.context.getConfiguration();
                configuration.set("map.input.file", this.split.getPath(this.index).toString());
                configuration.setLong("map.input.start", this.split.getOffset(this.index));
                configuration.setLong("map.input.length", this.split.getLength(this.index));
                if (ConnectorCombineInputFormat.this.plugedInInputFormat == null) {
                    ConnectorCombineInputFormat.this.configurePlugedInInuputFormat((JobContext)this.context);
                }
                this.currentPlugedInRecordReader = ConnectorCombineInputFormat.this.plugedInInputFormat.createRecordReader((InputSplit)this.split, this.context);
                this.sourceSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getInputSerDe(configuration)).newInstance();
                this.sourceSerDe.initialize((JobContext)this.context, ConnectorConfiguration.direction.input);
                if (this.index > 0) {
                    FileSplit fileSplit = new FileSplit(this.split.getPath(this.index), this.split.getOffset(this.index), this.split.getLength(this.index), this.split.getLocations());
                    this.currentPlugedInRecordReader.initialize((InputSplit)fileSplit, this.context);
                    ++this.index;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    private class ConnectorCombineFileInputFormat
    extends CombineFileInputFormat<K, V> {
        public static final int SPLIT_LOCATIONS_MAX = 6;

        private ConnectorCombineFileInputFormat() {
        }

        public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return null;
        }

        public List<InputSplit> getSplits(JobContext job) throws IOException {
            long numSplits = ConnectorConfiguration.getNumMappers(job.getConfiguration());
            long numFileBytes = 0L;
            long splitSize = 0L;
            if (numSplits != 0L) {
                numFileBytes = this.getJobSize(job);
                splitSize = numFileBytes / numSplits;
                this.setMaxSplitSize(splitSize);
                this.setMinSplitSizeRack(splitSize);
            }
            List splits = super.getSplits(job);
            int splitNumber = splits.size();
            String[] hosts = null;
            for (int i = splitNumber - 1; i >= 0; --i) {
                InputSplit split = (InputSplit)splits.get(i);
                try {
                    String[] locations = split.getLocations();
                    if (locations != null && locations.length != 0) break;
                    if (hosts == null) {
                        hosts = HadoopConfigurationUtils.getAllActiveHosts(job);
                    }
                    CombineFileSplit combineSplit = (CombineFileSplit)split;
                    CombineFileSplit newCombineSplit = new CombineFileSplit(combineSplit.getPaths(), combineSplit.getStartOffsets(), combineSplit.getLengths(), HadoopConfigurationUtils.selectUniqueActiveHosts(hosts, 6));
                    splits.remove(i);
                    splits.add(newCombineSplit);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
            }
            return splits;
        }

        protected long getJobSize(JobContext job) throws IOException {
            List stats = this.listStatus(job);
            long count = 0L;
            for (FileStatus stat : stats) {
                count += stat.getLen();
            }
            return count;
        }
    }

    public static class ConnectorCombineSplit
    extends InputSplit
    implements Writable {
        protected InputSplit[] inputSplits;
        private String[] locations;
        private long totalLength;
        private String inputSplitClassName;

        public ConnectorCombineSplit() {
        }

        public ConnectorCombineSplit(InputSplit[] splits, String inputSplitClassName) {
            this.inputSplits = splits;
            this.inputSplitClassName = inputSplitClassName;
        }

        public String getInputSplitClassName() {
            return this.inputSplitClassName;
        }

        public void setInputSplitClassName(String inputSplitClassName) {
            this.inputSplitClassName = inputSplitClassName;
        }

        public InputSplit[] getInputSplits() {
            return this.inputSplits;
        }

        public void setInputSplits(InputSplit[] inputSplits) {
            this.inputSplits = inputSplits;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.inputSplitClassName);
            out.writeLong(this.totalLength);
            out.writeInt(this.inputSplits.length);
            for (InputSplit split : this.inputSplits) {
                ((Writable)split).write(out);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.inputSplitClassName = in.readUTF();
            this.totalLength = in.readLong();
            int arrLength = in.readInt();
            this.inputSplits = new InputSplit[arrLength];
            for (int i = 0; i < arrLength; ++i) {
                try {
                    this.inputSplits[i] = (InputSplit)Class.forName(this.inputSplitClassName).newInstance();
                }
                catch (Exception e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                ((Writable)this.inputSplits[i]).readFields(in);
            }
        }

        public long getLength() throws IOException, InterruptedException {
            if (this.totalLength == 0L) {
                for (InputSplit split : this.inputSplits) {
                    this.totalLength += split.getLength();
                }
            }
            return this.totalLength;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            if (this.locations == null) {
                HashSet<String> locations = new HashSet<String>();
                for (InputSplit split : this.inputSplits) {
                    locations.addAll(Arrays.asList(split.getLocations()));
                }
                this.locations = locations.toArray(new String[0]);
            }
            return this.locations;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("inputSplitClass:" + this.inputSplitClassName + "\n");
            for (int i = 0; i < this.inputSplits.length; ++i) {
                sb.append("split" + i + ":" + this.inputSplits[i] + "\n");
            }
            return sb.toString();
        }
    }
}

