/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.tool.ui;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.tool.qualification.QualificationSummaryInfo;
import org.apache.spark.sql.rapids.tool.ui.QualificationReportGenerator$;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u0011\"\u0001AB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\")\u0011\f\u0001C\u00015\"9q\f\u0001b\u0001\n\u0007\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0004i\u0001\t\u0007I\u0011A5\t\rI\u0004\u0001\u0015!\u0003k\u0011\u001di\u0007A1A\u0005\u0002MDaA\u001f\u0001!\u0002\u0013!\b\"B>\u0001\t\u0003a\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\u0007\u0003?\u0001A\u0011\u0001?\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!I\u0011q\u0007\u0001\u0012\u0002\u0013%\u0011\u0011\b\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u0019\tI\u0006\u0001C\u0001y\u001e9\u00111L\u0011\t\u0002\u0005ucA\u0002\u0011\"\u0011\u0003\ty\u0006\u0003\u0004Z%\u0011\u0005\u0011\u0011\r\u0005\n\u0003G\u0012\"\u0019!C\u0001\u0003KB\u0001\"!\u001d\u0013A\u0003%\u0011q\r\u0005\n\u0003g\u0012\"\u0019!C\u0001\u0003kBq!a\u001e\u0013A\u0003%a\bC\u0005\u0002zI\u0011\r\u0011\"\u0001\u0002v!9\u00111\u0010\n!\u0002\u0013q\u0004\"CA?%\u0001\u0007I\u0011AA@\u0011%\tYI\u0005a\u0001\n\u0003\ti\t\u0003\u0005\u0002\u0014J\u0001\u000b\u0015BAA\u0011\u001d\t)J\u0005C\u0005\u0003/Cq!!(\u0013\t\u0013\ty\nC\u0004\u0002&J!\t!a*\u00039E+\u0018\r\\5gS\u000e\fG/[8o%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011!eI\u0001\u0003k&T!\u0001J\u0013\u0002\tQ|w\u000e\u001c\u0006\u0003M\u001d\naA]1qS\u0012\u001c(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u00011c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0015\u0002\u0011%tG/\u001a:oC2L!\u0001P\u001d\u0003\u000f1{wmZ5oO\u0006Iq.\u001e;qkR$\u0015N\u001d\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005\u001bT\"\u0001\"\u000b\u0005\r{\u0013A\u0002\u001fs_>$h(\u0003\u0002Fg\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)5'\u0001\u0004tk6\f%O\u001d\t\u0004\u0017B\u001bfB\u0001'O\u001d\t\tU*C\u00015\u0013\ty5'A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&aA*fc*\u0011qj\r\t\u0003)^k\u0011!\u0016\u0006\u0003-\u000e\nQ\"];bY&4\u0017nY1uS>t\u0017B\u0001-V\u0005a\tV/\u00197jM&\u001c\u0017\r^5p]N+X.\\1ss&sgm\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mkf\f\u0005\u0002]\u00015\t\u0011\u0005C\u0003>\u0007\u0001\u0007a\bC\u0003J\u0007\u0001\u0007!*A\u0004g_Jl\u0017\r^:\u0016\u0003\u0005t!AY3\u000e\u0003\rT!\u0001Z\u0017\u0002\r)\u001cxN\u001c\u001bt\u0013\t17-\u0001\bEK\u001a\fW\u000f\u001c;G_Jl\u0017\r^:\u0002\u0011\u0019|'/\\1ug\u0002\nab\\;uaV$xk\u001c:l!\u0006$\b.F\u0001k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0002gg*\u0011qnK\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ed'\u0001\u0002)bi\"\fqb\\;uaV$xk\u001c:l!\u0006$\b\u000eI\u000b\u0002iB\u0019!'^<\n\u0005Y\u001c$\u0001B*p[\u0016\u0004\"a\u001b=\n\u0005ed'A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0019am\u001d\u0011\u0002\r1\fWO\\2i)\u0005i\bC\u0001\u001a\u007f\u0013\ty8G\u0001\u0003V]&$\u0018AG2paf\f5o]3u\r>dG-\u001a:SK\u000e,(o]5wK2LH#B?\u0002\u0006\u0005m\u0001bBA\u0004\u0017\u0001\u0007\u0011\u0011B\u0001\u000egJ\u001cgi\u001c7eKJ\u0004\u0016\r\u001e5\u0011\t\u0005-\u0011\u0011D\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!a-\u001b7f\u0015\u0011\t\u0019\"!\u0006\u0002\u00079LwN\u0003\u0002\u0002\u0018\u0005!!.\u0019<b\u0013\r\t\u0018Q\u0002\u0005\u0007\u0003;Y\u0001\u0019\u00016\u0002\u000f\u0011\u001cH\u000fU1uQ\u0006yq-\u001a8fe\u0006$XMS*GS2,7/\u0001\bxe&$X-\u00119q%\u0016\u001cwN\u001d3\u0015\u000fu\f)#!\u000b\u00024!1\u0011qE\u0007A\u0002M\u000ba!\u00199q%\u0016\u001c\u0007bBA\u0016\u001b\u0001\u0007\u0011QF\u0001\n_V$8\u000b\u001e:fC6\u00042a[A\u0018\u0013\r\t\t\u0004\u001c\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u000265\u0001\n\u00111\u0001?\u0003\r\u0019X\r]\u0001\u0019oJLG/Z!qaJ+7m\u001c:eI\u0011,g-Y;mi\u0012\u001aTCAA\u001eU\rq\u0014QH\u0016\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011J\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001BO]=D_BL\u0018i]:fi\u001aKG.\u001a\u000b\u0006{\u0006M\u0013q\u000b\u0005\b\u0003+z\u0001\u0019AA\u0005\u0003-\u0019(o\u0019$jY\u0016\u0004\u0016\r\u001e5\t\r\u0005uq\u00021\u0001k\u0003\u0015\u0019Gn\\:f\u0003q\tV/\u00197jM&\u001c\u0017\r^5p]J+\u0007o\u001c:u\u000f\u0016tWM]1u_J\u0004\"\u0001\u0018\n\u0014\u0007I\tt\u0007\u0006\u0002\u0002^\u0005!\"+\u0011)J\tN{V+S0B'N+EkU0E\u0013J+\"!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WRA!!\u001c\u0002\u0016\u0005!A.\u00198h\u0013\r9\u00151N\u0001\u0016%\u0006\u0003\u0016\nR*`+&{\u0016iU*F)N{F)\u0013*!\u0003E\u0011\u0016\tU%E'~+\u0016j\u0018&T?\u0012\u000bE+Q\u000b\u0002}\u0005\u0011\"+\u0011)J\tN{V+S0K'~#\u0015\tV!!\u0003Q\u0011\u0016\tU%E'~+\u0016jX%O\t\u0016Cv\fU!U\u0011\u0006)\"+\u0011)J\tN{V+S0J\u001d\u0012+\u0005l\u0018)B)\"\u0003\u0013!\u00026be\u001a\u001bVCAAA!\u0015\u0011\u00141QAD\u0013\r\t)i\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0011\u0011R\u0005\u0004s\u00065\u0011!\u00036be\u001a\u001bv\fJ3r)\ri\u0018q\u0012\u0005\n\u0003#[\u0012\u0011!a\u0001\u0003\u0003\u000b1\u0001\u001f\u00132\u0003\u0019Q\u0017M\u001d$TA\u0005\u0011r-\u001a;QCRDgi\u001c:SKN|WO]2f)\u0011\tI!!'\t\r\u0005mU\u00041\u0001?\u0003!1\u0017\u000e\\3oC6,\u0017\u0001E:fi*\u000b'OR5mKNK8\u000f^3n)\u0011\t9)!)\t\r\u0005\rf\u00041\u0001?\u0003!1\u0017\u000e\\3OC6,\u0017!E4f]\u0016\u0014\u0018\r^3ECND'i\\1sIR)Q0!+\u0002.\"1\u00111V\u0010A\u0002y\naa\\;u\t&\u0014\b\"B% \u0001\u0004Q\u0005")
public class QualificationReportGenerator
implements Logging {
    private final Seq<QualificationSummaryInfo> sumArr;
    private final DefaultFormats$ formats;
    private final Path outputWorkPath;
    private final Some<org.apache.hadoop.fs.FileSystem> fs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void generateDashBoard(String string, Seq<QualificationSummaryInfo> seq) {
        QualificationReportGenerator$.MODULE$.generateDashBoard(string, seq);
    }

    public static void jarFS_$eq(Option<FileSystem> option) {
        QualificationReportGenerator$.MODULE$.jarFS_$eq(option);
    }

    public static Option<FileSystem> jarFS() {
        return QualificationReportGenerator$.MODULE$.jarFS();
    }

    public static String RAPIDS_UI_INDEX_PATH() {
        return QualificationReportGenerator$.MODULE$.RAPIDS_UI_INDEX_PATH();
    }

    public static String RAPIDS_UI_JS_DATA() {
        return QualificationReportGenerator$.MODULE$.RAPIDS_UI_JS_DATA();
    }

    public static String RAPIDS_UI_ASSETS_DIR() {
        return QualificationReportGenerator$.MODULE$.RAPIDS_UI_ASSETS_DIR();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public Path outputWorkPath() {
        return this.outputWorkPath;
    }

    public Some<org.apache.hadoop.fs.FileSystem> fs() {
        return this.fs;
    }

    public void launch() {
        java.nio.file.Path uiRootPath = QualificationReportGenerator$.MODULE$.org$apache$spark$sql$rapids$tool$ui$QualificationReportGenerator$$getPathForResource(QualificationReportGenerator$.MODULE$.RAPIDS_UI_ASSETS_DIR());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Generating UI files into... ").append(this.outputWorkPath().toUri()).toString());
        this.copyAssetFolderRecursively(uiRootPath, this.outputWorkPath());
    }

    public void copyAssetFolderRecursively(java.nio.file.Path srcFolderPath, Path dstPath) {
        block0: {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("UI code generator: Copying ... ").append(srcFolderPath.toUri()).toString());
            if (!Files.isDirectory(srcFolderPath, new LinkOption[0])) break block0;
            Path destinationPath = new Path(dstPath, ((Object)srcFolderPath.getFileName()).toString());
            this.fs().map((Function1 & Serializable & scala.Serializable)dstFileSys -> {
                QualificationReportGenerator.$anonfun$copyAssetFolderRecursively$2(this, destinationPath, srcFolderPath, dstFileSys);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void generateJSFiles() {
        Path outputPath = new Path(this.outputWorkPath(), QualificationReportGenerator$.MODULE$.RAPIDS_UI_JS_DATA());
        Path mainIndexPath = new Path(this.outputWorkPath(), QualificationReportGenerator$.MODULE$.RAPIDS_UI_INDEX_PATH());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Generating UI data in ").append(mainIndexPath.toUri()).toString());
        String fileHeader = new StringOps(Predef$.MODULE$.augmentString("\n        |let qualificationRecords = [\n       ")).stripMargin();
        String fileFooter = new StringOps(Predef$.MODULE$.augmentString("|];\n       ")).stripMargin();
        this.fs().foreach((Function1 & Serializable & scala.Serializable)dfs -> {
            QualificationReportGenerator.$anonfun$generateJSFiles$2(this, outputPath, fileHeader, fileFooter, dfs);
            return BoxedUnit.UNIT;
        });
    }

    private void writeAppRecord(QualificationSummaryInfo appRec, FSDataOutputStream outStream, String sep) {
        String sumRec = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(10).append("|\t").append(Serialization$.MODULE$.write((Object)appRec, (Formats)this.formats())).append(sep).append("\n       ").toString())).stripMargin();
        outStream.writeBytes(sumRec);
    }

    private String writeAppRecord$default$3() {
        return ",";
    }

    public void tryCopyAssetFile(java.nio.file.Path srcFilePath, Path dstPath) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Copying UI assets: ").append(srcFilePath.toUri().toString()).append(" to ").append(dstPath.toUri().toString()).toString());
        this.fs().foreach((Function1 & Serializable & scala.Serializable)dstFileSys -> {
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(srcFilePath$1, new OpenOption[0]), (Function1 & Serializable & scala.Serializable)in -> {
                QualificationReportGenerator.$anonfun$tryCopyAssetFile$4(dstFileSys, dstPath$1, in);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void close() {
        QualificationReportGenerator$.MODULE$.jarFS().foreach((Function1 & Serializable & scala.Serializable)jFS -> {
            jFS.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$copyAssetFolderRecursively$2(QualificationReportGenerator $this, Path destinationPath$1, java.nio.file.Path srcFolderPath$1, org.apache.hadoop.fs.FileSystem dstFileSys) {
        dstFileSys.mkdirs(destinationPath$1);
        Files.list(srcFolderPath$1).forEach(childPath -> {
            if (Files.isDirectory(childPath, new LinkOption[0])) {
                $this.copyAssetFolderRecursively((java.nio.file.Path)childPath, destinationPath$1);
            } else {
                $this.tryCopyAssetFile((java.nio.file.Path)childPath, new Path(destinationPath$1, ((Object)childPath.getFileName()).toString()));
            }
        });
    }

    public static final /* synthetic */ void $anonfun$generateJSFiles$2(QualificationReportGenerator $this, Path outputPath$1, String fileHeader$1, String fileFooter$1, org.apache.hadoop.fs.FileSystem dfs) {
        FSDataOutputStream outFile = dfs.create(outputPath$1);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            outFile.writeBytes(fileHeader$1);
            if ($this.sumArr.nonEmpty()) {
                if ($this.sumArr.size() > 1) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.sumArr.size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ind -> $this.writeAppRecord((QualificationSummaryInfo)$this.sumArr.apply(ind), outFile, $this.writeAppRecord$default$3()));
                }
                $this.writeAppRecord((QualificationSummaryInfo)$this.sumArr.last(), outFile, "");
            }
            outFile.writeBytes(fileFooter$1);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            outFile.flush();
            outFile.close();
        });
    }

    public static final /* synthetic */ void $anonfun$tryCopyAssetFile$4(org.apache.hadoop.fs.FileSystem dstFileSys$1, Path dstPath$1, InputStream in) {
        FSDataOutputStream out = dstFileSys$1.create(dstPath$1);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] buffer = new byte[133120];
            package$.MODULE$.Iterator().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> in.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bCount -> out.write(buffer, 0, bCount));
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            out.flush();
            out.close();
        });
    }

    public QualificationReportGenerator(String outputDir, Seq<QualificationSummaryInfo> sumArr) {
        this.sumArr = sumArr;
        Logging.$init$((Logging)this);
        this.formats = DefaultFormats$.MODULE$;
        this.outputWorkPath = new Path(outputDir);
        this.fs = new Some((Object)org.apache.hadoop.fs.FileSystem.get((URI)this.outputWorkPath().toUri(), (Configuration)new Configuration()));
    }
}

