/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.tool.qualification;

import com.nvidia.spark.rapids.tool.profiling.ProfileUtils$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLAdaptiveExecutionUpdate;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.rapids.tool.EventProcessorBase;
import org.apache.spark.sql.rapids.tool.GpuEventLogException;
import org.apache.spark.sql.rapids.tool.ToolUtils$;
import org.apache.spark.sql.rapids.tool.qualification.QualApplicationInfo;
import org.apache.spark.sql.rapids.tool.qualification.QualSQLExecutionInfo;
import org.apache.spark.sql.rapids.tool.qualification.QualificationAppInfo;
import org.apache.spark.sql.rapids.tool.qualification.StageTaskQualificationSummary;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0004\b\u0001;!Aa\u0005\u0001B\u0001B\u0003%!\u0005C\u0003(\u0001\u0011\u0005\u0001&\u0002\u0003,\u0001\u0001\u0011\u0003\"\u0002\u0017\u0001\t\u0003j\u0003\"B\u001f\u0001\t\u0003r\u0004\"\u0002#\u0001\t\u0003*\u0005\"B&\u0001\t\u0003b\u0005\"B,\u0001\t\u0003B\u0006\"\u00020\u0001\t\u0003z\u0006\"B3\u0001\t\u00032\u0007\"\u00027\u0001\t\u0003j\u0007\"B:\u0001\t\u0003\"(aG)vC2Lg-[2bi&|g.\u0012<f]R\u0004&o\\2fgN|'O\u0003\u0002\u0010!\u0005i\u0011/^1mS\u001aL7-\u0019;j_:T!!\u0005\n\u0002\tQ|w\u000e\u001c\u0006\u0003'Q\taA]1qS\u0012\u001c(BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011C\u0001\u0001\u001f!\ry\u0002EI\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\u0013\u000bZ,g\u000e\u001e)s_\u000e,7o]8s\u0005\u0006\u001cX\r\u0005\u0002$I5\ta\"\u0003\u0002&\u001d\t!\u0012+^1mS\u001aL7-\u0019;j_:\f\u0005\u000f]%oM>\f1!\u00199q\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003G\u0001AQA\n\u0002A\u0002\t\u0012\u0011\u0001V\u0001!I>\u001c\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016sg/\u001b:p]6,g\u000e^+qI\u0006$X\rF\u0002/iU\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012A!\u00168ji\")a\u0005\u0002a\u0001E!)a\u0007\u0002a\u0001o\u0005)QM^3oiB\u0011\u0001hO\u0007\u0002s)\u0011!HF\u0001\ng\u000eDW\rZ;mKJL!\u0001P\u001d\u0003=M\u0003\u0018M]6MSN$XM\\3s\u000b:4\u0018N]8o[\u0016tG/\u00169eCR,\u0017a\b3p'B\f'o\u001b'jgR,g.\u001a:BaBd\u0017nY1uS>t7\u000b^1siR\u0019af\u0010!\t\u000b\u0019*\u0001\u0019\u0001\u0012\t\u000bY*\u0001\u0019A!\u0011\u0005a\u0012\u0015BA\":\u0005u\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0006\u0003\b\u000f\\5dCRLwN\\*uCJ$\u0018A\u00063p'B\f'o\u001b'jgR,g.\u001a:UCN\\WI\u001c3\u0015\u000792u\tC\u0003'\r\u0001\u0007!\u0005C\u00037\r\u0001\u0007\u0001\n\u0005\u00029\u0013&\u0011!*\u000f\u0002\u0015'B\f'o\u001b'jgR,g.\u001a:UCN\\WI\u001c3\u0002A\u0011|7\u000b]1sW2K7\u000f^3oKJ\u001c\u0016\u000bT#yK\u000e,H/[8o'R\f'\u000f\u001e\u000b\u0004]5s\u0005\"\u0002\u0014\b\u0001\u0004\u0011\u0003\"\u0002\u001c\b\u0001\u0004y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\t)\u0018N\u0003\u0002U)\u0005IQ\r_3dkRLwN\\\u0005\u0003-F\u0013ad\u00159be.d\u0015n\u001d;f]\u0016\u00148+\u0015'Fq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0002=\u0011|7\u000b]1sW2K7\u000f^3oKJ\u001c\u0016\u000bT#yK\u000e,H/[8o\u000b:$Gc\u0001\u0018Z5\")a\u0005\u0003a\u0001E!)a\u0007\u0003a\u00017B\u0011\u0001\u000bX\u0005\u0003;F\u0013Ad\u00159be.d\u0015n\u001d;f]\u0016\u00148+\u0015'Fq\u0016\u001cW\u000f^5p]\u0016sG-A\fe_N\u0003\u0018M]6MSN$XM\\3s\u0015>\u00147\u000b^1siR\u0019a\u0006Y1\t\u000b\u0019J\u0001\u0019\u0001\u0012\t\u000bYJ\u0001\u0019\u00012\u0011\u0005a\u001a\u0017B\u00013:\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beR\fQ\u0003Z8Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d&pE\u0016sG\rF\u0002/O\"DQA\n\u0006A\u0002\tBQA\u000e\u0006A\u0002%\u0004\"\u0001\u000f6\n\u0005-L$aE*qCJ\\G*[:uK:,'OS8c\u000b:$\u0017!\b3p'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmQ8na2,G/\u001a3\u0015\u00079rw\u000eC\u0003'\u0017\u0001\u0007!\u0005C\u00037\u0017\u0001\u0007\u0001\u000f\u0005\u00029c&\u0011!/\u000f\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmQ8na2,G/\u001a3\u0002S\u0011|7\u000b]1sW2K7\u000f^3oKJ\u001c\u0016\u000bT!eCB$\u0018N^3Fq\u0016\u001cW\u000f^5p]V\u0003H-\u0019;f)\rqSO\u001e\u0005\u0006M1\u0001\rA\t\u0005\u0006m1\u0001\ra\u001e\t\u0003!bL!!_)\u0003OM\u0003\u0018M]6MSN$XM\\3s'Fc\u0015\tZ1qi&4X-\u0012=fGV$\u0018n\u001c8Va\u0012\fG/\u001a")
public class QualificationEventProcessor
extends EventProcessorBase<QualificationAppInfo> {
    @Override
    public void doSparkListenerEnvironmentUpdate(QualificationAppInfo app, SparkListenerEnvironmentUpdate event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        Map sparkProperties = ((TraversableOnce)event.environmentDetails().apply((Object)"Spark Properties")).toMap(Predef$.MODULE$.$conforms());
        if (ToolUtils$.MODULE$.isPluginEnabled((Map<String, String>)sparkProperties)) {
            throw new GpuEventLogException("Eventlog is from GPU run. Skipping ...");
        }
    }

    @Override
    public void doSparkListenerApplicationStart(QualificationAppInfo app, SparkListenerApplicationStart event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        QualApplicationInfo thisAppInfo = new QualApplicationInfo(event.appName(), (Option<String>)event.appId(), event.time(), event.sparkUser(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
        app.appInfo_$eq((Option<QualApplicationInfo>)new Some((Object)thisAppInfo));
        app.appId_$eq((String)event.appId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    @Override
    public void doSparkListenerTaskEnd(QualificationAppInfo app, SparkListenerTaskEnd event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        super.doSparkListenerTaskEnd(app, event);
        StageTaskQualificationSummary taskSum = (StageTaskQualificationSummary)app.stageIdToTaskEndSum().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)event.stageId()), (Function0 & Serializable & scala.Serializable)() -> new StageTaskQualificationSummary(event.stageId(), event.stageAttemptId(), 0L, 0L, 0L));
        taskSum.executorRunTime_$eq(taskSum.executorRunTime() + event.taskMetrics().executorRunTime());
        taskSum.executorCPUTime_$eq(taskSum.executorCPUTime() + TimeUnit.NANOSECONDS.toMillis(event.taskMetrics().executorCpuTime()));
        taskSum.totalTaskDuration_$eq(taskSum.totalTaskDuration() + event.taskInfo().duration());
        app.stageIdToSqlID().get((Object)BoxesRunTime.boxToInteger((int)event.stageId())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)sqlID -> {
            StageTaskQualificationSummary taskSum = (StageTaskQualificationSummary)app.sqlIDToTaskEndSum().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)sqlID), (Function0 & Serializable & scala.Serializable)() -> new StageTaskQualificationSummary(event.stageId(), event.stageAttemptId(), 0L, 0L, 0L));
            taskSum.executorRunTime_$eq(taskSum.executorRunTime() + event.taskMetrics().executorRunTime());
            taskSum.executorCPUTime_$eq(taskSum.executorCPUTime() + TimeUnit.NANOSECONDS.toMillis(event.taskMetrics().executorCpuTime()));
            taskSum.totalTaskDuration_$eq(taskSum.totalTaskDuration() + event.taskInfo().duration());
        });
    }

    @Override
    public void doSparkListenerSQLExecutionStart(QualificationAppInfo app, SparkListenerSQLExecutionStart event) {
        super.doSparkListenerSQLExecutionStart(app, event);
        QualSQLExecutionInfo sqlExecution = new QualSQLExecutionInfo(event.executionId(), event.time(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, "", (Option<Object>)None$.MODULE$, false, "");
        app.sqlStart().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)event.executionId())), (Object)sqlExecution));
        app.processSQLPlan(event.executionId(), event.sparkPlanInfo());
        app.sqlPlans().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)event.executionId())), (Object)event.sparkPlanInfo()));
    }

    @Override
    public void doSparkListenerSQLExecutionEnd(QualificationAppInfo app, SparkListenerSQLExecutionEnd event) {
        block0: {
            super.doSparkListenerSQLExecutionEnd(app, event);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
            app.lastSQLEndTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)event.time())));
            Option failures = app.sqlIDtoFailures().get((Object)BoxesRunTime.boxToLong((long)event.executionId()));
            if (!event.executionFailure().isDefined() && !failures.isDefined()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("SQL execution id ").append(event.executionId()).append(" had failures, skipping").toString());
            app.sqlIDToTaskEndSum().get((Object)BoxesRunTime.boxToLong((long)event.executionId())).foreach((Function1 & Serializable & scala.Serializable)sum -> {
                QualificationEventProcessor.$anonfun$doSparkListenerSQLExecutionEnd$3(sum);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void doSparkListenerJobStart(QualificationAppInfo app, SparkListenerJobStart event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        super.doSparkListenerJobStart(app, event);
        String sqlIDString = event.properties().getProperty("spark.sql.execution.id");
        ProfileUtils$.MODULE$.stringToLong(sqlIDString).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)sqlID -> event.stageIds().foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)stageId -> BoxesRunTime.unboxToLong((Object)app.stageIdToSqlID().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)stageId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sqlID))));
    }

    @Override
    public void doSparkListenerJobEnd(QualificationAppInfo app, SparkListenerJobEnd event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        super.doSparkListenerJobEnd(app, event);
        app.lastJobEndTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)event.time())));
        JobResult jobResult = event.jobResult();
        JobSucceeded$ jobSucceeded$ = JobSucceeded$.MODULE$;
        if (jobResult == null ? jobSucceeded$ != null : !jobResult.equals(jobSucceeded$)) {
            Option option = app.jobIdToSqlID().get((Object)BoxesRunTime.boxToInteger((int)event.jobId()));
            if (option instanceof Some) {
                Some some = (Some)option;
                long sqlID = BoxesRunTime.unboxToLong((Object)some.value());
                app.sqlIDToTaskEndSum().get((Object)BoxesRunTime.boxToLong((long)sqlID)).foreach((Function1 & Serializable & scala.Serializable)sum -> {
                    QualificationEventProcessor.$anonfun$doSparkListenerJobEnd$2(sum);
                    return BoxedUnit.UNIT;
                });
                ArrayBuffer failures = (ArrayBuffer)app.sqlIDtoFailures().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)sqlID), (Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty());
                String jobStr = new StringBuilder(3).append("Job").append(event.jobId()).toString();
                failures.$plus$eq((Object)jobStr);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    @Override
    public void doSparkListenerStageCompleted(QualificationAppInfo app, SparkListenerStageCompleted event) {
        super.doSparkListenerStageCompleted(app, event);
        if (event.stageInfo().failureReason().nonEmpty()) {
            Option option = app.stageIdToSqlID().get((Object)BoxesRunTime.boxToInteger((int)event.stageInfo().stageId()));
            if (option instanceof Some) {
                Some some = (Some)option;
                long sqlID = BoxesRunTime.unboxToLong((Object)some.value());
                ArrayBuffer failures = (ArrayBuffer)app.sqlIDtoFailures().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)sqlID), (Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty());
                String stageStr = new StringBuilder(5).append("Stage").append(event.stageInfo().stageId()).toString();
                failures.$plus$eq((Object)stageStr);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    @Override
    public void doSparkListenerSQLAdaptiveExecutionUpdate(QualificationAppInfo app, SparkListenerSQLAdaptiveExecutionUpdate event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing event: ").append(event.getClass()).toString());
        app.sqlPlans().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)event.executionId())), (Object)event.sparkPlanInfo()));
        app.processSQLPlan(event.executionId(), event.sparkPlanInfo());
    }

    public static final /* synthetic */ void $anonfun$doSparkListenerSQLExecutionEnd$3(StageTaskQualificationSummary sum) {
        sum.executorRunTime_$eq(0L);
        sum.executorCPUTime_$eq(0L);
    }

    public static final /* synthetic */ void $anonfun$doSparkListenerJobEnd$2(StageTaskQualificationSummary sum) {
        sum.executorRunTime_$eq(0L);
        sum.executorCPUTime_$eq(0L);
    }

    public QualificationEventProcessor(QualificationAppInfo app) {
        super(app);
    }
}

