/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.tool.qualification;

import com.fasterxml.jackson.core.JsonParseException;
import com.nvidia.spark.rapids.tool.EventLogInfo;
import com.nvidia.spark.rapids.tool.qualification.PluginTypeChecker;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.tool.GpuEventLogException;
import org.apache.spark.sql.rapids.tool.qualification.EstimatedSummaryInfo;
import org.apache.spark.sql.rapids.tool.qualification.QualificationAppInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;

public final class QualificationAppInfo$
implements Logging {
    public static QualificationAppInfo$ MODULE$;
    private final String RECOMMENDED;
    private final String NOT_RECOMMENDED;
    private final String STRONGLY_RECOMMENDED;
    private final String NOT_APPLICABLE;
    private final double LOWER_BOUND_RECOMMENDED;
    private final double LOWER_BOUND_STRONGLY_RECOMMENDED;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new QualificationAppInfo$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<Configuration> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public String RECOMMENDED() {
        return this.RECOMMENDED;
    }

    public String NOT_RECOMMENDED() {
        return this.NOT_RECOMMENDED;
    }

    public String STRONGLY_RECOMMENDED() {
        return this.STRONGLY_RECOMMENDED;
    }

    public String NOT_APPLICABLE() {
        return this.NOT_APPLICABLE;
    }

    public double LOWER_BOUND_RECOMMENDED() {
        return this.LOWER_BOUND_RECOMMENDED;
    }

    public double LOWER_BOUND_STRONGLY_RECOMMENDED() {
        return this.LOWER_BOUND_STRONGLY_RECOMMENDED;
    }

    public String getRecommendation(double totalSpeedup, boolean hasFailures) {
        return hasFailures ? this.NOT_APPLICABLE() : (totalSpeedup >= this.LOWER_BOUND_STRONGLY_RECOMMENDED() ? this.STRONGLY_RECOMMENDED() : (totalSpeedup >= this.LOWER_BOUND_RECOMMENDED() ? this.RECOMMENDED() : this.NOT_RECOMMENDED()));
    }

    public EstimatedSummaryInfo calculateEstimatedInfoSummary(double estimatedRatio, long sqlDataFrameDuration, long appDuration, double speedupFactor, String appName, String appId, boolean hasFailures) {
        long sqlDataFrameDurationToUse = sqlDataFrameDuration > appDuration ? appDuration : sqlDataFrameDuration;
        double speedupOpportunityWallClock = (double)sqlDataFrameDurationToUse * estimatedRatio;
        double estimated_wall_clock_dur_not_on_gpu = (double)appDuration - speedupOpportunityWallClock;
        double estimated_gpu_duration = speedupOpportunityWallClock / speedupFactor + estimated_wall_clock_dur_not_on_gpu;
        double estimated_gpu_speedup = appDuration == 0L || estimated_gpu_duration == 0.0 ? 0.0 : (double)appDuration / estimated_gpu_duration;
        double estimated_gpu_timesaved = (double)appDuration - estimated_gpu_duration;
        String recommendation = this.getRecommendation(estimated_gpu_speedup, hasFailures);
        return new EstimatedSummaryInfo(appName, appId, appDuration, sqlDataFrameDurationToUse, (long)speedupOpportunityWallClock, estimated_gpu_duration, estimated_gpu_speedup, estimated_gpu_timesaved, recommendation);
    }

    public Option<QualificationAppInfo> createApp(EventLogInfo path, Configuration hadoopConf, PluginTypeChecker pluginTypeChecker, boolean reportSqlLevel) {
        None$ none$;
        try {
            QualificationAppInfo app = new QualificationAppInfo((Option<EventLogInfo>)new Some((Object)path), (Option<Configuration>)new Some((Object)hadoopConf), pluginTypeChecker, reportSqlLevel);
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(10).append(path.eventLog().toString()).append(" has App: ").append(app.appId()).toString());
            none$ = new Some((Object)app);
        }
        catch (GpuEventLogException gpuLog) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> gpuLog.message());
            none$ = None$.MODULE$;
        }
        catch (JsonParseException json) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Error parsing JSON: ").append(path.eventLog().toString()).toString());
            none$ = None$.MODULE$;
        }
        catch (IllegalArgumentException il) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Error parsing file: ").append(path.eventLog().toString()).toString(), il);
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(42).append("Got unexpected exception processing file: ").append(path.eventLog().toString()).toString(), e);
            none$ = None$.MODULE$;
        }
        None$ app = none$;
        return app;
    }

    private QualificationAppInfo$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.RECOMMENDED = "Recommended";
        this.NOT_RECOMMENDED = "Not Recommended";
        this.STRONGLY_RECOMMENDED = "Strongly Recommended";
        this.NOT_APPLICABLE = "Not Applicable";
        this.LOWER_BOUND_RECOMMENDED = 1.3;
        this.LOWER_BOUND_STRONGLY_RECOMMENDED = 2.5;
    }
}

