/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.tool;

import com.nvidia.spark.rapids.tool.profiling.ProfileUtils$;
import com.nvidia.spark.rapids.tool.qualification.QualOutputWriter$;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ToolUtils$
implements Logging {
    public static ToolUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ToolUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isPluginEnabled(Map<String, String> properties) {
        return ((String)properties.getOrElse((Object)org.apache.spark.internal.config.package$.MODULE$.PLUGINS().key(), (Function0 & Serializable & scala.Serializable)() -> "")).contains("com.nvidia.spark.SQLPlugin") && new StringOps(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)"spark.rapids.sql.enabled", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
    }

    public String showString(Dataset<Row> df, int numRows) {
        return df.showString(numRows, 0, df.showString$default$3());
    }

    public double calculateDurationPercent(long first, long total) {
        double d;
        BigDecimal firstDec = scala.package$.MODULE$.BigDecimal().decimal(first);
        BigDecimal totalDec = scala.package$.MODULE$.BigDecimal().decimal(total);
        if (BoxesRunTime.equalsNumObject((Number)firstDec, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)totalDec, (Object)BoxesRunTime.boxToInteger((int)0))) {
            d = 0.0;
        } else {
            BigDecimal res = firstDec.$div(totalDec).$times(BigDecimal$.MODULE$.int2bigDecimal(100));
            d = this.formatDoubleValue(res, 2);
        }
        return d;
    }

    public double calculateAverage(double first, long size, int places) {
        double d;
        BigDecimal firstDec = scala.package$.MODULE$.BigDecimal().decimal(first);
        BigDecimal sizeDec = scala.package$.MODULE$.BigDecimal().decimal(size);
        if (BoxesRunTime.equalsNumObject((Number)firstDec, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)sizeDec, (Object)BoxesRunTime.boxToInteger((int)0))) {
            d = 0.0;
        } else {
            BigDecimal res = firstDec.$div(sizeDec);
            d = this.formatDoubleValue(res, places);
        }
        return d;
    }

    public double formatDoubleValue(BigDecimal bigValNum, int places) {
        return bigValNum.setScale(places, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    public String formatDoublePrecision(double valNum) {
        return Double.toString(this.truncateDoubleToTwoDecimal(valNum));
    }

    public double truncateDoubleToTwoDecimal(double valNum) {
        return package$.MODULE$.floor(valNum * (double)100) / (double)100;
    }

    public String escapeMetaCharacters(String str) {
        return str.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t").replaceAll("\f", "\\\\f").replaceAll("\b", "\\\\b").replaceAll("\u000b", "\\\\v").replaceAll("\u0007", "\\\\a");
    }

    public String renderTextField(Seq<Object> values, String separator, String txtDelimiter) {
        return ProfileUtils$.MODULE$.replaceDelimiter(values.mkString(separator), txtDelimiter);
    }

    public String formatComplexTypes(Seq<String> values, String fileDelimiter) {
        return this.renderTextField(values, ";", fileDelimiter);
    }

    public String formatComplexTypes$default$2() {
        return QualOutputWriter$.MODULE$.CSV_DELIMITER();
    }

    public String formatPotentialProblems(Seq<String> values, String fileDelimiter) {
        return this.renderTextField(values, ":", fileDelimiter);
    }

    public String formatPotentialProblems$default$2() {
        return QualOutputWriter$.MODULE$.CSV_DELIMITER();
    }

    private ToolUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

