/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tool.profiling;

import com.nvidia.spark.rapids.tool.ToolTextFileWriter;
import com.nvidia.spark.rapids.tool.profiling.JobInfoClass;
import com.nvidia.spark.rapids.tool.profiling.SQLExecutionInfoClass;
import com.nvidia.spark.rapids.tool.profiling.StageInfoClass;
import com.nvidia.spark.rapids.tool.profiling.TaskStageAccumCase;
import com.nvidia.spark.rapids.tool.profiling.TimelineJobInfo;
import com.nvidia.spark.rapids.tool.profiling.TimelineSqlInfo;
import com.nvidia.spark.rapids.tool.profiling.TimelineStageInfo;
import com.nvidia.spark.rapids.tool.profiling.TimelineTaskInfo;
import com.nvidia.spark.rapids.tool.profiling.TimelineTiming;
import java.io.Serializable;
import org.apache.spark.sql.rapids.tool.profiling.ApplicationInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GenerateTimeline$ {
    public static GenerateTimeline$ MODULE$;
    private final int TASK_HEIGHT;
    private final int TITLE_BOX_WIDTH;
    private final int PADDING;
    private final int FONT_SIZE;
    private final int TITLE_HEIGHT;
    private final int FOOTER_HEIGHT;
    private final double MS_PER_PIXEL;
    private final String[] COLORS;

    static {
        new GenerateTimeline$();
    }

    private int TASK_HEIGHT() {
        return this.TASK_HEIGHT;
    }

    private int TITLE_BOX_WIDTH() {
        return this.TITLE_BOX_WIDTH;
    }

    private int PADDING() {
        return this.PADDING;
    }

    private int FONT_SIZE() {
        return this.FONT_SIZE;
    }

    private int TITLE_HEIGHT() {
        return this.TITLE_HEIGHT;
    }

    private int FOOTER_HEIGHT() {
        return this.FOOTER_HEIGHT;
    }

    private double MS_PER_PIXEL() {
        return this.MS_PER_PIXEL;
    }

    private String[] COLORS() {
        return this.COLORS;
    }

    public <A extends TimelineTiming> int calcLayoutSlotsNeeded(Iterable<A> toSchedule) {
        ArrayBuffer slotsFreeUntil = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.computeLayout(toSchedule, (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            GenerateTimeline$.$anonfun$calcLayoutSlotsNeeded$1(x$1, BoxesRunTime.unboxToInt((Object)x$2));
            return BoxedUnit.UNIT;
        }, false, (Buffer<Object>)slotsFreeUntil);
        return slotsFreeUntil.length();
    }

    public <A extends TimelineTiming> void doLayout(Iterable<A> toSchedule, int numSlots, Function2<A, Object, BoxedUnit> scheduleCallback) {
        Buffer slotsFreeUntil = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(new long[numSlots])).toBuffer();
        this.computeLayout(toSchedule, scheduleCallback, true, (Buffer<Object>)slotsFreeUntil);
    }

    public <A extends TimelineTiming> void computeLayout(Iterable<A> toSchedule, Function2<A, Object, BoxedUnit> scheduleCallback, boolean errorOnMissingSlot, Buffer<Object> slotsFreeUntil) {
        ((IterableLike)toSchedule.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)GenerateTimeline$.$anonfun$computeLayout$1(x0$1, x1$1)))).foreach((Function1 & Serializable & scala.Serializable)timing -> {
            GenerateTimeline$.$anonfun$computeLayout$2(slotsFreeUntil, errorOnMissingSlot, scheduleCallback, timing);
            return BoxedUnit.UNIT;
        });
    }

    private void textBoxVirtCentered(String text, Number x, long y, ToolTextFileWriter fileWriter) {
        fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("<text x=\"").append(x).append("\" y=\"").append(y).append("\" dominant-baseline=\"middle\"\n         | font-family=\"Courier,monospace\" font-size=\"").append(this.FONT_SIZE()).append("\">").append(text).append("</text>\n         |").toString())).stripMargin());
    }

    private void sectionBox(String text, long yStart, int numElements, ToolTextFileWriter fileWriter) {
        int boxHeight = numElements * this.TASK_HEIGHT();
        long boxMiddleY = (long)(boxHeight / 2) + yStart;
        fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("<rect x=\"").append(this.PADDING()).append("\" y=\"").append(yStart).append("\" width=\"").append(this.TITLE_BOX_WIDTH()).append("\" height=\"").append(boxHeight).append("\"\n         | style=\"fill:white;fill-opacity:0.0;stroke:black;stroke-width:2\"/>\n         |").toString())).stripMargin());
        this.textBoxVirtCentered(text, Predef$.MODULE$.int2Integer(this.PADDING() * 2), boxMiddleY, fileWriter);
    }

    private void subTimingMark(String color, long startTime, long endTime, int slot, long xStart, long yStart, long minStart, ToolTextFileWriter fileWriter) {
        double x = (double)xStart + (double)(startTime - minStart) / this.MS_PER_PIXEL();
        long y = (long)(slot * this.TASK_HEIGHT()) + yStart + (long)(this.TASK_HEIGHT() / 2);
        double width = (double)(endTime - startTime) / this.MS_PER_PIXEL();
        int height = this.TASK_HEIGHT() / 2;
        fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("<rect x=\"").append(x).append("\" y=\"").append(y).append("\" width=\"").append(width).append("\" height=\"").append(height).append("\"\n         | style=\"fill:").append(color).append(";fill-opacity:1;stroke:gray;stroke-width:0.5\"/>\n         |").toString())).stripMargin());
    }

    private <A extends TimelineTiming> void timingBox(String text, String color, A timing, int slot, long xStart, long yStart, long minStart, ToolTextFileWriter fileWriter, Seq<Tuple2<String, Object>> subMarks) {
        long startTime = timing.startTime();
        long endTime = timing.endTime();
        double x = (double)xStart + (double)(startTime - minStart) / this.MS_PER_PIXEL();
        long y = (long)(slot * this.TASK_HEIGHT()) + yStart;
        double width = (double)(endTime - startTime) / this.MS_PER_PIXEL();
        fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("<rect x=\"").append(x).append("\" y=\"").append(y).append("\" width=\"").append(width).append("\" height=\"").append(this.TASK_HEIGHT()).append("\"\n         | style=\"fill:").append(color).append(";fill-opacity:1.0;stroke:#00ff00;stroke-width:1\"/>\n         |").toString())).stripMargin());
        LongRef subStart = LongRef.create((long)startTime);
        subMarks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GenerateTimeline$.$anonfun$timingBox$1(subStart, slot, xStart, yStart, minStart, fileWriter, x0$1);
            return BoxedUnit.UNIT;
        });
        this.textBoxVirtCentered(text, Predef$.MODULE$.double2Double(x), y + (long)(this.TASK_HEIGHT() / 2), fileWriter);
    }

    private <A extends TimelineTiming> Seq<Tuple2<String, Object>> timingBox$default$9() {
        return (Seq)Nil$.MODULE$;
    }

    private void scaleWithLines(long x, long y, long minStart, long maxFinish, long height, ToolTextFileWriter fileWriter) {
        long timeRange = maxFinish - minStart;
        double xEnd = (double)x + (double)timeRange / this.MS_PER_PIXEL();
        long yEnd = y + height;
        fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(156).append("<line x1=\"").append(x).append("\" y1=\"").append(yEnd).append("\" x2=\"").append(xEnd).append("\" y2=\"").append(yEnd).append("\" style=\"stroke:black;stroke-width:1\"/>\n         |<line x1=\"").append(x).append("\" y1=\"").append(y).append("\" x2=\"").append(xEnd).append("\" y2=\"").append(y).append("\" style=\"stroke:black;stroke-width:1\"/>\n         |").toString())).stripMargin());
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)timeRange)).by((Object)BoxesRunTime.boxToLong((long)100L)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeForTick -> {
            block0: {
                double xTick = (double)timeForTick / MODULE$.MS_PER_PIXEL() + (double)x;
                fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(105).append("<line x1=\"").append(xTick).append("\" y1=\"").append(y).append("\" x2=\"").append(xTick).append("\" y2=\"").append(yEnd).append("\"\n           | style=\"stroke:black;stroke-width:1;opacity:0.5\"/>\n           |").toString())).stripMargin());
                if (timeForTick % 1000L != 0L) break block0;
                fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(212).append("<line x1=\"").append(xTick).append("\" y1=\"").append(yEnd).append("\"\n             | x2=\"").append(xTick).append("\" y2=\"").append(yEnd + (long)MODULE$.PADDING()).append("\"\n             | style=\"stroke:black;stroke-width:1\"/>\n             |<text x=\"").append(xTick).append("\" y=\"").append(yEnd + (long)MODULE$.PADDING() + (long)MODULE$.FONT_SIZE()).append("\"\n             |font-family=\"Courier,monospace\" font-size=\"").append(MODULE$.FONT_SIZE()).append("\">").append(timeForTick).append(" ms</text>\n             |").toString())).stripMargin());
            }
        });
    }

    private int calcTimingHeights(int slots) {
        return slots * this.TASK_HEIGHT();
    }

    public void generateFor(ApplicationInfo app, String outputDirectory) {
        int jobsEndY;
        int stageRangesEndY;
        int stagesEndY;
        int execsEndY;
        TreeMap execHostToTaskList = new TreeMap((Ordering)Ordering.String$.MODULE$);
        HashMap stageIdToColor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef colorIndex = IntRef.create((int)0);
        LongRef minStartTime = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxEndTime = LongRef.create((long)0L);
        HashSet semWaitIds = new HashSet();
        HashSet readTimeIds = new HashSet();
        HashSet opTimeIds = new HashSet();
        HashSet writeTimeIds = new HashSet();
        app.allSQLMetrics().foreach((Function1 & Serializable & scala.Serializable)f -> {
            String string = f.name();
            boolean bl = "op time".equals(string) ? true : ("GPU decode time".equals(string) ? true : "GPU Time".equals(string));
            if (bl) {
                String string2 = f.metricType();
                String string3 = "nsTiming";
                if (string2 == null) {
                    if (string3 == null) return opTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                } else if (string2.equals(string3)) {
                    return opTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                }
            }
            if ("GPU semaphore wait time".equals(string)) {
                String string4 = f.metricType();
                String string5 = "nsTiming";
                if (string4 == null) {
                    if (string5 == null) return semWaitIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                } else if (string4.equals(string5)) {
                    return semWaitIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                }
            }
            if ("buffer time".equals(string)) {
                String string6 = f.metricType();
                String string7 = "nsTiming";
                if (string6 == null) {
                    if (string7 == null) return readTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                } else if (string6.equals(string7)) {
                    return readTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
                }
            }
            if (!"write time".equals(string)) return BoxedUnit.UNIT;
            String string8 = f.metricType();
            String string9 = "nsTiming";
            if (string8 != null) {
                if (!string8.equals(string9)) return BoxedUnit.UNIT;
                return writeTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
            }
            if (string9 == null) return writeTimeIds.$plus$eq((Object)BoxesRunTime.boxToLong((long)f.accumulatorId()));
            return BoxedUnit.UNIT;
        });
        List semMetrics = (List)((GenericTraversableTemplate)semWaitIds.toList().flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(app.taskStageAccumMap().get((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id)))), List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        List readMetrics = (List)((GenericTraversableTemplate)readTimeIds.toList().flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(app.taskStageAccumMap().get((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id)))), List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        List opMetrics = (List)((GenericTraversableTemplate)opTimeIds.toList().flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(app.taskStageAccumMap().get((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id)))), List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        List writeMetrics = (List)((GenericTraversableTemplate)writeTimeIds.toList().flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(app.taskStageAccumMap().get((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id)))), List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        app.taskEnd().foreach((Function1 & Serializable & scala.Serializable)tc -> {
            String host = tc.host();
            String execId = tc.executorId();
            int stageId = tc.stageId();
            long taskId = tc.taskId();
            long launchTime = tc.launchTime();
            long finishTime = tc.finishTime();
            long duration = tc.duration();
            long semTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)semMetrics.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GenerateTimeline$.$anonfun$generateFor$7(stageId, taskId, m)))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.update()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L;
            long readTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)readMetrics.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GenerateTimeline$.$anonfun$generateFor$9(stageId, taskId, m)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.update()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L + tc.sr_fetchWaitTime();
            long opTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)opMetrics.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GenerateTimeline$.$anonfun$generateFor$11(stageId, taskId, m)))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(x$5.update()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L;
            long writeTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)writeMetrics.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GenerateTimeline$.$anonfun$generateFor$13(stageId, taskId, m)))).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(x$6.update()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L + tc.sw_writeTime();
            TimelineTaskInfo taskInfo = new TimelineTaskInfo(stageId, taskId, launchTime, finishTime, duration, tc.executorDeserializeTime(), readTimeMs, semTimeMs, opTimeMs, writeTimeMs);
            String execHost = new StringBuilder(1).append(execId).append("/").append(host).toString();
            ((ArrayBuffer)execHostToTaskList.getOrElseUpdate((Object)execHost, (Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty())).$plus$eq((Object)taskInfo);
            minStartTime$1.elem = Math.min(launchTime, minStartTime$1.elem);
            maxEndTime$1.elem = Math.max(finishTime, maxEndTime$1.elem);
            return (String)stageIdToColor.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)stageId), (Function0 & Serializable & scala.Serializable)() -> {
                void var1_1;
                String color = MODULE$.COLORS()[colorIndex$1.elem % MODULE$.COLORS().length];
                ++colorIndex$1.elem;
                return var1_1;
            });
        });
        scala.collection.immutable.Iterable stageRangeInfo = (scala.collection.immutable.Iterable)((TraversableLike)execHostToTaskList.values().flatMap((Function1 & Serializable & scala.Serializable)taskList -> taskList, scala.collection.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)taskInfo -> BoxesRunTime.boxToInteger((int)taskInfo.stageId())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int stageId = tuple2._1$mcI$sp();
            Iterable iter = (Iterable)tuple2._2();
            long start = BoxesRunTime.unboxToLong((Object)((TraversableOnce)iter.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.startTime()), scala.collection.Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
            long end = BoxesRunTime.unboxToLong((Object)((TraversableOnce)iter.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.endTime()), scala.collection.Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
            TimelineStageInfo timelineStageInfo = new TimelineStageInfo(stageId, start, end, end - start);
            return timelineStageInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.mutable.Iterable stageInfo = (scala.collection.mutable.Iterable)app.stageIdToInfo().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            StageInfoClass sc;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    sc = (StageInfoClass)tuple2._2();
                    if (tuple22 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            int stageId = sc.info().stageId();
            long submissionTime = BoxesRunTime.unboxToLong((Object)sc.info().submissionTime().get());
            long completionTime = BoxesRunTime.unboxToLong((Object)sc.completionTime().get());
            long duration = BoxesRunTime.unboxToLong((Object)sc.duration().get());
            minStartTime$1.elem = Math.min(minStartTime$1.elem, submissionTime);
            maxEndTime$1.elem = Math.max(maxEndTime$1.elem, completionTime);
            TimelineStageInfo timelineStageInfo = new TimelineStageInfo(stageId, submissionTime, completionTime, duration);
            return timelineStageInfo;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Map execHostToSlots = ((TraversableOnce)execHostToTaskList.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String execHost = (String)tuple2._1();
            ArrayBuffer taskList = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)execHost, (Object)BoxesRunTime.boxToInteger((int)MODULE$.calcLayoutSlotsNeeded((Iterable)taskList)));
            return tuple22;
        }, TreeMap$.MODULE$.canBuildFrom((Ordering)Ordering.String$.MODULE$))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Iterable jobInfo = (scala.collection.mutable.Iterable)app.jobIdToInfo().flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                JobInfoClass jc = (JobInfoClass)tuple2._2();
                if (jc.endTime().isDefined() && jc.duration().isDefined()) {
                    int jobId = jc.jobID();
                    long startTime = jc.startTime();
                    long endTime = BoxesRunTime.unboxToLong((Object)jc.endTime().get());
                    long duration = BoxesRunTime.unboxToLong((Object)jc.duration().get());
                    minStartTime$1.elem = Math.min(minStartTime$1.elem, startTime);
                    maxEndTime$1.elem = Math.max(maxEndTime$1.elem, endTime);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new TimelineJobInfo(jobId, startTime, endTime, duration)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        scala.collection.mutable.Iterable sqlInfo = (scala.collection.mutable.Iterable)app.sqlIdToInfo().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                SQLExecutionInfoClass sc = (SQLExecutionInfoClass)tuple2._2();
                if (sc.endTime().isDefined()) {
                    long sqlId = sc.sqlID();
                    long startTime = sc.startTime();
                    long endTime = BoxesRunTime.unboxToLong((Object)sc.endTime().get());
                    long duration = BoxesRunTime.unboxToLong((Object)sc.duration().get());
                    minStartTime$1.elem = Math.min(minStartTime$1.elem, startTime);
                    maxEndTime$1.elem = Math.max(maxEndTime$1.elem, endTime);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new TimelineSqlInfo(sqlId, startTime, endTime, duration)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        maxEndTime.elem += 1000L;
        int titleStartX = this.PADDING();
        int titleStartY = 0;
        int titleEndY = titleStartY + this.TITLE_HEIGHT();
        int titleBoxStartX = this.PADDING();
        int titleBoxWidth = this.TITLE_BOX_WIDTH();
        int timingsStartX = titleBoxStartX + titleBoxWidth;
        double timingsWidth = (double)(maxEndTime.elem - minStartTime.elem) / this.MS_PER_PIXEL();
        double timingsEndX = (double)timingsStartX + timingsWidth;
        int execsStartY = titleEndY;
        int numExecTaskSlotsTotal = BoxesRunTime.unboxToInt((Object)execHostToSlots.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int execsHeight = this.calcTimingHeights(numExecTaskSlotsTotal);
        int execsWithFooterHeight = execsHeight + this.FOOTER_HEIGHT();
        int stagesStartY = execsEndY = execsStartY + execsWithFooterHeight;
        int numStageSlots = this.calcLayoutSlotsNeeded((Iterable)stageInfo);
        int stagesHeight = this.calcTimingHeights(numStageSlots);
        int stagesWithFooterHeight = stagesHeight + this.FOOTER_HEIGHT();
        int stageRangesStartY = stagesEndY = stagesStartY + stagesWithFooterHeight;
        int numStageRangeSlots = this.calcLayoutSlotsNeeded((Iterable)stageRangeInfo);
        int stageRangesHeight = this.calcTimingHeights(numStageRangeSlots);
        int stageRangesWithFooterHeight = stageRangesHeight + this.FOOTER_HEIGHT();
        int jobsStartY = stageRangesEndY = stageRangesStartY + stageRangesWithFooterHeight;
        int numJobsSlots = this.calcLayoutSlotsNeeded((Iterable)jobInfo);
        int jobsHeight = this.calcTimingHeights(numJobsSlots);
        int jobsWithFooterHeight = jobsHeight + this.FOOTER_HEIGHT();
        int sqlsStartY = jobsEndY = jobsStartY + jobsWithFooterHeight;
        int numSqlsSlots = this.calcLayoutSlotsNeeded((Iterable)sqlInfo);
        int sqlsHeight = this.calcTimingHeights(numSqlsSlots);
        int sqlsWithFooterHeight = sqlsHeight + this.FOOTER_HEIGHT();
        int sqlsEndY = sqlsStartY + sqlsWithFooterHeight;
        int imageHeight = sqlsEndY + this.PADDING();
        double imageWidth = timingsEndX;
        try (ToolTextFileWriter fileWriter = new ToolTextFileWriter(outputDirectory, "timeline.svg", "Timeline file");){
            fileWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(407).append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n           |<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"\n           | \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n           |<!-- Generated by Profiling Tool for the Rapids Accelerator and Apache Spark -->\n           |<svg width=\"").append(imageWidth).append("\" height=\"").append(imageHeight).append("\"\n           | xmlns=\"http://www.w3.org/2000/svg\">\n           | <title>").append(app.appId()).append(" Timeline</title>\n           |").toString())).stripMargin());
            this.textBoxVirtCentered(new StringBuilder(9).append(app.appId()).append(" Timeline").toString(), Predef$.MODULE$.int2Integer(titleStartX), titleStartY + this.TITLE_HEIGHT() / 2, fileWriter);
            IntRef currentExecsStartY = IntRef.create((int)execsStartY);
            execHostToTaskList.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                GenerateTimeline$.$anonfun$generateFor$26(execHostToSlots, currentExecsStartY, fileWriter, stageIdToColor, timingsStartX, minStartTime, timingsEndX, x0$6);
                return BoxedUnit.UNIT;
            });
            this.scaleWithLines(timingsStartX, execsStartY, minStartTime.elem, maxEndTime.elem, execsHeight, fileWriter);
            this.sectionBox("STAGES", stagesStartY, numStageSlots, fileWriter);
            this.doLayout((Iterable)stageInfo, numStageSlots, (Function2)(Function2 & Serializable & scala.Serializable)(x0$8, x1$2) -> {
                GenerateTimeline$.$anonfun$generateFor$28(stageIdToColor, timingsStartX, stagesStartY, minStartTime, fileWriter, x0$8, BoxesRunTime.unboxToInt((Object)x1$2));
                return BoxedUnit.UNIT;
            });
            this.scaleWithLines(timingsStartX, stagesStartY, minStartTime.elem, maxEndTime.elem, stagesHeight, fileWriter);
            this.sectionBox("STAGE RANGES", stageRangesStartY, numStageRangeSlots, fileWriter);
            this.doLayout((Iterable)stageRangeInfo, numStageRangeSlots, (Function2)(Function2 & Serializable & scala.Serializable)(x0$9, x1$3) -> {
                GenerateTimeline$.$anonfun$generateFor$29(stageIdToColor, timingsStartX, stageRangesStartY, minStartTime, fileWriter, x0$9, BoxesRunTime.unboxToInt((Object)x1$3));
                return BoxedUnit.UNIT;
            });
            this.scaleWithLines(timingsStartX, stageRangesStartY, minStartTime.elem, maxEndTime.elem, stageRangesHeight, fileWriter);
            this.sectionBox("JOBS", jobsStartY, numJobsSlots, fileWriter);
            this.doLayout((Iterable)jobInfo, numJobsSlots, (Function2)(Function2 & Serializable & scala.Serializable)(x0$10, x1$4) -> {
                GenerateTimeline$.$anonfun$generateFor$30(timingsStartX, jobsStartY, minStartTime, fileWriter, x0$10, BoxesRunTime.unboxToInt((Object)x1$4));
                return BoxedUnit.UNIT;
            });
            this.scaleWithLines(timingsStartX, jobsStartY, minStartTime.elem, maxEndTime.elem, jobsHeight, fileWriter);
            this.sectionBox("SQL", sqlsStartY, numSqlsSlots, fileWriter);
            this.doLayout((Iterable)sqlInfo, numSqlsSlots, (Function2)(Function2 & Serializable & scala.Serializable)(x0$11, x1$5) -> {
                GenerateTimeline$.$anonfun$generateFor$31(timingsStartX, sqlsStartY, minStartTime, fileWriter, x0$11, BoxesRunTime.unboxToInt((Object)x1$5));
                return BoxedUnit.UNIT;
            });
            this.scaleWithLines(timingsStartX, sqlsStartY, minStartTime.elem, maxEndTime.elem, sqlsHeight, fileWriter);
            fileWriter.write("</svg>");
        }
    }

    public static final /* synthetic */ void $anonfun$calcLayoutSlotsNeeded$1(TimelineTiming x$1, int x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$computeLayout$1(TimelineTiming x0$1, TimelineTiming x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineTiming a = (TimelineTiming)tuple2._1();
        TimelineTiming b = (TimelineTiming)tuple2._2();
        boolean bl = a.startTime() < b.startTime();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$computeLayout$2(Buffer slotsFreeUntil$1, boolean errorOnMissingSlot$1, Function2 scheduleCallback$1, TimelineTiming timing) {
        long startTime = timing.startTime();
        int slot = BoxesRunTime.unboxToInt((Object)slotsFreeUntil$1.indices().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> startTime + 1L >= BoxesRunTime.unboxToLong((Object)slotsFreeUntil$1.apply(i))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            if (errorOnMissingSlot$1) {
                throw new IllegalStateException("Not enough slots to schedule");
            }
            slotsFreeUntil$1.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}));
            return slotsFreeUntil$1.length() - 1;
        }));
        slotsFreeUntil$1.update(slot, (Object)BoxesRunTime.boxToLong((long)timing.endTime()));
        scheduleCallback$1.apply((Object)timing, (Object)BoxesRunTime.boxToInteger((int)slot));
    }

    public static final /* synthetic */ void $anonfun$timingBox$1(LongRef subStart$1, int slot$1, long xStart$1, long yStart$1, long minStart$1, ToolTextFileWriter fileWriter$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String subColor = (String)tuple2._1();
            long subTimeLength = tuple2._2$mcJ$sp();
            MODULE$.subTimingMark(subColor, subStart$1.elem, subStart$1.elem + subTimeLength, slot$1, xStart$1, yStart$1, minStart$1, fileWriter$1);
            subStart$1.elem += subTimeLength;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$7(int stageId$1, long taskId$1, TaskStageAccumCase m) {
        return m.stageId() == stageId$1 && m.taskId().contains((Object)BoxesRunTime.boxToLong((long)taskId$1)) && m.update().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$9(int stageId$1, long taskId$1, TaskStageAccumCase m) {
        return m.stageId() == stageId$1 && m.taskId().contains((Object)BoxesRunTime.boxToLong((long)taskId$1)) && m.update().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$11(int stageId$1, long taskId$1, TaskStageAccumCase m) {
        return m.stageId() == stageId$1 && m.taskId().contains((Object)BoxesRunTime.boxToLong((long)taskId$1)) && m.update().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$13(int stageId$1, long taskId$1, TaskStageAccumCase m) {
        return m.stageId() == stageId$1 && m.taskId().contains((Object)BoxesRunTime.boxToLong((long)taskId$1)) && m.update().isDefined();
    }

    public static final /* synthetic */ void $anonfun$generateFor$27(HashMap stageIdToColor$1, int timingsStartX$1, IntRef currentExecsStartY$1, LongRef minStartTime$1, ToolTextFileWriter fileWriter$3, TimelineTaskInfo x0$7, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineTaskInfo taskInfo = (TimelineTaskInfo)tuple2._1();
        int slot = tuple2._2$mcI$sp();
        ArrayBuffer subTimings = new ArrayBuffer();
        Object object = taskInfo.deserTime() > 0L ? subTimings.$plus$eq((Object)new Tuple2((Object)"yellow", (Object)BoxesRunTime.boxToLong((long)taskInfo.deserTime()))) : BoxedUnit.UNIT;
        Object object2 = taskInfo.readTime() > 0L ? subTimings.$plus$eq((Object)new Tuple2((Object)"white", (Object)BoxesRunTime.boxToLong((long)taskInfo.readTime()))) : BoxedUnit.UNIT;
        Object object3 = taskInfo.semTime() > 0L ? subTimings.$plus$eq((Object)new Tuple2((Object)"red", (Object)BoxesRunTime.boxToLong((long)taskInfo.semTime()))) : BoxedUnit.UNIT;
        Object object4 = taskInfo.opTime() > 0L ? subTimings.$plus$eq((Object)new Tuple2((Object)"green", (Object)BoxesRunTime.boxToLong((long)taskInfo.opTime()))) : BoxedUnit.UNIT;
        Object object5 = taskInfo.writeTime() > 0L ? subTimings.$plus$eq((Object)new Tuple2((Object)"blue", (Object)BoxesRunTime.boxToLong((long)taskInfo.writeTime()))) : BoxedUnit.UNIT;
        MODULE$.timingBox(new StringBuilder(3).append(taskInfo.duration()).append(" ms").toString(), (String)stageIdToColor$1.apply((Object)BoxesRunTime.boxToInteger((int)taskInfo.stageId())), taskInfo, slot, timingsStartX$1, currentExecsStartY$1.elem, minStartTime$1.elem, fileWriter$3, (Seq<Tuple2<String, Object>>)subTimings);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateFor$26(Map execHostToSlots$1, IntRef currentExecsStartY$1, ToolTextFileWriter fileWriter$3, HashMap stageIdToColor$1, int timingsStartX$1, LongRef minStartTime$1, double timingsEndX$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            String execHost = (String)tuple2._1();
            ArrayBuffer taskList = (ArrayBuffer)tuple2._2();
            int numElements = BoxesRunTime.unboxToInt((Object)execHostToSlots$1.apply((Object)execHost));
            int execHostHeight = MODULE$.calcTimingHeights(numElements);
            MODULE$.sectionBox(execHost, currentExecsStartY$1.elem, numElements, fileWriter$3);
            MODULE$.doLayout((Iterable)taskList, numElements, (Function2)(Function2 & Serializable & scala.Serializable)(x0$7, x1$1) -> {
                GenerateTimeline$.$anonfun$generateFor$27(stageIdToColor$1, timingsStartX$1, currentExecsStartY$1, minStartTime$1, fileWriter$3, x0$7, BoxesRunTime.unboxToInt((Object)x1$1));
                return BoxedUnit.UNIT;
            });
            currentExecsStartY$1.elem += execHostHeight;
        } else {
            throw new MatchError((Object)tuple2);
        }
        fileWriter$3.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("<line x1=\"").append(timingsStartX$1).append("\" y1=\"").append(currentExecsStartY$1.elem).append("\"\n               |  x2=\"").append(timingsEndX$1).append("\" y2=\"").append(currentExecsStartY$1.elem).append("\" style=\"stroke:black;stroke-width:1\"/>\n               |").toString())).stripMargin());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateFor$28(HashMap stageIdToColor$1, int timingsStartX$1, int stagesStartY$1, LongRef minStartTime$1, ToolTextFileWriter fileWriter$3, TimelineStageInfo x0$8, int x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)BoxesRunTime.boxToInteger((int)x1$2));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineStageInfo si = (TimelineStageInfo)tuple2._1();
        int slot = tuple2._2$mcI$sp();
        MODULE$.timingBox(new StringBuilder(10).append("STAGE ").append(si.stageId()).append(" ").append(si.duration()).append(" ms").toString(), (String)stageIdToColor$1.apply((Object)BoxesRunTime.boxToInteger((int)si.stageId())), si, slot, timingsStartX$1, stagesStartY$1, minStartTime$1.elem, fileWriter$3, MODULE$.timingBox$default$9());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateFor$29(HashMap stageIdToColor$1, int timingsStartX$1, int stageRangesStartY$1, LongRef minStartTime$1, ToolTextFileWriter fileWriter$3, TimelineStageInfo x0$9, int x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)BoxesRunTime.boxToInteger((int)x1$3));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineStageInfo si = (TimelineStageInfo)tuple2._1();
        int slot = tuple2._2$mcI$sp();
        MODULE$.timingBox(new StringBuilder(16).append("STAGE RANGE ").append(si.stageId()).append(" ").append(si.duration()).append(" ms").toString(), (String)stageIdToColor$1.apply((Object)BoxesRunTime.boxToInteger((int)si.stageId())), si, slot, timingsStartX$1, stageRangesStartY$1, minStartTime$1.elem, fileWriter$3, MODULE$.timingBox$default$9());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateFor$30(int timingsStartX$1, int jobsStartY$1, LongRef minStartTime$1, ToolTextFileWriter fileWriter$3, TimelineJobInfo x0$10, int x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)BoxesRunTime.boxToInteger((int)x1$4));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineJobInfo ji = (TimelineJobInfo)tuple2._1();
        int slot = tuple2._2$mcI$sp();
        MODULE$.timingBox(new StringBuilder(8).append("JOB ").append(ji.jobId()).append(" ").append(ji.duration()).append(" ms").toString(), "green", ji, slot, timingsStartX$1, jobsStartY$1, minStartTime$1.elem, fileWriter$3, MODULE$.timingBox$default$9());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateFor$31(int timingsStartX$1, int sqlsStartY$1, LongRef minStartTime$1, ToolTextFileWriter fileWriter$3, TimelineSqlInfo x0$11, int x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)BoxesRunTime.boxToInteger((int)x1$5));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimelineSqlInfo sql = (TimelineSqlInfo)tuple2._1();
        int slot = tuple2._2$mcI$sp();
        MODULE$.timingBox(new StringBuilder(8).append("SQL ").append(sql.sqlId()).append(" ").append(sql.duration()).append(" ms").toString(), "blue", sql, slot, timingsStartX$1, sqlsStartY$1, minStartTime$1.elem, fileWriter$3, MODULE$.timingBox$default$9());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private GenerateTimeline$() {
        MODULE$ = this;
        this.TASK_HEIGHT = 20;
        this.TITLE_BOX_WIDTH = 200;
        this.PADDING = 5;
        this.FONT_SIZE = 14;
        this.TITLE_HEIGHT = this.FONT_SIZE() + this.PADDING() * 2;
        this.FOOTER_HEIGHT = this.FONT_SIZE() + this.PADDING() * 2;
        this.MS_PER_PIXEL = 5.0;
        this.COLORS = (String[])((Object[])new String[]{"#696969", "#dcdcdc", "#556b2f", "#8b4513", "#483d8b", "#008000", "#3cb371", "#008b8b", "#000080", "#800080", "#b03060", "#ff4500", "#ffa500", "#8a2be2", "#00ff7f", "#dc143c", "#00ffff", "#00bfff", "#f4a460", "#0000ff", "#f08080", "#adff2f", "#da70d6", "#ff00ff", "#1e90ff", "#eee8aa", "#ffff54", "#ff1493", "#7b68ee"});
    }
}

