/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tool.profiling;

import com.nvidia.spark.rapids.tool.ToolTextFileWriter;
import com.nvidia.spark.rapids.tool.profiling.CollectInformation$;
import com.nvidia.spark.rapids.tool.profiling.QueryPlanWithMetrics;
import com.nvidia.spark.rapids.tool.profiling.SQLAccumProfileResults;
import com.nvidia.spark.rapids.tool.profiling.SparkPlanGraph;
import com.nvidia.spark.rapids.tool.profiling.SparkPlanGraph$;
import com.nvidia.spark.rapids.tool.profiling.StageMetrics;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.metric.SQLMetricInfo;
import org.apache.spark.sql.rapids.tool.profiling.ApplicationInfo;
import org.apache.spark.sql.rapids.tool.profiling.SparkPlanInfoWithStage$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GenerateDot$ {
    public static GenerateDot$ MODULE$;
    private final String GPU_COLOR;
    private final String CPU_COLOR;
    private final String TRANSITION_COLOR;

    static {
        new GenerateDot$();
    }

    public String GPU_COLOR() {
        return this.GPU_COLOR;
    }

    public String CPU_COLOR() {
        return this.CPU_COLOR;
    }

    public String TRANSITION_COLOR() {
        return this.TRANSITION_COLOR;
    }

    public String formatMetric(SQLMetricInfo m, long value) {
        String string;
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        String string2 = m.metricType();
        if ("timing".equals(string2)) {
            long ms = value;
            string = new StringBuilder(3).append(formatter.format(ms)).append(" ms").toString();
        } else if ("nsTiming".equals(string2)) {
            long ms = TimeUnit.NANOSECONDS.toMillis(value);
            string = new StringBuilder(3).append(formatter.format(ms)).append(" ms").toString();
        } else {
            string = String.valueOf(formatter.format(value));
        }
        return string;
    }

    public void writeDotGraph(QueryPlanWithMetrics plan, String physicalPlanString, scala.collection.immutable.Map<Object, StageMetrics> stageIdToStageMetrics, ToolTextFileWriter fileWriter, long sqlId, String appId) {
        SparkPlanGraph graph = SparkPlanGraph$.MODULE$.apply(plan.plan(), appId, Long.toString(sqlId), physicalPlanString, stageIdToStageMetrics);
        String str = graph.makeDotFile(plan.metrics());
        fileWriter.write(str);
    }

    public void apply(ApplicationInfo app, String outputDirectory) {
        Seq<SQLAccumProfileResults> accums = CollectInformation$.MODULE$.generateSQLAccums((Seq<ApplicationInfo>)((Seq)new .colon.colon((Object)app, (List)Nil$.MODULE$)));
        Seq accumSummary = (Seq)accums.map((Function1 & Serializable & scala.Serializable)a -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{a.sqlID(), a.accumulatorId(), a.max_value()})), Seq$.MODULE$.canBuildFrom());
        HashMap<Object, Object> accumIdToStageId = app.accumIdToStageId();
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        scala.collection.immutable.Map stageIdToStageMetrics = app.taskEnd().groupBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)task.stageId())).mapValues((Function1 & Serializable & scala.Serializable)tasks -> {
            ArrayBuffer durations = (ArrayBuffer)tasks.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.duration()), ArrayBuffer$.MODULE$.canBuildFrom());
            int numTasks = durations.length();
            long minDur = BoxesRunTime.unboxToLong((Object)durations.min((Ordering)Ordering.Long$.MODULE$));
            long maxDur = BoxesRunTime.unboxToLong((Object)durations.max((Ordering)Ordering.Long$.MODULE$));
            double meanDur = (double)BoxesRunTime.unboxToLong((Object)durations.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)numTasks;
            return new StageMetrics(numTasks, new StringBuilder(26).append("MIN: ").append(formatter.format(minDur)).append(" ms ").append("MAX: ").append(formatter.format(maxDur)).append(" ms ").append("AVG: ").append(formatter.format(meanDur)).append(" ms").toString());
        });
        HashMap sqlIdToMaxMetric = new HashMap();
        accumSummary.foreach((Function1 & Serializable & scala.Serializable)row -> {
            ArrayBuffer list = (ArrayBuffer)sqlIdToMaxMetric.getOrElseUpdate(row.apply(0), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            return list.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(row.apply(1)), row.apply(2)));
        });
        HashMap sqlPlansMap = (HashMap)app.sqlPlan().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long sqlId = tuple2._1$mcJ$sp();
            SparkPlanInfo sparkPlanInfo = (SparkPlanInfo)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)sqlId)), (Object)new Tuple2((Object)sparkPlanInfo, app.physicalPlanDescription().apply((Object)BoxesRunTime.boxToLong((long)sqlId))));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        sqlPlansMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GenerateDot$.$anonfun$apply$8(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            GenerateDot$.$anonfun$apply$9(outputDirectory, sqlIdToMaxMetric, accumIdToStageId, stageIdToStageMetrics, app, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$apply$9(String outputDirectory$1, HashMap sqlIdToMaxMetric$1, HashMap accumIdToStageId$1, scala.collection.immutable.Map stageIdToStageMetrics$1, ApplicationInfo app$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        long sqlID = tuple2._1$mcJ$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        SparkPlanInfo planInfo = (SparkPlanInfo)tuple22._1();
        String physicalPlan = (String)tuple22._2();
        try (ToolTextFileWriter dotFileWriter = new ToolTextFileWriter(outputDirectory$1, new StringBuilder(10).append("query-").append(sqlID).append(".dot").toString(), "Dot file");){
            scala.collection.immutable.Map metrics = ((TraversableOnce)sqlIdToMaxMetric$1.getOrElse((Object)BoxesRunTime.boxToLong((long)sqlID), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
            MODULE$.writeDotGraph(new QueryPlanWithMetrics(SparkPlanInfoWithStage$.MODULE$.apply(planInfo, (Map<Object, Object>)accumIdToStageId$1), (scala.collection.immutable.Map<Object, Object>)metrics), physicalPlan, (scala.collection.immutable.Map<Object, StageMetrics>)stageIdToStageMetrics$1, dotFileWriter, sqlID, app$1.appId());
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private GenerateDot$() {
        MODULE$ = this;
        this.GPU_COLOR = "#76b900";
        this.CPU_COLOR = "#0071c5";
        this.TRANSITION_COLOR = "red";
    }
}

