/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tool.planparser;

import com.nvidia.spark.rapids.tool.planparser.ReadMetaData;
import com.nvidia.spark.rapids.tool.qualification.PluginTypeChecker;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ReadParser$
implements Logging {
    public static ReadParser$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ReadParser$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String formatSchemaStr(String schema) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(schema)).stripPrefix("struct<"))).stripSuffix(">");
    }

    private String getFieldWithoutTag(String str, String tag) {
        int index = str.indexOf(tag);
        String subStr = str.substring(index + new StringOps(Predef$.MODULE$.augmentString(tag)).size());
        int endIndex = subStr.indexOf(", ");
        return endIndex != -1 ? subStr.substring(0, endIndex) : subStr;
    }

    public ReadMetaData parseReadNode(SparkPlanGraphNode node) {
        String string;
        String string2;
        String schemaTag = "ReadSchema: ";
        String schema = node.desc().contains(schemaTag) ? this.formatSchemaStr(this.getFieldWithoutTag(node.desc(), schemaTag)) : "";
        String locationTag = "Location: ";
        if (node.desc().contains(locationTag)) {
            string2 = this.getFieldWithoutTag(node.desc(), locationTag);
        } else if (node.name().contains("JDBCRelation")) {
            String tableName;
            String string3;
            Regex JDBCPattern = new StringOps(Predef$.MODULE$.augmentString(".*JDBCRelation\\((.*)\\).*")).r();
            Option option = JDBCPattern.unapplySeq((CharSequence)(string3 = node.name()));
            String string4 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (tableName = (String)((LinearSeqOptimized)option.get()).apply(0)) : "unknown";
            string2 = string4;
        } else {
            string2 = "unknown";
        }
        String location = string2;
        String pushedFilterTag = "PushedFilters: ";
        String pushedFilters = node.desc().contains(pushedFilterTag) ? this.getFieldWithoutTag(node.desc(), pushedFilterTag) : "unknown";
        String formatTag = "Format: ";
        if (node.desc().contains(formatTag)) {
            String format = this.getFieldWithoutTag(node.desc(), formatTag);
            string = node.name().startsWith("Gpu") ? new StringBuilder(5).append(format).append("(GPU)").toString() : format;
        } else {
            string = node.name().contains("JDBCRelation") ? "JDBC" : "unknown";
        }
        String fileFormat = string;
        return new ReadMetaData(schema, location, pushedFilters, fileFormat);
    }

    public double calculateReadScoreRatio(ReadMetaData meta, PluginTypeChecker pluginTypeChecker) {
        double readScore;
        block1: {
            HashMap notSupportFormatAndTypes = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            Tuple2<Object, Set<String>> tuple2 = pluginTypeChecker.scoreReadDataTypes(meta.format(), meta.schema());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double readScore2 = tuple2._1$mcD$sp();
            Set nsTypes = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)readScore2), (Object)nsTypes);
            Tuple2 tuple23 = tuple22;
            readScore = tuple23._1$mcD$sp();
            Set nsTypes2 = (Set)tuple23._2();
            if (!nsTypes2.nonEmpty()) break block1;
            Set currentFormat = (Set)notSupportFormatAndTypes.get((Object)meta.format()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
            notSupportFormatAndTypes.update((Object)meta.format(), (Object)currentFormat.$plus$plus((GenTraversableOnce)nsTypes2));
        }
        return readScore;
    }

    private ReadParser$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

