/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tool;

import com.nvidia.spark.rapids.tool.ApacheSparkEventLog;
import com.nvidia.spark.rapids.tool.DatabricksEventLog;
import com.nvidia.spark.rapids.tool.EventLogInfo;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.tool.profiling.ApplicationInfo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EventLogPathProcessor$
implements Logging {
    public static EventLogPathProcessor$ MODULE$;
    private final String EVENT_LOG_DIR_NAME_PREFIX;
    private final String EVENT_LOG_FILE_NAME_PREFIX;
    private final String DB_EVENT_LOG_FILE_NAME_PREFIX;
    private final Set<String> SPARK_SHORT_COMPRESSION_CODEC_NAMES;
    private final Set<String> SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventLogPathProcessor$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String EVENT_LOG_DIR_NAME_PREFIX() {
        return this.EVENT_LOG_DIR_NAME_PREFIX;
    }

    public String EVENT_LOG_FILE_NAME_PREFIX() {
        return this.EVENT_LOG_FILE_NAME_PREFIX;
    }

    public String DB_EVENT_LOG_FILE_NAME_PREFIX() {
        return this.DB_EVENT_LOG_FILE_NAME_PREFIX;
    }

    public boolean isEventLogDir(FileStatus status) {
        return status.isDirectory() && this.isEventLogDir(status.getPath().getName());
    }

    public boolean isEventLogDir(String path) {
        return path.startsWith(this.EVENT_LOG_DIR_NAME_PREFIX());
    }

    public boolean isDBEventLogFile(String fileName) {
        return fileName.startsWith(this.DB_EVENT_LOG_FILE_NAME_PREFIX());
    }

    public boolean isDBEventLogFile(FileStatus status) {
        return status.isFile() && this.isDBEventLogFile(status.getPath().getName());
    }

    public Set<String> SPARK_SHORT_COMPRESSION_CODEC_NAMES() {
        return this.SPARK_SHORT_COMPRESSION_CODEC_NAMES;
    }

    public Set<String> SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER() {
        return this.SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER;
    }

    public boolean eventLogNameFilter(Path logFile) {
        return EventLogFileWriter$.MODULE$.codecName(logFile).forall((Function1 & Serializable & scala.Serializable)suffix -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$eventLogNameFilter$1(suffix)));
    }

    public boolean isDatabricksEventLogDir(FileStatus dir, FileSystem fs) {
        FileStatus[] dbLogFiles = fs.listStatus(dir.getPath(), new PathFilter(){

            public boolean accept(Path path) {
                return EventLogPathProcessor$.MODULE$.isDBEventLogFile(path.getName());
            }
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dbLogFiles)).size() > 1;
    }

    public scala.collection.immutable.Map<EventLogInfo, Object> getEventLogInfo(String pathString, Configuration hadoopConf) {
        scala.collection.immutable.Map map;
        block10: {
            Path inputPath = new Path(pathString);
            FileSystem fs = inputPath.getFileSystem(hadoopConf);
            try {
                Tuple2 tuple2;
                FileStatus fileStatus = fs.getFileStatus(inputPath);
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                if (fileStatus.isFile() && !this.eventLogNameFilter(filePath)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("File: ").append(fileName).append(" it not a supported file type. ").append("Supported compression types are: ").append(MODULE$.SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER().mkString(", ")).append(". ").append("Skipping this file.").toString());
                    map = Predef$.MODULE$.Map().empty();
                    break block10;
                }
                if (fileStatus.isDirectory() && this.isEventLogDir(fileStatus)) {
                    ApacheSparkEventLog info = new ApacheSparkEventLog(fileStatus.getPath());
                    map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info), (Object)BoxesRunTime.boxToLong((long)fileStatus.getModificationTime()))}));
                    break block10;
                }
                if (fileStatus.isDirectory() && this.isDatabricksEventLogDir(fileStatus, fs)) {
                    DatabricksEventLog dbinfo = new DatabricksEventLog(fileStatus.getPath());
                    map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbinfo), (Object)BoxesRunTime.boxToLong((long)fileStatus.getModificationTime()))}));
                    break block10;
                }
                Tuple2 tuple22 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(inputPath))).partition((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$getEventLogInfo$2(fs, s)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                FileStatus[] validLogs = (FileStatus[])tuple22._1();
                FileStatus[] invalidLogs = (FileStatus[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)validLogs, (Object)invalidLogs);
                Tuple2 tuple24 = tuple23;
                FileStatus[] validLogs2 = (FileStatus[])tuple24._1();
                FileStatus[] invalidLogs2 = (FileStatus[])tuple24._2();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidLogs2)).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Skipping the following directories: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidLogs2)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
                }
                if ((tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])validLogs2)).partition((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$getEventLogInfo$5(l)))) == null) {
                    throw new MatchError((Object)tuple2);
                }
                FileStatus[] logsSupported = (FileStatus[])tuple2._1();
                FileStatus[] unsupport = (FileStatus[])tuple2._2();
                Tuple2 tuple25 = new Tuple2((Object)logsSupported, (Object)unsupport);
                Tuple2 tuple26 = tuple25;
                FileStatus[] logsSupported2 = (FileStatus[])tuple26._1();
                FileStatus[] unsupport2 = (FileStatus[])tuple26._2();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsupport2)).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Files: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsupport2)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).append(" ").append("have unsupported file types. Supported compression types are: ").append(MODULE$.SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER().mkString(", ")).append(". ").append("Skipping these files.").toString());
                }
                map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logsSupported2)).map((Function1 & Serializable & scala.Serializable)s -> s.isFile() || s.isDirectory() && MODULE$.isEventLogDir(s.getPath().getName()) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ApacheSparkEventLog(s.getPath())), (Object)BoxesRunTime.boxToLong((long)s.getModificationTime())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DatabricksEventLog(s.getPath())), (Object)BoxesRunTime.boxToLong((long)s.getModificationTime())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            }
            catch (FileNotFoundException fe) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append(pathString).append(" not found, skipping!").toString());
                map = Predef$.MODULE$.Map().empty();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Unexpected exception occurred reading ").append(pathString).append(", skipping!").toString(), e);
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public Tuple2<Seq<EventLogInfo>, Seq<EventLogInfo>> processAllPaths(Option<String> filterNLogs, Option<String> matchlogs, List<String> eventLogsPaths, Configuration hadoopConf) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map logsWithTimestamp = ((TraversableOnce)eventLogsPaths.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.getEventLogInfo((String)x$5, hadoopConf), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Paths after stringToPath: ").append(logsWithTimestamp).toString());
        scala.collection.immutable.Map matchedLogs = (scala.collection.immutable.Map)matchlogs.map((Function1 & Serializable & scala.Serializable)strMatch -> logsWithTimestamp.filterKeys((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$processAllPaths$4(strMatch, x$6)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> logsWithTimestamp);
        if (filterNLogs.nonEmpty() && !this.filterByAppCriteria(filterNLogs)) {
            Map map2;
            String[] filteredInfo = ((String)filterNLogs.get()).split("-");
            int numberofEventLogs = new StringOps(Predef$.MODULE$.augmentString(filteredInfo[0])).toInt();
            String criteria = filteredInfo[1];
            if (criteria.equals("newest")) {
                map2 = (Map)LinkedHashMap$.MODULE$.apply((Seq)matchedLogs.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$processAllPaths$6(x$7, x$8))));
            } else if (criteria.equals("oldest")) {
                map2 = (Map)LinkedHashMap$.MODULE$.apply((Seq)matchedLogs.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)EventLogPathProcessor$.$anonfun$processAllPaths$7(x$9, x$10))));
            } else {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Criteria should be either newest-filesystem or oldest-filesystem");
                map2 = Predef$.MODULE$.Map().empty();
            }
            Map matched = map2;
            map = (Map)matched.take(numberofEventLogs);
        } else {
            map = matchedLogs;
        }
        scala.collection.immutable.Map filteredLogs = map;
        return new Tuple2((Object)filteredLogs.keys().toSeq(), (Object)logsWithTimestamp.keys().toSeq());
    }

    public boolean filterByAppCriteria(Option<String> filterNLogs) {
        return ((String)filterNLogs.get()).endsWith("-oldest") || ((String)filterNLogs.get()).endsWith("-newest") || ((String)filterNLogs.get()).endsWith("per-app-name");
    }

    public void logApplicationInfo(ApplicationInfo app) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("==============  ").append(app.appId()).append(" (index=").append(app.index()).append(")  ==============").toString());
    }

    public LocalDateTime getDBEventLogFileDate(String eventLogFileName) {
        LocalDateTime localDateTime;
        String[] fileParts;
        if (!this.isDBEventLogFile(eventLogFileName)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append(eventLogFileName).append(" Not an event log file!").toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fileParts = eventLogFileName.split("--")))).size() < 2) {
            localDateTime = LocalDateTime.now();
        } else {
            String[] date = fileParts[0].split("-");
            int day = Integer.parseInt(date[3]);
            int month = Integer.parseInt(date[2]);
            int year = Integer.parseInt(date[1]);
            String[] time = fileParts[1].split("-");
            String[] minParse = new StringOps(Predef$.MODULE$.augmentString(time[1])).split('.');
            int hour = Integer.parseInt(time[0]);
            int min = Integer.parseInt(minParse[0]);
            localDateTime = LocalDateTime.of(year, month, day, hour, min);
        }
        return localDateTime;
    }

    public static final /* synthetic */ boolean $anonfun$eventLogNameFilter$1(String suffix) {
        return MODULE$.SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER().contains((Object)suffix);
    }

    public static final /* synthetic */ boolean $anonfun$getEventLogInfo$2(FileSystem fs$1, FileStatus s) {
        String name = s.getPath().getName();
        return s.isFile() || s.isDirectory() && (MODULE$.isEventLogDir(name) || MODULE$.isDatabricksEventLogDir(s, fs$1));
    }

    public static final /* synthetic */ boolean $anonfun$getEventLogInfo$5(FileStatus l) {
        return l.isFile() && MODULE$.eventLogNameFilter(l.getPath()) || l.isDirectory();
    }

    public static final /* synthetic */ boolean $anonfun$processAllPaths$4(String strMatch$1, EventLogInfo x$6) {
        return x$6.eventLog().getName().contains(strMatch$1);
    }

    public static final /* synthetic */ boolean $anonfun$processAllPaths$6(Tuple2 x$7, Tuple2 x$8) {
        return x$7._2$mcJ$sp() > x$8._2$mcJ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$processAllPaths$7(Tuple2 x$9, Tuple2 x$10) {
        return x$9._2$mcJ$sp() < x$10._2$mcJ$sp();
    }

    private EventLogPathProcessor$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.EVENT_LOG_DIR_NAME_PREFIX = "eventlog_v2_";
        this.EVENT_LOG_FILE_NAME_PREFIX = "events_";
        this.DB_EVENT_LOG_FILE_NAME_PREFIX = "eventlog";
        this.SPARK_SHORT_COMPRESSION_CODEC_NAMES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lz4", "lzf", "snappy", "zstd"}));
        this.SPARK_SHORT_COMPRESSION_CODEC_NAMES_FOR_FILTER = (Set)this.SPARK_SHORT_COMPRESSION_CODEC_NAMES().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gz"})));
    }
}

