/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.CudfRegexTranspiler;
import com.nvidia.spark.rapids.DataFromReplacementRule;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.RegexSplitMode$;
import com.nvidia.spark.rapids.RegexUnsupportedException;
import com.nvidia.spark.rapids.TernaryExprMeta;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.unsafe.types.UTF8String;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!\u0002\u0005\n\u0003\u0003!\u0002\"C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00115\u0011%A\u0004A!A!\u0002\u0013ID\bC\u0005>\u0001\t\u0005\t\u0015!\u0003?!\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000bC\u0003V\u0001\u0011\u0005a\u000bC\u0003g\u0001\u0011\u0005q\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0002\u0016'R\u0014\u0018N\\4Ta2LGOU3h\u000bb\u0004X*\u001a;b\u0015\tQ1\"\u0001\u0004sCBLGm\u001d\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\u000b\u0003+\t\u001a\"\u0001\u0001\f\u0011\u0007]q\u0002%D\u0001\u0019\u0015\tQ\u0011D\u0003\u0002\u000f5)\u00111\u0004H\u0001\u0007]ZLG-[1\u000b\u0003u\t1aY8n\u0013\ty\u0002DA\bUKJt\u0017M]=FqB\u0014X*\u001a;b!\t\t#\u0005\u0004\u0001\u0005\u000b\r\u0002!\u0019\u0001\u0013\u0003\u000b%s\u0005+\u0016+\u0012\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#a\u0002(pi\"Lgn\u001a\t\u0003YEj\u0011!\f\u0006\u0003]=\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001gC\u0001\tG\u0006$\u0018\r\\=ti&\u0011!'\f\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0017\u0001B3yaJL!!\u000e\u001c\u0002\u000f]\u0014\u0018\r\u001d9fI&\u0011q\u0007\u0007\u0002\u000b%\u0006\u0004\u0018\u000eZ:NKR\f\u0017\u0001B2p]\u001a\u0004\"a\u0006\u001e\n\u0005mB\"A\u0003*ba&$7oQ8oM&\u0011\u0001HN\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0007\u0019z\u0014)\u0003\u0002AO\t1q\n\u001d;j_:\u0004DA\u0011#L\u001dB)qCN\"K\u001bB\u0011\u0011\u0005\u0012\u0003\n\u000b\u000e\t\t\u0011!A\u0003\u0002\u0019\u0013Aa\u0018\u00132iE\u0011Qe\u0012\t\u0003M!K!!S\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\"\u0017\u0012IAjAA\u0001\u0002\u0003\u0015\tA\u0012\u0002\u0005?\u0012\nT\u0007\u0005\u0002\"\u001d\u0012IqjAA\u0001\u0002\u0003\u0015\tA\u0012\u0002\u0005?\u0012\nd'\u0003\u0002>m\u0005!!/\u001e7f!\t92+\u0003\u0002U1\t9B)\u0019;b\rJ|WNU3qY\u0006\u001cW-\\3oiJ+H.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b]K&lW3\u0011\u0007a\u0003\u0001%D\u0001\n\u0011\u0015\u0019T\u00011\u0001!\u0011\u0015AT\u00011\u0001:\u0011\u0015iT\u00011\u0001]!\r1s(\u0018\u0019\u0005=\u0002\u0014G\rE\u0003\u0018m}\u000b7\r\u0005\u0002\"A\u0012IQiWA\u0001\u0002\u0003\u0015\tA\u0012\t\u0003C\t$\u0011\u0002T.\u0002\u0002\u0003\u0005)\u0011\u0001$\u0011\u0005\u0005\"G!C(\\\u0003\u0003\u0005\tQ!\u0001G\u0011\u0015\tV\u00011\u0001S\u0003-\u0019\u0007.Z2l%\u0016<W\t\u001f9\u0015\u0005!T\bc\u0001\u0014@SB!aE\u001b7x\u0013\tYwE\u0001\u0004UkBdWM\r\t\u0003[Rt!A\u001c:\u0011\u0005=<S\"\u00019\u000b\u0005E\u001c\u0012A\u0002\u001fs_>$h(\u0003\u0002tO\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019x\u0005\u0005\u0002'q&\u0011\u0011p\n\u0002\b\u0005>|G.Z1o\u0011\u0015Yh\u00011\u0001}\u0003%!W\r\\5n\u000bb\u0004(\u000f\u0005\u0002-{&\u0011a0\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\t;ie><XK\\2iK\u000e\\W\r\u001a#fY&l\u0017\u000e^3s\u000bb\u001cW\r\u001d;j_:$\u0012!\n")
public abstract class StringSplitRegExpMeta<INPUT extends TernaryExpression>
extends TernaryExprMeta<INPUT> {
    public Option<Tuple2<String, Object>> checkRegExp(Expression delimExpr) {
        String pattern = "";
        boolean isRegExp = false;
        Option<Literal> delim = GpuOverrides$.MODULE$.extractLit(delimExpr);
        if (delim.isEmpty()) {
            this.willNotWorkOnGpu("Only literal delimiter patterns are supported");
        } else {
            UTF8String utf8Str = (UTF8String)((Literal)delim.get()).value();
            if (utf8Str == null) {
                this.willNotWorkOnGpu("Delimiter pattern is null");
            } else {
                CudfRegexTranspiler transpiler;
                Option<String> option;
                if (utf8Str.numChars() == 0) {
                    this.willNotWorkOnGpu("An empty delimiter pattern is not supported");
                }
                if ((option = (transpiler = new CudfRegexTranspiler(RegexSplitMode$.MODULE$)).transpileToSplittableString(utf8Str.toString())) instanceof Some) {
                    String simplified;
                    Some some = (Some)option;
                    pattern = simplified = (String)some.value();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    try {
                        pattern = (String)transpiler.transpile(utf8Str.toString(), (Option<String>)None$.MODULE$)._1();
                        isRegExp = true;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (RegexUnsupportedException e) {
                        this.willNotWorkOnGpu(e.getMessage());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    throw new MatchError(option);
                }
            }
        }
        return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
    }

    public Nothing$ throwUncheckedDelimiterException() {
        throw new IllegalStateException("Delimiter expression has not been checked for regex pattern");
    }

    public StringSplitRegExpMeta(INPUT expr, RapidsConf conf, Option<RapidsMeta<?, ?, ?>> parent, DataFromReplacementRule rule) {
        super(expr, conf, parent, rule);
    }
}

