/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.rapids.GpuFileFormatDataWriter;
import org.apache.spark.sql.rapids.GpuWriteJobDescription;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0004\b\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011!Y\u0003A!A!\u0002\u0013a\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0003\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003<\u0011%\u0011\u0005\u00011AA\u0002\u0013%1\tC\u0005J\u0001\u0001\u0007\t\u0011)Q\u0005y!I!\n\u0001a\u0001\u0002\u0004%Ia\u0013\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\nAC\u0011B\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u000bM\u0003A\u0011\u0002+\t\u000bU\u0003A\u0011\t,\u00039\u001d\u0003XoU5oO2,G)\u001b:fGR|'/\u001f#bi\u0006<&/\u001b;fe*\u0011q\u0002E\u0001\u0007e\u0006\u0004\u0018\u000eZ:\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005q\u0011BA\u000f\u000f\u0005]9\u0005/\u001e$jY\u00164uN]7bi\u0012\u000bG/Y,sSR,'/A\u0006eKN\u001c'/\u001b9uS>t\u0007CA\u000e!\u0013\t\tcB\u0001\fHaV<&/\u001b;f\u0015>\u0014G)Z:de&\u0004H/[8o\u0003I!\u0018m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!C7baJ,G-^2f\u0015\tAC#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003U\u0015\u0012!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006I1m\\7nSR$XM\u001d\t\u0003[Ij\u0011A\f\u0006\u0003_A\n!![8\u000b\u0005E\u0012\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Mr#A\u0005$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2\fa\u0001P5oSRtD\u0003\u0002\u001c8qe\u0002\"a\u0007\u0001\t\u000by!\u0001\u0019A\u0010\t\u000b\t\"\u0001\u0019A\u0012\t\u000b-\"\u0001\u0019\u0001\u0017\u0002\u0017\u0019LG.Z\"pk:$XM]\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t\u0019\u0011J\u001c;\u0002\u001f\u0019LG.Z\"pk:$XM]0%KF$\"\u0001R$\u0011\u0005u*\u0015B\u0001$?\u0005\u0011)f.\u001b;\t\u000f!3\u0011\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\u0019LG.Z\"pk:$XM\u001d\u0011\u0002\u001bI,7m\u001c:eg&sg)\u001b7f+\u0005a\u0005CA\u001fN\u0013\tqeH\u0001\u0003M_:<\u0017!\u0005:fG>\u0014Hm]%o\r&dWm\u0018\u0013fcR\u0011A)\u0015\u0005\b\u0011&\t\t\u00111\u0001M\u00039\u0011XmY8sINLeNR5mK\u0002\nqB\\3x\u001fV$\b/\u001e;Xe&$XM\u001d\u000b\u0002\t\u0006)qO]5uKR\u0011Ai\u0016\u0005\u000612\u0001\r!W\u0001\u0006E\u0006$8\r\u001b\t\u00035vk\u0011a\u0017\u0006\u00039B\t!B^3di>\u0014\u0018N_3e\u0013\tq6LA\u0007D_2,XN\\1s\u0005\u0006$8\r\u001b")
public class GpuSingleDirectoryDataWriter
extends GpuFileFormatDataWriter {
    private final GpuWriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private int fileCounter;
    private long recordsInFile;

    private int fileCounter() {
        return this.fileCounter;
    }

    private void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private long recordsInFile() {
        return this.recordsInFile;
    }

    private void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    private void newOutputWriter() {
        this.recordsInFile_$eq(0L);
        this.releaseResources();
        String ext = this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext);
        int arg$macro$1 = this.fileCounter();
        String currentPath = this.committer.newTaskTempFile(this.taskAttemptContext, (Option)None$.MODULE$, new StringBuilder(0).append(new StringOps("-c%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}))).append(ext).toString());
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & java.io.Serializable & Serializable)x$5 -> {
            x$5.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void write(ColumnarBatch batch) {
        boolean needToCloseBatch = true;
        try {
            if (this.description.maxRecordsPerFile() > 0L && this.recordsInFile() >= this.description.maxRecordsPerFile()) {
                this.fileCounter_$eq(this.fileCounter() + 1);
                Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
                this.newOutputWriter();
            }
            this.statsTrackers().foreach((Function1 & java.io.Serializable & Serializable)x$6 -> {
                x$6.newBatch(batch);
                return BoxedUnit.UNIT;
            });
            this.recordsInFile_$eq(this.recordsInFile() + (long)batch.numRows());
            needToCloseBatch = false;
        }
        finally {
            if (needToCloseBatch) {
                batch.close();
            }
        }
        this.currentWriter().write(batch, this.statsTrackers());
    }

    public GpuSingleDirectoryDataWriter(GpuWriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer);
        this.newOutputWriter();
    }
}

