/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.GpuReadCSVFileFormat;
import com.nvidia.spark.rapids.GpuReadCSVFileFormat$;
import com.nvidia.spark.rapids.GpuReadFileFormatWithMetrics;
import com.nvidia.spark.rapids.GpuReadOrcFileFormat;
import com.nvidia.spark.rapids.GpuReadOrcFileFormat$;
import com.nvidia.spark.rapids.GpuReadParquetFileFormat;
import com.nvidia.spark.rapids.GpuReadParquetFileFormat$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.SparkPlanMeta;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.json.rapids.GpuReadJsonFileFormat;
import org.apache.spark.sql.catalyst.json.rapids.GpuReadJsonFileFormat$;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.rapids.ExternalSource$;
import org.apache.spark.sql.rapids.GpuFileSourceScanExec;
import org.apache.spark.sql.rapids.GpuOrcFileFormat$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple10;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuFileSourceScanExec$
implements Serializable {
    public static GpuFileSourceScanExec$ MODULE$;

    static {
        new GpuFileSourceScanExec$();
    }

    public boolean $lessinit$greater$default$9() {
        return false;
    }

    public boolean $lessinit$greater$default$10() {
        return false;
    }

    public void tagSupport(SparkPlanMeta<FileSourceScanExec> meta) {
        FileFormat fileFormat = ((FileSourceScanExec)meta.wrapped()).relation().fileFormat();
        if (fileFormat instanceof CSVFileFormat) {
            GpuReadCSVFileFormat$.MODULE$.tagSupport(meta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (GpuOrcFileFormat$.MODULE$.isSparkOrcFormat(fileFormat)) {
            GpuReadOrcFileFormat$.MODULE$.tagSupport(meta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fileFormat instanceof ParquetFileFormat) {
            GpuReadParquetFileFormat$.MODULE$.tagSupport(meta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fileFormat instanceof JsonFileFormat) {
            GpuReadJsonFileFormat$.MODULE$.tagSupport(meta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ExternalSource$.MODULE$.isSupportedFormat(fileFormat)) {
            ExternalSource$.MODULE$.tagSupportForGpuFileSourceScan(meta);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(25).append("unsupported file format: ").append(fileFormat.getClass().getCanonicalName()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public FileFormat convertFileFormat(FileFormat format) {
        GpuReadFileFormatWithMetrics gpuReadFileFormatWithMetrics;
        FileFormat fileFormat = format;
        if (fileFormat instanceof CSVFileFormat) {
            gpuReadFileFormatWithMetrics = new GpuReadCSVFileFormat();
        } else if (GpuOrcFileFormat$.MODULE$.isSparkOrcFormat(fileFormat)) {
            gpuReadFileFormatWithMetrics = new GpuReadOrcFileFormat();
        } else if (fileFormat instanceof ParquetFileFormat) {
            gpuReadFileFormatWithMetrics = new GpuReadParquetFileFormat();
        } else if (fileFormat instanceof JsonFileFormat) {
            gpuReadFileFormatWithMetrics = new GpuReadJsonFileFormat();
        } else if (ExternalSource$.MODULE$.isSupportedFormat(fileFormat)) {
            gpuReadFileFormatWithMetrics = ExternalSource$.MODULE$.getReadFileFormat(fileFormat);
        } else {
            throw new IllegalArgumentException(new StringBuilder(17).append(fileFormat.getClass().getCanonicalName()).append(" is not supported").toString());
        }
        return gpuReadFileFormatWithMetrics;
    }

    public GpuFileSourceScanExec apply(HadoopFsRelation relation, Seq<Attribute> output2, StructType requiredSchema, Seq<Expression> partitionFilters2, Option<BitSet> optionalBucketSet, Option<Object> optionalNumCoalescedBuckets, Seq<Expression> dataFilters, Option<TableIdentifier> tableIdentifier, boolean disableBucketedScan, boolean queryUsesInputFile, RapidsConf rapidsConf) {
        return new GpuFileSourceScanExec(relation, output2, requiredSchema, partitionFilters2, optionalBucketSet, optionalNumCoalescedBuckets, dataFilters, tableIdentifier, disableBucketedScan, queryUsesInputFile, rapidsConf);
    }

    public boolean apply$default$10() {
        return false;
    }

    public boolean apply$default$9() {
        return false;
    }

    public Option<Tuple10<HadoopFsRelation, Seq<Attribute>, StructType, Seq<Expression>, Option<BitSet>, Option<Object>, Seq<Expression>, Option<TableIdentifier>, Object, Object>> unapply(GpuFileSourceScanExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.relation(), x$0.output(), (Object)x$0.requiredSchema(), x$0.partitionFilters(), x$0.optionalBucketSet(), x$0.optionalNumCoalescedBuckets(), x$0.dataFilters(), x$0.tableIdentifier(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.disableBucketedScan()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.queryUsesInputFile())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GpuFileSourceScanExec$() {
        MODULE$ = this;
    }
}

