/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.GpuDecimalDivide;
import org.apache.spark.sql.types.DecimalType;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class GpuDecimalDivide$
implements Serializable {
    public static GpuDecimalDivide$ MODULE$;

    static {
        new GpuDecimalDivide$();
    }

    public boolean $lessinit$greater$default$4() {
        return SQLConf$.MODULE$.get().ansiEnabled();
    }

    public int lhsNeededScale(DecimalType rhs, DecimalType outputType) {
        return outputType.scale() + rhs.scale() + 1;
    }

    public int lhsNeededPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int neededLhsScale = this.lhsNeededScale(rhs, outputType);
        return lhs.precision() - lhs.scale() + neededLhsScale;
    }

    public int nonRoundedIntermediateArgPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int neededLhsPrecision = this.lhsNeededPrecision(lhs, rhs, outputType);
        return package$.MODULE$.max(neededLhsPrecision, rhs.precision());
    }

    public int intermediateArgPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        return package$.MODULE$.min(this.nonRoundedIntermediateArgPrecision(lhs, rhs, outputType), 38);
    }

    public DecimalType intermediateLhsType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediateArgPrecision(lhs, rhs, outputType);
        int scale = package$.MODULE$.min(this.lhsNeededScale(rhs, outputType), precision);
        return new DecimalType(precision, scale);
    }

    public DecimalType intermediateRhsType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediateArgPrecision(lhs, rhs, outputType);
        return new DecimalType(precision, rhs.scale());
    }

    public DecimalType intermediateResultType(DecimalType outputType) {
        return new DecimalType(package$.MODULE$.min(outputType.precision() + 1, 38), package$.MODULE$.min(outputType.scale() + 1, 38));
    }

    public GpuDecimalDivide apply(Expression left, Expression right, DecimalType dataType, boolean failOnError) {
        return new GpuDecimalDivide(left, right, dataType, failOnError);
    }

    public boolean apply$default$4() {
        return SQLConf$.MODULE$.get().ansiEnabled();
    }

    public Option<Tuple4<Expression, Expression, DecimalType, Object>> unapply(GpuDecimalDivide x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.left(), (Object)x$0.right(), (Object)x$0.dataType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnError())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GpuDecimalDivide$() {
        MODULE$ = this;
    }
}

