/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.AvroProvider;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.ScanRule;
import com.nvidia.spark.rapids.ShimLoader$;
import com.nvidia.spark.rapids.SparkPlanMeta;
import com.nvidia.spark.rapids.iceberg.IcebergProvider;
import com.nvidia.spark.rapids.iceberg.IcebergProvider$;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.rapids.GpuFileSourceScanExec;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class ExternalSource$
implements Logging {
    public static ExternalSource$ MODULE$;
    private boolean hasSparkAvroJar;
    private AvroProvider avroProvider;
    private boolean hasIcebergJar;
    private IcebergProvider icebergProvider;
    private final String avroScanClassName;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new ExternalSource$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String avroScanClassName() {
        return this.avroScanClassName;
    }

    private boolean hasSparkAvroJar$lzycompute() {
        ExternalSource$ externalSource$ = this;
        synchronized (externalSource$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.hasSparkAvroJar = Utils$.MODULE$.classIsLoadable(this.avroScanClassName()) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ShimLoader$.MODULE$.loadClass(MODULE$.avroScanClassName())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExternalSource$.$anonfun$hasSparkAvroJar$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Avro library not found by the RAPIDS plugin. The Plugin jars are likely deployed using a static classpath spark.driver/executor.extraClassPath. Consider using --jars or --packages instead.");
                    return false;
                }));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.hasSparkAvroJar;
    }

    public boolean hasSparkAvroJar() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.hasSparkAvroJar$lzycompute() : this.hasSparkAvroJar;
    }

    private AvroProvider avroProvider$lzycompute() {
        ExternalSource$ externalSource$ = this;
        synchronized (externalSource$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.avroProvider = ShimLoader$.MODULE$.newAvroProvider();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.avroProvider;
    }

    public AvroProvider avroProvider() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.avroProvider$lzycompute() : this.avroProvider;
    }

    private boolean hasIcebergJar$lzycompute() {
        ExternalSource$ externalSource$ = this;
        synchronized (externalSource$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hasIcebergJar = Utils$.MODULE$.classIsLoadable(IcebergProvider$.MODULE$.cpuScanClassName()) && Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ShimLoader$.MODULE$.loadClass(IcebergProvider$.MODULE$.cpuScanClassName())).isSuccess();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hasIcebergJar;
    }

    private boolean hasIcebergJar() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hasIcebergJar$lzycompute() : this.hasIcebergJar;
    }

    private IcebergProvider icebergProvider$lzycompute() {
        ExternalSource$ externalSource$ = this;
        synchronized (externalSource$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.icebergProvider = IcebergProvider$.MODULE$.apply();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.icebergProvider;
    }

    private IcebergProvider icebergProvider() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.icebergProvider$lzycompute() : this.icebergProvider;
    }

    public boolean isSupportedFormat(FileFormat format) {
        return this.hasSparkAvroJar() ? this.avroProvider().isSupportedFormat(format) : false;
    }

    public boolean isPerFileReadEnabledForFormat(FileFormat format, RapidsConf conf) {
        return this.hasSparkAvroJar() ? this.avroProvider().isPerFileReadEnabledForFormat(format, conf) : false;
    }

    public void tagSupportForGpuFileSourceScan(SparkPlanMeta<FileSourceScanExec> meta) {
        block0: {
            if (!this.hasSparkAvroJar()) break block0;
            this.avroProvider().tagSupportForGpuFileSourceScan(meta);
        }
    }

    public FileFormat getReadFileFormat(FileFormat format) {
        if (!this.hasSparkAvroJar()) {
            throw new IllegalArgumentException(new StringBuilder(17).append(format.getClass().getCanonicalName()).append(" is not supported").toString());
        }
        return this.avroProvider().getReadFileFormat(format);
    }

    public PartitionReaderFactory createMultiFileReaderFactory(FileFormat format, Broadcast<SerializableConfiguration> broadcastedConf, Filter[] pushedFilters, GpuFileSourceScanExec fileScan) {
        if (!this.hasSparkAvroJar()) {
            throw new RuntimeException(new StringBuilder(33).append("File format ").append(format).append(" is not supported yet").toString());
        }
        return this.avroProvider().createMultiFileReaderFactory(format, broadcastedConf, pushedFilters, fileScan);
    }

    /*
     * WARNING - void declaration
     */
    public Map<Class<? extends Scan>, ScanRule<? extends Scan>> getScans() {
        void var1_1;
        block1: {
            Map scans = Predef$.MODULE$.Map().empty();
            if (this.hasSparkAvroJar()) {
                scans = scans.$plus$plus(this.avroProvider().getScans());
            }
            if (!this.hasIcebergJar()) break block1;
            scans = scans.$plus$plus(this.icebergProvider().getScans());
        }
        return var1_1;
    }

    public boolean isSupportedScan(Scan scan) {
        return this.hasSparkAvroJar() && this.avroProvider().isSupportedScan(scan) ? true : this.hasIcebergJar() && this.icebergProvider().isSupportedScan(scan);
    }

    public Scan copyScanWithInputFileTrue(Scan scan) {
        Scan scan2;
        if (this.hasSparkAvroJar() && this.avroProvider().isSupportedScan(scan)) {
            scan2 = this.avroProvider().copyScanWithInputFileTrue(scan);
        } else if (this.hasIcebergJar() && this.icebergProvider().isSupportedScan(scan)) {
            scan2 = scan;
        } else {
            throw new RuntimeException(new StringBuilder(23).append("Unsupported scan type: ").append(scan.getClass().getSimpleName()).toString());
        }
        return scan2;
    }

    public static final /* synthetic */ boolean $anonfun$hasSparkAvroJar$2(Class x$1) {
        return true;
    }

    private ExternalSource$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.avroScanClassName = "org.apache.spark.sql.v2.avro.AvroScan";
    }
}

