/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.rapids.BasicColumnarWriteJobStatsTracker$;
import org.apache.spark.sql.rapids.BasicColumnarWriteTaskStats;
import org.apache.spark.sql.rapids.ColumnarWriteTaskStatsTracker;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\n\u0014\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)A\t\u0001C\u0001\u000b\"1\u0011\n\u0001Q!\n)Ca!\u0014\u0001!B\u0013Q\u0005B\u0002(\u0001A\u0003&!\n\u0003\u0004P\u0001\u0001\u0006K\u0001\u0015\u0005\u0007'\u0002\u0001\u000b\u0015\u0002)\t\rQ\u0003\u0001\u0015!\u0003V\u0011\u0015A\u0007\u0001\"\u0003j\u0011\u0015A\u0007\u0001\"\u0003n\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t)\u0003\u0001C!\u0003O\u0011!EQ1tS\u000e\u001cu\u000e\\;n]\u0006\u0014xK]5uKR\u000b7o[*uCR\u001cHK]1dW\u0016\u0014(B\u0001\u000b\u0016\u0003\u0019\u0011\u0018\r]5eg*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M!\u0001aH\u0013*!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002'%\u0011\u0001f\u0005\u0002\u001e\u0007>dW/\u001c8be^\u0013\u0018\u000e^3UCN\\7\u000b^1ugR\u0013\u0018mY6feB\u0011!&L\u0007\u0002W)\u0011AfF\u0001\tS:$XM\u001d8bY&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003cYj\u0011A\r\u0006\u0003gQ\nAaY8oM*\u0011Q'G\u0001\u0007Q\u0006$wn\u001c9\n\u0005]\u0012$!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000buCN\\7i\\7nSR$\u0016.\\3NKR\u0014\u0018n\u0019\t\u0004Aib\u0014BA\u001e\"\u0005\u0019y\u0005\u000f^5p]B\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0007[\u0016$(/[2\u000b\u0005\u0005+\u0012!C3yK\u000e,H/[8o\u0013\t\u0019eHA\u0005T#2kU\r\u001e:jG\u00061A(\u001b8jiz\"2AR$I!\t1\u0003\u0001C\u00030\u0007\u0001\u0007\u0001\u0007C\u00039\u0007\u0001\u0007\u0011(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003A-K!\u0001T\u0011\u0003\u0007%sG/\u0001\u0005ok64\u0015\u000e\\3t\u0003EqW/\\*vE6LG\u000f^3e\r&dWm]\u0001\t]Vl')\u001f;fgB\u0011\u0001%U\u0005\u0003%\u0006\u0012A\u0001T8oO\u00069a.^7S_^\u001c\u0018AD:vE6LG\u000f^3e\r&dWm\u001d\t\u0004-nkV\"A,\u000b\u0005aK\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00035\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\tavKA\u0004ICND7+\u001a;\u0011\u0005y+gBA0d!\t\u0001\u0017%D\u0001b\u0015\t\u0011W$\u0001\u0004=e>|GOP\u0005\u0003I\u0006\na\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A-I\u0001\fO\u0016$h)\u001b7f'&TX\r\u0006\u0002kWB\u0019\u0001E\u000f)\t\u000b1T\u0001\u0019A/\u0002\u0011\u0019LG.\u001a)bi\"$2A\u001b8v\u0011\u0015y7\u00021\u0001q\u0003\t17\u000f\u0005\u0002rg6\t!O\u0003\u0002pi%\u0011AO\u001d\u0002\u000b\r&dWmU=ti\u0016l\u0007\"\u0002<\f\u0001\u00049\u0018\u0001\u00029bi\"\u0004\"!\u001d=\n\u0005e\u0014(\u0001\u0002)bi\"\fAB\\3x!\u0006\u0014H/\u001b;j_:$\u0012\u0001 \t\u0003AuL!A`\u0011\u0003\tUs\u0017\u000e^\u0001\b]\u0016<h)\u001b7f)\ra\u00181\u0001\u0005\u0006Y6\u0001\r!X\u0001\nG2|7/\u001a$jY\u0016$2\u0001`A\u0005\u0011\u0015ag\u00021\u0001^\u0003=)\b\u000fZ1uK\u001aKG.Z*uCR\u001cHc\u0001?\u0002\u0010!)An\u0004a\u0001;\u0006Aa.Z<CCR\u001c\u0007\u000eF\u0002}\u0003+Aq!a\u0006\u0011\u0001\u0004\tI\"A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"F\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BA\u0012\u0003;\u0011QbQ8mk6t\u0017M\u001d\"bi\u000eD\u0017!D4fi\u001aKg.\u00197Ti\u0006$8\u000f\u0006\u0003\u0002*\u0005U\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002)A\u0006eCR\f7o\\;sG\u0016\u001c\u0018\u0002BA\u001a\u0003[\u0011ab\u0016:ji\u0016$\u0016m]6Ti\u0006$8\u000f\u0003\u0004\u00028E\u0001\r\u0001U\u0001\u000fi\u0006\u001c8nQ8n[&$H+[7f\u0001")
public class BasicColumnarWriteTaskStatsTracker
implements ColumnarWriteTaskStatsTracker,
Logging {
    private final Configuration hadoopConf;
    private final Option<SQLMetric> taskCommitTimeMetric;
    private int numPartitions;
    private int numFiles;
    private int numSubmittedFiles;
    private long numBytes;
    private long numRows;
    private final HashSet<String> submittedFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> getFileSize(String filePath) {
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        return this.getFileSize(fs, path);
    }

    private Option<Object> getFileSize(FileSystem fs, Path path) {
        try {
            long len = fs.getFileStatus(path).getLen();
            if (len > 0L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)len));
            }
        }
        catch (FileNotFoundException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("File ").append(path).append(" is not yet visible").toString(), e);
            return None$.MODULE$;
        }
        long len = 0L;
        try {
            byte[] attr = fs.getXAttr(path, BasicColumnarWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR());
            if (attr != null && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(attr)).nonEmpty()) {
                String str = new String(attr, StandardCharsets.UTF_8);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("File Length statistics for ").append(path).append(" retrieved from XAttr: ").append(str).toString());
                long l = Long.parseLong(str);
                if (l > 0L) {
                    len = l;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring negative value in XAttr file length");
                }
            }
        }
        catch (NumberFormatException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Failed to parse").append(" ").append(BasicColumnarWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR()).append(":").append(e).append(";").append(" bytes written may be under-reported").toString());
        }
        catch (UnsupportedOperationException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("XAttr not supported on path ").append(path).toString(), e);
        }
        catch (Exception e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("XAttr processing failure on ").append(path).toString(), e);
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)len));
    }

    @Override
    public void newPartition() {
        ++this.numPartitions;
    }

    @Override
    public void newFile(String filePath) {
        this.submittedFiles.$plus$eq((Object)filePath);
        ++this.numSubmittedFiles;
    }

    @Override
    public void closeFile(String filePath) {
        this.updateFileStats(filePath);
        this.submittedFiles.remove((Object)filePath);
    }

    private void updateFileStats(String filePath) {
        this.getFileSize(filePath).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> {
            $this.numBytes += len;
            ++$this.numFiles;
        });
    }

    @Override
    public void newBatch(ColumnarBatch batch) {
        this.numRows += (long)batch.numRows();
    }

    @Override
    public WriteTaskStats getFinalStats(long taskCommitTime) {
        this.submittedFiles.foreach((Function1 & Serializable & scala.Serializable)filePath -> {
            this.updateFileStats(filePath);
            return BoxedUnit.UNIT;
        });
        this.submittedFiles.clear();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.taskMetrics().outputMetrics()).foreach((Function1 & Serializable & scala.Serializable)outputMetrics -> {
            BasicColumnarWriteTaskStatsTracker.$anonfun$getFinalStats$3(this, outputMetrics);
            return BoxedUnit.UNIT;
        });
        if (this.numSubmittedFiles != this.numFiles) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(153).append("Expected ").append($this.numSubmittedFiles).append(" files, but only saw ").append($this.numFiles).append(". ").append("This could be due to the output format not writing empty files, ").append("or files being not immediately visible in the filesystem.").toString());
        }
        this.taskCommitTimeMetric.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.$plus$eq(taskCommitTime);
            return BoxedUnit.UNIT;
        });
        return new BasicColumnarWriteTaskStats(this.numPartitions, this.numFiles, this.numBytes, this.numRows);
    }

    public static final /* synthetic */ void $anonfun$getFinalStats$3(BasicColumnarWriteTaskStatsTracker $this, OutputMetrics outputMetrics) {
        outputMetrics.setBytesWritten($this.numBytes);
        outputMetrics.setRecordsWritten($this.numRows);
    }

    public BasicColumnarWriteTaskStatsTracker(Configuration hadoopConf, Option<SQLMetric> taskCommitTimeMetric) {
        this.hadoopConf = hadoopConf;
        this.taskCommitTimeMetric = taskCommitTimeMetric;
        Logging.$init$((Logging)this);
        this.numPartitions = 0;
        this.numFiles = 0;
        this.numSubmittedFiles = 0;
        this.numBytes = 0L;
        this.numRows = 0L;
        this.submittedFiles = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

