/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shims;

import java.io.Serializable;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ParquetSchemaClipShims$ {
    public static ParquetSchemaClipShims$ MODULE$;

    static {
        new ParquetSchemaClipShims$();
    }

    public boolean useFieldId(SQLConf conf) {
        return conf.parquetFieldIdReadEnabled();
    }

    public boolean ignoreMissingIds(SQLConf conf) {
        return conf.ignoreMissingParquetFieldId();
    }

    public void checkIgnoreMissingIds(boolean ignoreMissingIds, MessageType parquetFileSchema, StructType catalystRequestedSchema) {
        if (!ignoreMissingIds && !ParquetReadSupport$.MODULE$.containsFieldIds((Type)parquetFileSchema) && ParquetUtils$.MODULE$.hasFieldIds(catalystRequestedSchema)) {
            throw new RuntimeException(new StringBuilder(181).append("Spark read schema expects field Ids, but Parquet file schema doesn't contain any field Ids.\nPlease remove the field ids from Spark schema or ignore missing ids by ").append("setting `").append(SQLConf$.MODULE$.IGNORE_MISSING_PARQUET_FIELD_ID().key()).append(" = true`\n").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n               |Spark read schema:\n               |").append(catalystRequestedSchema.prettyJson()).append("\n               |\n               |Parquet file schema:\n               |").append(parquetFileSchema.toString()).append("\n               |").toString())).stripMargin()).toString());
        }
    }

    public boolean hasFieldId(StructField field) {
        return ParquetUtils$.MODULE$.hasFieldId(field);
    }

    public boolean hasFieldIds(StructType schema) {
        return ParquetUtils$.MODULE$.hasFieldIds(schema);
    }

    public int getFieldId(StructField field) {
        return ParquetUtils$.MODULE$.getFieldId(field);
    }

    public Map<Object, Type> fieldIdToFieldMap(boolean useFieldId, Type fileType) {
        return useFieldId ? ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileType.asGroupType().getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaClipShims$.$anonfun$fieldIdToFieldMap$1(x$1)))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f.getId().intValue())), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
    }

    public Map<Object, String> fieldIdToNameMap(boolean useFieldId, Type fileType) {
        return useFieldId ? ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileType.asGroupType().getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaClipShims$.$anonfun$fieldIdToNameMap$1(x$2)))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f.getId().intValue())), (Object)f.getName()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType convertPrimitiveField(PrimitiveType parquetType) {
        block50: {
            block49: {
                typeAnnotation = parquetType.getLogicalTypeAnnotation();
                typeName = parquetType.getPrimitiveTypeName();
                var10_4 = typeName;
                if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var10_4)) {
                    return BooleanType$.MODULE$;
                }
                if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(var10_4)) {
                    return FloatType$.MODULE$;
                }
                if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var10_4)) {
                    return DoubleType$.MODULE$;
                }
                if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var10_4)) break block49;
                var11_6 = false;
                var12_7 = null;
                var13_8 = typeAnnotation;
                if (!(var13_8 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) ** GOTO lbl-1000
                var11_6 = true;
                var12_7 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var13_8;
                if (var12_7.isSigned()) {
                    var14_9 = var12_7.getBitWidth();
                    switch (var14_9) {
                        case 8: {
                            v0 = ByteType$.MODULE$;
                            break;
                        }
                        case 16: {
                            v0 = ShortType$.MODULE$;
                            break;
                        }
                        case 32: {
                            v0 = IntegerType$.MODULE$;
                            break;
                        }
                        default: {
                            throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                        }
                    }
                    var7_10 = v0;
                    return var7_10;
                } else if (var13_8 == null) {
                    var7_10 = IntegerType$.MODULE$;
                    return var7_10;
                } else if (var13_8 instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    var7_10 = DateType$.MODULE$;
                    return var7_10;
                } else if (var13_8 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    var7_10 = ParquetSchemaClipShims$.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation, typeName);
                    return var7_10;
                } else if (var11_6 && !var12_7.isSigned()) {
                    var15_11 = var12_7.getBitWidth();
                    switch (var15_11) {
                        case 8: {
                            v1 = ShortType$.MODULE$;
                            break;
                        }
                        case 16: {
                            v1 = IntegerType$.MODULE$;
                            break;
                        }
                        case 32: {
                            v1 = LongType$.MODULE$;
                            break;
                        }
                        default: {
                            throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                        }
                    }
                    var7_10 = v1;
                    return var7_10;
                } else {
                    if (var13_8 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                    var16_12 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var13_8;
                    v2 = var16_12.getUnit();
                    var17_13 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                    if (v2 != null) {
                        if (v2.equals(var17_13) == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                        throw ParquetSchemaClipShims$.typeNotImplemented$1(parquetType);
                    }
                    if (var17_13 == null) throw ParquetSchemaClipShims$.typeNotImplemented$1(parquetType);
                    throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                }
            }
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(var10_4)) {
                var18_14 = false;
                var19_15 = null;
                var20_16 = typeAnnotation;
                if (var20_16 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    var18_14 = true;
                    var19_15 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var20_16;
                    if (var19_15.isSigned()) {
                        var21_17 = var19_15.getBitWidth();
                        switch (var21_17) {
                            case 64: {
                                break;
                            }
                            default: {
                                throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                            }
                        }
                        var6_18 = LongType$.MODULE$;
                        return var6_18;
                    }
                }
                if (var20_16 == null) {
                    var6_18 = LongType$.MODULE$;
                    return var6_18;
                }
                if (var20_16 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    var6_18 = ParquetSchemaClipShims$.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation, typeName);
                    return var6_18;
                }
                if (var18_14 && !var19_15.isSigned()) {
                    var22_19 = var19_15.getBitWidth();
                    switch (var22_19) {
                        case 64: {
                            ** break;
                        }
                        default: {
                            throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                        }
lbl-1000:
                        // 1 sources

                        {
                            var6_18 = new DecimalType(20, 0);
                        }
                    }
                    return var6_18;
                }
                if (var20_16 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                var23_20 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var20_16;
                v3 = var23_20.getUnit();
                var24_21 = LogicalTypeAnnotation.TimeUnit.MICROS;
                if (v3 == null ? var24_21 != null : v3.equals(var24_21) == false) {
                    v4 = var23_20.getUnit();
                    var25_22 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                    if (v4 == null) {
                        if (var25_22 != null) {
                            throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                        }
                    } else if (v4.equals(var25_22) == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                }
                var6_18 = TimestampType$.MODULE$;
                return var6_18;
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(var10_4)) {
                if (SQLConf$.MODULE$.get().isParquetINT96AsTimestamp() != false) return TimestampType$.MODULE$;
                throw TrampolineUtil$.MODULE$.throwAnalysisException(new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
            }
            if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var10_4)) break block50;
            var26_23 = false;
            var27_24 = null;
            var28_25 = typeAnnotation;
            var5_26 = var28_25 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation != false ? true : (var28_25 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation != false ? true : var28_25 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation != false);
            if (var5_26) {
                var4_27 = StringType$.MODULE$;
                return var4_27;
            }
            if (var28_25 != null) ** GOTO lbl-1000
            var26_23 = true;
            var27_24 = var28_25;
            if (SQLConf$.MODULE$.get().isParquetBinaryAsString()) {
                var4_27 = StringType$.MODULE$;
                return var4_27;
            } else if (var26_23) {
                var4_27 = BinaryType$.MODULE$;
                return var4_27;
            } else if (var28_25 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                var4_27 = BinaryType$.MODULE$;
                return var4_27;
            } else {
                if (var28_25 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
                var4_27 = ParquetSchemaClipShims$.makeDecimalType$1(ParquetSchemaClipShims$.makeDecimalType$default$1$1(), typeAnnotation, typeName);
            }
            return var4_27;
        }
        if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var10_4) == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
        var29_28 = typeAnnotation;
        if (!(var29_28 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            if (var29_28 instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation == false) throw ParquetSchemaClipShims$.illegalType$1(parquetType);
            throw ParquetSchemaClipShims$.typeNotImplemented$1(parquetType);
        }
        var3_29 = ParquetSchemaClipShims$.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType.getTypeLength()), typeAnnotation, typeName);
        return var3_29;
    }

    public static final /* synthetic */ boolean $anonfun$fieldIdToFieldMap$1(Type x$1) {
        return x$1.getId() != null;
    }

    public static final /* synthetic */ boolean $anonfun$fieldIdToNameMap$1(Type x$2) {
        return x$2.getId() != null;
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return typeAnnotation$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(PrimitiveType parquetType$1) {
        return TrampolineUtil$.MODULE$.throwAnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(parquetType$1).toString());
    }

    private static final Nothing$ illegalType$1(PrimitiveType parquetType$1) {
        return TrampolineUtil$.MODULE$.throwAnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(parquetType$1).toString());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        if (maxPrecision != -1 && (1 > precision || precision > maxPrecision)) {
            throw TrampolineUtil$.MODULE$.throwAnalysisException(new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" ").append("cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        }
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    private ParquetSchemaClipShims$() {
        MODULE$ = this;
    }
}

