/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shims;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.rapids.shims.IntervalUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuIntervalUtils$
implements Arm {
    public static GpuIntervalUtils$ MODULE$;
    private final long MAX_DAY;
    private final long MAX_HOUR;
    private final long MAX_MINUTE;
    private final long MAX_SECOND;
    private final long MAX_HOUR_IN_DAY;
    private final long MAX_MINUTE_IN_HOUR;
    private final String prefixStr;
    private final String minLongBaseStr;
    private final String INTERVAL;
    private final String DAY;
    private final String HOUR;
    private final String MINUTE;
    private final String SECOND;
    private final String TO;
    private final String sign;
    private final String blanks;
    private final String normalPattern;
    private final String dayBoundPattern;
    private final String hourBoundPattern;
    private final String minuteBoundPattern;
    private final String secondBoundPattern;
    private final String microPattern;
    private final String dayPatternString;
    private final String dayLiteralRegex;
    private final String dayHourPatternString;
    private final String dayHourLiteralRegex;
    private final String dayMinutePatternString;
    private final String dayMinuteLiteralRegex;
    private final String daySecondPatternString;
    private final String daySecondLiteralRegex;
    private final String hourPatternString;
    private final String hourLiteralRegex;
    private final String hourMinutePatternString;
    private final String hourMinuteLiteralRegex;
    private final String hourSecondPatternString;
    private final String hourSecondLiteralRegex;
    private final String minutePatternString;
    private final String minuteLiteralRegex;
    private final String minuteSecondPatternString;
    private final String minuteSecondLiteralRegex;
    private final String secondPatternString;
    private final String secondLiteralRegex;

    static {
        new GpuIntervalUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public long MAX_DAY() {
        return this.MAX_DAY;
    }

    public long MAX_HOUR() {
        return this.MAX_HOUR;
    }

    public long MAX_MINUTE() {
        return this.MAX_MINUTE;
    }

    public long MAX_SECOND() {
        return this.MAX_SECOND;
    }

    public long MAX_HOUR_IN_DAY() {
        return this.MAX_HOUR_IN_DAY;
    }

    public long MAX_MINUTE_IN_HOUR() {
        return this.MAX_MINUTE_IN_HOUR;
    }

    public String prefixStr() {
        return this.prefixStr;
    }

    public String minLongBaseStr() {
        return this.minLongBaseStr;
    }

    private String INTERVAL() {
        return this.INTERVAL;
    }

    private String DAY() {
        return this.DAY;
    }

    private String HOUR() {
        return this.HOUR;
    }

    private String MINUTE() {
        return this.MINUTE;
    }

    private String SECOND() {
        return this.SECOND;
    }

    private String TO() {
        return this.TO;
    }

    private String sign() {
        return this.sign;
    }

    private String blanks() {
        return this.blanks;
    }

    private String normalPattern() {
        return this.normalPattern;
    }

    private String dayBoundPattern() {
        return this.dayBoundPattern;
    }

    private String hourBoundPattern() {
        return this.hourBoundPattern;
    }

    private String minuteBoundPattern() {
        return this.minuteBoundPattern;
    }

    private String secondBoundPattern() {
        return this.secondBoundPattern;
    }

    private String microPattern() {
        return this.microPattern;
    }

    private String dayPatternString() {
        return this.dayPatternString;
    }

    private String dayLiteralRegex() {
        return this.dayLiteralRegex;
    }

    private String dayHourPatternString() {
        return this.dayHourPatternString;
    }

    private String dayHourLiteralRegex() {
        return this.dayHourLiteralRegex;
    }

    private String dayMinutePatternString() {
        return this.dayMinutePatternString;
    }

    private String dayMinuteLiteralRegex() {
        return this.dayMinuteLiteralRegex;
    }

    private String daySecondPatternString() {
        return this.daySecondPatternString;
    }

    private String daySecondLiteralRegex() {
        return this.daySecondLiteralRegex;
    }

    private String hourPatternString() {
        return this.hourPatternString;
    }

    private String hourLiteralRegex() {
        return this.hourLiteralRegex;
    }

    private String hourMinutePatternString() {
        return this.hourMinutePatternString;
    }

    private String hourMinuteLiteralRegex() {
        return this.hourMinuteLiteralRegex;
    }

    private String hourSecondPatternString() {
        return this.hourSecondPatternString;
    }

    private String hourSecondLiteralRegex() {
        return this.hourSecondLiteralRegex;
    }

    private String minutePatternString() {
        return this.minutePatternString;
    }

    private String minuteLiteralRegex() {
        return this.minuteLiteralRegex;
    }

    private String minuteSecondPatternString() {
        return this.minuteSecondPatternString;
    }

    private String minuteSecondLiteralRegex() {
        return this.minuteSecondLiteralRegex;
    }

    private String secondPatternString() {
        return this.secondPatternString;
    }

    private String secondLiteralRegex() {
        return this.secondLiteralRegex;
    }

    public ColumnVector castStringToDayTimeIntervalWithThrow(ColumnView cv, DataType t) {
        return this.castStringToDayTimeIntervalWithThrow(cv, (DayTimeIntervalType)t);
    }

    public ColumnVector castStringToDayTimeIntervalWithThrow(ColumnView cv, DayTimeIntervalType t) {
        return (ColumnVector)this.withResource(this.castStringToDTInterval(cv, t), (Function1 & Serializable & scala.Serializable)ret -> {
            if (ret.getNullCount() > cv.getNullCount()) {
                throw new IllegalArgumentException("Cast string to day time interval failed, may be the format is invalid, range check failed or overflow");
            }
            return ret.incRefCount();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColumnVector castStringToDTInterval(ColumnView cv, DayTimeIntervalType t) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)t.startField()), (Object)BoxesRunTime.boxToByte((byte)t.endField()));
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by2 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.DAY() == by2) {
                return (ColumnVector)this.withResource(cv.extractRe(this.dayLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromDayToDay((ColumnVector)sign, groupsTable.getColumn(2))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by3 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.HOUR() == by3) {
                return (ColumnVector)this.withResource(cv.extractRe(this.dayHourLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromDayToHour((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by4 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by4) {
                return (ColumnVector)this.withResource(cv.extractRe(this.dayMinuteLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromDayToMinute((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3), groupsTable.getColumn(4))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by5 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.SECOND() == by5) {
                return (ColumnVector)this.withResource(cv.extractRe(this.daySecondLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromDayToSecond((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3), groupsTable.getColumn(4), groupsTable.getColumn(5), groupsTable.getColumn(6))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by6 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.HOUR() == by6) {
                return (ColumnVector)this.withResource(cv.extractRe(this.hourLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromHourToHour((ColumnVector)sign, groupsTable.getColumn(2))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by7 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by7) {
                return (ColumnVector)this.withResource(cv.extractRe(this.hourMinuteLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromHourToMinute((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by8 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.SECOND() == by8) {
                return (ColumnVector)this.withResource(cv.extractRe(this.hourSecondLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromHourToSecond((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3), groupsTable.getColumn(4), groupsTable.getColumn(5))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by9 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.MINUTE() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by9) {
                return (ColumnVector)this.withResource(cv.extractRe(this.minuteLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromMinuteToMinute((ColumnVector)sign, groupsTable.getColumn(2))));
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte by10 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            if (DayTimeIntervalType$.MODULE$.MINUTE() == by && DayTimeIntervalType$.MODULE$.SECOND() == by10) {
                return (ColumnVector)this.withResource(cv.extractRe(this.minuteSecondLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromMinuteToSecond((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3), groupsTable.getColumn(4))));
            }
        }
        if (tuple2 == null) throw new RuntimeException(new StringBuilder(37).append("Not supported DayTimeIntervalType(").append(t.startField()).append(", ").append(t.endField()).append(")").toString());
        byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
        byte by11 = BoxesRunTime.unboxToByte((Object)tuple2._2());
        if (DayTimeIntervalType$.MODULE$.SECOND() != by) throw new RuntimeException(new StringBuilder(37).append("Not supported DayTimeIntervalType(").append(t.startField()).append(", ").append(t.endField()).append(")").toString());
        if (DayTimeIntervalType$.MODULE$.SECOND() != by11) throw new RuntimeException(new StringBuilder(37).append("Not supported DayTimeIntervalType(").append(t.startField()).append(", ").append(t.endField()).append(")").toString());
        return (ColumnVector)this.withResource(cv.extractRe(this.secondLiteralRegex()), (Function1 & Serializable & scala.Serializable)groupsTable -> (ColumnVector)MODULE$.withResource(MODULE$.finalSign(groupsTable.getColumn(0), groupsTable.getColumn(1)), (Function1 & Serializable & scala.Serializable)sign -> MODULE$.addFromSecondToSecond((ColumnVector)sign, groupsTable.getColumn(2), groupsTable.getColumn(3))));
    }

    private ColumnVector finalSign(ColumnVector firstSignInTable, ColumnVector secondSignInTable) {
        return (ColumnVector)this.withResource(Scalar.fromString((String)"-"), (Function1 & Serializable & scala.Serializable)negScalar -> (ColumnVector)MODULE$.withResource(negScalar.equalTo((BinaryOperable)firstSignInTable), (Function1 & Serializable & scala.Serializable)neg1 -> (ColumnVector)MODULE$.withResource(negScalar.equalTo((BinaryOperable)secondSignInTable), (Function1 & Serializable & scala.Serializable)neg2 -> (ColumnVector)MODULE$.withResource(neg1.bitXor((BinaryOperable)neg2), (Function1 & Serializable & scala.Serializable)s -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)1L), (Function1 & Serializable & scala.Serializable)one -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)-1L), (Function1 & Serializable & scala.Serializable)negOne -> s.ifElse(negOne, one)))))));
    }

    private ColumnVector getMicrosFromDecimal(ColumnVector sign, ColumnVector decimal2) {
        return (ColumnVector)this.withResource(decimal2.castTo(DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL64, (int)-6)), (Function1 & Serializable & scala.Serializable)decimal -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)1000000L), (Function1 & Serializable & scala.Serializable)million -> (ColumnVector)MODULE$.withResource(decimal.mul((BinaryOperable)million), (Function1 & Serializable & scala.Serializable)r -> (ColumnVector)MODULE$.withResource(r.asLongs(), (Function1 & Serializable & scala.Serializable)l -> l.mul((BinaryOperable)sign)))));
    }

    private ColumnVector addFromDayToDay(ColumnVector sign, ColumnVector daysInTable) {
        return this.daysToMicros(sign, daysInTable, this.MAX_DAY());
    }

    private ColumnVector addFromDayToHour(ColumnVector sign, ColumnVector daysInTable, ColumnVector hoursInTable) {
        return this.add(this.daysToMicros(sign, daysInTable, this.MAX_DAY()), this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR_IN_DAY()));
    }

    private ColumnVector addFromDayToMinute(ColumnVector sign, ColumnVector daysInTable, ColumnVector hoursInTable, ColumnVector minutesInTable) {
        return this.add(this.daysToMicros(sign, daysInTable, this.MAX_DAY()), this.add(this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR_IN_DAY()), this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE_IN_HOUR())));
    }

    private ColumnVector addFromDayToSecond(ColumnVector sign, ColumnVector daysInTable, ColumnVector hoursInTable, ColumnVector minutesInTable, ColumnVector secondsInTable, ColumnVector microsInTable) {
        return this.add(this.daysToMicros(sign, daysInTable, this.MAX_DAY()), this.add(this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR_IN_DAY()), this.add(this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE_IN_HOUR()), this.add(this.secondsToMicros(sign, secondsInTable), this.getMicrosFromDecimal(sign, microsInTable)))));
    }

    private ColumnVector addFromHourToHour(ColumnVector sign, ColumnVector hoursInTable) {
        return this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR());
    }

    private ColumnVector addFromHourToMinute(ColumnVector sign, ColumnVector hoursInTable, ColumnVector minutesInTable) {
        return this.add(this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR()), this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE_IN_HOUR()));
    }

    private ColumnVector addFromHourToSecond(ColumnVector sign, ColumnVector hoursInTable, ColumnVector minutesInTable, ColumnVector secondsInTable, ColumnVector microsInTable) {
        return this.add(this.hoursToMicros(sign, hoursInTable, this.MAX_HOUR()), this.add(this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE_IN_HOUR()), this.add(this.secondsToMicros(sign, secondsInTable), this.getMicrosFromDecimal(sign, microsInTable))));
    }

    private ColumnVector addFromMinuteToMinute(ColumnVector sign, ColumnVector minutesInTable) {
        return this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE());
    }

    private ColumnVector addFromMinuteToSecond(ColumnVector sign, ColumnVector minutesInTable, ColumnVector secondsInTable, ColumnVector microsInTable) {
        return this.add(this.minutesToMicros(sign, minutesInTable, this.MAX_MINUTE()), this.add(this.secondsToMicros(sign, secondsInTable), this.getMicrosFromDecimal(sign, microsInTable)));
    }

    private ColumnVector addFromSecondToSecond(ColumnVector sign, ColumnVector secondsInTable, ColumnVector microsInTable) {
        return this.add(this.secondsToMicros(sign, secondsInTable, this.MAX_SECOND()), this.getMicrosFromDecimal(sign, microsInTable));
    }

    private ColumnVector getOverflow(ColumnVector lhs, ColumnVector rhs, ColumnVector ret) {
        ColumnVector signCV = (ColumnVector)this.withResource(ret.bitXor((BinaryOperable)lhs), (Function1 & Serializable & scala.Serializable)lXor -> (ColumnVector)MODULE$.withResource(ret.bitXor((BinaryOperable)rhs), (Function1 & Serializable & scala.Serializable)rXor -> lXor.bitAnd((BinaryOperable)rXor)));
        return (ColumnVector)this.withResource(signCV, (Function1 & Serializable & scala.Serializable)sign -> (ColumnVector)MODULE$.withResource(Scalar.fromInt((int)0), (Function1 & Serializable & scala.Serializable)zero -> sign.lessThan((BinaryOperable)zero)));
    }

    private ColumnVector setNullIfOverflow(ColumnVector lhs, ColumnVector rhs, ColumnVector ret) {
        return (ColumnVector)this.withResource(this.getOverflow(lhs, rhs, ret), (Function1 & Serializable & scala.Serializable)overflow -> (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)DType.INT64), (Function1 & Serializable & scala.Serializable)nullScalar -> overflow.ifElse(nullScalar, (ColumnView)ret)));
    }

    private ColumnVector add(ColumnVector left, ColumnVector right) {
        return (ColumnVector)this.withResource(left, (Function1 & Serializable & scala.Serializable)l -> (ColumnVector)MODULE$.withResource(right, (Function1 & Serializable & scala.Serializable)r -> (ColumnVector)MODULE$.withResource(l.add((BinaryOperable)r), (Function1 & Serializable & scala.Serializable)result -> MODULE$.setNullIfOverflow((ColumnVector)l, (ColumnVector)r, (ColumnVector)result))));
    }

    private ColumnVector daysToMicros(ColumnVector sign, ColumnVector daysInGroupTable, long maxDay) {
        return this.multiple(sign, daysInGroupTable, TimeUnit.DAYS.toMicros(1L), maxDay);
    }

    private ColumnVector hoursToMicros(ColumnVector sign, ColumnVector hoursInGroupTable, long maxHour) {
        return this.multiple(sign, hoursInGroupTable, TimeUnit.HOURS.toMicros(1L), maxHour);
    }

    private ColumnVector minutesToMicros(ColumnVector sign, ColumnVector minutesInGroupTable, long maxMinute) {
        return this.multiple(sign, minutesInGroupTable, TimeUnit.MINUTES.toMicros(1L), maxMinute);
    }

    private ColumnVector secondsToMicros(ColumnVector sign, ColumnVector secondsInGroupTable, long maxSecond) {
        return this.multiple(sign, secondsInGroupTable, TimeUnit.SECONDS.toMicros(1L), maxSecond);
    }

    private ColumnVector secondsToMicros(ColumnVector sign, ColumnVector secondsInGroupTable) {
        return this.multiple(sign, secondsInGroupTable, TimeUnit.SECONDS.toMicros(1L));
    }

    private ColumnVector multiple(ColumnVector sign, ColumnVector base, long multiple, long maxInBase) {
        ColumnVector baseWithFixCv = (ColumnVector)this.withResource(Scalar.fromLong((long)maxInBase), (Function1 & Serializable & scala.Serializable)maxScalar -> (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)DType.INT64), (Function1 & Serializable & scala.Serializable)nullScalar -> (ColumnVector)MODULE$.withResource(base.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)baseLong -> (ColumnVector)MODULE$.withResource(baseLong.greaterThan((BinaryOperable)maxScalar), (Function1 & Serializable & scala.Serializable)greater2 -> greater2.ifElse(nullScalar, (ColumnView)baseLong)))));
        ColumnVector baseWithSignCv = (ColumnVector)this.withResource(baseWithFixCv, (Function1 & Serializable & scala.Serializable)baseWithFix -> baseWithFix.mul((BinaryOperable)sign));
        return (ColumnVector)this.withResource(baseWithSignCv, (Function1 & Serializable & scala.Serializable)baseWithSign -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)multiple), (Function1 & Serializable & scala.Serializable)multipleScalar -> baseWithSign.mul((BinaryOperable)multipleScalar)));
    }

    private ColumnVector multiple(ColumnVector sign, ColumnVector groupInTable, long multiple) {
        ColumnVector baseWithSignCv = (ColumnVector)this.withResource(groupInTable.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)baseLong -> baseLong.mul((BinaryOperable)sign));
        return (ColumnVector)this.withResource(baseWithSignCv, (Function1 & Serializable & scala.Serializable)baseWithSign -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)multiple), (Function1 & Serializable & scala.Serializable)multipleScalar -> baseWithSign.mul((BinaryOperable)multipleScalar)));
    }

    public ColumnVector toDayTimeIntervalString(ColumnView micros, DataType dayTimeType) {
        DayTimeIntervalType t = (DayTimeIntervalType)dayTimeType;
        return this.toDayTimeIntervalString(micros, t.startField(), t.endField());
    }

    public ColumnVector toDayTimeIntervalString(ColumnView micros, byte startField, byte endField) {
        long numRows = micros.getRowCount();
        String from = DayTimeIntervalType$.MODULE$.fieldToString(startField).toUpperCase();
        String to = DayTimeIntervalType$.MODULE$.fieldToString(endField).toUpperCase();
        String postfixStr = new StringBuilder(2).append("' ").append((Object)(startField == endField ? from : new StringBuilder(4).append(from).append(" TO ").append(to).toString())).toString();
        ColumnVector retCv = (ColumnVector)this.withResource(new ArrayBuffer(), (Function1 & Serializable & scala.Serializable)parts -> {
            parts.$plus$eq(MODULE$.withResource(Scalar.fromLong((long)0L), (Function1 & Serializable & scala.Serializable)zero -> (ColumnVector)MODULE$.withResource(micros.lessThan((BinaryOperable)zero), (Function1 & Serializable & scala.Serializable)less -> (ColumnVector)MODULE$.withResource(Scalar.fromString((String)new StringBuilder(1).append(MODULE$.prefixStr()).append("-").toString()), (Function1 & Serializable & scala.Serializable)negPrefix -> (ColumnVector)MODULE$.withResource(Scalar.fromString((String)MODULE$.prefixStr()), (Function1 & Serializable & scala.Serializable)prefix -> less.ifElse(negPrefix, prefix))))));
            return (ColumnVector)MODULE$.withResource(new CloseableHolder<ColumnVector>(micros.abs()), (Function1 & Serializable & scala.Serializable)restHolder -> {
                ArrayBuffer<ColumnView> arrayBuffer;
                BoxedUnit boxedUnit;
                byte by = startField;
                if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                    parts.$plus$eq((Object)MODULE$.divResult((ColumnVector)restHolder.get(), 86400000000L));
                    restHolder.setAndCloseOld(MODULE$.getRest((ColumnVector)restHolder.get(), 86400000000L));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                    parts.$plus$eq((Object)MODULE$.divResultWithPadding((ColumnVector)restHolder.get(), 3600000000L));
                    restHolder.setAndCloseOld(MODULE$.getRest((ColumnVector)restHolder.get(), 3600000000L));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                    parts.$plus$eq((Object)MODULE$.divResultWithPadding((ColumnVector)restHolder.get(), 60000000L));
                    restHolder.setAndCloseOld(MODULE$.getRest((ColumnVector)restHolder.get(), 60000000L));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                    boxedUnit = MODULE$.addDecimalParts((ColumnVector)restHolder.get(), (ArrayBuffer<ColumnView>)parts);
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
                if (startField < DayTimeIntervalType$.MODULE$.HOUR() && DayTimeIntervalType$.MODULE$.HOUR() <= endField) {
                    parts.$plus$eq((Object)MODULE$.getConstStringVector(" ", numRows));
                    parts.$plus$eq((Object)MODULE$.divResultWithPadding((ColumnVector)restHolder.get(), 3600000000L));
                    restHolder.setAndCloseOld(MODULE$.getRest((ColumnVector)restHolder.get(), 3600000000L));
                }
                if (startField < DayTimeIntervalType$.MODULE$.MINUTE() && DayTimeIntervalType$.MODULE$.MINUTE() <= endField) {
                    parts.$plus$eq((Object)MODULE$.getConstStringVector(":", numRows));
                    parts.$plus$eq((Object)MODULE$.divResultWithPadding((ColumnVector)restHolder.get(), 60000000L));
                    restHolder.setAndCloseOld(MODULE$.getRest((ColumnVector)restHolder.get(), 60000000L));
                }
                if (startField < DayTimeIntervalType$.MODULE$.SECOND() && DayTimeIntervalType$.MODULE$.SECOND() <= endField) {
                    parts.$plus$eq((Object)MODULE$.getConstStringVector(":", numRows));
                    arrayBuffer = MODULE$.addDecimalParts((ColumnVector)restHolder.get(), (ArrayBuffer<ColumnView>)parts);
                } else {
                    arrayBuffer = BoxedUnit.UNIT;
                }
                parts.$plus$eq((Object)MODULE$.getConstStringVector(postfixStr, numRows));
                return ColumnVector.stringConcatenate((ColumnView[])((ColumnView[])parts.toArray(ClassTag$.MODULE$.apply(ColumnView.class))));
            });
        });
        return (ColumnVector)this.withResource(retCv, (Function1 & Serializable & scala.Serializable)ret -> {
            String string;
            String string2;
            byte by = startField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                string2 = new StringBuilder(1).append("-").append(MODULE$.MAX_DAY()).toString();
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                string2 = new StringBuilder(1).append("-").append(MODULE$.MAX_HOUR()).toString();
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                string2 = new StringBuilder(1).append("-").append(MODULE$.MAX_MINUTE()).toString();
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                string2 = new StringBuilder(8).append("-").append(MODULE$.MAX_SECOND()).append(".775808").toString();
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            String firstStr = string2;
            if (startField == endField) {
                string = "";
            } else {
                int n;
                int n2;
                byte by2 = startField;
                if (DayTimeIntervalType$.MODULE$.DAY() == by2) {
                    n2 = 10;
                } else if (DayTimeIntervalType$.MODULE$.HOUR() == by2) {
                    n2 = 13;
                } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by2) {
                    n2 = 16;
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
                }
                int substrStart = n2;
                byte by3 = endField;
                if (DayTimeIntervalType$.MODULE$.HOUR() == by3) {
                    n = 13;
                } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by3) {
                    n = 16;
                } else if (DayTimeIntervalType$.MODULE$.SECOND() == by3) {
                    n = 26;
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by3));
                }
                int substrEnd = n;
                string = MODULE$.minLongBaseStr().substring(substrStart, substrEnd);
            }
            String followingStr = string;
            String minStr = new StringBuilder(0).append(MODULE$.prefixStr()).append(firstStr).append(followingStr).append(postfixStr).toString();
            return (ColumnVector)MODULE$.withResource(Scalar.fromString((String)minStr), (Function1 & Serializable & scala.Serializable)minStrScalar -> (ColumnVector)MODULE$.withResource(Scalar.fromLong((long)Long.MIN_VALUE), (Function1 & Serializable & scala.Serializable)minS -> (ColumnVector)MODULE$.withResource(micros.equalTo((BinaryOperable)minS), (Function1 & Serializable & scala.Serializable)eq -> eq.ifElse(minStrScalar, (ColumnView)ret))));
        });
    }

    private ColumnVector divResult(ColumnVector micros, long div) {
        return (ColumnVector)this.withResource(Scalar.fromLong((long)div), (Function1 & Serializable & scala.Serializable)divS -> (ColumnVector)MODULE$.withResource(micros.div((BinaryOperable)divS), (Function1 & Serializable & scala.Serializable)ret -> ret.castTo(DType.STRING)));
    }

    private ColumnVector divResultWithPadding(ColumnVector micros, long div) {
        return (ColumnVector)this.withResource(this.divResult(micros, div), (Function1 & Serializable & scala.Serializable)s -> s.zfill(2));
    }

    private ColumnVector getRest(ColumnVector micros, long div) {
        return (ColumnVector)this.withResource(Scalar.fromLong((long)div), (Function1 & Serializable & scala.Serializable)divS -> micros.mod((BinaryOperable)divS));
    }

    private ColumnVector getConstStringVector(String s, long numRows) {
        return (ColumnVector)this.withResource(Scalar.fromString((String)s), (Function1 & Serializable & scala.Serializable)scalar -> ColumnVector.fromScalar((Scalar)scalar, (int)((int)numRows)));
    }

    private ArrayBuffer<ColumnView> addDecimalParts(ColumnVector rest, ArrayBuffer<ColumnView> parts) {
        this.withResource(Scalar.fromString((String)"0"), (Function1 & Serializable & scala.Serializable)padZero -> (ArrayBuffer)MODULE$.withResource(Scalar.fromString((String)""), (Function1 & Serializable & scala.Serializable)empty -> parts.$plus$eq(MODULE$.withResource(Scalar.fromLong((long)10000000L), (Function1 & Serializable & scala.Serializable)tenSeconds -> (ColumnVector)MODULE$.withResource(rest.lessThan((BinaryOperable)tenSeconds), (Function1 & Serializable & scala.Serializable)lessThan10 -> lessThan10.ifElse(padZero, empty))))));
        DType decimalType = DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)-6);
        BigInteger microsPerSecondBigInt = new BigInteger(Long.toString(1000000L));
        ColumnVector decimalStrCv = (ColumnVector)this.withResource(rest.castTo(decimalType), (Function1 & Serializable & scala.Serializable)decimal -> (ColumnVector)MODULE$.withResource(Scalar.fromDecimal((int)0, (BigInteger)microsPerSecondBigInt), (Function1 & Serializable & scala.Serializable)microsPerSecond -> (ColumnVector)MODULE$.withResource(decimal.div((BinaryOperable)microsPerSecond), (Function1 & Serializable & scala.Serializable)r -> r.castTo(DType.STRING))));
        ColumnVector stripedCv = (ColumnVector)this.withResource(decimalStrCv, (Function1 & Serializable & scala.Serializable)decimalStr -> (ColumnVector)MODULE$.withResource(Scalar.fromString((String)"0"), (Function1 & Serializable & scala.Serializable)zero -> decimalStr.rstrip(zero)));
        return parts.$plus$eq(this.withResource(stripedCv, (Function1 & Serializable & scala.Serializable)striped -> (ColumnVector)MODULE$.withResource(Scalar.fromString((String)"."), (Function1 & Serializable & scala.Serializable)dot -> striped.rstrip(dot))));
    }

    public ColumnVector dayTimeIntervalToLong(ColumnView dtCv, DataType dt) {
        ColumnVector columnVector;
        byte by = ((DayTimeIntervalType)dt).endField();
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)86400000000L), (Function1 & Serializable & scala.Serializable)micros -> dtCv.div((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)3600000000L), (Function1 & Serializable & scala.Serializable)micros -> dtCv.div((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)60000000L), (Function1 & Serializable & scala.Serializable)micros -> dtCv.div((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)1000000L), (Function1 & Serializable & scala.Serializable)micros -> dtCv.div((BinaryOperable)micros));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return columnVector;
    }

    public ColumnVector dayTimeIntervalToInt(ColumnView dtCv, DataType dt) {
        return (ColumnVector)this.withResource(this.dayTimeIntervalToLong(dtCv, dt), (Function1 & Serializable & scala.Serializable)longCv -> MODULE$.castToTargetWithOverflowCheck((ColumnView)longCv, DType.INT32));
    }

    public ColumnVector dayTimeIntervalToShort(ColumnView dtCv, DataType dt) {
        return (ColumnVector)this.withResource(this.dayTimeIntervalToLong(dtCv, dt), (Function1 & Serializable & scala.Serializable)longCv -> MODULE$.castToTargetWithOverflowCheck((ColumnView)longCv, DType.INT16));
    }

    public ColumnVector dayTimeIntervalToByte(ColumnView dtCv, DataType dt) {
        return (ColumnVector)this.withResource(this.dayTimeIntervalToLong(dtCv, dt), (Function1 & Serializable & scala.Serializable)longCv -> MODULE$.castToTargetWithOverflowCheck((ColumnView)longCv, DType.INT8));
    }

    public ColumnVector yearMonthIntervalToLong(ColumnView ymCv, DataType ym) {
        ColumnVector columnVector;
        byte by = ((YearMonthIntervalType)ym).endField();
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)12L), (Function1 & Serializable & scala.Serializable)monthsPerYear -> ymCv.div((BinaryOperable)monthsPerYear));
        } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            columnVector = ymCv.castTo(DType.INT64);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return columnVector;
    }

    public ColumnVector yearMonthIntervalToInt(ColumnView ymCv, DataType ym) {
        ColumnVector columnVector;
        byte by = ((YearMonthIntervalType)ym).endField();
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromInt((int)12), (Function1 & Serializable & scala.Serializable)monthsPerYear -> ymCv.div((BinaryOperable)monthsPerYear));
        } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            columnVector = ymCv.copyToColumnVector();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return columnVector;
    }

    public ColumnVector yearMonthIntervalToShort(ColumnView ymCv, DataType ym) {
        return (ColumnVector)this.withResource(this.yearMonthIntervalToInt(ymCv, ym), (Function1 & Serializable & scala.Serializable)i -> MODULE$.castToTargetWithOverflowCheck((ColumnView)i, DType.INT16));
    }

    public ColumnVector yearMonthIntervalToByte(ColumnView ymCv, DataType ym) {
        return (ColumnVector)this.withResource(this.yearMonthIntervalToInt(ymCv, ym), (Function1 & Serializable & scala.Serializable)i -> MODULE$.castToTargetWithOverflowCheck((ColumnView)i, DType.INT8));
    }

    private ColumnVector castToTargetWithOverflowCheck(ColumnView cv, DType dType) {
        return (ColumnVector)this.withResource(cv.castTo(dType), (Function1 & Serializable & scala.Serializable)retTarget -> (ColumnVector)MODULE$.withResource(cv.notEqualTo((BinaryOperable)retTarget), (Function1 & Serializable & scala.Serializable)notEqual -> {
            if (BoolUtils$.MODULE$.isAnyValidTrue((ColumnVector)notEqual)) {
                throw new ArithmeticException(new StringBuilder(32).append("overflow occurs when casting to ").append(dType).toString());
            }
            return retTarget.incRefCount();
        }));
    }

    public ColumnVector longToDayTimeInterval(ColumnView longCv, DataType dt) {
        Scalar scalar;
        byte by = ((DayTimeIntervalType)dt).endField();
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            scalar = Scalar.fromLong((long)86400000000L);
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            scalar = Scalar.fromLong((long)3600000000L);
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            scalar = Scalar.fromLong((long)60000000L);
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            scalar = Scalar.fromLong((long)1000000L);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        Scalar microsScalar = scalar;
        return (ColumnVector)this.withResource(microsScalar, (Function1 & Serializable & scala.Serializable)micros -> IntervalUtils$.MODULE$.multipleToLongWithOverflowCheck((BinaryOperable)longCv, (BinaryOperable)micros));
    }

    public ColumnVector intToDayTimeInterval(ColumnView intCv, DataType dt) {
        ColumnVector columnVector;
        byte by = ((DayTimeIntervalType)dt).endField();
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)86400000000L), (Function1 & Serializable & scala.Serializable)micros -> intCv.getType().equals((Object)DType.INT32) ? IntervalUtils$.MODULE$.multipleToLongWithOverflowCheck((BinaryOperable)intCv, (BinaryOperable)micros) : intCv.mul((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)3600000000L), (Function1 & Serializable & scala.Serializable)micros -> intCv.mul((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)60000000L), (Function1 & Serializable & scala.Serializable)micros -> intCv.mul((BinaryOperable)micros));
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)1000000L), (Function1 & Serializable & scala.Serializable)micros -> intCv.mul((BinaryOperable)micros));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return columnVector;
    }

    public ColumnVector longToYearMonthInterval(ColumnView longCv, DataType ym) {
        ColumnVector columnVector;
        byte by = ((YearMonthIntervalType)ym).endField();
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            columnVector = (ColumnVector)this.withResource(Scalar.fromLong((long)12L), (Function1 & Serializable & scala.Serializable)num12 -> IntervalUtils$.MODULE$.multipleToIntWithOverflowCheck((BinaryOperable)longCv, (BinaryOperable)num12));
        } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            columnVector = IntervalUtils$.MODULE$.castLongToIntWithOverflowCheck(longCv);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return columnVector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColumnVector intToYearMonthInterval(ColumnView intCv, DataType ym) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)((YearMonthIntervalType)ym).endField()), (Object)intCv.getType());
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            DType dType = (DType)tuple2._2();
            if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
                DType dType2 = DType.INT32;
                DType dType3 = dType;
                if (dType2 == null) {
                    if (dType3 == null) return (ColumnVector)this.withResource(Scalar.fromInt((int)12), (Function1 & Serializable & scala.Serializable)num12 -> IntervalUtils$.MODULE$.multipleToIntWithOverflowCheck((BinaryOperable)intCv, (BinaryOperable)num12));
                } else if (dType2.equals(dType3)) {
                    return (ColumnVector)this.withResource(Scalar.fromInt((int)12), (Function1 & Serializable & scala.Serializable)num12 -> IntervalUtils$.MODULE$.multipleToIntWithOverflowCheck((BinaryOperable)intCv, (BinaryOperable)num12));
                }
            }
        }
        if (tuple2 != null) {
            byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
            DType dType = (DType)tuple2._2();
            if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
                boolean bl;
                DType dType4 = DType.INT16;
                DType dType5 = dType;
                if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                    bl = true;
                } else {
                    DType dType6 = DType.INT8;
                    DType dType7 = dType;
                    bl = !(dType6 != null ? !dType6.equals(dType7) : dType7 != null);
                }
                if (bl) {
                    return (ColumnVector)this.withResource(Scalar.fromInt((int)12), (Function1 & Serializable & scala.Serializable)num12 -> intCv.mul((BinaryOperable)num12));
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
        if (YearMonthIntervalType$.MODULE$.MONTH() != by) throw new MatchError((Object)tuple2);
        return intCv.castTo(DType.INT32);
    }

    private GpuIntervalUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.MAX_DAY = Long.MAX_VALUE / TimeUnit.DAYS.toMicros(1L);
        this.MAX_HOUR = Long.MAX_VALUE / TimeUnit.HOURS.toMicros(1L);
        this.MAX_MINUTE = Long.MAX_VALUE / TimeUnit.MINUTES.toMicros(1L);
        this.MAX_SECOND = Long.MAX_VALUE / TimeUnit.SECONDS.toMicros(1L);
        this.MAX_HOUR_IN_DAY = 23L;
        this.MAX_MINUTE_IN_HOUR = 59L;
        this.prefixStr = "INTERVAL '";
        this.minLongBaseStr = "-106751991 04:00:54.775808000";
        this.INTERVAL = "[iI][nN][tT][eE][rR][vV][aA][lL]";
        this.DAY = "[dD][aA][yY]";
        this.HOUR = "[hH][oO][uU][rR]";
        this.MINUTE = "[mM][iI][nN][uU][tT][eE]";
        this.SECOND = "[sS][eE][cC][oO][nN][dD]";
        this.TO = "[tT][oO]";
        this.sign = "([+\\-])?";
        this.blanks = "\\s+";
        this.normalPattern = "(\\d{1,2})";
        this.dayBoundPattern = "(\\d{1,9})";
        this.hourBoundPattern = "(\\d{1,10})";
        this.minuteBoundPattern = "(\\d{1,12})";
        this.secondBoundPattern = "(\\d{1,13})";
        this.microPattern = "(\\.\\d{1,9})?";
        this.dayPatternString = new StringBuilder(0).append(this.sign()).append(this.dayBoundPattern()).toString();
        this.dayLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.dayPatternString()).append("'").append(this.blanks()).append(this.DAY()).append("$").toString();
        this.dayHourPatternString = new StringBuilder(1).append(this.sign()).append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).toString();
        this.dayHourLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.dayHourPatternString()).append("'").append(this.blanks()).append(this.DAY()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.HOUR()).append("$").toString();
        this.dayMinutePatternString = new StringBuilder(2).append(this.sign()).append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).toString();
        this.dayMinuteLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.dayMinutePatternString()).append("'").append(this.blanks()).append(this.DAY()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.MINUTE()).append("$").toString();
        this.daySecondPatternString = new StringBuilder(3).append(this.sign()).append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).toString();
        this.daySecondLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.daySecondPatternString()).append("'").append(this.blanks()).append(this.DAY()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.SECOND()).append("$").toString();
        this.hourPatternString = new StringBuilder(0).append(this.sign()).append(this.hourBoundPattern()).toString();
        this.hourLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.hourPatternString()).append("'").append(this.blanks()).append(this.HOUR()).append("$").toString();
        this.hourMinutePatternString = new StringBuilder(1).append(this.sign()).append(this.hourBoundPattern()).append(":").append(this.normalPattern()).toString();
        this.hourMinuteLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.hourMinutePatternString()).append("'").append(this.blanks()).append(this.HOUR()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.MINUTE()).append("$").toString();
        this.hourSecondPatternString = new StringBuilder(2).append(this.sign()).append(this.hourBoundPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).toString();
        this.hourSecondLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.hourSecondPatternString()).append("'").append(this.blanks()).append(this.HOUR()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.SECOND()).append("$").toString();
        this.minutePatternString = new StringBuilder(0).append(this.sign()).append(this.minuteBoundPattern()).toString();
        this.minuteLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.minutePatternString()).append("'").append(this.blanks()).append(this.MINUTE()).append("$").toString();
        this.minuteSecondPatternString = new StringBuilder(1).append(this.sign()).append(this.minuteBoundPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).toString();
        this.minuteSecondLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.minuteSecondPatternString()).append("'").append(this.blanks()).append(this.MINUTE()).append(this.blanks()).append(this.TO()).append(this.blanks()).append(this.SECOND()).append("$").toString();
        this.secondPatternString = new StringBuilder(0).append(this.sign()).append(this.secondBoundPattern()).append(this.microPattern()).toString();
        this.secondLiteralRegex = new StringBuilder(4).append("^").append(this.INTERVAL()).append(this.blanks()).append(this.sign()).append("'").append(this.secondPatternString()).append("'").append(this.blanks()).append(this.SECOND()).append("$").toString();
    }
}

