/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark.source;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseDataReader<T>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDataReader.class);
    private final Table table;
    private final Iterator<FileScanTask> tasks;
    private final Map<String, InputFile> inputFiles;
    private CloseableIterator<T> currentIterator;
    private T current = null;
    private FileScanTask currentTask = null;

    BaseDataReader(Table table, CombinedScanTask task) {
        this.table = table;
        this.tasks = task.files().iterator();
        HashMap keyMetadata = Maps.newHashMap();
        task.files().stream().flatMap(fileScanTask -> Stream.concat(Stream.of(fileScanTask.file()), fileScanTask.deletes().stream())).forEach(file -> keyMetadata.put(file.path().toString(), file.keyMetadata()));
        Stream<EncryptedInputFile> encrypted = keyMetadata.entrySet().stream().map(entry -> EncryptedFiles.encryptedInput((InputFile)table.io().newInputFile((String)entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue())));
        Iterable decryptedFiles = table.encryption().decrypt(encrypted::iterator);
        HashMap files = Maps.newHashMapWithExpectedSize((int)task.files().size());
        decryptedFiles.forEach(decrypted -> files.putIfAbsent(decrypted.location(), decrypted));
        this.inputFiles = ImmutableMap.copyOf((Map)files);
        this.currentIterator = CloseableIterator.empty();
    }

    protected Table table() {
        return this.table;
    }

    public boolean next() throws IOException {
        try {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    this.current = this.currentIterator.next();
                    return true;
                }
                if (!this.tasks.hasNext()) break;
                this.currentIterator.close();
                this.currentTask = this.tasks.next();
                this.currentIterator = this.open(this.currentTask);
            }
            this.currentIterator.close();
            return false;
        }
        catch (IOException | RuntimeException e) {
            if (this.currentTask != null && !this.currentTask.isDataTask()) {
                LOG.error("Error reading file: {}", (Object)this.getInputFile(this.currentTask).location(), (Object)e);
            }
            throw e;
        }
    }

    public T get() {
        return this.current;
    }

    abstract CloseableIterator<T> open(FileScanTask var1);

    @Override
    public void close() throws IOException {
        InputFileBlockHolder.unset();
        this.currentIterator.close();
        while (this.tasks.hasNext()) {
            this.tasks.next();
        }
    }

    protected InputFile getInputFile(FileScanTask task) {
        Preconditions.checkArgument((!task.isDataTask() ? 1 : 0) != 0, (Object)"Invalid task type");
        return this.inputFiles.get(task.file().path().toString());
    }

    protected InputFile getInputFile(String location) {
        return this.inputFiles.get(location);
    }

    protected Map<Integer, ?> constantsMap(FileScanTask task, Schema readSchema) {
        if (readSchema.findField(0x7FFFFFFA) != null) {
            Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
            return PartitionUtil.constantsMap((FileScanTask)task, (Types.StructType)partitionType, BaseDataReader::convertConstant);
        }
        return PartitionUtil.constantsMap((FileScanTask)task, BaseDataReader::convertConstant);
    }

    protected static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case DECIMAL: {
                return Decimal.apply((BigDecimal)((BigDecimal)value));
            }
            case STRING: {
                if (value instanceof Utf8) {
                    Utf8 utf8 = (Utf8)value;
                    return UTF8String.fromBytes((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
                }
                return UTF8String.fromString((String)value.toString());
            }
            case FIXED: {
                if (value instanceof byte[]) {
                    return value;
                }
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)type;
                if (structType.fields().isEmpty()) {
                    return new GenericInternalRow();
                }
                List fields = structType.fields();
                Object[] values = new Object[fields.size()];
                StructLike struct = (StructLike)value;
                for (int index = 0; index < fields.size(); ++index) {
                    Types.NestedField field = (Types.NestedField)fields.get(index);
                    Type fieldType = field.type();
                    values[index] = BaseDataReader.convertConstant(fieldType, struct.get(index, fieldType.typeId().javaClass()));
                }
                return new GenericInternalRow(values);
            }
        }
        return value;
    }
}

