/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;

public class SparkConfParser {
    private final Map<String, String> properties;
    private final RuntimeConfig sessionConf;
    private final Map<String, String> options;

    SparkConfParser(SparkSession spark, Table table, Map<String, String> options) {
        this.properties = table.properties();
        this.sessionConf = spark.conf();
        this.options = options;
    }

    public BooleanConfParser booleanConf() {
        return new BooleanConfParser();
    }

    public IntConfParser intConf() {
        return new IntConfParser();
    }

    public LongConfParser longConf() {
        return new LongConfParser();
    }

    public StringConfParser stringConf() {
        return new StringConfParser();
    }

    abstract class ConfParser<ThisT, T> {
        private final List<String> optionNames = Lists.newArrayList();
        private String sessionConfName;
        private String tablePropertyName;

        ConfParser() {
        }

        protected abstract ThisT self();

        public ThisT option(String name) {
            this.optionNames.add(name);
            return this.self();
        }

        public ThisT sessionConf(String name) {
            this.sessionConfName = name;
            return this.self();
        }

        public ThisT tableProperty(String name) {
            this.tablePropertyName = name;
            return this.self();
        }

        protected T parse(Function<String, T> conversion, T defaultValue) {
            String propertyValue;
            String sessionConfValue;
            if (!this.optionNames.isEmpty()) {
                for (String optionName : this.optionNames) {
                    String optionValue = (String)SparkConfParser.this.options.get(optionName.toLowerCase(Locale.ROOT));
                    if (optionValue == null) continue;
                    return conversion.apply(optionValue);
                }
            }
            if (this.sessionConfName != null && (sessionConfValue = SparkConfParser.this.sessionConf.get(this.sessionConfName, null)) != null) {
                return conversion.apply(sessionConfValue);
            }
            if (this.tablePropertyName != null && (propertyValue = (String)SparkConfParser.this.properties.get(this.tablePropertyName)) != null) {
                return conversion.apply(propertyValue);
            }
            return defaultValue;
        }
    }

    class StringConfParser
    extends ConfParser<StringConfParser, String> {
        private String defaultValue;

        StringConfParser() {
        }

        @Override
        protected StringConfParser self() {
            return this;
        }

        public StringConfParser defaultValue(String value) {
            this.defaultValue = value;
            return this.self();
        }

        public String parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Function.identity(), this.defaultValue);
        }

        public String parseOptional() {
            return this.parse(Function.identity(), null);
        }
    }

    class LongConfParser
    extends ConfParser<LongConfParser, Long> {
        private Long defaultValue;

        LongConfParser() {
        }

        @Override
        protected LongConfParser self() {
            return this;
        }

        public LongConfParser defaultValue(long value) {
            this.defaultValue = value;
            return this.self();
        }

        public long parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Long::parseLong, this.defaultValue);
        }

        public Long parseOptional() {
            return this.parse(Long::parseLong, null);
        }
    }

    class IntConfParser
    extends ConfParser<IntConfParser, Integer> {
        private Integer defaultValue;

        IntConfParser() {
        }

        @Override
        protected IntConfParser self() {
            return this;
        }

        public IntConfParser defaultValue(int value) {
            this.defaultValue = value;
            return this.self();
        }

        public int parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Integer::parseInt, this.defaultValue);
        }

        public Integer parseOptional() {
            return this.parse(Integer::parseInt, null);
        }
    }

    class BooleanConfParser
    extends ConfParser<BooleanConfParser, Boolean> {
        private Boolean defaultValue;

        BooleanConfParser() {
        }

        @Override
        protected BooleanConfParser self() {
            return this;
        }

        public BooleanConfParser defaultValue(boolean value) {
            this.defaultValue = value;
            return this.self();
        }

        public BooleanConfParser defaultValue(String value) {
            this.defaultValue = Boolean.parseBoolean(value);
            return this.self();
        }

        public boolean parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Boolean::parseBoolean, this.defaultValue);
        }
    }
}

