/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.google.flatbuffers.FlatBufferBuilder;
import com.nvidia.spark.rapids.DirectByteBufferFactory;
import com.nvidia.spark.rapids.format.BlockIdMeta;
import com.nvidia.spark.rapids.format.BufferMeta;
import com.nvidia.spark.rapids.format.BufferTransferRequest;
import com.nvidia.spark.rapids.format.BufferTransferResponse;
import com.nvidia.spark.rapids.format.CodecBufferDescriptor;
import com.nvidia.spark.rapids.format.MetadataRequest;
import com.nvidia.spark.rapids.format.MetadataResponse;
import com.nvidia.spark.rapids.format.TableMeta;
import com.nvidia.spark.rapids.format.TransferRequest;
import com.nvidia.spark.rapids.format.TransferResponse;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ShuffleMetadata$
implements Logging {
    public static ShuffleMetadata$ MODULE$;
    private final DirectByteBufferFactory bbFactory;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ShuffleMetadata$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DirectByteBufferFactory bbFactory() {
        return this.bbFactory;
    }

    private int copyBufferMeta(FlatBufferBuilder fbb, BufferMeta buffMeta) {
        IndexedSeq descrOffsets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffMeta.codecBufferDescrsLength()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> {
            CodecBufferDescriptor descr = buffMeta.codecBufferDescrs(i);
            return CodecBufferDescriptor.createCodecBufferDescriptor(fbb, descr.codec(), descr.compressedOffset(), descr.compressedSize(), descr.uncompressedOffset(), descr.uncompressedSize());
        }, IndexedSeq$.MODULE$.canBuildFrom());
        None$ codecDescrArrayOffset = descrOffsets.nonEmpty() ? new Some((Object)BoxesRunTime.boxToInteger((int)BufferMeta.createCodecBufferDescrsVector(fbb, (int[])descrOffsets.toArray(ClassTag$.MODULE$.Int())))) : None$.MODULE$;
        BufferMeta.startBufferMeta(fbb);
        BufferMeta.addId(fbb, buffMeta.id());
        BufferMeta.addSize(fbb, buffMeta.size());
        BufferMeta.addUncompressedSize(fbb, buffMeta.uncompressedSize());
        codecDescrArrayOffset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)off -> BufferMeta.addCodecBufferDescrs(fbb, off));
        return BufferMeta.endBufferMeta(fbb);
    }

    public int[] copyTables(FlatBufferBuilder fbb, Seq<TableMeta> tables) {
        return (int[])((TraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)tableMeta -> BoxesRunTime.boxToInteger((int)ShuffleMetadata$.$anonfun$copyTables$1(fbb, tableMeta)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public ByteBuffer buildMetaResponse(Seq<TableMeta> tables) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024, (FlatBufferBuilder.ByteBufferFactory)this.bbFactory());
        int[] tableOffsets = this.copyTables(fbb, tables);
        int tableMetasOffset = MetadataResponse.createTableMetasVector(fbb, tableOffsets);
        int finIndex = MetadataResponse.createMetadataResponse(fbb, tableMetasOffset);
        fbb.finish(finIndex);
        return fbb.dataBuffer();
    }

    public ByteBuffer buildShuffleMetadataRequest(Seq<ShuffleBlockBatchId> blockIds) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024, (FlatBufferBuilder.ByteBufferFactory)this.bbFactory());
        Seq blockIdOffsets = (Seq)blockIds.map((Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToInteger((int)ShuffleMetadata$.$anonfun$buildShuffleMetadataRequest$1(fbb, blockId)), Seq$.MODULE$.canBuildFrom());
        int blockIdVectorOffset = MetadataRequest.createBlockIdsVector(fbb, (int[])blockIdOffsets.toArray(ClassTag$.MODULE$.Int()));
        int finIndex = MetadataRequest.createMetadataRequest(fbb, blockIdVectorOffset);
        fbb.finish(finIndex);
        return fbb.dataBuffer();
    }

    public FlatBufferBuilder getBuilder() {
        return new FlatBufferBuilder(1024, (FlatBufferBuilder.ByteBufferFactory)this.bbFactory());
    }

    public FlatBufferBuilder getHeapBuilder() {
        return new FlatBufferBuilder(1024);
    }

    public MetadataRequest getMetadataRequest(ByteBuffer byteBuffer) {
        return MetadataRequest.getRootAsMetadataRequest(byteBuffer);
    }

    public MetadataResponse getMetadataResponse(ByteBuffer byteBuffer) {
        return MetadataResponse.getRootAsMetadataResponse(byteBuffer);
    }

    public TransferResponse getTransferResponse(ByteBuffer resp) {
        return TransferResponse.getRootAsTransferResponse(resp);
    }

    public TransferRequest getTransferRequest(ByteBuffer transferRequest) {
        return TransferRequest.getRootAsTransferRequest(transferRequest);
    }

    public int buildBufferTransferRequest(FlatBufferBuilder fbb, int bufferId) {
        return BufferTransferRequest.createBufferTransferRequest(fbb, bufferId);
    }

    public ByteBuffer buildBufferTransferResponse(Seq<BufferMeta> bufferMetas) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024, (FlatBufferBuilder.ByteBufferFactory)this.bbFactory());
        int[] responses = (int[])((TraversableOnce)bufferMetas.map((Function1 & Serializable & scala.Serializable)bm -> BoxesRunTime.boxToInteger((int)ShuffleMetadata$.$anonfun$buildBufferTransferResponse$1(fbb, bm)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        int responsesVector = TransferResponse.createResponsesVector(fbb, responses);
        int root = TransferResponse.createTransferResponse(fbb, responsesVector);
        fbb.finish(root);
        return fbb.dataBuffer();
    }

    public ByteBuffer buildTransferRequest(long id, Seq<Object> toIssue) {
        FlatBufferBuilder fbb = this.getBuilder();
        ArrayBuffer requestIds = new ArrayBuffer(toIssue.size());
        toIssue.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            requestIds.append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{MODULE$.buildBufferTransferRequest(fbb, n)}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        int requestVec = TransferRequest.createRequestsVector(fbb, (int[])requestIds.toArray(ClassTag$.MODULE$.Int()));
        int transferRequestOffset = TransferRequest.createTransferRequest(fbb, id, requestVec);
        fbb.finish(transferRequestOffset);
        return fbb.dataBuffer();
    }

    public String printResponse(String state, MetadataResponse res) {
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        out.append(new StringBuilder(70).append("----------------------- METADATA RESPONSE ").append(state).append(" --------------------------\n").toString());
        out.append(new StringBuilder(8).append(res.tableMetasLength()).append(" tables\n").toString());
        out.append("------------------------------------------------------------------------------\n");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), res.tableMetasLength()).foreach((Function1 & Serializable & scala.Serializable)tableIndex -> ShuffleMetadata$.$anonfun$printResponse$1(res, out, BoxesRunTime.unboxToInt((Object)tableIndex)));
        out.append(new StringBuilder(70).append("----------------------- END METADATA RESPONSE ").append(state).append(" ----------------------\n").toString());
        return out.toString();
    }

    public String printRequest(MetadataRequest req) {
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        out.append("----------------------- METADATA REQUEST --------------------------\n");
        out.append(new StringBuilder(17).append("blockId length: ").append(req.blockIdsLength()).append("\n").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), req.blockIdsLength()).foreach((Function1 & Serializable & scala.Serializable)i -> out.append(new StringBuilder(69).append("block_id = [shuffle_id=").append(req.blockIds(BoxesRunTime.unboxToInt((Object)i)).shuffleId()).append(", ").append("map_id=").append(req.blockIds(BoxesRunTime.unboxToInt((Object)i)).mapId()).append(", ").append("start_reduce_id=").append(req.blockIds(BoxesRunTime.unboxToInt((Object)i)).startReduceId()).append(" , ").append("end_reduce_id=").append(req.blockIds(BoxesRunTime.unboxToInt((Object)i)).endReduceId()).append("]\n").toString()));
        out.append("----------------------- END METADATA REQUEST ----------------------\n");
        return out.toString();
    }

    public TableMeta copyTableMetaToHeap(TableMeta meta) {
        FlatBufferBuilder fbb = this.getHeapBuilder();
        int[] tables = this.copyTables(fbb, (Seq<TableMeta>)((Seq)new .colon.colon((Object)meta, (List)Nil$.MODULE$)));
        fbb.finish(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(tables)).head()));
        return TableMeta.getRootAsTableMeta(fbb.dataBuffer());
    }

    public static final /* synthetic */ int $anonfun$copyTables$1(FlatBufferBuilder fbb$3, TableMeta tableMeta) {
        None$ none$;
        BufferMeta buffMeta = tableMeta.bufferMeta();
        None$ buffMetaOffset = buffMeta != null ? new Some((Object)BoxesRunTime.boxToInteger((int)MODULE$.copyBufferMeta(fbb$3, buffMeta))) : None$.MODULE$;
        ByteBuffer packedMetaBuffer = tableMeta.packedMetaAsByteBuffer();
        if (packedMetaBuffer != null) {
            ByteBuffer destBuffer = fbb$3.createUnintializedVector(1, packedMetaBuffer.remaining(), 1);
            destBuffer.put(packedMetaBuffer);
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)fbb$3.endVector()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ packedMetaOffset = none$;
        TableMeta.startTableMeta(fbb$3);
        buffMetaOffset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bmo -> TableMeta.addBufferMeta(fbb$3, bmo));
        packedMetaOffset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pmo -> TableMeta.addPackedMeta(fbb$3, pmo));
        TableMeta.addRowCount(fbb$3, tableMeta.rowCount());
        return TableMeta.endTableMeta(fbb$3);
    }

    public static final /* synthetic */ int $anonfun$buildShuffleMetadataRequest$1(FlatBufferBuilder fbb$4, ShuffleBlockBatchId blockId) {
        return BlockIdMeta.createBlockIdMeta(fbb$4, blockId.shuffleId(), blockId.mapId(), blockId.startReduceId(), blockId.endReduceId());
    }

    public static final /* synthetic */ int $anonfun$buildBufferTransferResponse$1(FlatBufferBuilder fbb$5, BufferMeta bm) {
        int buffMetaOffset = MODULE$.copyBufferMeta(fbb$5, bm);
        return BufferTransferResponse.createBufferTransferResponse(fbb$5, bm.id(), (byte)0, buffMetaOffset);
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$printResponse$1(MetadataResponse res$1, scala.collection.mutable.StringBuilder out$1, int tableIndex) {
        TableMeta tableMeta = res$1.tableMetas(tableIndex);
        return out$1.append(new StringBuilder(13).append("table: ").append(tableIndex).append(" rows=").append(tableMeta.rowCount()).toString());
    }

    private ShuffleMetadata$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.bbFactory = new DirectByteBufferFactory();
    }
}

